/*
 * Decompiled with CFR 0.152.
 */
package me.onemobile.android.download;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.onemobile.android.download.aa;
import me.onemobile.android.download.u;
import me.onemobile.android.download.w;
import me.onemobile.android.download.x;

public class Helpers {
    private static final Pattern CONTENT_DISPOSITION_PATTERN;
    public static Random sRandom;

    static {
        sRandom = new Random(SystemClock.uptimeMillis());
        CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"([^\"]*)\"");
    }

    private Helpers() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkCanHandleDownload(Context context, String string2, int n2, boolean bl2) {
        if (bl2 || n2 != 0 && n2 != 2 || string2 != null) {
            return;
        }
        throw new w(406, "external download with no mime type not allowed");
    }

    private static String chooseExtensionFromFilename(String string2, int n2, String string3, int n3) {
        String string4;
        block4: {
            block5: {
                string4 = null;
                if (string2 == null) break block4;
                int n4 = string3.lastIndexOf(46);
                String string5 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3.substring(n4 + 1));
                if (string5 == null) break block5;
                boolean bl2 = string5.equalsIgnoreCase(string2);
                string4 = null;
                if (bl2) break block4;
            }
            string4 = Helpers.chooseExtensionFromMimeType(string2, false);
        }
        if (string4 == null) {
            string4 = string3.substring(n3);
        }
        return string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String chooseExtensionFromMimeType(String string2, boolean bl2) {
        String string3 = null;
        if (string2 != null && (string3 = MimeTypeMap.getSingleton().getExtensionFromMimeType(string2)) != null) {
            string3 = "." + string3;
        }
        if (string3 != null) return string3;
        if (string2 != null && string2.toLowerCase().startsWith("text/")) {
            if (string2.equalsIgnoreCase("text/html")) {
                return ".html";
            }
            if (!bl2) return string3;
            return ".txt";
        }
        if (!bl2) return string3;
        return ".bin";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String chooseFilename(String string2, String string3, String string4, String string5, int n2) {
        int n3;
        String string6;
        String string7;
        int n4;
        String string8 = null;
        if (string2 != null) {
            boolean bl2 = string2.endsWith("/");
            string8 = null;
            if (!bl2) {
                int n5 = 1 + string2.lastIndexOf(47);
                string8 = n5 > 0 ? string2.substring(n5) : string2;
            }
        }
        if (string8 == null && string4 != null && (string8 = Helpers.parseContentDisposition(string4)) != null && (n4 = 1 + string8.lastIndexOf(47)) > 0) {
            string8 = string8.substring(n4);
        }
        if (string8 == null && string5 != null && (string7 = Uri.decode((String)string5)) != null && !string7.endsWith("/") && string7.indexOf(63) < 0) {
            int n6 = 1 + string7.lastIndexOf(47);
            if (n6 > 0) {
                string7 = string7.substring(n6);
            }
        } else {
            string7 = string8;
        }
        if (string7 == null && (string6 = Uri.decode((String)string2)) != null && !string6.endsWith("/") && string6.indexOf(63) < 0 && (n3 = 1 + string6.lastIndexOf(47)) > 0) {
            string7 = string6.substring(n3);
        }
        if (string7 == null) {
            string7 = "downloadfile";
        }
        return Helpers.replaceInvalidVfatCharacters(string7);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String chooseFullPath(Context context, String string2, String string3, String string4, String string5, String string6, int n2, long l2) {
        String string7;
        File file = Helpers.locateDestinationDirectory(context, string6, n2, l2);
        String string8 = Helpers.chooseFilename(string2, string3, string4, string5, n2);
        int n3 = string8.lastIndexOf(46);
        if (n3 < 0) {
            string7 = Helpers.chooseExtensionFromMimeType(string6, true);
        } else {
            string7 = Helpers.chooseExtensionFromFilename(string6, n2, string8, n3);
            string8 = string8.substring(0, n3);
        }
        if (string8.length() < 2) {
            string8 = String.valueOf(string2.hashCode());
        }
        boolean bl2 = "recovery".equalsIgnoreCase(String.valueOf(string8) + string7);
        return Helpers.chooseUniqueFilename(n2, String.valueOf(file.getPath()) + File.separator + string8, string7, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String chooseUniqueFilename(int n2, String string2, String string3, boolean bl2) {
        int n3 = 1;
        String string4 = String.valueOf(string2) + string3;
        if (new File(string4).exists() || bl2 && (n2 == n3 || n2 == 2 || n2 == 3)) {
            String string5 = String.valueOf(string2) + "-";
            int n4 = n3;
            block0: while (true) {
                if (n4 >= 1000000000) {
                    throw new w(492, "failed to generate an unused filename on internal download storage");
                }
                int n5 = n3;
                int n6 = 0;
                while (true) {
                    if (n6 >= 9) {
                        n4 *= 10;
                        n3 = n5;
                        continue block0;
                    }
                    string4 = String.valueOf(string5) + n5 + string3;
                    if (!new File(string4).exists()) break block0;
                    n5 += 1 + sRandom.nextInt(n4);
                    ++n6;
                }
                break;
            }
        }
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void deleteFile(Context context, ContentResolver contentResolver, long l2, String string2, String string3) {
        try {
            new File(string2).delete();
        }
        catch (Exception exception) {
            Log.w((String)"DownloadManager", (String)("file: '" + string2 + "' couldn't be deleted"), (Throwable)exception);
        }
        Uri uri = u.b(context);
        String[] stringArray = new String[]{String.valueOf(l2)};
        contentResolver.delete(uri, "_id = ? ", stringArray);
    }

    public static final boolean discardPurgeableFiles(Context context, long l2) {
        long l3;
        Cursor cursor = context.getContentResolver().query(u.b(context), null, "( status = '200' AND destination = '2' )", null, "lastmod");
        if (cursor == null) {
            return false;
        }
        try {
            cursor.moveToFirst();
            l3 = 0L;
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
        while (true) {
            boolean bl2 = cursor.isAfterLast();
            if (!bl2 && l3 < l2) break block6;
            break;
        }
        {
            block6: {
                cursor.close();
                return l3 > 0L;
            }
            File file = new File(cursor.getString(cursor.getColumnIndex("_data")));
            l3 += file.length();
            file.delete();
            long l4 = cursor.getLong(cursor.getColumnIndex("_id"));
            context.getContentResolver().delete(ContentUris.withAppendedId((Uri)u.b(context), (long)l4), null, null);
            cursor.moveToNext();
            continue;
        }
    }

    public static String generateSaveFile(Context context, String string2, String string3, String string4, String string5, String string6, int n2, long l2, boolean bl2) {
        Helpers.checkCanHandleDownload(context, string6, n2, bl2);
        if (n2 == 4) {
            return Helpers.getPathForFileUri(string3, l2);
        }
        return Helpers.chooseFullPath(context, string2, string3, string4, string5, string6, n2, l2);
    }

    public static long getAvailableBytes(File file) {
        StatFs statFs = new StatFs(file.getPath());
        return ((long)statFs.getAvailableBlocks() - 4L) * (long)statFs.getBlockSize();
    }

    private static File getCacheDestination(Context context, long l2) {
        long l3;
        File file = Environment.getDownloadCacheDirectory();
        do {
            if ((l3 = Helpers.getAvailableBytes(file)) < l2) continue;
            return file;
        } while (Helpers.discardPurgeableFiles(context, l2 - l3));
        throw new w(498, "not enough free space in internal download storage, unable to free any more");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static File getExternalDestination(Context context, long l2) {
        boolean bl2 = Helpers.isExternalMediaMounted();
        boolean bl3 = Helpers.isDownloadDestinationInSD(context);
        File file = bl2 && bl3 ? Environment.getExternalStorageDirectory() : context.getFilesDir();
        if (file == null || !file.exists()) {
            Log.d((String)"DownloadManager", (String)"download aborted - can not find a dictionary for downloading");
            throw new w(492, "can not find a dictionary for downloading");
        }
        if (Helpers.getAvailableBytes(file) < l2) {
            Log.d((String)"DownloadManager", (String)"download aborted - not enough free space");
            throw new w(498, "insufficient space on external media");
        }
        File file2 = bl2 && bl3 ? new File(String.valueOf(file.getPath()) + "/onemobile_download") : file;
        if (!file2.isDirectory() && !file2.mkdir()) {
            throw new w(492, "unable to create external downloads directory " + file2.getPath());
        }
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static File getFilesystemRoot(String string2) {
        File file = Environment.getDownloadCacheDirectory();
        if (string2.startsWith(file.getPath()) || string2.startsWith((file = Environment.getExternalStorageDirectory()).getPath())) {
            return file;
        }
        throw new IllegalArgumentException("Cannot determine filesystem root for " + string2);
    }

    private static String getPathForFileUri(String string2, long l2) {
        if (!Helpers.isExternalMediaMounted()) {
            throw new w(499, "external media not mounted");
        }
        String string3 = Uri.parse((String)string2).getPath();
        if (new File(string3).exists()) {
            Log.d((String)"DownloadManager", (String)("File already exists: " + string3));
            throw new w(488, "requested destination file already exists");
        }
        if (Helpers.getAvailableBytes(Helpers.getFilesystemRoot(string3)) < l2) {
            throw new w(498, "insufficient space on external storage");
        }
        return string3;
    }

    public static boolean isDownloadDestinationInSD(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("download_dir_in_sd", true);
    }

    public static boolean isExternalMediaMounted() {
        String string2 = Environment.getExternalStorageState();
        if (string2 == null || !string2.equals("mounted")) {
            Log.d((String)"DownloadManager", (String)"no external storage");
            return false;
        }
        return true;
    }

    public static boolean isFilenameValid(String string2) {
        String string3 = string2.replaceFirst("/+", "/");
        return string3.startsWith(Environment.getDownloadCacheDirectory().toString()) || string3.startsWith(Environment.getExternalStorageDirectory().toString());
    }

    public static boolean isNetworkAvailable(aa aa2) {
        return aa2.b() != null;
    }

    private static File locateDestinationDirectory(Context context, String string2, int n2, long l2) {
        if (n2 == 1 || n2 == 2 || n2 == 3) {
            return Helpers.getCacheDestination(context, l2);
        }
        return Helpers.getExternalDestination(context, l2);
    }

    private static String parseContentDisposition(String string2) {
        try {
            Matcher matcher = CONTENT_DISPOSITION_PATTERN.matcher(string2);
            if (matcher.find()) {
                String string3 = matcher.group(1);
                return string3;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseExpression(x x2) {
        while (true) {
            if (x2.a() == 1) {
                x2.b();
                Helpers.parseExpression(x2);
                if (x2.a() != 2) {
                    throw new IllegalArgumentException("syntax error, unmatched parenthese");
                }
                x2.b();
            } else {
                Helpers.parseStatement(x2);
            }
            if (x2.a() != 3) {
                return;
            }
            x2.b();
        }
    }

    private static void parseStatement(x x2) {
        if (x2.a() != 4) {
            throw new IllegalArgumentException("syntax error, expected column name");
        }
        x2.b();
        if (x2.a() == 5) {
            x2.b();
            if (x2.a() != 6) {
                throw new IllegalArgumentException("syntax error, expected quoted string");
            }
            x2.b();
            return;
        }
        if (x2.a() == 7) {
            x2.b();
            if (x2.a() != 8) {
                throw new IllegalArgumentException("syntax error, expected NULL");
            }
            x2.b();
            return;
        }
        throw new IllegalArgumentException("syntax error after column name");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String replaceInvalidVfatCharacters(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl2 = false;
        while (n2 < string2.length()) {
            char c2 = string2.charAt(n2);
            if (c2 >= '\u0000' && c2 <= '\u001f' || c2 == '\"' || c2 == '*' || c2 == '/' || c2 == ':' || c2 == '<' || c2 == '>' || c2 == '?' || c2 == '\\' || c2 == '|' || c2 == '\u007f') {
                if (!bl2) {
                    stringBuffer.append('_');
                    bl2 = true;
                }
            } else {
                stringBuffer.append(c2);
                bl2 = false;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void setDownloadDestinationInSD(Context context, boolean bl2) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("download_dir_in_sd", bl2).commit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void validateSelection(String string2, Set<String> set) {
        if (string2 == null) return;
        try {
            x x2 = new x(string2, set);
            Helpers.parseExpression(x2);
            if (x2.a() == 9) return;
            throw new IllegalArgumentException("syntax error");
        }
        catch (RuntimeException runtimeException) {
            Log.d((String)"DownloadManager", (String)("invalid selection triggered " + runtimeException));
            throw runtimeException;
        }
    }
}

