/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.ads.Ad;
import com.google.ads.AdListener;
import com.google.ads.AdRequest;
import com.google.ads.AdSize;
import com.google.ads.AppEventListener;
import com.google.ads.internal.AdWebView;
import com.google.ads.internal.b;
import com.google.ads.internal.d;
import com.google.ads.internal.j;
import com.google.ads.util.AdUtil;
import java.util.HashSet;
import java.util.Set;

public class AdView
extends RelativeLayout
implements Ad {
    private d a;

    public AdView(Activity activity, AdSize adSize, String string2) {
        super(activity.getApplicationContext());
        try {
            this.a((Context)activity, adSize, null);
            this.b((Context)activity, adSize, null);
            this.a(activity, adSize, string2);
            return;
        }
        catch (b b2) {
            this.a((Context)activity, b2.c("Could not initialize AdView"), adSize, null);
            b2.a("Could not initialize AdView");
            return;
        }
    }

    protected AdView(Activity activity, AdSize[] adSizeArray, String string2) {
        this(activity, new AdSize(0, 0), string2);
        this.a(adSizeArray);
    }

    public AdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.a(context, attributeSet);
    }

    public AdView(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet);
    }

    private int a(Context context, int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(Activity activity, AdSize adSize, String string2) {
        FrameLayout frameLayout = new FrameLayout((Context)activity);
        frameLayout.setFocusable(false);
        this.a = new d(this, activity, adSize, string2, (ViewGroup)frameLayout, false);
        this.setGravity(17);
        try {
            ViewGroup viewGroup = j.a(activity, this.a);
            if (viewGroup != null) {
                viewGroup.addView((View)frameLayout, -2, -2);
                this.addView((View)viewGroup, -2, -2);
                return;
            }
            this.addView((View)frameLayout, -2, -2);
            return;
        }
        catch (VerifyError verifyError) {
            com.google.ads.util.b.a("Gestures disabled: Not supported on this version of Android.", verifyError);
            this.addView((View)frameLayout, -2, -2);
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) return;
        String string2 = this.b("adSize", context, attributeSet, true);
        AdSize[] adSizeArray = this.a(string2);
        if (adSizeArray == null) throw new b("Attribute \"adSize\" invalid: " + string2, true);
        try {
            if (adSizeArray.length == 0) {
                throw new b("Attribute \"adSize\" invalid: " + string2, true);
            }
            if (!this.a("adUnitId", attributeSet)) {
                throw new b("Required XML attribute \"adUnitId\" missing", true);
            }
            if (this.isInEditMode()) {
                this.a(context, "Ads by Google", -1, adSizeArray[0], attributeSet);
                return;
            }
            String string3 = this.b("adUnitId", context, attributeSet, true);
            boolean bl2 = this.a("loadAdOnCreate", context, attributeSet, false);
            if (!(context instanceof Activity)) {
                throw new b("AdView was initialized with a Context that wasn't an Activity.", true);
            }
            Activity activity = (Activity)context;
            this.a((Context)activity, adSizeArray[0], attributeSet);
            this.b((Context)activity, adSizeArray[0], attributeSet);
            if (adSizeArray.length == 1) {
                this.a(activity, adSizeArray[0], string3);
            } else {
                this.a(activity, new AdSize(0, 0), string3);
                this.a(adSizeArray);
            }
            if (!bl2) return;
            Set<String> set = this.c("testDevices", context, attributeSet, false);
            if (set.contains("TEST_EMULATOR")) {
                set.remove("TEST_EMULATOR");
                set.add(AdRequest.TEST_EMULATOR);
            }
            this.loadAd(new AdRequest().setTestDevices(set).setKeywords(this.c("keywords", context, attributeSet, false)));
            return;
        }
        catch (b b2) {
            AdSize[] adSizeArray2;
            b b3;
            block16: {
                b3 = b2;
                adSizeArray2 = adSizeArray;
                break block16;
                catch (b b4) {
                    b3 = b4;
                    adSizeArray2 = null;
                }
            }
            String string4 = b3.c("Could not initialize AdView");
            Object object = adSizeArray2 != null && adSizeArray2.length > 0 ? adSizeArray2[0] : AdSize.BANNER;
            this.a(context, string4, (AdSize)object, attributeSet);
            b3.a("Could not initialize AdView");
            if (this.isInEditMode()) return;
            b3.b("Could not initialize AdView");
            return;
        }
    }

    private void a(Context context, String string2, AdSize adSize, AttributeSet attributeSet) {
        com.google.ads.util.b.b(string2);
        this.a(context, string2, -65536, adSize, attributeSet);
    }

    private void a(AdSize ... adSizeArray) {
        AdSize[] adSizeArray2 = new AdSize[adSizeArray.length];
        for (int i2 = 0; i2 < adSizeArray.length; ++i2) {
            adSizeArray2[i2] = AdSize.createAdSize(adSizeArray[i2], this.getContext());
        }
        this.a.h().l.a(adSizeArray2);
    }

    private boolean a(Context context, AdSize adSize, AttributeSet attributeSet) {
        if (!AdUtil.c(context)) {
            this.a(context, "You must have AdActivity declared in AndroidManifest.xml with configChanges.", adSize, attributeSet);
            return false;
        }
        return true;
    }

    private boolean a(String string2, Context context, AttributeSet attributeSet, boolean bl2) {
        String string3 = attributeSet.getAttributeValue("http://schemas.android.com/apk/lib/com.google.ads", string2);
        boolean bl3 = attributeSet.getAttributeBooleanValue("http://schemas.android.com/apk/lib/com.google.ads", string2, bl2);
        if (string3 != null) {
            String string4 = context.getPackageName();
            if (string3.matches("^@([^:]+)\\:(.*)$")) {
                string4 = string3.replaceFirst("^@([^:]+)\\:(.*)$", "$1");
                string3 = string3.replaceFirst("^@([^:]+)\\:(.*)$", "@$2");
            }
            if (string3.startsWith("@bool/")) {
                String string5 = string3.substring(6);
                TypedValue typedValue = new TypedValue();
                try {
                    this.getResources().getValue(string4 + ":bool/" + string5, typedValue, true);
                    if (typedValue.type == 18) {
                        return typedValue.data != 0;
                    }
                }
                catch (Resources.NotFoundException notFoundException) {
                    throw new b("Could not find resource for " + string2 + ": " + string3, true, notFoundException);
                }
                throw new b("Resource " + string2 + " was not a boolean: " + typedValue, true);
            }
        }
        return bl3;
    }

    private boolean a(String string2, AttributeSet attributeSet) {
        return attributeSet.getAttributeValue("http://schemas.android.com/apk/lib/com.google.ads", string2) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String b(String string2, Context context, AttributeSet attributeSet, boolean bl2) {
        String string3 = attributeSet.getAttributeValue("http://schemas.android.com/apk/lib/com.google.ads", string2);
        if (string3 != null) {
            String string4 = context.getPackageName();
            if (string3.matches("^@([^:]+)\\:(.*)$")) {
                string4 = string3.replaceFirst("^@([^:]+)\\:(.*)$", "$1");
                string3 = string3.replaceFirst("^@([^:]+)\\:(.*)$", "@$2");
            }
            if (string3.startsWith("@string/")) {
                String string5 = string3.substring(8);
                TypedValue typedValue = new TypedValue();
                try {
                    this.getResources().getValue(string4 + ":string/" + string5, typedValue, true);
                    if (typedValue.string == null) throw new b("Resource " + string2 + " was not a string: " + typedValue, true);
                    string3 = ((Object)typedValue.string).toString();
                }
                catch (Resources.NotFoundException notFoundException) {
                    throw new b("Could not find resource for " + string2 + ": " + string3, true, notFoundException);
                }
            }
        }
        if (!bl2 || string3 != null) return string3;
        throw new b("Required XML attribute \"" + string2 + "\" missing", true);
    }

    private boolean b(Context context, AdSize adSize, AttributeSet attributeSet) {
        if (!AdUtil.b(context)) {
            this.a(context, "You must have INTERNET and ACCESS_NETWORK_STATE permissions in AndroidManifest.xml.", adSize, attributeSet);
            return false;
        }
        return true;
    }

    private Set<String> c(String string2, Context context, AttributeSet attributeSet, boolean bl2) {
        String string3 = this.b(string2, context, attributeSet, bl2);
        HashSet<String> hashSet = new HashSet<String>();
        if (string3 != null) {
            String[] stringArray = string3.split(",");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = stringArray[i2].trim();
                if (string4.length() == 0) continue;
                hashSet.add(string4);
            }
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    void a(Context context, String string2, int n2, AdSize adSize, AttributeSet attributeSet) {
        if (adSize == null) {
            adSize = AdSize.BANNER;
        }
        AdSize adSize2 = AdSize.createAdSize(adSize, context.getApplicationContext());
        if (this.getChildCount() == 0) {
            TextView textView = attributeSet == null ? new TextView(context) : new TextView(context, attributeSet);
            textView.setGravity(17);
            textView.setText((CharSequence)string2);
            textView.setTextColor(n2);
            textView.setBackgroundColor(-16777216);
            LinearLayout linearLayout = attributeSet == null ? new LinearLayout(context) : new LinearLayout(context, attributeSet);
            linearLayout.setGravity(17);
            LinearLayout linearLayout2 = attributeSet == null ? new LinearLayout(context) : new LinearLayout(context, attributeSet);
            linearLayout2.setGravity(17);
            linearLayout2.setBackgroundColor(n2);
            int n3 = this.a(context, adSize2.getWidth());
            int n4 = this.a(context, adSize2.getHeight());
            linearLayout.addView((View)textView, n3 - 2, n4 - 2);
            linearLayout2.addView((View)linearLayout);
            this.addView((View)linearLayout2, n3, n4);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    AdSize[] a(String string2) {
        String[] stringArray = string2.split(",");
        AdSize[] adSizeArray = new AdSize[stringArray.length];
        int n2 = 0;
        while (true) {
            AdSize adSize;
            block18: {
                String string3;
                block17: {
                    int n3;
                    int n4;
                    if (n2 >= stringArray.length) {
                        return adSizeArray;
                    }
                    string3 = stringArray[n2].trim();
                    if (!string3.matches("^(\\d+|FULL_WIDTH)\\s*[xX]\\s*(\\d+|AUTO_HEIGHT)$")) break block17;
                    String[] stringArray2 = string3.split("[xX]");
                    stringArray2[0] = stringArray2[0].trim();
                    stringArray2[1] = stringArray2[1].trim();
                    try {
                        n4 = "FULL_WIDTH".equals(stringArray2[0]) ? -1 : Integer.parseInt(stringArray2[0]);
                        boolean bl2 = "AUTO_HEIGHT".equals(stringArray2[1]);
                        if (!bl2) {
                            int n5;
                            n3 = n5 = Integer.parseInt(stringArray2[1]);
                        }
                        n3 = -2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    adSize = new AdSize(n4, n3);
                    break block18;
                }
                if ("BANNER".equals(string3)) {
                    adSize = AdSize.BANNER;
                } else if ("SMART_BANNER".equals(string3)) {
                    adSize = AdSize.SMART_BANNER;
                } else if ("IAB_MRECT".equals(string3)) {
                    adSize = AdSize.IAB_MRECT;
                } else if ("IAB_BANNER".equals(string3)) {
                    adSize = AdSize.IAB_BANNER;
                } else if ("IAB_LEADERBOARD".equals(string3)) {
                    adSize = AdSize.IAB_LEADERBOARD;
                } else {
                    if (!"IAB_WIDE_SKYSCRAPER".equals(string3)) return null;
                    adSize = AdSize.IAB_WIDE_SKYSCRAPER;
                }
            }
            if (adSize == null) {
                return null;
            }
            adSizeArray[n2] = adSize;
            ++n2;
        }
    }

    public void destroy() {
        this.a.b();
    }

    @Override
    public boolean isReady() {
        if (this.a == null) {
            return false;
        }
        return this.a.r();
    }

    public boolean isRefreshing() {
        if (this.a == null) {
            return false;
        }
        return this.a.s();
    }

    @Override
    public void loadAd(AdRequest adRequest) {
        if (this.a != null) {
            if (this.isRefreshing()) {
                this.a.e();
            }
            this.a.a(adRequest);
        }
    }

    protected void onMeasure(int n2, int n3) {
        AdWebView adWebView = this.a.k();
        if (adWebView != null) {
            adWebView.setVisibility(0);
        }
        super.onMeasure(n2, n3);
    }

    @Override
    public void setAdListener(AdListener adListener) {
        this.a.h().m.a(adListener);
    }

    protected void setAppEventListener(AppEventListener appEventListener) {
        this.a.h().n.a(appEventListener);
    }

    protected void setSupportedAdSizes(AdSize ... adSizeArray) {
        if (this.a.h().l.a() == null) {
            com.google.ads.util.b.b("Error: Tried to set supported ad sizes on a single-size AdView.");
            return;
        }
        this.a(adSizeArray);
    }

    @Override
    public void stopLoading() {
        if (this.a != null) {
            this.a.A();
        }
    }
}

