/*
 * Decompiled with CFR 0.152.
 */
package com.adwhirl.util;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public class AdWhirlUtil {
    public static final String ADWHIRL = "AdWhirl SDK";
    public static final int CUSTOM_TYPE_BANNER = 1;
    public static final int CUSTOM_TYPE_ICON = 2;
    public static final int NETWORK_TYPE_1MOBILE2 = 9;
    public static final int NETWORK_TYPE_4THSCREEN = 13;
    public static final int NETWORK_TYPE_ADMOB = 1;
    public static final int NETWORK_TYPE_ADSENSE = 14;
    public static final int NETWORK_TYPE_ADWHIRL = 10;
    public static final int NETWORK_TYPE_DOUBLECLICK = 15;
    public static final int NETWORK_TYPE_EVENT = 17;
    public static final int NETWORK_TYPE_GENERIC = 16;
    public static final int NETWORK_TYPE_GREYSTRIP = 7;
    public static final int NETWORK_TYPE_INMOBI = 18;
    public static final int NETWORK_TYPE_JUMPTAP = 2;
    public static final int NETWORK_TYPE_LIVERAIL = 5;
    public static final int NETWORK_TYPE_MDOTM = 12;
    public static final int NETWORK_TYPE_MEDIALETS = 4;
    public static final int NETWORK_TYPE_MILLENNIAL = 6;
    public static final int NETWORK_TYPE_MOBCLIX = 11;
    public static final int NETWORK_TYPE_NEXAGE = 24;
    public static final int NETWORK_TYPE_ONERIOT = 23;
    public static final int NETWORK_TYPE_QUATTRO = 8;
    public static final int NETWORK_TYPE_VIDEOEGG = 3;
    public static final int NETWORK_TYPE_ZESTADZ = 20;
    private static double density = 0.0;
    public static final String host = "http://ads.1mobile.com/market/";
    public static final String locationString = "&location=%f,%f&location_timestamp=%d";
    public static final String urlClick = "http://ads.1mobile.com/market/click.php?appid=%s&nid=%s&type=%d&uuid=%s&country_code=%s&appver=%d&client=2";
    public static final String urlConfig = "http://ads.1mobile.com/market/getInfo.php?appid=%s&appver=%d&client=2";
    public static final String urlCustom = "http://ads.1mobile.com/market/custom.php?appid=%s&nid=%s&uuid=%s&country_code=%s%s&appver=%d&client=2&ss=%s&nt=%s&pi=%s";
    public static final String urlImpression = "http://ads.1mobile.com/market/impression.php?appid=%s&nid=%s&type=%d&uuid=%s&country_code=%s&appver=%d&client=2";

    static {
        density = -1.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String convertToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = byArray.length;
        int n3 = 0;
        block0: while (n3 < n2) {
            byte by2 = byArray[n3];
            int n4 = 0xF & by2 >>> 4;
            int n5 = 0;
            while (true) {
                if (n4 >= 0 && n4 <= 9) {
                    stringBuffer.append((char)(n4 + 48));
                } else {
                    stringBuffer.append((char)(97 + (n4 - 10)));
                }
                int n6 = by2 & 0xF;
                int n7 = n5 + 1;
                if (n5 > 0) {
                    ++n3;
                    continue block0;
                }
                n5 = n7;
                n4 = n6;
            }
            break;
        }
        return stringBuffer.toString();
    }

    public static double convertToScreenPixels(double d2, double d3) {
        if (d3 > 0.0) {
            d2 *= d3;
        }
        return d2;
    }

    public static int convertToScreenPixels(int n2, double d2) {
        return (int)AdWhirlUtil.convertToScreenPixels((double)n2, d2);
    }

    public static double getDensity(Activity activity) {
        if (density == -1.0) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            density = displayMetrics.density;
        }
        return density;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getEncodedDeviceId(Context context) {
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        String string3 = string2 == null || AdWhirlUtil.isEmulator() ? AdWhirlUtil.md5("emulator") : AdWhirlUtil.md5(string2);
        if (string3 == null) {
            return null;
        }
        return string3.toUpperCase(Locale.US);
    }

    public static boolean isEmulator() {
        return Build.BOARD.equals("unknown") && Build.DEVICE.equals("generic") && Build.BRAND.equals("generic");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String md5(String string2) {
        String string3 = null;
        if (string2 == null) return string3;
        int n2 = string2.length();
        string3 = null;
        if (n2 <= 0) return string3;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string2.getBytes(), 0, string2.length());
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{new BigInteger(1, messageDigest.digest())};
            String string4 = String.format(locale, "%032X", objectArray);
            return string4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return string2.substring(0, 32);
        }
    }
}

