/*
 * Decompiled with CFR 0.152.
 */
package com.adwhirl.adapters;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import com.adwhirl.AdWhirlLayout;
import com.adwhirl.AdWhirlLayout$ViewAdRunnable;
import com.adwhirl.AdWhirlTargeting;
import com.adwhirl.adapters.AdWhirlAdapter;
import com.adwhirl.obj.Ration;
import com.adwhirl.util.AdWhirlUtil;
import com.google.ads.Ad;
import com.google.ads.AdListener;
import com.google.ads.AdRequest;
import com.google.ads.AdRequest$ErrorCode;
import com.google.ads.AdRequest$Gender;
import com.google.ads.AdSize;
import com.google.ads.AdView;

public class GoogleAdMobAdsAdapter
extends AdWhirlAdapter
implements AdListener {
    private AdView adView;

    public GoogleAdMobAdsAdapter(AdWhirlLayout adWhirlLayout, Ration ration) {
        super(adWhirlLayout, ration);
    }

    /*
     * Enabled aggressive block sorting
     */
    private AdSize adjustAdSize(Context context) {
        int n2 = 1;
        if (context.getResources().getConfiguration().orientation != n2) {
            n2 = 0;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int n3 = n2 != 0 ? displayMetrics.heightPixels : displayMetrics.widthPixels;
        int n4 = n2 != 0 ? displayMetrics.widthPixels : displayMetrics.heightPixels;
        if (n4 <= 480 && n3 <= 860) {
            return AdSize.BANNER;
        }
        if (n2 != 0) {
            return AdSize.IAB_BANNER;
        }
        return AdSize.IAB_LEADERBOARD;
    }

    protected AdRequest$Gender genderForAdWhirlTargeting() {
        switch (AdWhirlTargeting.getGender()) {
            default: {
                return null;
            }
            case MALE: {
                return AdRequest$Gender.MALE;
            }
            case FEMALE: 
        }
        return AdRequest$Gender.FEMALE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handle() {
        Activity activity;
        AdWhirlLayout adWhirlLayout = (AdWhirlLayout)((Object)this.adWhirlLayoutReference.get());
        if (adWhirlLayout == null || (activity = (Activity)adWhirlLayout.activityReference.get()) == null) {
            return;
        }
        this.adView = new AdView(activity, AdSize.SMART_BANNER, this.ration.key);
        this.adView.setAdListener(this);
        this.adView.loadAd(this.requestForAdWhirlLayout(adWhirlLayout));
    }

    protected void log(String string2) {
    }

    @Override
    public void onDismissScreen(Ad ad2) {
    }

    @Override
    public void onFailedToReceiveAd(Ad ad2, AdRequest$ErrorCode adRequest$ErrorCode) {
        this.log("failure (" + (Object)((Object)adRequest$ErrorCode) + ")");
        ad2.setAdListener(null);
        AdWhirlLayout adWhirlLayout = (AdWhirlLayout)((Object)this.adWhirlLayoutReference.get());
        if (adWhirlLayout == null) {
            return;
        }
        adWhirlLayout.rollover();
    }

    @Override
    public void onLeaveApplication(Ad ad2) {
    }

    @Override
    public void onPresentScreen(Ad ad2) {
    }

    @Override
    public void onReceiveAd(Ad ad2) {
        this.log("success");
        AdWhirlLayout adWhirlLayout = (AdWhirlLayout)((Object)this.adWhirlLayoutReference.get());
        if (adWhirlLayout == null) {
            return;
        }
        if (!(ad2 instanceof AdView)) {
            this.log("invalid AdView");
            return;
        }
        AdView adView = (AdView)ad2;
        adWhirlLayout.adWhirlManager.resetRollover();
        adWhirlLayout.handler.post((Runnable)new AdWhirlLayout$ViewAdRunnable(adWhirlLayout, (ViewGroup)adView));
        adWhirlLayout.rotateThreadedDelayed();
    }

    protected AdRequest requestForAdWhirlLayout(AdWhirlLayout adWhirlLayout) {
        Activity activity;
        AdRequest adRequest = new AdRequest();
        if (AdWhirlTargeting.getTestMode() && (activity = (Activity)adWhirlLayout.activityReference.get()) != null) {
            adRequest.addTestDevice(AdWhirlUtil.getEncodedDeviceId(activity.getApplicationContext()));
        }
        adRequest.setGender(this.genderForAdWhirlTargeting());
        adRequest.setBirthday(AdWhirlTargeting.getBirthDate());
        if (adWhirlLayout.extra.locationOn == 1) {
            adRequest.setLocation(adWhirlLayout.adWhirlManager.location);
        }
        adRequest.setKeywords(AdWhirlTargeting.getKeywordSet());
        return adRequest;
    }

    @Override
    public void willDestroy() {
        this.log("AdView will get destroyed");
        if (this.adView != null) {
            this.adView.stopLoading();
            this.adView.removeAllViews();
            this.adView.destroy();
        }
    }
}

