/*
 * Decompiled with CFR 0.152.
 */
package com.adwhirl;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.view.Display;
import android.view.WindowManager;
import com.adwhirl.AdWhirlTargeting;
import com.adwhirl.obj.Extra;
import com.adwhirl.obj.Ration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdWhirlManager {
    private static final String PREFS_STRING_CONFIG = "config";
    private static final String PREFS_STRING_TIMESTAMP = "timestamp";
    private static long configExpireTimeout = 1800000L;
    public static String screenSize;
    private WeakReference<Context> contextReference;
    private Extra extra;
    public String keyAdWhirl;
    public String localeString;
    public Location location;
    private int pageId;
    private List<Ration> rationsList;
    Iterator<Ration> rollovers;
    private double totalWeight = 0.0;

    public AdWhirlManager(WeakReference<Context> weakReference, String string2, int n2) {
        Context context;
        this.contextReference = weakReference;
        this.keyAdWhirl = string2;
        this.pageId = n2;
        this.localeString = Locale.getDefault().toString();
        if (screenSize == null && (context = (Context)weakReference.get()) != null) {
            AdWhirlManager.setScreenSize(context);
        }
    }

    /*
     * Loose catch block
     */
    private String convertStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 8192);
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            String string2;
            block11: {
                string2 = bufferedReader.readLine();
                if (string2 != null) break block11;
                inputStream.close();
                return stringBuilder.toString();
            }
            stringBuilder.append(String.valueOf(string2) + "\n");
            continue;
            break;
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
                return null;
            }
            catch (IOException iOException2) {
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                return null;
            }
            throw throwable;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void parseConfigurationString(String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.parseExtraJson(jSONObject.getJSONObject("extra"));
            this.parseRationsJson(jSONObject.getJSONArray("rations"));
            return;
        }
        catch (JSONException jSONException) {
            this.extra = new Extra();
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.extra = new Extra();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseExtraJson(JSONObject jSONObject) {
        Extra extra = new Extra();
        try {
            extra.cycleTime = jSONObject.getInt("cycle_time");
            extra.locationOn = jSONObject.getInt("location_on");
            extra.transition = jSONObject.getInt("transition");
            JSONObject jSONObject2 = jSONObject.getJSONObject("background_color_rgb");
            extra.bgRed = jSONObject2.getInt("red");
            extra.bgGreen = jSONObject2.getInt("green");
            extra.bgBlue = jSONObject2.getInt("blue");
            extra.bgAlpha = 255 * jSONObject2.getInt("alpha");
            JSONObject jSONObject3 = jSONObject.getJSONObject("text_color_rgb");
            extra.fgRed = jSONObject3.getInt("red");
            extra.fgGreen = jSONObject3.getInt("green");
            extra.fgBlue = jSONObject3.getInt("blue");
            extra.fgAlpha = 255 * jSONObject3.getInt("alpha");
        }
        catch (JSONException jSONException) {}
        this.extra = extra;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseRationsJson(JSONArray jSONArray) {
        ArrayList<Ration> arrayList = new ArrayList<Ration>();
        this.totalWeight = 0.0;
        try {
            int n2;
            for (int i2 = 0; i2 < (n2 = jSONArray.length()); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                if (jSONObject == null) continue;
                Ration ration = new Ration();
                ration.nid = jSONObject.getString("nid");
                ration.type = jSONObject.getInt("type");
                ration.name = jSONObject.getString("nname");
                ration.weight = jSONObject.getInt("weight");
                ration.priority = jSONObject.getInt("priority");
                switch (ration.type) {
                    default: {
                        ration.key = jSONObject.getString("key");
                        break;
                    }
                    case 8: {
                        JSONObject jSONObject2 = jSONObject.getJSONObject("key");
                        ration.key = jSONObject2.getString("siteID");
                        ration.key2 = jSONObject2.getString("publisherID");
                        break;
                    }
                    case 24: {
                        JSONObject jSONObject3 = jSONObject.getJSONObject("key");
                        ration.key = jSONObject3.getString("dcn");
                        ration.key2 = jSONObject3.getString("position");
                    }
                }
                this.totalWeight += ration.weight;
                arrayList.add(ration);
            }
        }
        catch (JSONException jSONException) {}
        Collections.sort(arrayList);
        this.rationsList = arrayList;
        this.rollovers = this.rationsList.iterator();
    }

    public static void setConfigExpireTimeout(long l2) {
        configExpireTimeout = l2;
    }

    public static void setScreenSize(Context context) {
        try {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            screenSize = String.valueOf(display.getWidth()) + "x" + display.getHeight();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchConfig() {
        String string2;
        block12: {
            block11: {
                Context context = (Context)this.contextReference.get();
                if (context == null) break block11;
                SharedPreferences sharedPreferences = context.getSharedPreferences(this.keyAdWhirl, 0);
                string2 = sharedPreferences.getString(PREFS_STRING_CONFIG, null);
                long l2 = sharedPreferences.getLong(PREFS_STRING_TIMESTAMP, -1L);
                if (string2 == null || string2.length() < 10 || configExpireTimeout == -1L || System.currentTimeMillis() >= l2 + configExpireTimeout) {
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.keyAdWhirl, AdWhirlTargeting.versionCode};
                    HttpGet httpGet = new HttpGet(String.format(locale, "http://ads.1mobile.com/market/getInfo.php?appid=%s&appver=%d&client=2", objectArray));
                    try {
                        HttpEntity httpEntity = defaultHttpClient.execute((HttpUriRequest)httpGet).getEntity();
                        if (httpEntity != null) {
                            string2 = this.convertStreamToString(httpEntity.getContent());
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putString(PREFS_STRING_CONFIG, string2);
                            editor.putLong(PREFS_STRING_TIMESTAMP, System.currentTimeMillis());
                            editor.commit();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (ClientProtocolException clientProtocolException) {}
                }
                if (string2 != null && string2.length() > 0 && !string2.equals("null")) break block12;
            }
            return;
        }
        this.parseConfigurationString(string2);
    }

    public Extra getExtra() {
        if (this.totalWeight <= 0.0) {
            return null;
        }
        return this.extra;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Location getLocation() {
        if (this.contextReference == null) {
            return null;
        }
        Context context = (Context)this.contextReference.get();
        if (context == null) return null;
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0) {
            return ((LocationManager)context.getSystemService("location")).getLastKnownLocation("gps");
        }
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) return null;
        return ((LocationManager)context.getSystemService("location")).getLastKnownLocation("network");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNetwork(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo == null) return "0";
        switch (networkInfo.getType()) {
            default: {
                return "0";
            }
            case 1: 
        }
        return "1";
    }

    /*
     * Enabled aggressive block sorting
     */
    public Ration getRation() {
        double d2 = new Random().nextDouble() * this.totalWeight;
        double d3 = 0.0;
        Iterator<Ration> iterator = this.rationsList.iterator();
        Ration ration = null;
        while (iterator.hasNext()) {
            ration = iterator.next();
            if (!((d3 += ration.weight) >= d2)) continue;
        }
        return ration;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Ration getRollover() {
        if (this.rollovers == null || !this.rollovers.hasNext()) {
            return null;
        }
        return this.rollovers.next();
    }

    public void resetRollover() {
        this.rollovers = this.rationsList.iterator();
    }
}

