/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.SlidingPaneLayout$AccessibilityDelegate;
import android.support.v4.widget.SlidingPaneLayout$DisableLayerRunnable;
import android.support.v4.widget.SlidingPaneLayout$DragHelperCallback;
import android.support.v4.widget.SlidingPaneLayout$LayoutParams;
import android.support.v4.widget.SlidingPaneLayout$PanelSlideListener;
import android.support.v4.widget.SlidingPaneLayout$SavedState;
import android.support.v4.widget.SlidingPaneLayout$SlidingPanelLayoutImpl;
import android.support.v4.widget.SlidingPaneLayout$SlidingPanelLayoutImplBase;
import android.support.v4.widget.SlidingPaneLayout$SlidingPanelLayoutImplJB;
import android.support.v4.widget.SlidingPaneLayout$SlidingPanelLayoutImplJBMR1;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import java.util.ArrayList;

public class SlidingPaneLayout
extends ViewGroup {
    private static final int DEFAULT_FADE_COLOR = -858993460;
    private static final int DEFAULT_OVERHANG_SIZE = 32;
    static final SlidingPaneLayout$SlidingPanelLayoutImpl IMPL;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final String TAG = "SlidingPaneLayout";
    private boolean mCanSlide;
    private int mCoveredFadeColor;
    private final ViewDragHelper mDragHelper;
    private boolean mFirstLayout = true;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private boolean mIsUnableToDrag;
    private final int mOverhangSize;
    private SlidingPaneLayout$PanelSlideListener mPanelSlideListener;
    private int mParallaxBy;
    private float mParallaxOffset;
    private final ArrayList<SlidingPaneLayout$DisableLayerRunnable> mPostedRunnables;
    private boolean mPreservedOpenState;
    private Drawable mShadowDrawable;
    private float mSlideOffset;
    private int mSlideRange;
    private View mSlideableView;
    private int mSliderFadeColor = -858993460;
    private final Rect mTmpRect = new Rect();

    static {
        int n2 = Build.VERSION.SDK_INT;
        IMPL = n2 >= 17 ? new SlidingPaneLayout$SlidingPanelLayoutImplJBMR1() : (n2 >= 16 ? new SlidingPaneLayout$SlidingPanelLayoutImplJB() : new SlidingPaneLayout$SlidingPanelLayoutImplBase());
    }

    public SlidingPaneLayout(Context context) {
        this(context, null);
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mPostedRunnables = new ArrayList();
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mOverhangSize = (int)(0.5f + 32.0f * f2);
        ViewConfiguration.get((Context)context);
        this.setWillNotDraw(false);
        ViewCompat.setAccessibilityDelegate((View)this, new SlidingPaneLayout$AccessibilityDelegate(this));
        ViewCompat.setImportantForAccessibility((View)this, 1);
        this.mDragHelper = ViewDragHelper.create(this, 0.5f, new SlidingPaneLayout$DragHelperCallback(this, null));
        this.mDragHelper.setEdgeTrackingEnabled(1);
        this.mDragHelper.setMinVelocity(f2 * 400.0f);
    }

    static /* synthetic */ boolean access$100(SlidingPaneLayout slidingPaneLayout) {
        return slidingPaneLayout.mIsUnableToDrag;
    }

    static /* synthetic */ ArrayList access$1000(SlidingPaneLayout slidingPaneLayout) {
        return slidingPaneLayout.mPostedRunnables;
    }

    static /* synthetic */ ViewDragHelper access$200(SlidingPaneLayout slidingPaneLayout) {
        return slidingPaneLayout.mDragHelper;
    }

    static /* synthetic */ float access$300(SlidingPaneLayout slidingPaneLayout) {
        return slidingPaneLayout.mSlideOffset;
    }

    static /* synthetic */ View access$400(SlidingPaneLayout slidingPaneLayout) {
        return slidingPaneLayout.mSlideableView;
    }

    static /* synthetic */ boolean access$502(SlidingPaneLayout slidingPaneLayout, boolean bl2) {
        slidingPaneLayout.mPreservedOpenState = bl2;
        return bl2;
    }

    static /* synthetic */ void access$600(SlidingPaneLayout slidingPaneLayout, int n2) {
        slidingPaneLayout.onPanelDragged(n2);
    }

    static /* synthetic */ int access$700(SlidingPaneLayout slidingPaneLayout) {
        return slidingPaneLayout.mSlideRange;
    }

    static /* synthetic */ void access$900(SlidingPaneLayout slidingPaneLayout, View view) {
        slidingPaneLayout.invalidateChildRegion(view);
    }

    private boolean closePane(View view, int n2) {
        boolean bl2;
        block3: {
            block2: {
                if (this.mFirstLayout) break block2;
                boolean bl3 = this.smoothSlideTo(0.0f, n2);
                bl2 = false;
                if (!bl3) break block3;
            }
            this.mPreservedOpenState = false;
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dimChildView(View view, float f2, int n2) {
        SlidingPaneLayout$LayoutParams slidingPaneLayout$LayoutParams = (SlidingPaneLayout$LayoutParams)view.getLayoutParams();
        if (f2 > 0.0f && n2 != 0) {
            int n3 = (int)(f2 * (float)((0xFF000000 & n2) >>> 24)) << 24 | 0xFFFFFF & n2;
            if (slidingPaneLayout$LayoutParams.dimPaint == null) {
                slidingPaneLayout$LayoutParams.dimPaint = new Paint();
            }
            slidingPaneLayout$LayoutParams.dimPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(n3, PorterDuff.Mode.SRC_OVER));
            if (ViewCompat.getLayerType(view) != 2) {
                ViewCompat.setLayerType(view, 2, slidingPaneLayout$LayoutParams.dimPaint);
            }
            this.invalidateChildRegion(view);
            return;
        } else {
            if (ViewCompat.getLayerType(view) == 0) return;
            if (slidingPaneLayout$LayoutParams.dimPaint != null) {
                slidingPaneLayout$LayoutParams.dimPaint.setColorFilter(null);
            }
            SlidingPaneLayout$DisableLayerRunnable slidingPaneLayout$DisableLayerRunnable = new SlidingPaneLayout$DisableLayerRunnable(this, view);
            this.mPostedRunnables.add(slidingPaneLayout$DisableLayerRunnable);
            ViewCompat.postOnAnimation((View)this, slidingPaneLayout$DisableLayerRunnable);
            return;
        }
    }

    private void invalidateChildRegion(View view) {
        IMPL.invalidateChildRegion(this, view);
    }

    private void onPanelDragged(int n2) {
        SlidingPaneLayout$LayoutParams slidingPaneLayout$LayoutParams = (SlidingPaneLayout$LayoutParams)this.mSlideableView.getLayoutParams();
        this.mSlideOffset = (float)(n2 - (this.getPaddingLeft() + slidingPaneLayout$LayoutParams.leftMargin)) / (float)this.mSlideRange;
        if (this.mParallaxBy != 0) {
            this.parallaxOtherViews(this.mSlideOffset);
        }
        if (slidingPaneLayout$LayoutParams.dimWhenOffset) {
            this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
        }
        this.dispatchOnPanelSlide(this.mSlideableView);
    }

    private boolean openPane(View view, int n2) {
        if (this.mFirstLayout || this.smoothSlideTo(1.0f, n2)) {
            this.mPreservedOpenState = true;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parallaxOtherViews(float f2) {
        int n2 = 0;
        SlidingPaneLayout$LayoutParams slidingPaneLayout$LayoutParams = (SlidingPaneLayout$LayoutParams)this.mSlideableView.getLayoutParams();
        boolean bl2 = slidingPaneLayout$LayoutParams.dimWhenOffset && slidingPaneLayout$LayoutParams.leftMargin <= 0;
        int n3 = this.getChildCount();
        while (n2 < n3) {
            View view = this.getChildAt(n2);
            if (view != this.mSlideableView) {
                int n4 = (int)((1.0f - this.mParallaxOffset) * (float)this.mParallaxBy);
                this.mParallaxOffset = f2;
                view.offsetLeftAndRight(n4 - (int)((1.0f - f2) * (float)this.mParallaxBy));
                if (bl2) {
                    this.dimChildView(view, 1.0f - this.mParallaxOffset, this.mCoveredFadeColor);
                }
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean viewIsOpaque(View view) {
        block6: {
            block5: {
                if (ViewCompat.isOpaque(view)) break block5;
                if (Build.VERSION.SDK_INT >= 18) {
                    return false;
                }
                Drawable drawable2 = view.getBackground();
                if (drawable2 == null) {
                    return false;
                }
                if (drawable2.getOpacity() != -1) break block6;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = -1 + viewGroup.getChildCount(); i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 >= view2.getLeft() && n3 + n5 < view2.getRight() && n4 + n6 >= view2.getTop() && n4 + n6 < view2.getBottom() && this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) return true;
            }
        }
        if (!bl2 || !ViewCompat.canScrollHorizontally(view, -n2)) return false;
        return true;
    }

    @Deprecated
    public boolean canSlide() {
        return this.mCanSlide;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof SlidingPaneLayout$LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public boolean closePane() {
        return this.closePane(this.mSlideableView, 0);
    }

    public void computeScroll() {
        block3: {
            block2: {
                if (!this.mDragHelper.continueSettling(true)) break block2;
                if (this.mCanSlide) break block3;
                this.mDragHelper.abort();
            }
            return;
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    void dispatchOnPanelClosed(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelClosed(view);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelOpened(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelOpened(view);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelSlide(View view) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelSlide(view, this.mSlideOffset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.getChildCount() <= 1) return;
        View view = this.getChildAt(1);
        if (view == null) return;
        if (this.mShadowDrawable == null) {
            return;
        }
        int n2 = this.mShadowDrawable.getIntrinsicWidth();
        int n3 = view.getLeft();
        int n4 = view.getTop();
        int n5 = view.getBottom();
        int n6 = n3 - n2;
        this.mShadowDrawable.setBounds(n6, n4, n3, n5);
        this.mShadowDrawable.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean drawChild(Canvas canvas, View view, long l2) {
        boolean bl2;
        int n2;
        block6: {
            block3: {
                block4: {
                    block5: {
                        Bitmap bitmap;
                        SlidingPaneLayout$LayoutParams slidingPaneLayout$LayoutParams = (SlidingPaneLayout$LayoutParams)view.getLayoutParams();
                        n2 = canvas.save(2);
                        if (this.mCanSlide && !slidingPaneLayout$LayoutParams.slideable && this.mSlideableView != null) {
                            canvas.getClipBounds(this.mTmpRect);
                            this.mTmpRect.right = Math.min(this.mTmpRect.right, this.mSlideableView.getLeft());
                            canvas.clipRect(this.mTmpRect);
                        }
                        if (Build.VERSION.SDK_INT >= 11) break block3;
                        if (!slidingPaneLayout$LayoutParams.dimWhenOffset || !(this.mSlideOffset > 0.0f)) break block4;
                        if (!view.isDrawingCacheEnabled()) {
                            view.setDrawingCacheEnabled(true);
                        }
                        if ((bitmap = view.getDrawingCache()) == null) break block5;
                        canvas.drawBitmap(bitmap, (float)view.getLeft(), (float)view.getTop(), slidingPaneLayout$LayoutParams.dimPaint);
                        bl2 = false;
                        break block6;
                    }
                    Log.e((String)TAG, (String)("drawChild: child view " + view + " returned null drawing cache"));
                    break block3;
                }
                if (view.isDrawingCacheEnabled()) {
                    view.setDrawingCacheEnabled(false);
                }
            }
            bl2 = super.drawChild(canvas, view, l2);
        }
        canvas.restoreToCount(n2);
        return bl2;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new SlidingPaneLayout$LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new SlidingPaneLayout$LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new SlidingPaneLayout$LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new SlidingPaneLayout$LayoutParams(layoutParams);
    }

    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public int getParallaxDistance() {
        return this.mParallaxBy;
    }

    public int getSliderFadeColor() {
        return this.mSliderFadeColor;
    }

    boolean isDimmed(View view) {
        if (view == null) {
            return false;
        }
        SlidingPaneLayout$LayoutParams slidingPaneLayout$LayoutParams = (SlidingPaneLayout$LayoutParams)view.getLayoutParams();
        return this.mCanSlide && slidingPaneLayout$LayoutParams.dimWhenOffset && this.mSlideOffset > 0.0f;
    }

    public boolean isOpen() {
        return !this.mCanSlide || this.mSlideOffset == 1.0f;
    }

    public boolean isSlideable() {
        return this.mCanSlide;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
        int n2 = this.mPostedRunnables.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mPostedRunnables.get(i2).run();
        }
        this.mPostedRunnables.clear();
    }

    /*
     * Unable to fully structure code
     */
    public boolean onInterceptTouchEvent(MotionEvent var1_1) {
        var2_2 = MotionEventCompat.getActionMasked(var1_1);
        if (this.mCanSlide || var2_2 != 0 || this.getChildCount() <= 1 || (var11_3 = this.getChildAt(1)) == null) ** GOTO lbl7
        if (!this.mDragHelper.isViewUnder(var11_3, (int)var1_1.getX(), (int)var1_1.getY())) {
            var12_4 = true;
lbl5:
            // 2 sources

            while (true) {
                this.mPreservedOpenState = var12_4;
lbl7:
                // 2 sources

                if (!this.mCanSlide || this.mIsUnableToDrag && var2_2 != 0) {
                    this.mDragHelper.cancel();
                    var3_5 = super.onInterceptTouchEvent(var1_1);
                    return var3_5;
                }
                break;
            }
        } else {
            var12_4 = false;
            ** continue;
        }
        if (var2_2 == 3 || var2_2 == 1) {
            this.mDragHelper.cancel();
            return false;
        }
        switch (var2_2) lbl-1000:
        // 2 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var8_6 = false;
lbl22:
                    // 2 sources

                    while (true) {
                        if (!this.mDragHelper.shouldInterceptTouchEvent(var1_1)) {
                            var3_5 = false;
                            if (!var8_6) ** continue;
                        }
                        return true;
                    }
                    break;
                }
            }
            case 0: {
                this.mIsUnableToDrag = false;
                var9_7 = var1_1.getX();
                var10_8 = var1_1.getY();
                this.mInitialMotionX = var9_7;
                this.mInitialMotionY = var10_8;
                if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)var9_7, (int)var10_8) || !this.isDimmed(this.mSlideableView)) ** GOTO lbl-1000
                var8_6 = true;
                ** continue;
            }
            case 2: 
        }
        var4_9 = var1_1.getX();
        var5_10 = var1_1.getY();
        var6_11 = Math.abs(var4_9 - this.mInitialMotionX);
        var7_12 = Math.abs(var5_10 - this.mInitialMotionY);
        ** while (!(var6_11 > (float)this.mDragHelper.getTouchSlop()) || !(var7_12 > var6_11))
lbl42:
        // 1 sources

        this.mDragHelper.cancel();
        this.mIsUnableToDrag = true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        int n6 = n4 - n2;
        int n7 = this.getPaddingLeft();
        int n8 = this.getPaddingRight();
        int n9 = this.getPaddingTop();
        int n10 = this.getChildCount();
        if (this.mFirstLayout) {
            float f2 = this.mCanSlide && this.mPreservedOpenState ? 1.0f : 0.0f;
            this.mSlideOffset = f2;
        }
        int n11 = 0;
        int n12 = n7;
        while (true) {
            int n13;
            block12: {
                block11: {
                    block10: {
                        if (n11 >= n10) break block10;
                        View view = this.getChildAt(n11);
                        if (view.getVisibility() == 8) break block11;
                        SlidingPaneLayout$LayoutParams slidingPaneLayout$LayoutParams = (SlidingPaneLayout$LayoutParams)view.getLayoutParams();
                        int n14 = view.getMeasuredWidth();
                        int n15 = 0;
                        if (slidingPaneLayout$LayoutParams.slideable) {
                            int n16;
                            int n17 = slidingPaneLayout$LayoutParams.leftMargin + slidingPaneLayout$LayoutParams.rightMargin;
                            this.mSlideRange = n16 = Math.min(n12, n6 - n8 - this.mOverhangSize) - n7 - n17;
                            boolean bl3 = n16 + (n7 + slidingPaneLayout$LayoutParams.leftMargin) + n14 / 2 > n6 - n8;
                            slidingPaneLayout$LayoutParams.dimWhenOffset = bl3;
                            n13 = n7 + ((int)((float)n16 * this.mSlideOffset) + slidingPaneLayout$LayoutParams.leftMargin);
                        } else {
                            int n18 = this.mCanSlide && this.mParallaxBy != 0 ? (int)((1.0f - this.mSlideOffset) * (float)this.mParallaxBy) : 0;
                            n15 = n18;
                            n13 = n12;
                        }
                        int n19 = n13 - n15;
                        view.layout(n19, n9, n19 + n14, n9 + view.getMeasuredHeight());
                        n12 += view.getWidth();
                        break block12;
                    }
                    if (this.mFirstLayout) {
                        if (this.mCanSlide) {
                            if (this.mParallaxBy != 0) {
                                this.parallaxOtherViews(this.mSlideOffset);
                            }
                            if (((SlidingPaneLayout$LayoutParams)this.mSlideableView.getLayoutParams()).dimWhenOffset) {
                                this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
                            }
                        } else {
                            for (int i2 = 0; i2 < n10; ++i2) {
                                this.dimChildView(this.getChildAt(i2), 0.0f, this.mSliderFadeColor);
                            }
                        }
                        this.updateObscuredViewsVisibility(this.mSlideableView);
                    }
                    this.mFirstLayout = false;
                    return;
                }
                n13 = n7;
            }
            ++n11;
            n7 = n13;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int var1_1, int var2_2) {
        block16: {
            block19: {
                block17: {
                    block18: {
                        var3_3 = View.MeasureSpec.getMode((int)var1_1);
                        var4_4 = View.MeasureSpec.getSize((int)var1_1);
                        var5_5 = View.MeasureSpec.getMode((int)var2_2);
                        var6_6 = View.MeasureSpec.getSize((int)var2_2);
                        if (var3_3 == 0x40000000) break block17;
                        if (!this.isInEditMode()) break block18;
                        if (var3_3 == -2147483648 || var3_3 != 0) ** GOTO lbl-1000
                        var7_7 = var5_5;
                        var8_8 = 300;
                        var9_9 = var6_6;
                        break block19;
                    }
                    throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
                }
                if (var5_5 != 0) ** GOTO lbl-1000
                if (!this.isInEditMode()) {
                    throw new IllegalStateException("Height must not be UNSPECIFIED");
                }
                if (var5_5 == 0) {
                    var7_7 = -2147483648;
                    var8_8 = var4_4;
                    var9_9 = 300;
                } else lbl-1000:
                // 3 sources

                {
                    var7_7 = var5_5;
                    var8_8 = var4_4;
                    var9_9 = var6_6;
                }
            }
            switch (var7_7) {
                default: {
                    var11_10 = 0;
                    var10_11 = -1;
                    break;
                }
                case 0x40000000: {
                    var10_11 = var11_10 = var9_9 - this.getPaddingTop() - this.getPaddingBottom();
                    break;
                }
                case -2147483648: {
                    var10_11 = var9_9 - this.getPaddingTop() - this.getPaddingBottom();
                    var11_10 = 0;
                }
            }
            var12_12 = false;
            var13_13 = var8_8 - this.getPaddingLeft() - this.getPaddingRight();
            var14_14 = this.getChildCount();
            if (var14_14 > 2) {
                Log.e((String)"SlidingPaneLayout", (String)"onMeasure: More than two child views are not supported.");
            }
            this.mSlideableView = null;
            var15_15 = 0;
            var16_16 = var11_10;
            var17_17 = 0.0f;
            while (true) {
                block22: {
                    block24: {
                        block20: {
                            block23: {
                                block21: {
                                    if (var15_15 >= var14_14) break block20;
                                    var29_18 = this.getChildAt(var15_15);
                                    var30_19 = (SlidingPaneLayout$LayoutParams)var29_18.getLayoutParams();
                                    if (var29_18.getVisibility() != 8) break block21;
                                    var30_19.dimWhenOffset = false;
                                    var39_28 = var13_13;
                                    var42_31 = var16_16;
                                    var40_29 = var17_17;
                                    var41_30 = var12_12;
                                    break block22;
                                }
                                if (!(var30_19.weight > 0.0f)) break block23;
                                var17_17 += var30_19.weight;
                                if (var30_19.width == 0) break block24;
                            }
                            var31_20 = var30_19.leftMargin + var30_19.rightMargin;
                            var32_21 = var30_19.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)(var8_8 - var31_20), (int)-2147483648) : (var30_19.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(var8_8 - var31_20), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)var30_19.width, (int)0x40000000));
                            var33_22 = var30_19.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)var10_11, (int)-2147483648) : (var30_19.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)var10_11, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)var30_19.height, (int)0x40000000));
                            var29_18.measure(var32_21, var33_22);
                            var34_23 = var29_18.getMeasuredWidth();
                            var35_24 = var29_18.getMeasuredHeight();
                            if (var7_7 == -2147483648 && var35_24 > var16_16) {
                                var16_16 = Math.min(var35_24, var10_11);
                            }
                            var37_26 = (var36_25 = var13_13 - var34_23) < 0;
                            var30_19.slideable = var37_26;
                            var38_27 = var37_26 | var12_12;
                            if (var30_19.slideable) {
                                this.mSlideableView = var29_18;
                            }
                            var39_28 = var36_25;
                            var40_29 = var17_17;
                            var41_30 = var38_27;
                            var42_31 = var16_16;
                            break block22;
                        }
                        if (var12_12 || var17_17 > 0.0f) {
                            var18_32 = var8_8 - this.mOverhangSize;
                            break;
                        }
                        break block16;
                    }
                    var39_28 = var13_13;
                    var42_31 = var16_16;
                    var40_29 = var17_17;
                    var41_30 = var12_12;
                }
                ++var15_15;
                var12_12 = var41_30;
                var16_16 = var42_31;
                var13_13 = var39_28;
                var17_17 = var40_29;
            }
            for (var19_33 = 0; var19_33 < var14_14; ++var19_33) {
                var20_34 = this.getChildAt(var19_33);
                if (var20_34.getVisibility() == 8) continue;
                var21_35 = (SlidingPaneLayout$LayoutParams)var20_34.getLayoutParams();
                if (var20_34.getVisibility() == 8) continue;
                var22_36 = var21_35.width == 0 && var21_35.weight > 0.0f;
                var23_37 = var22_36 != false ? 0 : var20_34.getMeasuredWidth();
                if (var12_12 && var20_34 != this.mSlideableView) {
                    if (var21_35.width >= 0 || var23_37 <= var18_32 && !(var21_35.weight > 0.0f)) continue;
                    var28_42 = var22_36 ? (var21_35.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)var10_11, (int)-2147483648) : (var21_35.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)var10_11, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)var21_35.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)var20_34.getMeasuredHeight(), (int)0x40000000);
                    var20_34.measure(View.MeasureSpec.makeMeasureSpec((int)var18_32, (int)0x40000000), var28_42);
                    continue;
                }
                if (!(var21_35.weight > 0.0f)) continue;
                var24_38 = var21_35.width == 0 ? (var21_35.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)var10_11, (int)-2147483648) : (var21_35.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)var10_11, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)var21_35.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)var20_34.getMeasuredHeight(), (int)0x40000000);
                if (var12_12) {
                    var26_40 = var8_8 - (var21_35.leftMargin + var21_35.rightMargin);
                    var27_41 = View.MeasureSpec.makeMeasureSpec((int)var26_40, (int)0x40000000);
                    if (var23_37 == var26_40) continue;
                    var20_34.measure(var27_41, var24_38);
                    continue;
                }
                var25_39 = Math.max(0, var13_13);
                var20_34.measure(View.MeasureSpec.makeMeasureSpec((int)(var23_37 + (int)(var21_35.weight * (float)var25_39 / var17_17)), (int)0x40000000), var24_38);
            }
        }
        this.setMeasuredDimension(var8_8, var16_16);
        this.mCanSlide = var12_12;
        if (this.mDragHelper.getViewDragState() != 0 && !var12_12) {
            this.mDragHelper.abort();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreInstanceState(Parcelable parcelable) {
        SlidingPaneLayout$SavedState slidingPaneLayout$SavedState = (SlidingPaneLayout$SavedState)parcelable;
        super.onRestoreInstanceState(slidingPaneLayout$SavedState.getSuperState());
        if (slidingPaneLayout$SavedState.isOpen) {
            this.openPane();
        } else {
            this.closePane();
        }
        this.mPreservedOpenState = slidingPaneLayout$SavedState.isOpen;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Parcelable onSaveInstanceState() {
        SlidingPaneLayout$SavedState slidingPaneLayout$SavedState = new SlidingPaneLayout$SavedState(super.onSaveInstanceState());
        boolean bl2 = this.isSlideable() ? this.isOpen() : this.mPreservedOpenState;
        slidingPaneLayout$SavedState.isOpen = bl2;
        return slidingPaneLayout$SavedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            this.mFirstLayout = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2;
        float f2;
        float f3;
        if (!this.mCanSlide) {
            return super.onTouchEvent(motionEvent);
        }
        this.mDragHelper.processTouchEvent(motionEvent);
        switch (0xFF & motionEvent.getAction()) {
            case 0: {
                float f4 = motionEvent.getX();
                float f5 = motionEvent.getY();
                this.mInitialMotionX = f4;
                this.mInitialMotionY = f5;
            }
            default: {
                return true;
            }
            case 1: 
        }
        if (!this.isDimmed(this.mSlideableView)) return true;
        float f6 = motionEvent.getX();
        float f7 = f6 - this.mInitialMotionX;
        if (!(f7 * f7 + (f3 = (f2 = motionEvent.getY()) - this.mInitialMotionY) * f3 < (float)((n2 = this.mDragHelper.getTouchSlop()) * n2))) return true;
        if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)f6, (int)f2)) return true;
        this.closePane(this.mSlideableView, 0);
        return true;
    }

    public boolean openPane() {
        return this.openPane(this.mSlideableView, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requestChildFocus(View view, View view2) {
        super.requestChildFocus(view, view2);
        if (!this.isInTouchMode() && !this.mCanSlide) {
            boolean bl2 = view == this.mSlideableView;
            this.mPreservedOpenState = bl2;
        }
    }

    void setAllChildrenVisible() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 4) continue;
            view.setVisibility(0);
        }
    }

    public void setCoveredFadeColor(int n2) {
        this.mCoveredFadeColor = n2;
    }

    public void setPanelSlideListener(SlidingPaneLayout$PanelSlideListener slidingPaneLayout$PanelSlideListener) {
        this.mPanelSlideListener = slidingPaneLayout$PanelSlideListener;
    }

    public void setParallaxDistance(int n2) {
        this.mParallaxBy = n2;
        this.requestLayout();
    }

    public void setShadowDrawable(Drawable drawable2) {
        this.mShadowDrawable = drawable2;
    }

    public void setShadowResource(int n2) {
        this.setShadowDrawable(this.getResources().getDrawable(n2));
    }

    public void setSliderFadeColor(int n2) {
        this.mSliderFadeColor = n2;
    }

    @Deprecated
    public void smoothSlideClosed() {
        this.closePane();
    }

    @Deprecated
    public void smoothSlideOpen() {
        this.openPane();
    }

    boolean smoothSlideTo(float f2, int n2) {
        if (!this.mCanSlide) {
            return false;
        }
        SlidingPaneLayout$LayoutParams slidingPaneLayout$LayoutParams = (SlidingPaneLayout$LayoutParams)this.mSlideableView.getLayoutParams();
        int n3 = (int)((float)(this.getPaddingLeft() + slidingPaneLayout$LayoutParams.leftMargin) + f2 * (float)this.mSlideRange);
        if (this.mDragHelper.smoothSlideViewTo(this.mSlideableView, n3, this.mSlideableView.getTop())) {
            this.setAllChildrenVisible();
            ViewCompat.postInvalidateOnAnimation((View)this);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateObscuredViewsVisibility(View view) {
        View view2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getPaddingLeft();
        int n7 = this.getWidth() - this.getPaddingRight();
        int n8 = this.getPaddingTop();
        int n9 = this.getHeight() - this.getPaddingBottom();
        if (view != null && SlidingPaneLayout.viewIsOpaque(view)) {
            n5 = view.getLeft();
            n4 = view.getRight();
            n3 = view.getTop();
            n2 = view.getBottom();
        } else {
            n2 = 0;
            n3 = 0;
            n4 = 0;
            n5 = 0;
        }
        int n10 = this.getChildCount();
        for (int i2 = 0; i2 < n10 && (view2 = this.getChildAt(i2)) != view; ++i2) {
            int n11 = Math.max(n6, view2.getLeft());
            int n12 = Math.max(n8, view2.getTop());
            int n13 = Math.min(n7, view2.getRight());
            int n14 = Math.min(n9, view2.getBottom());
            int n15 = n11 >= n5 && n12 >= n3 && n13 <= n4 && n14 <= n2 ? 4 : 0;
            view2.setVisibility(n15);
        }
    }
}

