/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewParentCompat;
import android.support.v4.view.a.a;
import android.support.v4.view.a.e;
import android.support.v4.view.a.i;
import android.support.v4.view.a.o;
import android.support.v4.widget.ExploreByTouchHelper$ExploreByTouchNodeProvider;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import java.util.LinkedList;
import java.util.List;

public abstract class ExploreByTouchHelper
extends AccessibilityDelegateCompat {
    private static final String DEFAULT_CLASS_NAME = View.class.getName();
    public static final int INVALID_ID = Integer.MIN_VALUE;
    private int mFocusedVirtualViewId;
    private int mHoveredVirtualViewId;
    private final AccessibilityManager mManager;
    private ExploreByTouchHelper$ExploreByTouchNodeProvider mNodeProvider;
    private final int[] mTempGlobalRect;
    private final Rect mTempParentRect;
    private final Rect mTempScreenRect = new Rect();
    private final Rect mTempVisibleRect;
    private final View mView;

    public ExploreByTouchHelper(View view) {
        this.mTempParentRect = new Rect();
        this.mTempVisibleRect = new Rect();
        this.mTempGlobalRect = new int[2];
        this.mFocusedVirtualViewId = Integer.MIN_VALUE;
        this.mHoveredVirtualViewId = Integer.MIN_VALUE;
        if (view == null) {
            throw new IllegalArgumentException("View may not be null");
        }
        this.mView = view;
        this.mManager = (AccessibilityManager)view.getContext().getSystemService("accessibility");
    }

    static /* synthetic */ i access$100(ExploreByTouchHelper exploreByTouchHelper, int n2) {
        return exploreByTouchHelper.createNode(n2);
    }

    static /* synthetic */ boolean access$200(ExploreByTouchHelper exploreByTouchHelper, int n2, int n3, Bundle bundle) {
        return exploreByTouchHelper.performAction(n2, n3, bundle);
    }

    private boolean clearAccessibilityFocus(int n2) {
        if (this.isAccessibilityFocused(n2)) {
            this.mFocusedVirtualViewId = Integer.MIN_VALUE;
            this.mView.invalidate();
            this.sendEventForVirtualView(n2, 65536);
            return true;
        }
        return false;
    }

    private AccessibilityEvent createEvent(int n2, int n3) {
        switch (n2) {
            default: {
                return this.createEventForChild(n2, n3);
            }
            case -1: 
        }
        return this.createEventForHost(n3);
    }

    private AccessibilityEvent createEventForChild(int n2, int n3) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n3);
        accessibilityEvent.setEnabled(true);
        accessibilityEvent.setClassName((CharSequence)DEFAULT_CLASS_NAME);
        this.onPopulateEventForVirtualView(n2, accessibilityEvent);
        if (accessibilityEvent.getText().isEmpty() && accessibilityEvent.getContentDescription() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateEventForVirtualViewId()");
        }
        accessibilityEvent.setPackageName((CharSequence)this.mView.getContext().getPackageName());
        a.a(accessibilityEvent).a(this.mView, n2);
        return accessibilityEvent;
    }

    private AccessibilityEvent createEventForHost(int n2) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n2);
        ViewCompat.onInitializeAccessibilityEvent(this.mView, accessibilityEvent);
        return accessibilityEvent;
    }

    private i createNode(int n2) {
        switch (n2) {
            default: {
                return this.createNodeForChild(n2);
            }
            case -1: 
        }
        return this.createNodeForHost();
    }

    /*
     * Enabled aggressive block sorting
     */
    private i createNodeForChild(int n2) {
        i i2 = i.b();
        i2.h(true);
        i2.b(DEFAULT_CLASS_NAME);
        this.onPopulateNodeForVirtualView(n2, i2);
        if (i2.o() == null && i2.p() == null) {
            throw new RuntimeException("Callbacks must add text or a content description in populateNodeForVirtualViewId()");
        }
        i2.a(this.mTempParentRect);
        if (this.mTempParentRect.isEmpty()) {
            throw new RuntimeException("Callbacks must set parent bounds in populateNodeForVirtualViewId()");
        }
        int n3 = i2.c();
        if ((n3 & 0x40) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        if ((n3 & 0x80) != 0) {
            throw new RuntimeException("Callbacks must not add ACTION_CLEAR_ACCESSIBILITY_FOCUS in populateNodeForVirtualViewId()");
        }
        i2.a(this.mView.getContext().getPackageName());
        i2.a(this.mView, n2);
        i2.d(this.mView);
        if (this.mFocusedVirtualViewId == n2) {
            i2.d(true);
            i2.a(128);
        } else {
            i2.d(false);
            i2.a(64);
        }
        if (this.intersectVisibleToUser(this.mTempParentRect)) {
            i2.c(true);
            i2.b(this.mTempParentRect);
        }
        this.mView.getLocationOnScreen(this.mTempGlobalRect);
        int n4 = this.mTempGlobalRect[0];
        int n5 = this.mTempGlobalRect[1];
        this.mTempScreenRect.set(this.mTempParentRect);
        this.mTempScreenRect.offset(n4, n5);
        i2.d(this.mTempScreenRect);
        return i2;
    }

    private i createNodeForHost() {
        i i2 = i.a(this.mView);
        ViewCompat.onInitializeAccessibilityNodeInfo(this.mView, i2);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        this.getVisibleVirtualViews(linkedList);
        for (Integer n2 : linkedList) {
            i2.b(this.mView, n2);
        }
        return i2;
    }

    private boolean intersectVisibleToUser(Rect rect) {
        if (rect == null || rect.isEmpty()) {
            return false;
        }
        if (this.mView.getWindowVisibility() != 0) {
            return false;
        }
        ViewParent viewParent = this.mView.getParent();
        while (viewParent instanceof View) {
            View view = (View)viewParent;
            if (ViewCompat.getAlpha(view) <= 0.0f || view.getVisibility() != 0) {
                return false;
            }
            viewParent = view.getParent();
        }
        if (viewParent == null) {
            return false;
        }
        if (!this.mView.getLocalVisibleRect(this.mTempVisibleRect)) {
            return false;
        }
        return rect.intersect(this.mTempVisibleRect);
    }

    private boolean isAccessibilityFocused(int n2) {
        return this.mFocusedVirtualViewId == n2;
    }

    private boolean manageFocusForChild(int n2, int n3, Bundle bundle) {
        switch (n3) {
            default: {
                return false;
            }
            case 64: {
                return this.requestAccessibilityFocus(n2);
            }
            case 128: 
        }
        return this.clearAccessibilityFocus(n2);
    }

    private boolean performAction(int n2, int n3, Bundle bundle) {
        switch (n2) {
            default: {
                return this.performActionForChild(n2, n3, bundle);
            }
            case -1: 
        }
        return this.performActionForHost(n3, bundle);
    }

    private boolean performActionForChild(int n2, int n3, Bundle bundle) {
        switch (n3) {
            default: {
                return this.onPerformActionForVirtualView(n2, n3, bundle);
            }
            case 64: 
            case 128: 
        }
        return this.manageFocusForChild(n2, n3, bundle);
    }

    private boolean performActionForHost(int n2, Bundle bundle) {
        return ViewCompat.performAccessibilityAction(this.mView, n2, bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean requestAccessibilityFocus(int n2) {
        if (!this.mManager.isEnabled() || !e.a(this.mManager) || this.isAccessibilityFocused(n2)) {
            return false;
        }
        this.mFocusedVirtualViewId = n2;
        this.mView.invalidate();
        this.sendEventForVirtualView(n2, 32768);
        return true;
    }

    private void updateHoveredVirtualView(int n2) {
        if (this.mHoveredVirtualViewId == n2) {
            return;
        }
        int n3 = this.mHoveredVirtualViewId;
        this.mHoveredVirtualViewId = n2;
        this.sendEventForVirtualView(n2, 128);
        this.sendEventForVirtualView(n3, 256);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        boolean bl2 = true;
        if (!this.mManager.isEnabled()) return false;
        if (!e.a(this.mManager)) {
            return false;
        }
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 7: 
            case 9: {
                int n2 = this.getVirtualViewAt(motionEvent.getX(), motionEvent.getY());
                this.updateHoveredVirtualView(n2);
                if (n2 != Integer.MIN_VALUE) return bl2;
                return false;
            }
            case 10: 
        }
        if (this.mFocusedVirtualViewId == Integer.MIN_VALUE) return false;
        this.updateHoveredVirtualView(Integer.MIN_VALUE);
        return bl2;
    }

    @Override
    public o getAccessibilityNodeProvider(View view) {
        if (this.mNodeProvider == null) {
            this.mNodeProvider = new ExploreByTouchHelper$ExploreByTouchNodeProvider(this, null);
        }
        return this.mNodeProvider;
    }

    public int getFocusedVirtualView() {
        return this.mFocusedVirtualViewId;
    }

    protected abstract int getVirtualViewAt(float var1, float var2);

    protected abstract void getVisibleVirtualViews(List<Integer> var1);

    public void invalidateRoot() {
        this.invalidateVirtualView(-1);
    }

    public void invalidateVirtualView(int n2) {
        this.sendEventForVirtualView(n2, 2048);
    }

    protected abstract boolean onPerformActionForVirtualView(int var1, int var2, Bundle var3);

    protected abstract void onPopulateEventForVirtualView(int var1, AccessibilityEvent var2);

    protected abstract void onPopulateNodeForVirtualView(int var1, i var2);

    /*
     * Enabled aggressive block sorting
     */
    public boolean sendEventForVirtualView(int n2, int n3) {
        ViewParent viewParent;
        if (n2 == Integer.MIN_VALUE || !this.mManager.isEnabled() || (viewParent = this.mView.getParent()) == null) {
            return false;
        }
        AccessibilityEvent accessibilityEvent = this.createEvent(n2, n3);
        return ViewParentCompat.requestSendAccessibilityEvent(viewParent, this.mView, accessibilityEvent);
    }
}

