/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.widget.DrawerLayout$AccessibilityDelegate;
import android.support.v4.widget.DrawerLayout$DrawerListener;
import android.support.v4.widget.DrawerLayout$LayoutParams;
import android.support.v4.widget.DrawerLayout$SavedState;
import android.support.v4.widget.DrawerLayout$ViewDragCallback;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

public class DrawerLayout
extends ViewGroup {
    private static final boolean ALLOW_EDGE_LOCK = false;
    private static final boolean CHILDREN_DISALLOW_INTERCEPT = true;
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int[] LAYOUT_ATTRS = new int[]{16842931};
    public static final int LOCK_MODE_LOCKED_CLOSED = 1;
    public static final int LOCK_MODE_LOCKED_OPEN = 2;
    public static final int LOCK_MODE_UNLOCKED = 0;
    private static final int MIN_DRAWER_MARGIN = 64;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final int PEEK_DELAY = 160;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_SETTLING = 2;
    private static final String TAG = "DrawerLayout";
    private static final float TOUCH_SLOP_SENSITIVITY = 1.0f;
    private boolean mChildrenCanceledTouch;
    private boolean mDisallowInterceptRequested;
    private int mDrawerState;
    private boolean mFirstLayout = true;
    private boolean mInLayout;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private final DrawerLayout$ViewDragCallback mLeftCallback;
    private final ViewDragHelper mLeftDragger;
    private DrawerLayout$DrawerListener mListener;
    private int mLockModeLeft;
    private int mLockModeRight;
    private int mMinDrawerMargin;
    private final DrawerLayout$ViewDragCallback mRightCallback;
    private final ViewDragHelper mRightDragger;
    private int mScrimColor = -1728053248;
    private float mScrimOpacity;
    private Paint mScrimPaint = new Paint();
    private Drawable mShadowLeft;
    private Drawable mShadowRight;

    public DrawerLayout(Context context) {
        this(context, null);
    }

    public DrawerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DrawerLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        float f2 = this.getResources().getDisplayMetrics().density;
        this.mMinDrawerMargin = (int)(0.5f + 64.0f * f2);
        float f3 = f2 * 400.0f;
        this.mLeftCallback = new DrawerLayout$ViewDragCallback(this, 3);
        this.mRightCallback = new DrawerLayout$ViewDragCallback(this, 5);
        this.mLeftDragger = ViewDragHelper.create(this, 1.0f, this.mLeftCallback);
        this.mLeftDragger.setEdgeTrackingEnabled(1);
        this.mLeftDragger.setMinVelocity(f3);
        this.mLeftCallback.setDragger(this.mLeftDragger);
        this.mRightDragger = ViewDragHelper.create(this, 1.0f, this.mRightCallback);
        this.mRightDragger.setEdgeTrackingEnabled(2);
        this.mRightDragger.setMinVelocity(f3);
        this.mRightCallback.setDragger(this.mRightDragger);
        this.setFocusableInTouchMode(true);
        ViewCompat.setAccessibilityDelegate((View)this, new DrawerLayout$AccessibilityDelegate(this));
        ViewGroupCompat.setMotionEventSplittingEnabled(this, false);
    }

    static /* synthetic */ int[] access$100() {
        return LAYOUT_ATTRS;
    }

    private View findVisibleDrawer() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (!this.isDrawerView(view) || !this.isDrawerVisible(view)) continue;
            return view;
        }
        return null;
    }

    static String gravityToString(int n2) {
        if ((n2 & 3) == 3) {
            return "LEFT";
        }
        if ((n2 & 5) == 5) {
            return "RIGHT";
        }
        return Integer.toHexString(n2);
    }

    private static boolean hasOpaqueBackground(View view) {
        Drawable drawable2 = view.getBackground();
        boolean bl2 = false;
        if (drawable2 != null) {
            int n2 = drawable2.getOpacity();
            bl2 = false;
            if (n2 == -1) {
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean hasPeekingDrawer() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((DrawerLayout$LayoutParams)this.getChildAt((int)i2).getLayoutParams()).isPeeking) continue;
            return true;
        }
        return false;
    }

    private boolean hasVisibleDrawer() {
        return this.findVisibleDrawer() != null;
    }

    void cancelChildViewTouch() {
        if (!this.mChildrenCanceledTouch) {
            long l2 = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0);
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getChildAt(i2).dispatchTouchEvent(motionEvent);
            }
            motionEvent.recycle();
            this.mChildrenCanceledTouch = true;
        }
    }

    boolean checkDrawerViewGravity(View view, int n2) {
        return (n2 & this.getDrawerViewGravity(view)) == n2;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof DrawerLayout$LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public void closeDrawer(int n2) {
        int n3 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this));
        View view = this.findDrawerWithGravity(n3);
        if (view == null) {
            throw new IllegalArgumentException("No drawer view found with absolute gravity " + DrawerLayout.gravityToString(n3));
        }
        this.closeDrawer(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void closeDrawer(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a sliding drawer");
        }
        if (this.mFirstLayout) {
            DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
            drawerLayout$LayoutParams.onScreen = 0.0f;
            drawerLayout$LayoutParams.knownOpen = false;
        } else if (this.checkDrawerViewGravity(view, 3)) {
            this.mLeftDragger.smoothSlideViewTo(view, -view.getWidth(), view.getTop());
        } else {
            this.mRightDragger.smoothSlideViewTo(view, this.getWidth(), view.getTop());
        }
        this.invalidate();
    }

    public void closeDrawers() {
        this.closeDrawers(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void closeDrawers(boolean bl2) {
        int n2 = this.getChildCount();
        boolean bl3 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
            if (!this.isDrawerView(view) || bl2 && !drawerLayout$LayoutParams.isPeeking) continue;
            int n3 = view.getWidth();
            bl3 = this.checkDrawerViewGravity(view, 3) ? (bl3 |= this.mLeftDragger.smoothSlideViewTo(view, -n3, view.getTop())) : (bl3 |= this.mRightDragger.smoothSlideViewTo(view, this.getWidth(), view.getTop()));
            drawerLayout$LayoutParams.isPeeking = false;
        }
        this.mLeftCallback.removeCallbacks();
        this.mRightCallback.removeCallbacks();
        if (bl3) {
            this.invalidate();
        }
    }

    public void computeScroll() {
        int n2 = this.getChildCount();
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 = Math.max(f2, ((DrawerLayout$LayoutParams)this.getChildAt((int)i2).getLayoutParams()).onScreen);
        }
        this.mScrimOpacity = f2;
        if (this.mLeftDragger.continueSettling(true) | this.mRightDragger.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void dispatchOnDrawerClosed(View view) {
        DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
        if (drawerLayout$LayoutParams.knownOpen) {
            drawerLayout$LayoutParams.knownOpen = false;
            if (this.mListener != null) {
                this.mListener.onDrawerClosed(view);
            }
            this.sendAccessibilityEvent(32);
        }
    }

    void dispatchOnDrawerOpened(View view) {
        DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
        if (!drawerLayout$LayoutParams.knownOpen) {
            drawerLayout$LayoutParams.knownOpen = true;
            if (this.mListener != null) {
                this.mListener.onDrawerOpened(view);
            }
            view.sendAccessibilityEvent(32);
        }
    }

    void dispatchOnDrawerSlide(View view, float f2) {
        if (this.mListener != null) {
            this.mListener.onDrawerSlide(view, f2);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected boolean drawChild(Canvas canvas, View view, long l2) {
        int n2 = this.getHeight();
        boolean bl2 = this.isContentView(view);
        int n3 = this.getWidth();
        int n4 = canvas.save();
        int n5 = 0;
        boolean bl3 = true;
        while (true) {
            int n6;
            int n7;
            block14: {
                int n8;
                block13: {
                    block12: {
                        block8: {
                            block9: {
                                block10: {
                                    View view2;
                                    block11: {
                                        int n9;
                                        block7: {
                                            if (!bl3 || (bl3 = false)) break block7;
                                            if (!bl2) break block8;
                                            n9 = this.getChildCount();
                                            n7 = 0;
                                        }
                                        if (n7 >= n9) break block9;
                                        view2 = this.getChildAt(n7);
                                        if (view2 == view || view2.getVisibility() != 0 || !DrawerLayout.hasOpaqueBackground(view2) || !this.isDrawerView(view2) || view2.getHeight() < n2) break block10;
                                        if (!this.checkDrawerViewGravity(view2, 3)) break block11;
                                        n8 = view2.getRight();
                                        if (n8 <= n5) break block12;
                                        break block13;
                                    }
                                    n6 = view2.getLeft();
                                    if (n6 < n3) break block14;
                                }
                                n6 = n3;
                                break block14;
                            }
                            canvas.clipRect(n5, 0, n3, this.getHeight());
                        }
                        int n10 = n3;
                        boolean bl4 = super.drawChild(canvas, view, l2);
                        canvas.restoreToCount(n4);
                        if (this.mScrimOpacity > 0.0f && bl2) {
                            int n11 = (int)((float)((0xFF000000 & this.mScrimColor) >>> 24) * this.mScrimOpacity) << 24 | 0xFFFFFF & this.mScrimColor;
                            this.mScrimPaint.setColor(n11);
                            canvas.drawRect((float)n5, 0.0f, (float)n10, (float)this.getHeight(), this.mScrimPaint);
                            return bl4;
                        } else {
                            if (this.mShadowLeft != null && this.checkDrawerViewGravity(view, 3)) {
                                int n12 = this.mShadowLeft.getIntrinsicWidth();
                                int n13 = view.getRight();
                                int n14 = this.mLeftDragger.getEdgeSize();
                                float f2 = Math.max(0.0f, Math.min((float)n13 / (float)n14, 1.0f));
                                this.mShadowLeft.setBounds(n13, view.getTop(), n12 + n13, view.getBottom());
                                this.mShadowLeft.setAlpha((int)(255.0f * f2));
                                this.mShadowLeft.draw(canvas);
                                return bl4;
                            }
                            if (this.mShadowRight == null || !this.checkDrawerViewGravity(view, 5)) return bl4;
                            int n15 = this.mShadowRight.getIntrinsicWidth();
                            int n16 = view.getLeft();
                            int n17 = this.getWidth() - n16;
                            int n18 = this.mRightDragger.getEdgeSize();
                            float f3 = Math.max(0.0f, Math.min((float)n17 / (float)n18, 1.0f));
                            this.mShadowRight.setBounds(n16 - n15, view.getTop(), n16, view.getBottom());
                            this.mShadowRight.setAlpha((int)(255.0f * f3));
                            this.mShadowRight.draw(canvas);
                            return bl4;
                        }
                    }
                    n8 = n5;
                }
                n5 = n8;
                n6 = n3;
            }
            ++n7;
            n3 = n6;
        }
    }

    View findDrawerWithGravity(int n2) {
        int n3 = this.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            View view = this.getChildAt(i2);
            if ((7 & this.getDrawerViewGravity(view)) != (n2 & 7)) continue;
            return view;
        }
        return null;
    }

    View findOpenDrawer() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (!((DrawerLayout$LayoutParams)view.getLayoutParams()).knownOpen) continue;
            return view;
        }
        return null;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new DrawerLayout$LayoutParams(-1, -1);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new DrawerLayout$LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof DrawerLayout$LayoutParams) {
            return new DrawerLayout$LayoutParams((DrawerLayout$LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new DrawerLayout$LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new DrawerLayout$LayoutParams(layoutParams);
    }

    public int getDrawerLockMode(int n2) {
        int n3 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this));
        if (n3 == 3) {
            return this.mLockModeLeft;
        }
        if (n3 == 5) {
            return this.mLockModeRight;
        }
        return 0;
    }

    public int getDrawerLockMode(View view) {
        int n2 = this.getDrawerViewGravity(view);
        if (n2 == 3) {
            return this.mLockModeLeft;
        }
        if (n2 == 5) {
            return this.mLockModeRight;
        }
        return 0;
    }

    int getDrawerViewGravity(View view) {
        return GravityCompat.getAbsoluteGravity(((DrawerLayout$LayoutParams)view.getLayoutParams()).gravity, ViewCompat.getLayoutDirection(view));
    }

    float getDrawerViewOffset(View view) {
        return ((DrawerLayout$LayoutParams)view.getLayoutParams()).onScreen;
    }

    boolean isContentView(View view) {
        return ((DrawerLayout$LayoutParams)view.getLayoutParams()).gravity == 0;
    }

    public boolean isDrawerOpen(int n2) {
        View view = this.findDrawerWithGravity(n2);
        if (view != null) {
            return this.isDrawerOpen(view);
        }
        return false;
    }

    public boolean isDrawerOpen(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a drawer");
        }
        return ((DrawerLayout$LayoutParams)view.getLayoutParams()).knownOpen;
    }

    boolean isDrawerView(View view) {
        return (7 & GravityCompat.getAbsoluteGravity(((DrawerLayout$LayoutParams)view.getLayoutParams()).gravity, ViewCompat.getLayoutDirection(view))) != 0;
    }

    public boolean isDrawerVisible(int n2) {
        View view = this.findDrawerWithGravity(n2);
        if (view != null) {
            return this.isDrawerVisible(view);
        }
        return false;
    }

    public boolean isDrawerVisible(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a drawer");
        }
        return ((DrawerLayout$LayoutParams)view.getLayoutParams()).onScreen > 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveDrawerToOffset(View view, float f2) {
        float f3 = this.getDrawerViewOffset(view);
        int n2 = view.getWidth();
        int n3 = (int)(f3 * (float)n2);
        int n4 = (int)(f2 * (float)n2) - n3;
        if (!this.checkDrawerViewGravity(view, 3)) {
            n4 = -n4;
        }
        view.offsetLeftAndRight(n4);
        this.setDrawerViewOffset(view, f2);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean bl2;
        boolean bl3;
        block5: {
            int n2 = MotionEventCompat.getActionMasked(motionEvent);
            bl3 = this.mLeftDragger.shouldInterceptTouchEvent(motionEvent) | this.mRightDragger.shouldInterceptTouchEvent(motionEvent);
            switch (n2) {
                case 0: {
                    float f2 = motionEvent.getX();
                    float f3 = motionEvent.getY();
                    this.mInitialMotionX = f2;
                    this.mInitialMotionY = f3;
                    bl2 = this.mScrimOpacity > 0.0f && this.isContentView(this.mLeftDragger.findTopChildUnder((int)f2, (int)f3));
                }
                case 2: {
                    if (!this.mLeftDragger.checkTouchSlop(3)) break;
                    this.mLeftCallback.removeCallbacks();
                    this.mRightCallback.removeCallbacks();
                    bl2 = false;
                    break block5;
                }
                case 1: 
                case 3: {
                    this.closeDrawers(true);
                    this.mDisallowInterceptRequested = false;
                    this.mChildrenCanceledTouch = false;
                }
            }
            bl2 = false;
            break block5;
            this.mDisallowInterceptRequested = false;
            this.mChildrenCanceledTouch = false;
        }
        if (bl3) return true;
        if (bl2) return true;
        if (this.hasPeekingDrawer()) return true;
        boolean bl4 = this.mChildrenCanceledTouch;
        boolean bl5 = false;
        if (!bl4) return bl5;
        return true;
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (n2 == 4 && this.hasVisibleDrawer()) {
            KeyEventCompat.startTracking(keyEvent);
            return true;
        }
        return super.onKeyDown(n2, keyEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        if (n2 == 4) {
            View view = this.findVisibleDrawer();
            if (view != null && this.getDrawerLockMode(view) == 0) {
                this.closeDrawers();
            }
            return view != null;
        }
        return super.onKeyUp(n2, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        this.mInLayout = true;
        int n6 = n4 - n2;
        int n7 = this.getChildCount();
        int n8 = 0;
        while (true) {
            if (n8 >= n7) {
                this.mInLayout = false;
                this.mFirstLayout = false;
                return;
            }
            View view = this.getChildAt(n8);
            if (view.getVisibility() != 8) {
                DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
                if (this.isContentView(view)) {
                    view.layout(drawerLayout$LayoutParams.leftMargin, drawerLayout$LayoutParams.topMargin, drawerLayout$LayoutParams.leftMargin + view.getMeasuredWidth(), drawerLayout$LayoutParams.topMargin + view.getMeasuredHeight());
                } else {
                    float f2;
                    int n9;
                    int n10 = view.getMeasuredWidth();
                    int n11 = view.getMeasuredHeight();
                    if (this.checkDrawerViewGravity(view, 3)) {
                        n9 = -n10 + (int)((float)n10 * drawerLayout$LayoutParams.onScreen);
                        f2 = (float)(n10 + n9) / (float)n10;
                    } else {
                        n9 = n6 - (int)((float)n10 * drawerLayout$LayoutParams.onScreen);
                        f2 = (float)(n6 - n9) / (float)n10;
                    }
                    boolean bl3 = f2 != drawerLayout$LayoutParams.onScreen;
                    switch (0x70 & drawerLayout$LayoutParams.gravity) {
                        default: {
                            view.layout(n9, drawerLayout$LayoutParams.topMargin, n10 + n9, n11);
                            break;
                        }
                        case 80: {
                            int n12 = n5 - n3;
                            view.layout(n9, n12 - drawerLayout$LayoutParams.bottomMargin - view.getMeasuredHeight(), n10 + n9, n12 - drawerLayout$LayoutParams.bottomMargin);
                            break;
                        }
                        case 16: {
                            int n13 = n5 - n3;
                            int n14 = (n13 - n11) / 2;
                            if (n14 < drawerLayout$LayoutParams.topMargin) {
                                n14 = drawerLayout$LayoutParams.topMargin;
                            } else if (n14 + n11 > n13 - drawerLayout$LayoutParams.bottomMargin) {
                                n14 = n13 - drawerLayout$LayoutParams.bottomMargin - n11;
                            }
                            view.layout(n9, n14, n10 + n9, n11 + n14);
                        }
                    }
                    if (bl3) {
                        this.setDrawerViewOffset(view, f2);
                    }
                    int n15 = drawerLayout$LayoutParams.onScreen > 0.0f ? 0 : 4;
                    if (view.getVisibility() != n15) {
                        view.setVisibility(n15);
                    }
                }
            }
            ++n8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        block13: {
            int n6;
            block12: {
                n5 = 300;
                int n7 = View.MeasureSpec.getMode((int)n2);
                int n8 = View.MeasureSpec.getMode((int)n3);
                n4 = View.MeasureSpec.getSize((int)n2);
                n6 = View.MeasureSpec.getSize((int)n3);
                if (n7 == 0x40000000 && n8 == 0x40000000) break block12;
                if (!this.isInEditMode()) {
                    throw new IllegalArgumentException("DrawerLayout must be measured with MeasureSpec.EXACTLY.");
                }
                if (n7 != Integer.MIN_VALUE && n7 == 0) {
                    n4 = n5;
                }
                if (n8 != Integer.MIN_VALUE && n8 == 0) break block13;
            }
            n5 = n6;
        }
        this.setMeasuredDimension(n4, n5);
        int n9 = this.getChildCount();
        int n10 = 0;
        while (n10 < n9) {
            View view = this.getChildAt(n10);
            if (view.getVisibility() != 8) {
                DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
                if (this.isContentView(view)) {
                    view.measure(View.MeasureSpec.makeMeasureSpec((int)(n4 - drawerLayout$LayoutParams.leftMargin - drawerLayout$LayoutParams.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n5 - drawerLayout$LayoutParams.topMargin - drawerLayout$LayoutParams.bottomMargin), (int)0x40000000));
                } else {
                    if (!this.isDrawerView(view)) {
                        throw new IllegalStateException("Child " + view + " at index " + n10 + " does not have a valid layout_gravity - must be Gravity.LEFT, Gravity.RIGHT or Gravity.NO_GRAVITY");
                    }
                    int n11 = 7 & this.getDrawerViewGravity(view);
                    if ((n11 & 0) != 0) {
                        throw new IllegalStateException("Child drawer has absolute gravity " + DrawerLayout.gravityToString(n11) + " but this DrawerLayout already has a drawer view along that edge");
                    }
                    view.measure(DrawerLayout.getChildMeasureSpec((int)n2, (int)(this.mMinDrawerMargin + drawerLayout$LayoutParams.leftMargin + drawerLayout$LayoutParams.rightMargin), (int)drawerLayout$LayoutParams.width), DrawerLayout.getChildMeasureSpec((int)n3, (int)(drawerLayout$LayoutParams.topMargin + drawerLayout$LayoutParams.bottomMargin), (int)drawerLayout$LayoutParams.height));
                }
            }
            ++n10;
        }
        return;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        View view;
        DrawerLayout$SavedState drawerLayout$SavedState = (DrawerLayout$SavedState)parcelable;
        super.onRestoreInstanceState(drawerLayout$SavedState.getSuperState());
        if (drawerLayout$SavedState.openDrawerGravity != 0 && (view = this.findDrawerWithGravity(drawerLayout$SavedState.openDrawerGravity)) != null) {
            this.openDrawer(view);
        }
        this.setDrawerLockMode(drawerLayout$SavedState.lockModeLeft, 3);
        this.setDrawerLockMode(drawerLayout$SavedState.lockModeRight, 5);
    }

    protected Parcelable onSaveInstanceState() {
        DrawerLayout$SavedState drawerLayout$SavedState = new DrawerLayout$SavedState(super.onSaveInstanceState());
        int n2 = this.getChildCount();
        int n3 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n3 >= n2) break block3;
                    View view = this.getChildAt(n3);
                    if (!this.isDrawerView(view)) break block4;
                    DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
                    if (!drawerLayout$LayoutParams.knownOpen) break block4;
                    drawerLayout$SavedState.openDrawerGravity = drawerLayout$LayoutParams.gravity;
                }
                drawerLayout$SavedState.lockModeLeft = this.mLockModeLeft;
                drawerLayout$SavedState.lockModeRight = this.mLockModeRight;
                return drawerLayout$SavedState;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl2;
        block5: {
            this.mLeftDragger.processTouchEvent(motionEvent);
            this.mRightDragger.processTouchEvent(motionEvent);
            switch (0xFF & motionEvent.getAction()) {
                default: {
                    return true;
                }
                case 0: {
                    float f2 = motionEvent.getX();
                    float f3 = motionEvent.getY();
                    this.mInitialMotionX = f2;
                    this.mInitialMotionY = f3;
                    this.mDisallowInterceptRequested = false;
                    this.mChildrenCanceledTouch = false;
                    return true;
                }
                case 1: {
                    View view;
                    int n2;
                    float f4;
                    float f5;
                    float f6 = motionEvent.getX();
                    float f7 = motionEvent.getY();
                    View view2 = this.mLeftDragger.findTopChildUnder((int)f6, (int)f7);
                    if (view2 == null || !this.isContentView(view2) || !((f5 = f6 - this.mInitialMotionX) * f5 + (f4 = f7 - this.mInitialMotionY) * f4 < (float)((n2 = this.mLeftDragger.getTouchSlop()) * n2)) || (view = this.findOpenDrawer()) == null) break;
                    bl2 = this.getDrawerLockMode(view) == 2;
                    break block5;
                }
                case 3: {
                    this.closeDrawers(true);
                    this.mDisallowInterceptRequested = false;
                    this.mChildrenCanceledTouch = false;
                    return true;
                }
            }
            bl2 = true;
        }
        this.closeDrawers(bl2);
        this.mDisallowInterceptRequested = false;
        return true;
    }

    public void openDrawer(int n2) {
        int n3 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this));
        View view = this.findDrawerWithGravity(n3);
        if (view == null) {
            throw new IllegalArgumentException("No drawer view found with absolute gravity " + DrawerLayout.gravityToString(n3));
        }
        this.openDrawer(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void openDrawer(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a sliding drawer");
        }
        if (this.mFirstLayout) {
            DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
            drawerLayout$LayoutParams.onScreen = 1.0f;
            drawerLayout$LayoutParams.knownOpen = true;
        } else if (this.checkDrawerViewGravity(view, 3)) {
            this.mLeftDragger.smoothSlideViewTo(view, 0, view.getTop());
        } else {
            this.mRightDragger.smoothSlideViewTo(view, this.getWidth() - view.getWidth(), view.getTop());
        }
        this.invalidate();
    }

    public void requestDisallowInterceptTouchEvent(boolean bl2) {
        super.requestDisallowInterceptTouchEvent(bl2);
        this.mDisallowInterceptRequested = bl2;
        if (bl2) {
            this.closeDrawers(true);
        }
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void setDrawerListener(DrawerLayout$DrawerListener drawerLayout$DrawerListener) {
        this.mListener = drawerLayout$DrawerListener;
    }

    public void setDrawerLockMode(int n2) {
        this.setDrawerLockMode(n2, 3);
        this.setDrawerLockMode(n2, 5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDrawerLockMode(int n2, int n3) {
        int n4 = GravityCompat.getAbsoluteGravity(n3, ViewCompat.getLayoutDirection((View)this));
        if (n4 == 3) {
            this.mLockModeLeft = n2;
        } else if (n4 == 5) {
            this.mLockModeRight = n2;
        }
        if (n2 != 0) {
            ViewDragHelper viewDragHelper = n4 == 3 ? this.mLeftDragger : this.mRightDragger;
            viewDragHelper.cancel();
        }
        switch (n2) {
            case 2: {
                View view = this.findDrawerWithGravity(n4);
                if (view == null) return;
                this.openDrawer(view);
                return;
            }
            default: {
                return;
            }
            case 1: {
                View view = this.findDrawerWithGravity(n4);
                if (view == null) return;
                this.closeDrawer(view);
                return;
            }
        }
    }

    public void setDrawerLockMode(int n2, View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a drawer with appropriate layout_gravity");
        }
        this.setDrawerLockMode(n2, this.getDrawerViewGravity(view));
    }

    public void setDrawerShadow(int n2, int n3) {
        this.setDrawerShadow(this.getResources().getDrawable(n2), n3);
    }

    public void setDrawerShadow(Drawable drawable2, int n2) {
        int n3 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this));
        if ((n3 & 3) == 3) {
            this.mShadowLeft = drawable2;
            this.invalidate();
        }
        if ((n3 & 5) == 5) {
            this.mShadowRight = drawable2;
            this.invalidate();
        }
    }

    void setDrawerViewOffset(View view, float f2) {
        DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
        if (f2 == drawerLayout$LayoutParams.onScreen) {
            return;
        }
        drawerLayout$LayoutParams.onScreen = f2;
        this.dispatchOnDrawerSlide(view, f2);
    }

    public void setScrimColor(int n2) {
        this.mScrimColor = n2;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateDrawerState(int n2, int n3, View view) {
        int n4 = 1;
        int n5 = this.mLeftDragger.getViewDragState();
        int n6 = this.mRightDragger.getViewDragState();
        if (n5 != n4 && n6 != n4) {
            n4 = n5 == 2 || n6 == 2 ? 2 : 0;
        }
        if (view != null && n3 == 0) {
            DrawerLayout$LayoutParams drawerLayout$LayoutParams = (DrawerLayout$LayoutParams)view.getLayoutParams();
            if (drawerLayout$LayoutParams.onScreen == 0.0f) {
                this.dispatchOnDrawerClosed(view);
            } else if (drawerLayout$LayoutParams.onScreen == 1.0f) {
                this.dispatchOnDrawerOpened(view);
            }
        }
        if (n4 != this.mDrawerState) {
            this.mDrawerState = n4;
            if (this.mListener != null) {
                this.mListener.onDrawerStateChanged(n4);
            }
        }
    }
}

