/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager$1;
import android.support.v4.view.ViewPager$2;
import android.support.v4.view.ViewPager$3;
import android.support.v4.view.ViewPager$Decor;
import android.support.v4.view.ViewPager$ItemInfo;
import android.support.v4.view.ViewPager$LayoutParams;
import android.support.v4.view.ViewPager$MyAccessibilityDelegate;
import android.support.v4.view.ViewPager$OnAdapterChangeListener;
import android.support.v4.view.ViewPager$OnPageChangeListener;
import android.support.v4.view.ViewPager$PageTransformer;
import android.support.v4.view.ViewPager$PagerObserver;
import android.support.v4.view.ViewPager$SavedState;
import android.support.v4.view.ViewPager$ViewPositionComparator;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ViewPager
extends ViewGroup {
    private static final int CLOSE_ENOUGH = 2;
    private static final Comparator<ViewPager$ItemInfo> COMPARATOR;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private static final int INVALID_POINTER = -1;
    private static final int[] LAYOUT_ATTRS;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int MIN_FLING_VELOCITY = 400;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    private static final String TAG = "ViewPager";
    private static final boolean USE_CACHE;
    private static final Interpolator sInterpolator;
    private static final ViewPager$ViewPositionComparator sPositionComparator;
    private int mActivePointerId = -1;
    private PagerAdapter mAdapter;
    private ViewPager$OnAdapterChangeListener mAdapterChangeListener;
    private int mBottomPageBounds;
    private boolean mCalledSuper;
    private int mChildHeightMeasureSpec;
    private int mChildWidthMeasureSpec;
    private int mCloseEnough;
    private int mCurItem;
    private int mDecorChildCount;
    private int mDefaultGutterSize;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private final Runnable mEndScrollRunnable;
    private int mExpectedAdapterCount;
    private long mFakeDragBeginTime;
    private boolean mFakeDragging;
    private boolean mFirstLayout = true;
    private float mFirstOffset = -3.4028235E38f;
    private int mFlingDistance;
    private int mGutterSize;
    private boolean mIgnoreGutter;
    private boolean mInLayout;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private ViewPager$OnPageChangeListener mInternalPageChangeListener;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private final ArrayList<ViewPager$ItemInfo> mItems = new ArrayList();
    private float mLastMotionX;
    private float mLastMotionY;
    private float mLastOffset;
    private EdgeEffectCompat mLeftEdge;
    private Drawable mMarginDrawable;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private boolean mNeedCalculatePageOffsets = false;
    private ViewPager$PagerObserver mObserver;
    private int mOffscreenPageLimit = 1;
    private ViewPager$OnPageChangeListener mOnPageChangeListener;
    private int mPageMargin;
    private ViewPager$PageTransformer mPageTransformer;
    private boolean mPopulatePending;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mRestoredCurItem = -1;
    private EdgeEffectCompat mRightEdge;
    private int mScrollState = 0;
    private Scroller mScroller;
    private boolean mScrollingCacheEnabled;
    private Method mSetChildrenDrawingOrderEnabled;
    private final ViewPager$ItemInfo mTempItem = new ViewPager$ItemInfo();
    private final Rect mTempRect = new Rect();
    private int mTopPageBounds;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    static {
        LAYOUT_ATTRS = new int[]{16842931};
        COMPARATOR = new ViewPager$1();
        sInterpolator = new ViewPager$2();
        sPositionComparator = new ViewPager$ViewPositionComparator();
    }

    public ViewPager(Context context) {
        super(context);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new ViewPager$3(this);
        this.initViewPager();
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new ViewPager$3(this);
        this.initViewPager();
    }

    static /* synthetic */ void access$000(ViewPager viewPager, int n2) {
        viewPager.setScrollState(n2);
    }

    static /* synthetic */ PagerAdapter access$200(ViewPager viewPager) {
        return viewPager.mAdapter;
    }

    static /* synthetic */ int access$300(ViewPager viewPager) {
        return viewPager.mCurItem;
    }

    static /* synthetic */ int[] access$400() {
        return LAYOUT_ATTRS;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculatePageOffsets(ViewPager$ItemInfo viewPager$ItemInfo, int n2, ViewPager$ItemInfo viewPager$ItemInfo2) {
        float f2;
        int n3;
        block13: {
            int n4;
            block16: {
                ViewPager$ItemInfo viewPager$ItemInfo3;
                int n5;
                float f3;
                block15: {
                    int n6;
                    block14: {
                        n3 = this.mAdapter.getCount();
                        int n7 = this.getClientWidth();
                        f2 = n7 > 0 ? (float)this.mPageMargin / (float)n7 : 0.0f;
                        if (viewPager$ItemInfo2 == null) break block13;
                        n6 = viewPager$ItemInfo2.position;
                        if (n6 >= viewPager$ItemInfo.position) break block14;
                        f3 = f2 + (viewPager$ItemInfo2.offset + viewPager$ItemInfo2.widthFactor);
                        n5 = 0;
                        break block15;
                    }
                    if (n6 <= viewPager$ItemInfo.position) break block13;
                    n4 = -1 + this.mItems.size();
                    float f4 = viewPager$ItemInfo2.offset;
                    break block16;
                }
                for (int i2 = n6 + 1; i2 <= viewPager$ItemInfo.position && n5 < this.mItems.size(); f3 += f2 + viewPager$ItemInfo3.widthFactor, ++i2) {
                    viewPager$ItemInfo3 = this.mItems.get(n5);
                    while (i2 > viewPager$ItemInfo3.position && n5 < -1 + this.mItems.size()) {
                        viewPager$ItemInfo3 = this.mItems.get(++n5);
                    }
                    while (i2 < viewPager$ItemInfo3.position) {
                        f3 += f2 + this.mAdapter.getPageWidth(i2);
                        ++i2;
                    }
                    viewPager$ItemInfo3.offset = f3;
                }
                break block13;
            }
            for (int i3 = n6 - 1; i3 >= viewPager$ItemInfo.position && n4 >= 0; --i3) {
                ViewPager$ItemInfo viewPager$ItemInfo4 = this.mItems.get(n4);
                while (i3 < viewPager$ItemInfo4.position && n4 > 0) {
                    viewPager$ItemInfo4 = this.mItems.get(--n4);
                }
                while (i3 > viewPager$ItemInfo4.position) {
                    f4 -= f2 + this.mAdapter.getPageWidth(i3);
                    --i3;
                }
                viewPager$ItemInfo4.offset = f4 -= f2 + viewPager$ItemInfo4.widthFactor;
            }
        }
        int n8 = this.mItems.size();
        float f5 = viewPager$ItemInfo.offset;
        int n9 = -1 + viewPager$ItemInfo.position;
        float f6 = viewPager$ItemInfo.position == 0 ? viewPager$ItemInfo.offset : -3.4028235E38f;
        this.mFirstOffset = f6;
        float f7 = viewPager$ItemInfo.position == n3 - 1 ? viewPager$ItemInfo.offset + viewPager$ItemInfo.widthFactor - 1.0f : Float.MAX_VALUE;
        this.mLastOffset = f7;
        int n10 = n2 - 1;
        while (n10 >= 0) {
            ViewPager$ItemInfo viewPager$ItemInfo5 = this.mItems.get(n10);
            float f8 = f5;
            while (n9 > viewPager$ItemInfo5.position) {
                PagerAdapter pagerAdapter = this.mAdapter;
                int n11 = n9 - 1;
                f8 -= f2 + pagerAdapter.getPageWidth(n9);
                n9 = n11;
            }
            viewPager$ItemInfo5.offset = f5 = f8 - (f2 + viewPager$ItemInfo5.widthFactor);
            if (viewPager$ItemInfo5.position == 0) {
                this.mFirstOffset = f5;
            }
            int n12 = n10 - 1;
            --n9;
            n10 = n12;
        }
        float f9 = f2 + (viewPager$ItemInfo.offset + viewPager$ItemInfo.widthFactor);
        int n13 = 1 + viewPager$ItemInfo.position;
        int n14 = n2 + 1;
        while (true) {
            if (n14 >= n8) {
                this.mNeedCalculatePageOffsets = false;
                return;
            }
            ViewPager$ItemInfo viewPager$ItemInfo6 = this.mItems.get(n14);
            float f10 = f9;
            while (n13 < viewPager$ItemInfo6.position) {
                PagerAdapter pagerAdapter = this.mAdapter;
                int n15 = n13 + 1;
                f10 += f2 + pagerAdapter.getPageWidth(n13);
                n13 = n15;
            }
            if (viewPager$ItemInfo6.position == n3 - 1) {
                this.mLastOffset = f10 + viewPager$ItemInfo6.widthFactor - 1.0f;
            }
            viewPager$ItemInfo6.offset = f10;
            f9 = f10 + (f2 + viewPager$ItemInfo6.widthFactor);
            int n16 = n14 + 1;
            ++n13;
            n14 = n16;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void completeScroll(boolean bl2) {
        boolean bl3 = this.mScrollState == 2;
        if (bl3) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
            }
        }
        this.mPopulatePending = false;
        boolean bl4 = bl3;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(i2);
            if (!viewPager$ItemInfo.scrolling) continue;
            viewPager$ItemInfo.scrolling = false;
            bl4 = true;
        }
        if (bl4) {
            if (!bl2) {
                this.mEndScrollRunnable.run();
                return;
            }
            ViewCompat.postOnAnimation((View)this, this.mEndScrollRunnable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int determineTargetPage(int n2, float f2, int n3, int n4) {
        if (Math.abs(n4) > this.mFlingDistance && Math.abs(n3) > this.mMinimumVelocity) {
            if (n3 <= 0) {
                ++n2;
            }
        } else {
            float f3 = n2 >= this.mCurItem ? 0.4f : 0.6f;
            n2 = (int)(f3 + (f2 + (float)n2));
        }
        if (this.mItems.size() <= 0) return n2;
        ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(0);
        ViewPager$ItemInfo viewPager$ItemInfo2 = this.mItems.get(-1 + this.mItems.size());
        return Math.max(viewPager$ItemInfo.position, Math.min(n2, viewPager$ItemInfo2.position));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enableLayers(boolean bl2) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = bl2 ? 2 : 0;
            ViewCompat.setLayerType(this.getChildAt(n3), n4, null);
            ++n3;
        }
        return;
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        Rect rect2 = rect == null ? new Rect() : rect;
        if (view == null) {
            rect2.set(0, 0, 0, 0);
            return rect2;
        }
        rect2.left = view.getLeft();
        rect2.right = view.getRight();
        rect2.top = view.getTop();
        rect2.bottom = view.getBottom();
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof ViewGroup && viewParent != this) {
            ViewGroup viewGroup = (ViewGroup)viewParent;
            rect2.left += viewGroup.getLeft();
            rect2.right += viewGroup.getRight();
            rect2.top += viewGroup.getTop();
            rect2.bottom += viewGroup.getBottom();
            viewParent = viewGroup.getParent();
        }
        return rect2;
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ViewPager$ItemInfo infoForCurrentScrollPosition() {
        int n2 = this.getClientWidth();
        float f2 = n2 > 0 ? (float)this.getScrollX() / (float)n2 : 0.0f;
        float f3 = n2 > 0 ? (float)this.mPageMargin / (float)n2 : 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n3 = -1;
        int n4 = 0;
        boolean bl2 = true;
        ViewPager$ItemInfo viewPager$ItemInfo = null;
        while (n4 < this.mItems.size()) {
            ViewPager$ItemInfo viewPager$ItemInfo2;
            int n5;
            ViewPager$ItemInfo viewPager$ItemInfo3 = this.mItems.get(n4);
            if (!bl2 && viewPager$ItemInfo3.position != n3 + 1) {
                ViewPager$ItemInfo viewPager$ItemInfo4 = this.mTempItem;
                viewPager$ItemInfo4.offset = f3 + (f4 + f5);
                viewPager$ItemInfo4.position = n3 + 1;
                viewPager$ItemInfo4.widthFactor = this.mAdapter.getPageWidth(viewPager$ItemInfo4.position);
                n5 = n4 - 1;
                viewPager$ItemInfo2 = viewPager$ItemInfo4;
            } else {
                n5 = n4;
                viewPager$ItemInfo2 = viewPager$ItemInfo3;
            }
            float f6 = viewPager$ItemInfo2.offset;
            float f7 = f3 + (f6 + viewPager$ItemInfo2.widthFactor);
            if (!bl2) {
                if (!(f2 >= f6)) return viewPager$ItemInfo;
            }
            if (f2 < f7) return viewPager$ItemInfo2;
            if (n5 == -1 + this.mItems.size()) {
                return viewPager$ItemInfo2;
            }
            int n6 = viewPager$ItemInfo2.position;
            float f8 = viewPager$ItemInfo2.widthFactor;
            int n7 = n5 + 1;
            f5 = f6;
            n3 = n6;
            f4 = f8;
            viewPager$ItemInfo = viewPager$ItemInfo2;
            n4 = n7;
            bl2 = false;
        }
        return viewPager$ItemInfo;
    }

    private boolean isGutterDrag(float f2, float f3) {
        return f2 < (float)this.mGutterSize && f3 > 0.0f || f2 > (float)(this.getWidth() - this.mGutterSize) && f3 < 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionIndex(motionEvent);
        if (MotionEventCompat.getPointerId(motionEvent, n2) == this.mActivePointerId) {
            int n3 = n2 == 0 ? 1 : 0;
            this.mLastMotionX = MotionEventCompat.getX(motionEvent, n3);
            this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n3);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private boolean pageScrolled(int n2) {
        boolean bl2;
        if (this.mItems.size() == 0) {
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            boolean bl3 = this.mCalledSuper;
            bl2 = false;
            if (!bl3) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
        } else {
            ViewPager$ItemInfo viewPager$ItemInfo = this.infoForCurrentScrollPosition();
            int n3 = this.getClientWidth();
            int n4 = n3 + this.mPageMargin;
            float f2 = (float)this.mPageMargin / (float)n3;
            int n5 = viewPager$ItemInfo.position;
            float f3 = ((float)n2 / (float)n3 - viewPager$ItemInfo.offset) / (f2 + viewPager$ItemInfo.widthFactor);
            int n6 = (int)(f3 * (float)n4);
            this.mCalledSuper = false;
            this.onPageScrolled(n5, f3, n6);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean performDrag(float f2) {
        boolean bl2;
        float f3;
        boolean bl3;
        boolean bl4 = true;
        float f4 = this.mLastMotionX - f2;
        this.mLastMotionX = f2;
        float f5 = f4 + (float)this.getScrollX();
        int n2 = this.getClientWidth();
        float f6 = (float)n2 * this.mFirstOffset;
        float f7 = (float)n2 * this.mLastOffset;
        ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(0);
        ViewPager$ItemInfo viewPager$ItemInfo2 = this.mItems.get(-1 + this.mItems.size());
        if (viewPager$ItemInfo.position != 0) {
            f6 = viewPager$ItemInfo.offset * (float)n2;
            bl3 = false;
        } else {
            bl3 = bl4;
        }
        if (viewPager$ItemInfo2.position != -1 + this.mAdapter.getCount()) {
            f3 = viewPager$ItemInfo2.offset * (float)n2;
            bl4 = false;
        } else {
            f3 = f7;
        }
        if (f5 < f6) {
            bl2 = false;
            if (bl3) {
                float f8 = f6 - f5;
                bl2 = this.mLeftEdge.onPull(Math.abs(f8) / (float)n2);
            }
        } else if (f5 > f3) {
            bl2 = false;
            if (bl4) {
                float f9 = f5 - f3;
                bl2 = this.mRightEdge.onPull(Math.abs(f9) / (float)n2);
            }
            f6 = f3;
        } else {
            f6 = f5;
            bl2 = false;
        }
        this.mLastMotionX += f6 - (float)((int)f6);
        this.scrollTo((int)f6, this.getScrollY());
        this.pageScrolled((int)f6);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void recomputeScrollPosition(int n2, int n3, int n4, int n5) {
        if (n3 > 0 && !this.mItems.isEmpty()) {
            int n6 = n4 + (n2 - this.getPaddingLeft() - this.getPaddingRight());
            int n7 = n5 + (n3 - this.getPaddingLeft() - this.getPaddingRight());
            int n8 = (int)((float)this.getScrollX() / (float)n7 * (float)n6);
            this.scrollTo(n8, this.getScrollY());
            if (this.mScroller.isFinished()) return;
            int n9 = this.mScroller.getDuration() - this.mScroller.timePassed();
            ViewPager$ItemInfo viewPager$ItemInfo = this.infoForPosition(this.mCurItem);
            this.mScroller.startScroll(n8, 0, (int)(viewPager$ItemInfo.offset * (float)n2), 0, n9);
            return;
        }
        ViewPager$ItemInfo viewPager$ItemInfo = this.infoForPosition(this.mCurItem);
        float f2 = viewPager$ItemInfo != null ? Math.min(viewPager$ItemInfo.offset, this.mLastOffset) : 0.0f;
        int n10 = (int)(f2 * (float)(n2 - this.getPaddingLeft() - this.getPaddingRight()));
        if (n10 == this.getScrollX()) return;
        this.completeScroll(false);
        this.scrollTo(n10, this.getScrollY());
    }

    private void removeNonDecorViews() {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            if (((ViewPager$LayoutParams)this.getChildAt((int)i2).getLayoutParams()).isDecor) continue;
            this.removeViewAt(i2);
            --i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollToItem(int n2, boolean bl2, int n3, boolean bl3) {
        ViewPager$ItemInfo viewPager$ItemInfo = this.infoForPosition(n2);
        int n4 = viewPager$ItemInfo != null ? (int)((float)this.getClientWidth() * Math.max(this.mFirstOffset, Math.min(viewPager$ItemInfo.offset, this.mLastOffset))) : 0;
        if (bl2) {
            this.smoothScrollTo(n4, 0, n3);
            if (bl3 && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(n2);
            }
            if (bl3 && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.onPageSelected(n2);
            }
            return;
        }
        if (bl3 && this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(n2);
        }
        if (bl3 && this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(n2);
        }
        this.completeScroll(false);
        this.scrollTo(n4, 0);
        this.pageScrolled(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setScrollState(int n2) {
        block5: {
            block4: {
                if (this.mScrollState == n2) break block4;
                this.mScrollState = n2;
                if (this.mPageTransformer != null) {
                    boolean bl2 = n2 != 0;
                    this.enableLayers(bl2);
                }
                if (this.mOnPageChangeListener != null) break block5;
            }
            return;
        }
        this.mOnPageChangeListener.onPageScrollStateChanged(n2);
    }

    private void setScrollingCacheEnabled(boolean bl2) {
        if (this.mScrollingCacheEnabled != bl2) {
            this.mScrollingCacheEnabled = bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            if (this.mDrawingOrderedChildren == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                this.mDrawingOrderedChildren.clear();
            }
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view = this.getChildAt(i2);
                this.mDrawingOrderedChildren.add(view);
            }
            Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        int n4 = arrayList.size();
        int n5 = this.getDescendantFocusability();
        if (n5 != 393216) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                ViewPager$ItemInfo viewPager$ItemInfo;
                View view = this.getChildAt(i2);
                if (view.getVisibility() != 0 || (viewPager$ItemInfo = this.infoForChild(view)) == null || viewPager$ItemInfo.position != this.mCurItem) continue;
                view.addFocusables(arrayList, n2, n3);
            }
        }
        if (n5 == 262144 && n4 != arrayList.size() || !this.isFocusable() || (n3 & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode() || arrayList == null) {
            return;
        }
        arrayList.add((View)this);
    }

    ViewPager$ItemInfo addNewItem(int n2, int n3) {
        ViewPager$ItemInfo viewPager$ItemInfo = new ViewPager$ItemInfo();
        viewPager$ItemInfo.position = n2;
        viewPager$ItemInfo.object = this.mAdapter.instantiateItem(this, n2);
        viewPager$ItemInfo.widthFactor = this.mAdapter.getPageWidth(n2);
        if (n3 < 0 || n3 >= this.mItems.size()) {
            this.mItems.add(viewPager$ItemInfo);
            return viewPager$ItemInfo;
        }
        this.mItems.add(n3, viewPager$ItemInfo);
        return viewPager$ItemInfo;
    }

    public void addTouchables(ArrayList<View> arrayList) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            ViewPager$ItemInfo viewPager$ItemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (viewPager$ItemInfo = this.infoForChild(view)) == null || viewPager$ItemInfo.position != this.mCurItem) continue;
            view.addTouchables(arrayList);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        ViewGroup.LayoutParams layoutParams2 = !this.checkLayoutParams(layoutParams) ? this.generateLayoutParams(layoutParams) : layoutParams;
        ViewPager$LayoutParams viewPager$LayoutParams = (ViewPager$LayoutParams)layoutParams2;
        viewPager$LayoutParams.isDecor |= view instanceof ViewPager$Decor;
        if (!this.mInLayout) {
            super.addView(view, n2, layoutParams2);
            return;
        }
        if (viewPager$LayoutParams != null && viewPager$LayoutParams.isDecor) {
            throw new IllegalStateException("Cannot add pager decor view during layout");
        }
        viewPager$LayoutParams.needsMeasure = true;
        this.addViewInLayout(view, n2, layoutParams2);
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrowScroll(int var1_1) {
        block14: {
            block12: {
                block15: {
                    block16: {
                        block17: {
                            block9: {
                                block10: {
                                    block11: {
                                        var2_2 = this.findFocus();
                                        if (var2_2 == this) {
                                            var3_3 = null;
lbl4:
                                            // 3 sources

                                            while (true) {
                                                var4_4 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, var3_3, var1_1);
                                                if (var4_4 == null || var4_4 == var3_3) break block9;
                                                if (var1_1 != 17) break block10;
                                                var8_5 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var4_4).left;
                                                var9_6 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var3_3).left;
                                                if (var3_3 != null && var8_5 >= var9_6) {
                                                    var5_7 = this.pageLeft();
lbl12:
                                                    // 6 sources

                                                    while (true) {
                                                        if (var5_7) {
                                                            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)var1_1));
                                                        }
                                                        return var5_7;
                                                    }
                                                }
                                                break block11;
                                                break;
                                            }
                                        }
                                        if (var2_2 == null) break block12;
                                        var10_8 = var2_2.getParent();
                                        while (var10_8 instanceof ViewGroup) {
                                            block13: {
                                                if (var10_8 == this) {
                                                    var11_9 = true;
lbl22:
                                                    // 2 sources

                                                    while (true) {
                                                        if (var11_9) break block12;
                                                        var12_10 = new StringBuilder();
                                                        var12_10.append(var2_2.getClass().getSimpleName());
                                                        var14_11 = var2_2.getParent();
                                                        while (var14_11 instanceof ViewGroup) {
                                                            var12_10.append(" => ").append(var14_11.getClass().getSimpleName());
                                                            var14_11 = var14_11.getParent();
                                                        }
                                                        break block13;
                                                        break;
                                                    }
                                                }
                                                var10_8 = var10_8.getParent();
                                                continue;
                                            }
                                            Log.e((String)"ViewPager", (String)("arrowScroll tried to find focus based on non-child current focused view " + var12_10.toString()));
                                            var3_3 = null;
                                            ** GOTO lbl4
                                        }
                                        break block14;
                                    }
                                    var5_7 = var4_4.requestFocus();
                                    ** GOTO lbl12
                                }
                                if (var1_1 != 66) break block15;
                                var6_12 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var4_4).left;
                                var7_13 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var3_3).left;
                                if (var3_3 != null && var6_12 <= var7_13) break block16;
                                var5_7 = var4_4.requestFocus();
                                ** GOTO lbl12
                            }
                            if (var1_1 != 17 && var1_1 != 1) break block17;
                            var5_7 = this.pageLeft();
                            ** GOTO lbl12
                        }
                        if (var1_1 != 66 && var1_1 != 2) break block15;
                    }
                    var5_7 = this.pageRight();
                    ** GOTO lbl12
                }
                var5_7 = false;
                ** while (true)
            }
            var3_3 = var2_2;
            ** while (true)
        }
        var11_9 = false;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
        this.mFakeDragBeginTime = l2;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = -1 + viewGroup.getChildCount(); i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 >= view2.getLeft() && n3 + n5 < view2.getRight() && n4 + n6 >= view2.getTop() && n4 + n6 < view2.getBottom() && this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) return true;
            }
        }
        if (!bl2 || !ViewCompat.canScrollHorizontally(view, -n2)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean canScrollHorizontally(int n2) {
        if (this.mAdapter == null) return false;
        int n3 = this.getClientWidth();
        int n4 = this.getScrollX();
        if (n2 < 0) {
            if (n4 <= (int)((float)n3 * this.mFirstOffset)) return false;
            return true;
        }
        if (n2 > 0 && n4 < (int)((float)n3 * this.mLastOffset)) return true;
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewPager$LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
                if (!this.pageScrolled(n4)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, n5);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dataSetChanged() {
        int n2;
        this.mExpectedAdapterCount = n2 = this.mAdapter.getCount();
        boolean bl2 = this.mItems.size() < 1 + 2 * this.mOffscreenPageLimit && this.mItems.size() < n2;
        int n3 = this.mCurItem;
        boolean bl3 = false;
        int n4 = n3;
        boolean bl4 = bl2;
        int n5 = 0;
        while (true) {
            boolean bl5;
            int n6;
            boolean bl6;
            int n7;
            block8: {
                block10: {
                    block9: {
                        int n8;
                        ViewPager$ItemInfo viewPager$ItemInfo;
                        block11: {
                            if (n5 >= this.mItems.size()) break block9;
                            viewPager$ItemInfo = this.mItems.get(n5);
                            n8 = this.mAdapter.getItemPosition(viewPager$ItemInfo.object);
                            if (n8 == -1) break block10;
                            if (n8 != -2) break block11;
                            this.mItems.remove(n5);
                            int n9 = n5 - 1;
                            if (!bl3) {
                                this.mAdapter.startUpdate(this);
                                bl3 = true;
                            }
                            this.mAdapter.destroyItem(this, viewPager$ItemInfo.position, viewPager$ItemInfo.object);
                            if (this.mCurItem == viewPager$ItemInfo.position) {
                                int n10 = Math.max(0, Math.min(this.mCurItem, n2 - 1));
                                n7 = n9;
                                bl6 = bl3;
                                n6 = n10;
                                bl5 = true;
                                break block8;
                            } else {
                                n7 = n9;
                                bl6 = bl3;
                                n6 = n4;
                                bl5 = true;
                            }
                            break block8;
                        }
                        if (viewPager$ItemInfo.position == n8) break block10;
                        if (viewPager$ItemInfo.position == this.mCurItem) {
                            n4 = n8;
                        }
                        viewPager$ItemInfo.position = n8;
                        n7 = n5;
                        bl6 = bl3;
                        n6 = n4;
                        bl5 = true;
                        break block8;
                    }
                    if (bl3) {
                        this.mAdapter.finishUpdate(this);
                    }
                    Collections.sort(this.mItems, COMPARATOR);
                    if (bl4) {
                        int n11 = this.getChildCount();
                        for (int i2 = 0; i2 < n11; ++i2) {
                            ViewPager$LayoutParams viewPager$LayoutParams = (ViewPager$LayoutParams)this.getChildAt(i2).getLayoutParams();
                            if (viewPager$LayoutParams.isDecor) continue;
                            viewPager$LayoutParams.widthFactor = 0.0f;
                        }
                        this.setCurrentItemInternal(n4, false, true);
                        this.requestLayout();
                    }
                    return;
                }
                n7 = n5;
                bl6 = bl3;
                n6 = n4;
                bl5 = bl4;
            }
            int n12 = n7 + 1;
            bl4 = bl5;
            n4 = n6;
            bl3 = bl6;
            n5 = n12;
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int n2 = this.getChildCount();
        int n3 = 0;
        while (true) {
            ViewPager$ItemInfo viewPager$ItemInfo;
            boolean bl2 = false;
            if (n3 >= n2) return bl2;
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0 && (viewPager$ItemInfo = this.infoForChild(view)) != null && viewPager$ItemInfo.position == this.mCurItem && view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) {
                return true;
            }
            ++n3;
        }
    }

    float distanceInfluenceForSnapDuration(float f2) {
        return (float)Math.sin((float)(0.4712389167638204 * (double)(f2 - 0.5f)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(Canvas canvas) {
        super.draw(canvas);
        int n2 = ViewCompat.getOverScrollMode((View)this);
        if (n2 == 0 || n2 == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            boolean bl2 = this.mLeftEdge.isFinished();
            boolean bl3 = false;
            if (!bl2) {
                int n3 = canvas.save();
                int n4 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                int n5 = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate((float)(-n4 + this.getPaddingTop()), this.mFirstOffset * (float)n5);
                this.mLeftEdge.setSize(n4, n5);
                bl3 = false | this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(n3);
            }
            if (!this.mRightEdge.isFinished()) {
                int n6 = canvas.save();
                int n7 = this.getWidth();
                int n8 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), -(1.0f + this.mLastOffset) * (float)n7);
                this.mRightEdge.setSize(n8, n7);
                bl3 |= this.mRightEdge.draw(canvas);
                canvas.restoreToCount(n6);
            }
            if (!bl3) return;
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.mLeftEdge.finish();
        this.mRightEdge.finish();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mMarginDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
        int n2 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
        this.mPopulatePending = true;
        int n3 = this.getClientWidth();
        int n4 = this.getScrollX();
        ViewPager$ItemInfo viewPager$ItemInfo = this.infoForCurrentScrollPosition();
        this.setCurrentItemInternal(this.determineTargetPage(viewPager$ItemInfo.position, ((float)n4 / (float)n3 - viewPager$ItemInfo.offset) / viewPager$ItemInfo.widthFactor, n2, (int)(this.mLastMotionX - this.mInitialMotionX)), true, true, n2);
        this.endDrag();
        this.mFakeDragging = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean executeKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() != 0) return false;
        switch (keyEvent.getKeyCode()) {
            default: {
                return false;
            }
            case 21: {
                return this.arrowScroll(17);
            }
            case 22: {
                return this.arrowScroll(66);
            }
            case 61: {
                if (Build.VERSION.SDK_INT < 11) return false;
                if (KeyEventCompat.hasNoModifiers(keyEvent)) {
                    return this.arrowScroll(2);
                }
                if (!KeyEventCompat.hasModifiers(keyEvent, 1)) return false;
                return this.arrowScroll(1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fakeDragBy(float f2) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        this.mLastMotionX = f2 + this.mLastMotionX;
        float f3 = (float)this.getScrollX() - f2;
        int n2 = this.getClientWidth();
        float f4 = (float)n2 * this.mFirstOffset;
        float f5 = (float)n2 * this.mLastOffset;
        ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(0);
        ViewPager$ItemInfo viewPager$ItemInfo2 = this.mItems.get(-1 + this.mItems.size());
        float f6 = viewPager$ItemInfo.position != 0 ? viewPager$ItemInfo.offset * (float)n2 : f4;
        float f7 = viewPager$ItemInfo2.position != -1 + this.mAdapter.getCount() ? viewPager$ItemInfo2.offset * (float)n2 : f5;
        if (!(f3 < f6)) {
            f6 = f3 > f7 ? f7 : f3;
        }
        this.mLastMotionX += f6 - (float)((int)f6);
        this.scrollTo((int)f6, this.getScrollY());
        this.pageScrolled((int)f6);
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)l2, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewPager$LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewPager$LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    protected int getChildDrawingOrder(int n2, int n3) {
        if (this.mDrawingOrder == 2) {
            n3 = n2 - 1 - n3;
        }
        return ((ViewPager$LayoutParams)this.mDrawingOrderedChildren.get((int)n3).getLayoutParams()).childIndex;
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    ViewPager$ItemInfo infoForAnyChild(View view) {
        ViewParent viewParent;
        while ((viewParent = view.getParent()) != this) {
            if (viewParent == null || !(viewParent instanceof View)) {
                return null;
            }
            view = (View)viewParent;
        }
        return this.infoForChild(view);
    }

    ViewPager$ItemInfo infoForChild(View view) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(i2);
            if (!this.mAdapter.isViewFromObject(view, viewPager$ItemInfo.object)) continue;
            return viewPager$ItemInfo;
        }
        return null;
    }

    ViewPager$ItemInfo infoForPosition(int n2) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(i2);
            if (viewPager$ItemInfo.position != n2) continue;
            return viewPager$ItemInfo;
        }
        return null;
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop(viewConfiguration);
        this.mMinimumVelocity = (int)(400.0f * f2);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffectCompat(context);
        this.mRightEdge = new EdgeEffectCompat(context);
        this.mFlingDistance = (int)(25.0f * f2);
        this.mCloseEnough = (int)(2.0f * f2);
        this.mDefaultGutterSize = (int)(16.0f * f2);
        ViewCompat.setAccessibilityDelegate((View)this, new ViewPager$MyAccessibilityDelegate(this));
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int n2 = this.getScrollX();
            int n3 = this.getWidth();
            float f2 = (float)this.mPageMargin / (float)n3;
            ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(0);
            float f3 = viewPager$ItemInfo.offset;
            int n4 = this.mItems.size();
            int n5 = viewPager$ItemInfo.position;
            int n6 = this.mItems.get((int)(n4 - 1)).position;
            int n7 = 0;
            for (int i2 = n5; i2 < n6; ++i2) {
                float f4;
                while (i2 > viewPager$ItemInfo.position && n7 < n4) {
                    ArrayList<ViewPager$ItemInfo> arrayList = this.mItems;
                    viewPager$ItemInfo = arrayList.get(++n7);
                }
                if (i2 == viewPager$ItemInfo.position) {
                    f4 = (viewPager$ItemInfo.offset + viewPager$ItemInfo.widthFactor) * (float)n3;
                    f3 = f2 + (viewPager$ItemInfo.offset + viewPager$ItemInfo.widthFactor);
                } else {
                    float f5 = this.mAdapter.getPageWidth(i2);
                    f4 = (f3 + f5) * (float)n3;
                    f3 += f5 + f2;
                }
                if (f4 + (float)this.mPageMargin > (float)n2) {
                    this.mMarginDrawable.setBounds((int)f4, this.mTopPageBounds, (int)(0.5f + (f4 + (float)this.mPageMargin)), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (f4 > (float)(n2 + n3)) break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = 0xFF & motionEvent.getAction();
        if (n2 == 3 || n2 == 1) {
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker == null) return false;
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
            return false;
        }
        if (n2 != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (n2) {
            case 2: {
                int n3 = this.mActivePointerId;
                if (n3 == -1) break;
                int n4 = MotionEventCompat.findPointerIndex(motionEvent, n3);
                float f2 = MotionEventCompat.getX(motionEvent, n4);
                float f3 = f2 - this.mLastMotionX;
                float f4 = Math.abs(f3);
                float f5 = MotionEventCompat.getY(motionEvent, n4);
                float f6 = Math.abs(f5 - this.mInitialMotionY);
                if (f3 != 0.0f && !this.isGutterDrag(this.mLastMotionX, f3) && this.canScroll((View)this, false, (int)f3, (int)f2, (int)f5)) {
                    this.mLastMotionX = f2;
                    this.mLastMotionY = f5;
                    this.mIsUnableToDrag = true;
                    return false;
                }
                if (f4 > (float)this.mTouchSlop && 0.5f * f4 > f6) {
                    this.mIsBeingDragged = true;
                    this.setScrollState(1);
                    float f7 = f3 > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                    this.mLastMotionX = f7;
                    this.mLastMotionY = f5;
                    this.setScrollingCacheEnabled(true);
                } else if (f6 > (float)this.mTouchSlop) {
                    this.mIsUnableToDrag = true;
                }
                if (!this.mIsBeingDragged || !this.performDrag(f2)) break;
                ViewCompat.postInvalidateOnAnimation((View)this);
                break;
            }
            case 0: {
                float f8;
                float f9;
                this.mInitialMotionX = f9 = motionEvent.getX();
                this.mLastMotionX = f9;
                this.mInitialMotionY = f8 = motionEvent.getY();
                this.mLastMotionY = f8;
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                this.mIsUnableToDrag = false;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll(false);
                this.mIsBeingDragged = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                break;
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        return this.mIsBeingDragged;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        int n6 = this.getChildCount();
        int n7 = n4 - n2;
        int n8 = n5 - n3;
        int n9 = this.getPaddingLeft();
        int n10 = this.getPaddingTop();
        int n11 = this.getPaddingRight();
        int n12 = this.getPaddingBottom();
        int n13 = this.getScrollX();
        int n14 = 0;
        int n15 = 0;
        while (true) {
            int n16;
            int n17;
            int n18;
            int n19;
            block16: {
                block15: {
                    block14: {
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        if (n15 >= n6) break block14;
                        View view = this.getChildAt(n15);
                        if (view.getVisibility() == 8) break block15;
                        ViewPager$LayoutParams viewPager$LayoutParams = (ViewPager$LayoutParams)view.getLayoutParams();
                        if (!viewPager$LayoutParams.isDecor) break block15;
                        int n24 = 7 & viewPager$LayoutParams.gravity;
                        int n25 = 0x70 & viewPager$LayoutParams.gravity;
                        switch (n24) {
                            default: {
                                n23 = n9;
                                break;
                            }
                            case 3: {
                                int n26 = n9 + view.getMeasuredWidth();
                                n23 = n9;
                                n9 = n26;
                                break;
                            }
                            case 1: {
                                n23 = Math.max((n7 - view.getMeasuredWidth()) / 2, n9);
                                break;
                            }
                            case 5: {
                                int n27 = n7 - n11 - view.getMeasuredWidth();
                                n11 += view.getMeasuredWidth();
                                n23 = n27;
                            }
                        }
                        switch (n25) {
                            default: {
                                n22 = n10;
                                int n28 = n12;
                                n21 = n10;
                                n20 = n28;
                                break;
                            }
                            case 48: {
                                int n29 = n10 + view.getMeasuredHeight();
                                int n30 = n10;
                                n20 = n12;
                                n21 = n29;
                                n22 = n30;
                                break;
                            }
                            case 16: {
                                n22 = Math.max((n8 - view.getMeasuredHeight()) / 2, n10);
                                int n31 = n12;
                                n21 = n10;
                                n20 = n31;
                                break;
                            }
                            case 80: {
                                n22 = n8 - n12 - view.getMeasuredHeight();
                                int n32 = n12 + view.getMeasuredHeight();
                                n21 = n10;
                                n20 = n32;
                            }
                        }
                        int n33 = n23 + n13;
                        view.layout(n33, n22, n33 + view.getMeasuredWidth(), n22 + view.getMeasuredHeight());
                        n19 = n14 + 1;
                        n18 = n21;
                        n12 = n20;
                        n17 = n11;
                        n16 = n9;
                        break block16;
                    }
                    int n34 = n7 - n9 - n11;
                    for (int i2 = 0; i2 < n6; ++i2) {
                        ViewPager$ItemInfo viewPager$ItemInfo;
                        View view = this.getChildAt(i2);
                        if (view.getVisibility() == 8) continue;
                        ViewPager$LayoutParams viewPager$LayoutParams = (ViewPager$LayoutParams)view.getLayoutParams();
                        if (viewPager$LayoutParams.isDecor || (viewPager$ItemInfo = this.infoForChild(view)) == null) continue;
                        int n35 = n9 + (int)((float)n34 * viewPager$ItemInfo.offset);
                        if (viewPager$LayoutParams.needsMeasure) {
                            viewPager$LayoutParams.needsMeasure = false;
                            view.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)n34 * viewPager$LayoutParams.widthFactor)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n8 - n10 - n12), (int)0x40000000));
                        }
                        view.layout(n35, n10, n35 + view.getMeasuredWidth(), n10 + view.getMeasuredHeight());
                    }
                    this.mTopPageBounds = n10;
                    this.mBottomPageBounds = n8 - n12;
                    this.mDecorChildCount = n14;
                    if (this.mFirstLayout) {
                        this.scrollToItem(this.mCurItem, false, 0, false);
                    }
                    this.mFirstLayout = false;
                    return;
                }
                n19 = n14;
                n18 = n10;
                n17 = n11;
                n16 = n9;
            }
            ++n15;
            n9 = n16;
            n11 = n17;
            n10 = n18;
            n14 = n19;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        block12: {
            block9: {
                block10: {
                    this.setMeasuredDimension(ViewPager.getDefaultSize((int)0, (int)var1_1), ViewPager.getDefaultSize((int)0, (int)var2_2));
                    var3_3 = this.getMeasuredWidth();
                    this.mGutterSize = Math.min(var3_3 / 10, this.mDefaultGutterSize);
                    var4_4 = var3_3 - this.getPaddingLeft() - this.getPaddingRight();
                    var5_5 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
                    var6_6 = this.getChildCount();
                    block0: for (var7_7 = 0; var7_7 < var6_6; ++var7_7) {
                        block11: {
                            block13: {
                                block15: {
                                    block14: {
                                        var12_8 = this.getChildAt(var7_7);
                                        if (var12_8.getVisibility() == 8 || (var13_9 = (ViewPager$LayoutParams)var12_8.getLayoutParams()) == null || !var13_9.isDecor) ** GOTO lbl33
                                        var14_10 = 7 & var13_9.gravity;
                                        var15_11 = 112 & var13_9.gravity;
                                        var16_12 = -2147483648;
                                        var17_13 = -2147483648;
                                        if (var15_11 != 48 && var15_11 != 80) break block14;
                                        var18_14 = true;
lbl16:
                                        // 2 sources

                                        while (var14_10 == 3 || var14_10 == 5) {
                                            var19_15 = true;
lbl18:
                                            // 2 sources

                                            while (var18_14) {
                                                var16_12 = 0x40000000;
lbl20:
                                                // 3 sources

                                                while (var13_9.width != -2) {
                                                    var20_16 = 0x40000000;
                                                    if (var13_9.width == -1) break block9;
                                                    var21_17 = var13_9.width;
lbl24:
                                                    // 3 sources

                                                    while (true) {
                                                        if (var13_9.height == -2) break block10;
                                                        var17_13 = 0x40000000;
                                                        if (var13_9.height == -1) break block10;
                                                        var22_18 = var13_9.height;
lbl29:
                                                        // 2 sources

                                                        while (true) {
                                                            var12_8.measure(View.MeasureSpec.makeMeasureSpec((int)var21_17, (int)var20_16), View.MeasureSpec.makeMeasureSpec((int)var22_18, (int)var17_13));
                                                            if (!var18_14) break block11;
                                                            var5_5 -= var12_8.getMeasuredHeight();
lbl33:
                                                            // 4 sources

                                                            continue block0;
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                }
                                                break block12;
                                            }
                                            break block13;
                                        }
                                        break block15;
                                    }
                                    var18_14 = false;
                                    ** GOTO lbl16
                                }
                                var19_15 = false;
                                ** GOTO lbl18
                            }
                            if (!var19_15) ** GOTO lbl20
                            var17_13 = 0x40000000;
                            ** GOTO lbl20
                        }
                        if (!var19_15) ** GOTO lbl33
                        var4_4 -= var12_8.getMeasuredWidth();
                        ** continue;
                    }
                    this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var4_4, (int)0x40000000);
                    this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var5_5, (int)0x40000000);
                    this.mInLayout = true;
                    this.populate();
                    this.mInLayout = false;
                    var8_19 = this.getChildCount();
                    for (var9_20 = 0; var9_20 < var8_19; ++var9_20) {
                        var10_21 = this.getChildAt(var9_20);
                        if (var10_21.getVisibility() == 8 || (var11_22 = (ViewPager$LayoutParams)var10_21.getLayoutParams()) != null && var11_22.isDecor) continue;
                        var10_21.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)var4_4 * var11_22.widthFactor)), (int)0x40000000), this.mChildHeightMeasureSpec);
                    }
                    return;
                }
                var22_18 = var5_5;
                ** while (true)
            }
            var21_17 = var4_4;
            ** GOTO lbl24
        }
        var20_16 = var16_12;
        var21_17 = var4_4;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPageScrolled(int n2, float f2, int n3) {
        if (this.mDecorChildCount > 0) {
            int n4 = this.getScrollX();
            int n5 = this.getPaddingLeft();
            int n6 = this.getPaddingRight();
            int n7 = this.getWidth();
            int n8 = this.getChildCount();
            for (int i2 = 0; i2 < n8; ++i2) {
                int n9;
                int n10;
                View view = this.getChildAt(i2);
                ViewPager$LayoutParams viewPager$LayoutParams = (ViewPager$LayoutParams)view.getLayoutParams();
                if (viewPager$LayoutParams.isDecor) {
                    int n11;
                    int n12;
                    switch (7 & viewPager$LayoutParams.gravity) {
                        default: {
                            n12 = n5;
                            int n13 = n6;
                            n10 = n5;
                            n9 = n13;
                            break;
                        }
                        case 3: {
                            int n14 = n5 + view.getWidth();
                            int n15 = n5;
                            n9 = n6;
                            n10 = n14;
                            n12 = n15;
                            break;
                        }
                        case 1: {
                            n12 = Math.max((n7 - view.getMeasuredWidth()) / 2, n5);
                            int n16 = n6;
                            n10 = n5;
                            n9 = n16;
                            break;
                        }
                        case 5: {
                            n12 = n7 - n6 - view.getMeasuredWidth();
                            int n17 = n6 + view.getMeasuredWidth();
                            n10 = n5;
                            n9 = n17;
                        }
                    }
                    if ((n11 = n12 + n4 - view.getLeft()) != 0) {
                        view.offsetLeftAndRight(n11);
                    }
                } else {
                    int n18 = n6;
                    n10 = n5;
                    n9 = n18;
                }
                int n19 = n9;
                n5 = n10;
                n6 = n19;
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(n2, f2, n3);
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(n2, f2, n3);
        }
        if (this.mPageTransformer != null) {
            int n20 = this.getScrollX();
            int n21 = this.getChildCount();
            for (int i3 = 0; i3 < n21; ++i3) {
                View view = this.getChildAt(i3);
                if (((ViewPager$LayoutParams)view.getLayoutParams()).isDecor) continue;
                float f3 = (float)(view.getLeft() - n20) / (float)this.getClientWidth();
                this.mPageTransformer.transformPage(view, f3);
            }
        }
        this.mCalledSuper = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        int n3;
        int n4 = -1;
        int n5 = this.getChildCount();
        if ((n2 & 2) != 0) {
            n4 = 1;
            n3 = 0;
        } else {
            n3 = n5 - 1;
            n5 = n4;
        }
        while (n3 != n5) {
            ViewPager$ItemInfo viewPager$ItemInfo;
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0 && (viewPager$ItemInfo = this.infoForChild(view)) != null && viewPager$ItemInfo.position == this.mCurItem && view.requestFocus(n2, rect)) {
                return true;
            }
            n3 += n4;
        }
        return false;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof ViewPager$SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        ViewPager$SavedState viewPager$SavedState = (ViewPager$SavedState)parcelable;
        super.onRestoreInstanceState(viewPager$SavedState.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(viewPager$SavedState.adapterState, viewPager$SavedState.loader);
            this.setCurrentItemInternal(viewPager$SavedState.position, false, true);
            return;
        }
        this.mRestoredCurItem = viewPager$SavedState.position;
        this.mRestoredAdapterState = viewPager$SavedState.adapterState;
        this.mRestoredClassLoader = viewPager$SavedState.loader;
    }

    public Parcelable onSaveInstanceState() {
        ViewPager$SavedState viewPager$SavedState = new ViewPager$SavedState(super.onSaveInstanceState());
        viewPager$SavedState.position = this.mCurItem;
        if (this.mAdapter != null) {
            viewPager$SavedState.adapterState = this.mAdapter.saveState();
        }
        return viewPager$SavedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            this.recomputeScrollPosition(n2, n4, this.mPageMargin, this.mPageMargin);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mFakeDragging) {
            return true;
        }
        if (motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null) return false;
        if (this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n2 = 0xFF & motionEvent.getAction();
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                float f2;
                float f3;
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mIsBeingDragged = true;
                this.setScrollState(1);
                this.mInitialMotionX = f3 = motionEvent.getX();
                this.mLastMotionX = f3;
                this.mInitialMotionY = f2 = motionEvent.getY();
                this.mLastMotionY = f2;
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                return true;
            }
            case 2: {
                if (!this.mIsBeingDragged) {
                    int n3 = MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId);
                    float f4 = MotionEventCompat.getX(motionEvent, n3);
                    float f5 = Math.abs(f4 - this.mLastMotionX);
                    float f6 = MotionEventCompat.getY(motionEvent, n3);
                    float f7 = Math.abs(f6 - this.mLastMotionY);
                    if (f5 > (float)this.mTouchSlop && f5 > f7) {
                        this.mIsBeingDragged = true;
                        float f8 = f4 - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                        this.mLastMotionX = f8;
                        this.mLastMotionY = f6;
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                    }
                }
                boolean bl3 = this.mIsBeingDragged;
                bl2 = false;
                if (!bl3) break;
                bl2 = false | this.performDrag(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)));
                break;
            }
            case 1: {
                boolean bl4 = this.mIsBeingDragged;
                bl2 = false;
                if (!bl4) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n4 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                this.mPopulatePending = true;
                int n5 = this.getClientWidth();
                int n6 = this.getScrollX();
                ViewPager$ItemInfo viewPager$ItemInfo = this.infoForCurrentScrollPosition();
                this.setCurrentItemInternal(this.determineTargetPage(viewPager$ItemInfo.position, ((float)n6 / (float)n5 - viewPager$ItemInfo.offset) / viewPager$ItemInfo.widthFactor, n4, (int)(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)) - this.mInitialMotionX)), true, true, n4);
                this.mActivePointerId = -1;
                this.endDrag();
                bl2 = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 3: {
                boolean bl5 = this.mIsBeingDragged;
                bl2 = false;
                if (!bl5) break;
                this.scrollToItem(this.mCurItem, true, 0, false);
                this.mActivePointerId = -1;
                this.endDrag();
                bl2 = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 5: {
                int n7 = MotionEventCompat.getActionIndex(motionEvent);
                this.mLastMotionX = MotionEventCompat.getX(motionEvent, n7);
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n7);
                return true;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                this.mLastMotionX = MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId));
                return true;
            }
        }
        if (!bl2) return true;
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    boolean pageLeft() {
        if (this.mCurItem > 0) {
            this.setCurrentItem(-1 + this.mCurItem, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        if (this.mAdapter != null && this.mCurItem < -1 + this.mAdapter.getCount()) {
            this.setCurrentItem(1 + this.mCurItem, true);
            return true;
        }
        return false;
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void populate(int n2) {
        ViewPager$ItemInfo viewPager$ItemInfo;
        int n3;
        block22: {
            int n4;
            ViewPager$ItemInfo viewPager$ItemInfo2;
            block23: {
                ViewPager$ItemInfo viewPager$ItemInfo3;
                int n5;
                int n6;
                int n7;
                int n8;
                block20: {
                    if (this.mCurItem != n2) {
                        int n9 = this.mCurItem < n2 ? 66 : 17;
                        ViewPager$ItemInfo viewPager$ItemInfo4 = this.infoForPosition(this.mCurItem);
                        this.mCurItem = n2;
                        viewPager$ItemInfo2 = viewPager$ItemInfo4;
                        n3 = n9;
                    } else {
                        n3 = 2;
                        viewPager$ItemInfo2 = null;
                    }
                    if (this.mAdapter == null) {
                        this.sortChildDrawingOrder();
                        return;
                    }
                    if (this.mPopulatePending) {
                        this.sortChildDrawingOrder();
                        return;
                    }
                    if (this.getWindowToken() == null) return;
                    this.mAdapter.startUpdate(this);
                    int n10 = this.mOffscreenPageLimit;
                    n8 = Math.max(0, this.mCurItem - n10);
                    n7 = this.mAdapter.getCount();
                    n6 = Math.min(n7 - 1, n10 + this.mCurItem);
                    if (n7 != this.mExpectedAdapterCount) {
                        String string2;
                        try {
                            String string3;
                            string2 = string3 = this.getResources().getResourceName(this.getId());
                            throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + n7 + " Pager id: " + string2 + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
                        }
                        catch (Resources.NotFoundException notFoundException) {
                            string2 = Integer.toHexString(this.getId());
                            throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + n7 + " Pager id: " + string2 + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
                        }
                    }
                    for (n5 = 0; n5 < this.mItems.size(); ++n5) {
                        viewPager$ItemInfo3 = this.mItems.get(n5);
                        if (viewPager$ItemInfo3.position < this.mCurItem) continue;
                        if (viewPager$ItemInfo3.position != this.mCurItem) break;
                        break block20;
                    }
                    viewPager$ItemInfo3 = null;
                }
                viewPager$ItemInfo = viewPager$ItemInfo3 == null && n7 > 0 ? this.addNewItem(this.mCurItem, n5) : viewPager$ItemInfo3;
                if (viewPager$ItemInfo == null) break block22;
                int n11 = n5 - 1;
                ViewPager$ItemInfo viewPager$ItemInfo5 = n11 >= 0 ? this.mItems.get(n11) : null;
                int n12 = this.getClientWidth();
                float f2 = n12 <= 0 ? 0.0f : 2.0f - viewPager$ItemInfo.widthFactor + (float)this.getPaddingLeft() / (float)n12;
                int n13 = -1 + this.mCurItem;
                float f3 = 0.0f;
                n4 = n5;
                int n14 = n11;
                for (int i2 = n13; i2 >= 0; --i2) {
                    if (f3 >= f2 && i2 < n8) {
                        if (viewPager$ItemInfo5 == null) break;
                        if (i2 != viewPager$ItemInfo5.position || viewPager$ItemInfo5.scrolling) continue;
                        this.mItems.remove(n14);
                        this.mAdapter.destroyItem(this, i2, viewPager$ItemInfo5.object);
                        --n4;
                        if (--n14 >= 0) {
                            viewPager$ItemInfo5 = this.mItems.get(n14);
                            continue;
                        }
                        viewPager$ItemInfo5 = null;
                        continue;
                    }
                    if (viewPager$ItemInfo5 != null && i2 == viewPager$ItemInfo5.position) {
                        f3 += viewPager$ItemInfo5.widthFactor;
                        if (--n14 >= 0) {
                            viewPager$ItemInfo5 = this.mItems.get(n14);
                            continue;
                        }
                        viewPager$ItemInfo5 = null;
                        continue;
                    }
                    f3 += this.addNewItem((int)i2, (int)(n14 + 1)).widthFactor;
                    ++n4;
                    viewPager$ItemInfo5 = n14 >= 0 ? this.mItems.get(n14) : null;
                }
                float f4 = viewPager$ItemInfo.widthFactor;
                int n15 = n4 + 1;
                if (!(f4 < 2.0f)) break block23;
                ViewPager$ItemInfo viewPager$ItemInfo6 = n15 < this.mItems.size() ? this.mItems.get(n15) : null;
                float f5 = n12 <= 0 ? 0.0f : 2.0f + (float)this.getPaddingRight() / (float)n12;
                int n16 = 1 + this.mCurItem;
                ViewPager$ItemInfo viewPager$ItemInfo7 = viewPager$ItemInfo6;
                int n17 = n15;
                ViewPager$ItemInfo viewPager$ItemInfo8 = viewPager$ItemInfo7;
                for (int i3 = n16; i3 < n7; ++i3) {
                    float f6;
                    ViewPager$ItemInfo viewPager$ItemInfo9;
                    block21: {
                        block25: {
                            block24: {
                                if (!(f4 >= f5) || i3 <= n6) break block24;
                                if (viewPager$ItemInfo8 == null) break;
                                if (i3 != viewPager$ItemInfo8.position || viewPager$ItemInfo8.scrolling) break block25;
                                this.mItems.remove(n17);
                                this.mAdapter.destroyItem(this, i3, viewPager$ItemInfo8.object);
                                ViewPager$ItemInfo viewPager$ItemInfo10 = n17 < this.mItems.size() ? this.mItems.get(n17) : null;
                                float f7 = f4;
                                viewPager$ItemInfo9 = viewPager$ItemInfo10;
                                f6 = f7;
                                break block21;
                            }
                            if (viewPager$ItemInfo8 != null && i3 == viewPager$ItemInfo8.position) {
                                float f8 = f4 + viewPager$ItemInfo8.widthFactor;
                                ViewPager$ItemInfo viewPager$ItemInfo11 = ++n17 < this.mItems.size() ? this.mItems.get(n17) : null;
                                viewPager$ItemInfo9 = viewPager$ItemInfo11;
                                f6 = f8;
                                break block21;
                            } else {
                                ViewPager$ItemInfo viewPager$ItemInfo12 = this.addNewItem(i3, n17);
                                float f9 = f4 + viewPager$ItemInfo12.widthFactor;
                                ViewPager$ItemInfo viewPager$ItemInfo13 = ++n17 < this.mItems.size() ? this.mItems.get(n17) : null;
                                viewPager$ItemInfo9 = viewPager$ItemInfo13;
                                f6 = f9;
                            }
                            break block21;
                        }
                        float f10 = f4;
                        viewPager$ItemInfo9 = viewPager$ItemInfo8;
                        f6 = f10;
                    }
                    float f11 = f6;
                    viewPager$ItemInfo8 = viewPager$ItemInfo9;
                    f4 = f11;
                }
            }
            this.calculatePageOffsets(viewPager$ItemInfo, n4, viewPager$ItemInfo2);
        }
        PagerAdapter pagerAdapter = this.mAdapter;
        int n18 = this.mCurItem;
        Object object = viewPager$ItemInfo != null ? viewPager$ItemInfo.object : null;
        pagerAdapter.setPrimaryItem(this, n18, object);
        this.mAdapter.finishUpdate(this);
        int n19 = this.getChildCount();
        for (int i4 = 0; i4 < n19; ++i4) {
            ViewPager$ItemInfo viewPager$ItemInfo14;
            View view = this.getChildAt(i4);
            ViewPager$LayoutParams viewPager$LayoutParams = (ViewPager$LayoutParams)view.getLayoutParams();
            viewPager$LayoutParams.childIndex = i4;
            if (viewPager$LayoutParams.isDecor || viewPager$LayoutParams.widthFactor != 0.0f || (viewPager$ItemInfo14 = this.infoForChild(view)) == null) continue;
            viewPager$LayoutParams.widthFactor = viewPager$ItemInfo14.widthFactor;
            viewPager$LayoutParams.position = viewPager$ItemInfo14.position;
        }
        this.sortChildDrawingOrder();
        if (!this.hasFocus()) return;
        View view = this.findFocus();
        ViewPager$ItemInfo viewPager$ItemInfo15 = view != null ? this.infoForAnyChild(view) : null;
        if (viewPager$ItemInfo15 != null) {
            if (viewPager$ItemInfo15.position == this.mCurItem) return;
        }
        int n20 = 0;
        while (n20 < this.getChildCount()) {
            View view2 = this.getChildAt(n20);
            ViewPager$ItemInfo viewPager$ItemInfo16 = this.infoForChild(view2);
            if (viewPager$ItemInfo16 != null && viewPager$ItemInfo16.position == this.mCurItem) {
                if (view2.requestFocus(n3)) return;
            }
            ++n20;
        }
    }

    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
            return;
        }
        super.removeView(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(PagerAdapter pagerAdapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
            this.mAdapter.startUpdate(this);
            for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
                ViewPager$ItemInfo viewPager$ItemInfo = this.mItems.get(i2);
                this.mAdapter.destroyItem(this, viewPager$ItemInfo.position, viewPager$ItemInfo.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        PagerAdapter pagerAdapter2 = this.mAdapter;
        this.mAdapter = pagerAdapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new ViewPager$PagerObserver(this, null);
            }
            this.mAdapter.registerDataSetObserver(this.mObserver);
            this.mPopulatePending = false;
            boolean bl2 = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (!bl2) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
        if (this.mAdapterChangeListener != null && pagerAdapter2 != pagerAdapter) {
            this.mAdapterChangeListener.onAdapterChanged(pagerAdapter2, pagerAdapter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    void setChildrenDrawingOrderEnabledCompat(boolean bl2) {
        if (Build.VERSION.SDK_INT < 7) return;
        if (this.mSetChildrenDrawingOrderEnabled == null) {
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                this.mSetChildrenDrawingOrderEnabled = ViewGroup.class.getDeclaredMethod("setChildrenDrawingOrderEnabled", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)TAG, (String)"Can't find setChildrenDrawingOrderEnabled", (Throwable)noSuchMethodException);
            }
        }
        try {
            Method method = this.mSetChildrenDrawingOrderEnabled;
            Object[] objectArray = new Object[]{bl2};
            method.invoke((Object)this, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error changing children drawing order", (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCurrentItem(int n2) {
        this.mPopulatePending = false;
        boolean bl2 = !this.mFirstLayout;
        this.setCurrentItemInternal(n2, bl2, false);
    }

    public void setCurrentItem(int n2, boolean bl2) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, bl2, false);
    }

    void setCurrentItemInternal(int n2, boolean bl2, boolean bl3) {
        this.setCurrentItemInternal(n2, bl2, bl3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCurrentItemInternal(int n2, boolean bl2, boolean bl3, int n3) {
        int n4;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!bl3 && this.mCurItem == n2 && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.mAdapter.getCount()) {
            n2 = -1 + this.mAdapter.getCount();
        }
        if (n2 > (n4 = this.mOffscreenPageLimit) + this.mCurItem || n2 < this.mCurItem - n4) {
            for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
                this.mItems.get((int)i2).scrolling = true;
            }
        }
        int n5 = this.mCurItem;
        boolean bl4 = false;
        if (n5 != n2) {
            bl4 = true;
        }
        if (!this.mFirstLayout) {
            this.populate(n2);
            this.scrollToItem(n2, bl2, n3, bl4);
            return;
        }
        this.mCurItem = n2;
        if (bl4 && this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(n2);
        }
        if (bl4 && this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(n2);
        }
        this.requestLayout();
    }

    ViewPager$OnPageChangeListener setInternalPageChangeListener(ViewPager$OnPageChangeListener viewPager$OnPageChangeListener) {
        ViewPager$OnPageChangeListener viewPager$OnPageChangeListener2 = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = viewPager$OnPageChangeListener;
        return viewPager$OnPageChangeListener2;
    }

    public void setOffscreenPageLimit(int n2) {
        if (n2 <= 0) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + n2 + " too small; defaulting to 1"));
            n2 = 1;
        }
        if (n2 != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n2;
            this.populate();
        }
    }

    void setOnAdapterChangeListener(ViewPager$OnAdapterChangeListener viewPager$OnAdapterChangeListener) {
        this.mAdapterChangeListener = viewPager$OnAdapterChangeListener;
    }

    public void setOnPageChangeListener(ViewPager$OnPageChangeListener viewPager$OnPageChangeListener) {
        this.mOnPageChangeListener = viewPager$OnPageChangeListener;
    }

    public void setPageMargin(int n2) {
        int n3 = this.mPageMargin;
        this.mPageMargin = n2;
        int n4 = this.getWidth();
        this.recomputeScrollPosition(n4, n4, n2, n3);
        this.requestLayout();
    }

    public void setPageMarginDrawable(int n2) {
        this.setPageMarginDrawable(this.getContext().getResources().getDrawable(n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPageMarginDrawable(Drawable drawable2) {
        this.mMarginDrawable = drawable2;
        if (drawable2 != null) {
            this.refreshDrawableState();
        }
        boolean bl2 = drawable2 == null;
        this.setWillNotDraw(bl2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPageTransformer(boolean bl2, ViewPager$PageTransformer viewPager$PageTransformer) {
        int n2 = 1;
        if (Build.VERSION.SDK_INT < 11) return;
        int n3 = viewPager$PageTransformer != null ? n2 : 0;
        int n4 = this.mPageTransformer != null ? n2 : 0;
        int n5 = n3 != n4 ? n2 : 0;
        this.mPageTransformer = viewPager$PageTransformer;
        this.setChildrenDrawingOrderEnabledCompat(n3 != 0);
        if (n3 != 0) {
            if (bl2) {
                n2 = 2;
            }
            this.mDrawingOrder = n2;
        } else {
            this.mDrawingOrder = 0;
        }
        if (n5 != 0) {
            this.populate();
        }
    }

    void smoothScrollTo(int n2, int n3) {
        this.smoothScrollTo(n2, n3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void smoothScrollTo(int n2, int n3, int n4) {
        int n5;
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int n6 = this.getScrollX();
        int n7 = this.getScrollY();
        int n8 = n2 - n6;
        int n9 = n3 - n7;
        if (n8 == 0 && n9 == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        int n10 = this.getClientWidth();
        int n11 = n10 / 2;
        float f2 = Math.min(1.0f, 1.0f * (float)Math.abs(n8) / (float)n10);
        float f3 = (float)n11 + (float)n11 * this.distanceInfluenceForSnapDuration(f2);
        int n12 = Math.abs(n4);
        if (n12 > 0) {
            n5 = 4 * Math.round(1000.0f * Math.abs(f3 / (float)n12));
        } else {
            float f4 = (float)n10 * this.mAdapter.getPageWidth(this.mCurItem);
            n5 = (int)(100.0f * (1.0f + (float)Math.abs(n8) / (f4 + (float)this.mPageMargin)));
        }
        int n13 = Math.min(n5, 600);
        this.mScroller.startScroll(n6, n7, n8, n9, n13);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        return super.verifyDrawable(drawable2) || drawable2 == this.mMarginDrawable;
    }
}

