/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

public class SparseArrayCompat<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private int mSize;
    private Object[] mValues;

    public SparseArrayCompat() {
        this(10);
    }

    public SparseArrayCompat(int n2) {
        int n3 = SparseArrayCompat.idealIntArraySize(n2);
        this.mKeys = new int[n3];
        this.mValues = new Object[n3];
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int binarySearch(int[] nArray, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        int n6 = n2 - 1;
        int n7 = n5;
        while (n7 - n6 > 1) {
            int n8 = (n7 + n6) / 2;
            if (nArray[n8] < n4) {
                n6 = n8;
                continue;
            }
            n7 = n8;
        }
        if (n7 == n2 + n3) {
            return 0xFFFFFFFF ^ n2 + n3;
        }
        if (nArray[n7] == n4) return n7;
        return ~n7;
    }

    private void gc() {
        int n2 = this.mSize;
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (object == DELETED) continue;
            if (i2 != n3) {
                nArray[n3] = nArray[i2];
                objectArray[n3] = object;
            }
            ++n3;
        }
        this.mGarbage = false;
        this.mSize = n3;
    }

    static int idealByteArraySize(int n2) {
        int n3 = 4;
        while (true) {
            block4: {
                block3: {
                    if (n3 >= 32) break block3;
                    if (n2 > -12 + (1 << n3)) break block4;
                    n2 = -12 + (1 << n3);
                }
                return n2;
            }
            ++n3;
        }
    }

    static int idealIntArraySize(int n2) {
        return SparseArrayCompat.idealByteArraySize(n2 * 4) / 4;
    }

    public void append(int n2, E e2) {
        int n3;
        if (this.mSize != 0 && n2 <= this.mKeys[-1 + this.mSize]) {
            this.put(n2, e2);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n3 = this.mSize) >= this.mKeys.length) {
            int n4 = SparseArrayCompat.idealIntArraySize(n3 + 1);
            int[] nArray = new int[n4];
            Object[] objectArray = new Object[n4];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        this.mKeys[n3] = n2;
        this.mValues[n3] = e2;
        this.mSize = n3 + 1;
    }

    public void clear() {
        int n2 = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void delete(int n2) {
        int n3 = SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n2);
        if (n3 >= 0 && this.mValues[n3] != DELETED) {
            this.mValues[n3] = DELETED;
            this.mGarbage = true;
        }
    }

    public E get(int n2) {
        return this.get(n2, null);
    }

    public E get(int n2, E e2) {
        int n3 = SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n2);
        if (n3 < 0 || this.mValues[n3] == DELETED) {
            return e2;
        }
        return (E)this.mValues[n3];
    }

    public int indexOfKey(int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n2);
    }

    public int indexOfValue(E e2) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (this.mValues[i2] != e2) continue;
            return i2;
        }
        return -1;
    }

    public int keyAt(int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n2];
    }

    public void put(int n2, E e2) {
        int n3 = SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n2);
        if (n3 >= 0) {
            this.mValues[n3] = e2;
            return;
        }
        int n4 = ~n3;
        if (n4 < this.mSize && this.mValues[n4] == DELETED) {
            this.mKeys[n4] = n2;
            this.mValues[n4] = e2;
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
            n4 = 0xFFFFFFFF ^ SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n2);
        }
        if (this.mSize >= this.mKeys.length) {
            int n5 = SparseArrayCompat.idealIntArraySize(1 + this.mSize);
            int[] nArray = new int[n5];
            Object[] objectArray = new Object[n5];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        if (this.mSize - n4 != 0) {
            System.arraycopy(this.mKeys, n4, this.mKeys, n4 + 1, this.mSize - n4);
            System.arraycopy(this.mValues, n4, this.mValues, n4 + 1, this.mSize - n4);
        }
        this.mKeys[n4] = n2;
        this.mValues[n4] = e2;
        this.mSize = 1 + this.mSize;
    }

    public void remove(int n2) {
        this.delete(n2);
    }

    public void removeAt(int n2) {
        if (this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void removeAtRange(int n2, int n3) {
        int n4 = Math.min(this.mSize, n2 + n3);
        while (n2 < n4) {
            this.removeAt(n2);
            ++n2;
        }
    }

    public void setValueAt(int n2, E e2) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n2] = e2;
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public E valueAt(int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n2];
    }
}

