/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.support.v4.text.BidiFormatter$1;
import android.support.v4.text.BidiFormatter$Builder;
import android.support.v4.text.BidiFormatter$DirectionalityEstimator;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.text.TextUtilsCompat;
import java.util.Locale;

public final class BidiFormatter {
    private static final int DEFAULT_FLAGS = 2;
    private static final BidiFormatter DEFAULT_LTR_INSTANCE;
    private static final BidiFormatter DEFAULT_RTL_INSTANCE;
    private static TextDirectionHeuristicCompat DEFAULT_TEXT_DIRECTION_HEURISTIC;
    private static final int DIR_LTR = -1;
    private static final int DIR_RTL = 1;
    private static final int DIR_UNKNOWN = 0;
    private static final String EMPTY_STRING = "";
    private static final int FLAG_STEREO_RESET = 2;
    private static final char LRE = '\u202a';
    private static final char LRM = '\u200e';
    private static final String LRM_STRING;
    private static final char PDF = '\u202c';
    private static final char RLE = '\u202b';
    private static final char RLM = '\u200f';
    private static final String RLM_STRING;
    private final TextDirectionHeuristicCompat mDefaultTextDirectionHeuristicCompat;
    private final int mFlags;
    private final boolean mIsRtlContext;

    static {
        DEFAULT_TEXT_DIRECTION_HEURISTIC = TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
        LRM_STRING = Character.toString('\u200e');
        RLM_STRING = Character.toString('\u200f');
        DEFAULT_LTR_INSTANCE = new BidiFormatter(false, 2, DEFAULT_TEXT_DIRECTION_HEURISTIC);
        DEFAULT_RTL_INSTANCE = new BidiFormatter(true, 2, DEFAULT_TEXT_DIRECTION_HEURISTIC);
    }

    private BidiFormatter(boolean bl2, int n2, TextDirectionHeuristicCompat textDirectionHeuristicCompat) {
        this.mIsRtlContext = bl2;
        this.mFlags = n2;
        this.mDefaultTextDirectionHeuristicCompat = textDirectionHeuristicCompat;
    }

    /* synthetic */ BidiFormatter(boolean bl2, int n2, TextDirectionHeuristicCompat textDirectionHeuristicCompat, BidiFormatter$1 bidiFormatter$1) {
        this(bl2, n2, textDirectionHeuristicCompat);
    }

    static /* synthetic */ boolean access$000(Locale locale) {
        return BidiFormatter.isRtlLocale(locale);
    }

    static /* synthetic */ TextDirectionHeuristicCompat access$100() {
        return DEFAULT_TEXT_DIRECTION_HEURISTIC;
    }

    static /* synthetic */ BidiFormatter access$200() {
        return DEFAULT_RTL_INSTANCE;
    }

    static /* synthetic */ BidiFormatter access$300() {
        return DEFAULT_LTR_INSTANCE;
    }

    private static int getEntryDir(String string2) {
        return new BidiFormatter$DirectionalityEstimator(string2, false).getEntryDir();
    }

    private static int getExitDir(String string2) {
        return new BidiFormatter$DirectionalityEstimator(string2, false).getExitDir();
    }

    public static BidiFormatter getInstance() {
        return new BidiFormatter$Builder().build();
    }

    public static BidiFormatter getInstance(Locale locale) {
        return new BidiFormatter$Builder(locale).build();
    }

    public static BidiFormatter getInstance(boolean bl2) {
        return new BidiFormatter$Builder(bl2).build();
    }

    private static boolean isRtlLocale(Locale locale) {
        return TextUtilsCompat.getLayoutDirectionFromLocale(locale) == 1;
    }

    private String markAfter(String string2, TextDirectionHeuristicCompat textDirectionHeuristicCompat) {
        boolean bl2 = textDirectionHeuristicCompat.isRtl(string2, 0, string2.length());
        if (!this.mIsRtlContext && (bl2 || BidiFormatter.getExitDir(string2) == 1)) {
            return LRM_STRING;
        }
        if (this.mIsRtlContext && (!bl2 || BidiFormatter.getExitDir(string2) == -1)) {
            return RLM_STRING;
        }
        return EMPTY_STRING;
    }

    private String markBefore(String string2, TextDirectionHeuristicCompat textDirectionHeuristicCompat) {
        boolean bl2 = textDirectionHeuristicCompat.isRtl(string2, 0, string2.length());
        if (!this.mIsRtlContext && (bl2 || BidiFormatter.getEntryDir(string2) == 1)) {
            return LRM_STRING;
        }
        if (this.mIsRtlContext && (!bl2 || BidiFormatter.getEntryDir(string2) == -1)) {
            return RLM_STRING;
        }
        return EMPTY_STRING;
    }

    public final boolean getStereoReset() {
        return (2 & this.mFlags) != 0;
    }

    public final boolean isRtl(String string2) {
        return this.mDefaultTextDirectionHeuristicCompat.isRtl(string2, 0, string2.length());
    }

    public final boolean isRtlContext() {
        return this.mIsRtlContext;
    }

    public final String unicodeWrap(String string2) {
        return this.unicodeWrap(string2, this.mDefaultTextDirectionHeuristicCompat, true);
    }

    public final String unicodeWrap(String string2, TextDirectionHeuristicCompat textDirectionHeuristicCompat) {
        return this.unicodeWrap(string2, textDirectionHeuristicCompat, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String unicodeWrap(String string2, TextDirectionHeuristicCompat textDirectionHeuristicCompat, boolean bl2) {
        boolean bl3 = textDirectionHeuristicCompat.isRtl(string2, 0, string2.length());
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getStereoReset() && bl2) {
            TextDirectionHeuristicCompat textDirectionHeuristicCompat2 = bl3 ? TextDirectionHeuristicsCompat.RTL : TextDirectionHeuristicsCompat.LTR;
            stringBuilder.append(this.markBefore(string2, textDirectionHeuristicCompat2));
        }
        if (bl3 != this.mIsRtlContext) {
            char c2 = bl3 ? (char)'\u202b' : '\u202a';
            stringBuilder.append(c2);
            stringBuilder.append(string2);
            stringBuilder.append('\u202c');
        } else {
            stringBuilder.append(string2);
        }
        if (bl2) {
            TextDirectionHeuristicCompat textDirectionHeuristicCompat3 = bl3 ? TextDirectionHeuristicsCompat.RTL : TextDirectionHeuristicsCompat.LTR;
            stringBuilder.append(this.markAfter(string2, textDirectionHeuristicCompat3));
        }
        return stringBuilder.toString();
    }

    public final String unicodeWrap(String string2, boolean bl2) {
        return this.unicodeWrap(string2, this.mDefaultTextDirectionHeuristicCompat, bl2);
    }
}

