/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

class BidiFormatter$DirectionalityEstimator {
    private static final byte[] DIR_TYPE_CACHE = new byte[1792];
    private static final int DIR_TYPE_CACHE_SIZE = 1792;
    private int charIndex;
    private final boolean isHtml;
    private char lastChar;
    private final int length;
    private final String text;

    static {
        for (int i2 = 0; i2 < 1792; ++i2) {
            BidiFormatter$DirectionalityEstimator.DIR_TYPE_CACHE[i2] = Character.getDirectionality(i2);
        }
    }

    BidiFormatter$DirectionalityEstimator(String string2, boolean bl2) {
        this.text = string2;
        this.isHtml = bl2;
        this.length = string2.length();
    }

    private static byte getCachedDirectionality(char c2) {
        if (c2 < '\u0700') {
            return DIR_TYPE_CACHE[c2];
        }
        return Character.getDirectionality(c2);
    }

    private byte skipEntityBackward() {
        int n2 = this.charIndex;
        while (this.charIndex > 0) {
            int n3;
            String string2 = this.text;
            this.charIndex = n3 = -1 + this.charIndex;
            this.lastChar = string2.charAt(n3);
            if (this.lastChar == '&') {
                return 12;
            }
            if (this.lastChar != ';') continue;
        }
        this.charIndex = n2;
        this.lastChar = (char)59;
        return 13;
    }

    private byte skipEntityForward() {
        while (this.charIndex < this.length) {
            char c2;
            String string2 = this.text;
            int n2 = this.charIndex;
            this.charIndex = n2 + 1;
            this.lastChar = c2 = string2.charAt(n2);
            if (c2 != ';') continue;
        }
        return 12;
    }

    private byte skipTagBackward() {
        int n2 = this.charIndex;
        block0: while (this.charIndex > 0) {
            int n3;
            String string2 = this.text;
            this.charIndex = n3 = -1 + this.charIndex;
            this.lastChar = string2.charAt(n3);
            if (this.lastChar == '<') {
                return 12;
            }
            if (this.lastChar == '>') break;
            if (this.lastChar != '\"' && this.lastChar != '\'') continue;
            char c2 = this.lastChar;
            while (this.charIndex > 0) {
                char c3;
                int n4;
                String string3 = this.text;
                this.charIndex = n4 = -1 + this.charIndex;
                this.lastChar = c3 = string3.charAt(n4);
                if (c3 != c2) continue;
                continue block0;
            }
        }
        this.charIndex = n2;
        this.lastChar = (char)62;
        return 13;
    }

    private byte skipTagForward() {
        int n2 = this.charIndex;
        block0: while (this.charIndex < this.length) {
            String string2 = this.text;
            int n3 = this.charIndex;
            this.charIndex = n3 + 1;
            this.lastChar = string2.charAt(n3);
            if (this.lastChar == '>') {
                return 12;
            }
            if (this.lastChar != '\"' && this.lastChar != '\'') continue;
            char c2 = this.lastChar;
            while (this.charIndex < this.length) {
                char c3;
                String string3 = this.text;
                int n4 = this.charIndex;
                this.charIndex = n4 + 1;
                this.lastChar = c3 = string3.charAt(n4);
                if (c3 != c2) continue;
                continue block0;
            }
        }
        this.charIndex = n2;
        this.lastChar = (char)60;
        return 13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte dirTypeBackward() {
        this.lastChar = this.text.charAt(-1 + this.charIndex);
        if (Character.isLowSurrogate(this.lastChar)) {
            int n2 = Character.codePointBefore(this.text, this.charIndex);
            this.charIndex -= Character.charCount(n2);
            return Character.getDirectionality(n2);
        }
        this.charIndex = -1 + this.charIndex;
        byte by2 = BidiFormatter$DirectionalityEstimator.getCachedDirectionality(this.lastChar);
        if (!this.isHtml) return by2;
        if (this.lastChar == '>') {
            return this.skipTagBackward();
        }
        if (this.lastChar != ';') return by2;
        return this.skipEntityBackward();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte dirTypeForward() {
        this.lastChar = this.text.charAt(this.charIndex);
        if (Character.isHighSurrogate(this.lastChar)) {
            int n2 = Character.codePointAt(this.text, this.charIndex);
            this.charIndex += Character.charCount(n2);
            return Character.getDirectionality(n2);
        }
        this.charIndex = 1 + this.charIndex;
        byte by2 = BidiFormatter$DirectionalityEstimator.getCachedDirectionality(this.lastChar);
        if (!this.isHtml) return by2;
        if (this.lastChar == '<') {
            return this.skipTagForward();
        }
        if (this.lastChar != '&') return by2;
        return this.skipEntityForward();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    int getEntryDir() {
        this.charIndex = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block13: while (this.charIndex < this.length && n2 == 0) {
            switch (this.dirTypeForward()) {
                case 9: {
                    continue block13;
                }
                default: {
                    n2 = n4;
                    continue block13;
                }
                case 14: 
                case 15: {
                    ++n4;
                    n3 = -1;
                    continue block13;
                }
                case 16: 
                case 17: {
                    ++n4;
                    n3 = 1;
                    continue block13;
                }
                case 18: {
                    --n4;
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    if (n4 == 0) {
                        return -1;
                    }
                    n2 = n4;
                    continue block13;
                }
                case 1: 
                case 2: 
            }
            if (n4 == 0) {
                return 1;
            }
            n2 = n4;
        }
        if (n2 == 0) {
            return 0;
        }
        if (n3 != 0) {
            return n3;
        }
        block14: while (this.charIndex > 0) {
            switch (this.dirTypeBackward()) {
                default: {
                    continue block14;
                }
                case 14: 
                case 15: {
                    if (n2 == n4) return -1;
                    --n4;
                    continue block14;
                }
                case 16: 
                case 17: {
                    if (n2 == n4) {
                        return 1;
                    }
                    --n4;
                    continue block14;
                }
                case 18: 
            }
            ++n4;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getExitDir() {
        this.charIndex = this.length;
        int n2 = 0;
        int n3 = 0;
        block8: while (true) {
            int n4 = this.charIndex;
            int n5 = 0;
            if (n4 <= 0) return n5;
            switch (this.dirTypeBackward()) {
                case 9: {
                    continue block8;
                }
                default: {
                    if (n2 != 0) continue block8;
                    n2 = n3;
                    continue block8;
                }
                case 0: {
                    if (n3 == 0) {
                        return -1;
                    }
                    if (n2 != 0) continue block8;
                    n2 = n3;
                    continue block8;
                }
                case 14: 
                case 15: {
                    if (n2 == n3) {
                        return -1;
                    }
                    --n3;
                    continue block8;
                }
                case 1: 
                case 2: {
                    if (n3 == 0) {
                        return 1;
                    }
                    if (n2 != 0) continue block8;
                    n2 = n3;
                    continue block8;
                }
                case 16: 
                case 17: {
                    if (n2 == n3) {
                        return 1;
                    }
                    --n3;
                    continue block8;
                }
                case 18: 
            }
            ++n3;
        }
    }
}

