/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.support.v4.content.FileProvider$PathStrategy;
import android.support.v4.content.FileProvider$SimplePathStrategy;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public class FileProvider
extends ContentProvider {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static final File DEVICE_ROOT = new File("/");
    private static final String META_DATA_FILE_PROVIDER_PATHS = "android.support.FILE_PROVIDER_PATHS";
    private static final String TAG_CACHE_PATH = "cache-path";
    private static final String TAG_EXTERNAL = "external-path";
    private static final String TAG_FILES_PATH = "files-path";
    private static final String TAG_ROOT_PATH = "root-path";
    private static HashMap<String, FileProvider$PathStrategy> sCache = new HashMap();
    private FileProvider$PathStrategy mStrategy;

    /*
     * Enabled aggressive block sorting
     */
    private static File buildPath(File file, String ... stringArray) {
        int n2 = stringArray.length;
        int n3 = 0;
        File file2 = file;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            File file3 = string2 != null ? new File(file2, string2) : file2;
            ++n3;
            file2 = file3;
        }
        return file2;
    }

    private static Object[] copyOf(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    private static String[] copyOf(String[] stringArray, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileProvider$PathStrategy getPathStrategy(Context context, String string2) {
        HashMap<String, FileProvider$PathStrategy> hashMap = sCache;
        synchronized (hashMap) {
            FileProvider$PathStrategy fileProvider$PathStrategy = sCache.get(string2);
            if (fileProvider$PathStrategy == null) {
                try {
                    FileProvider$PathStrategy fileProvider$PathStrategy2;
                    fileProvider$PathStrategy = fileProvider$PathStrategy2 = FileProvider.parsePathStrategy(context, string2);
                    sCache.put(string2, fileProvider$PathStrategy);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", iOException);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    throw new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", xmlPullParserException);
                }
            }
            return fileProvider$PathStrategy;
        }
    }

    public static Uri getUriForFile(Context context, String string2, File file) {
        return FileProvider.getPathStrategy(context, string2).getUriForFile(file);
    }

    private static int modeToMode(String string2) {
        if ("r".equals(string2)) {
            return 0x10000000;
        }
        if ("w".equals(string2) || "wt".equals(string2)) {
            return 0x2C000000;
        }
        if ("wa".equals(string2)) {
            return 0x2A000000;
        }
        if ("rw".equals(string2)) {
            return 0x38000000;
        }
        if ("rwt".equals(string2)) {
            return 0x3C000000;
        }
        throw new IllegalArgumentException("Invalid mode: " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static FileProvider$PathStrategy parsePathStrategy(Context context, String string2) {
        FileProvider$SimplePathStrategy fileProvider$SimplePathStrategy = new FileProvider$SimplePathStrategy(string2);
        XmlResourceParser xmlResourceParser = context.getPackageManager().resolveContentProvider(string2, 128).loadXmlMetaData(context.getPackageManager(), META_DATA_FILE_PROVIDER_PATHS);
        if (xmlResourceParser == null) {
            throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data");
        }
        int n2;
        while ((n2 = xmlResourceParser.next()) != 1) {
            if (n2 != 2) continue;
            String string3 = xmlResourceParser.getName();
            String string4 = xmlResourceParser.getAttributeValue(null, ATTR_NAME);
            String string5 = xmlResourceParser.getAttributeValue(null, ATTR_PATH);
            File file = TAG_ROOT_PATH.equals(string3) ? FileProvider.buildPath(DEVICE_ROOT, string5) : (TAG_FILES_PATH.equals(string3) ? FileProvider.buildPath(context.getFilesDir(), string5) : (TAG_CACHE_PATH.equals(string3) ? FileProvider.buildPath(context.getCacheDir(), string5) : (TAG_EXTERNAL.equals(string3) ? FileProvider.buildPath(Environment.getExternalStorageDirectory(), string5) : null)));
            if (file == null) continue;
            fileProvider$SimplePathStrategy.addRoot(string4, file);
        }
        return fileProvider$SimplePathStrategy;
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        super.attachInfo(context, providerInfo);
        if (providerInfo.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!providerInfo.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        this.mStrategy = FileProvider.getPathStrategy(context, providerInfo.authority);
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        if (this.mStrategy.getFileForUri(uri).delete()) {
            return 1;
        }
        return 0;
    }

    public String getType(Uri uri) {
        File file = this.mStrategy.getFileForUri(uri);
        int n2 = file.getName().lastIndexOf(46);
        if (n2 >= 0) {
            String string2 = file.getName().substring(n2 + 1);
            String string3 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
            if (string3 != null) {
                return string3;
            }
        }
        return "application/octet-stream";
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public boolean onCreate() {
        return true;
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) {
        return ParcelFileDescriptor.open((File)this.mStrategy.getFileForUri(uri), (int)FileProvider.modeToMode(string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        File file = this.mStrategy.getFileForUri(uri);
        if (stringArray == null) {
            stringArray = COLUMNS;
        }
        String[] stringArray3 = new String[stringArray.length];
        Object[] objectArray = new Object[stringArray.length];
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if (n3 >= n2) {
                String[] stringArray4 = FileProvider.copyOf(stringArray3, n4);
                Object[] objectArray2 = FileProvider.copyOf(objectArray, n4);
                MatrixCursor matrixCursor = new MatrixCursor(stringArray4, 1);
                matrixCursor.addRow(objectArray2);
                return matrixCursor;
            }
            String string4 = stringArray[n3];
            if ("_display_name".equals(string4)) {
                stringArray3[n4] = "_display_name";
                n5 = n4 + 1;
                objectArray[n4] = file.getName();
            } else if ("_size".equals(string4)) {
                stringArray3[n4] = "_size";
                n5 = n4 + 1;
                objectArray[n4] = file.length();
            } else {
                n5 = n4;
            }
            ++n3;
            n4 = n5;
        }
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("No external updates");
    }
}

