/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NavUtils;
import android.support.v4.app.TaskStackBuilder$SupportParentable;
import android.support.v4.app.TaskStackBuilder$TaskStackBuilderImpl;
import android.support.v4.app.TaskStackBuilder$TaskStackBuilderImplBase;
import android.support.v4.app.TaskStackBuilder$TaskStackBuilderImplHoneycomb;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class TaskStackBuilder
implements Iterable<Intent> {
    private static final TaskStackBuilder$TaskStackBuilderImpl IMPL = Build.VERSION.SDK_INT >= 11 ? new TaskStackBuilder$TaskStackBuilderImplHoneycomb() : new TaskStackBuilder$TaskStackBuilderImplBase();
    private static final String TAG = "TaskStackBuilder";
    private final ArrayList<Intent> mIntents = new ArrayList();
    private final Context mSourceContext;

    private TaskStackBuilder(Context context) {
        this.mSourceContext = context;
    }

    public static TaskStackBuilder create(Context context) {
        return new TaskStackBuilder(context);
    }

    public static TaskStackBuilder from(Context context) {
        return TaskStackBuilder.create(context);
    }

    public TaskStackBuilder addNextIntent(Intent intent) {
        this.mIntents.add(intent);
        return this;
    }

    public TaskStackBuilder addNextIntentWithParentStack(Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null) {
            componentName = intent.resolveActivity(this.mSourceContext.getPackageManager());
        }
        if (componentName != null) {
            this.addParentStack(componentName);
        }
        this.addNextIntent(intent);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TaskStackBuilder addParentStack(Activity activity) {
        Intent intent;
        boolean bl2 = activity instanceof TaskStackBuilder$SupportParentable;
        Intent intent2 = null;
        if (bl2) {
            intent2 = ((TaskStackBuilder$SupportParentable)activity).getSupportParentActivityIntent();
        }
        if ((intent = intent2 == null ? NavUtils.getParentActivityIntent(activity) : intent2) != null) {
            ComponentName componentName = intent.getComponent();
            if (componentName == null) {
                componentName = intent.resolveActivity(this.mSourceContext.getPackageManager());
            }
            this.addParentStack(componentName);
            this.addNextIntent(intent);
        }
        return this;
    }

    public TaskStackBuilder addParentStack(ComponentName componentName) {
        int n2 = this.mIntents.size();
        Intent intent = NavUtils.getParentActivityIntent(this.mSourceContext, componentName);
        while (intent != null) {
            try {
                Intent intent2;
                this.mIntents.add(n2, intent);
                intent = intent2 = NavUtils.getParentActivityIntent(this.mSourceContext, intent.getComponent());
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)TAG, (String)"Bad ComponentName while traversing activity parent metadata");
                throw new IllegalArgumentException(nameNotFoundException);
            }
        }
        return this;
    }

    public TaskStackBuilder addParentStack(Class<?> clazz) {
        return this.addParentStack(new ComponentName(this.mSourceContext, clazz));
    }

    public Intent editIntentAt(int n2) {
        return this.mIntents.get(n2);
    }

    public Intent getIntent(int n2) {
        return this.editIntentAt(n2);
    }

    public int getIntentCount() {
        return this.mIntents.size();
    }

    public Intent[] getIntents() {
        Intent[] intentArray = new Intent[this.mIntents.size()];
        if (intentArray.length == 0) {
            return intentArray;
        }
        intentArray[0] = new Intent(this.mIntents.get(0)).addFlags(0x1000C000);
        for (int i2 = 1; i2 < intentArray.length; ++i2) {
            intentArray[i2] = new Intent(this.mIntents.get(i2));
        }
        return intentArray;
    }

    public PendingIntent getPendingIntent(int n2, int n3) {
        return this.getPendingIntent(n2, n3, null);
    }

    public PendingIntent getPendingIntent(int n2, int n3, Bundle bundle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        Intent[] intentArray = this.mIntents.toArray(new Intent[this.mIntents.size()]);
        intentArray[0] = new Intent(intentArray[0]).addFlags(0x1000C000);
        return IMPL.getPendingIntent(this.mSourceContext, intentArray, n2, n3, bundle);
    }

    @Override
    public Iterator<Intent> iterator() {
        return this.mIntents.iterator();
    }

    public void startActivities() {
        this.startActivities(null);
    }

    public void startActivities(Bundle bundle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
        }
        Intent[] intentArray = this.mIntents.toArray(new Intent[this.mIntents.size()]);
        intentArray[0] = new Intent(intentArray[0]).addFlags(0x1000C000);
        if (!ContextCompat.startActivities(this.mSourceContext, intentArray, bundle)) {
            Intent intent = new Intent(intentArray[-1 + intentArray.length]);
            intent.addFlags(0x10000000);
            this.mSourceContext.startActivity(intent);
        }
    }
}

