/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.app.ShareCompat;
import android.text.Html;
import android.text.Spanned;
import android.util.Log;
import java.util.ArrayList;

public class ShareCompat$IntentReader {
    private static final String TAG = "IntentReader";
    private Activity mActivity;
    private ComponentName mCallingActivity;
    private String mCallingPackage;
    private Intent mIntent;
    private ArrayList<Uri> mStreams;

    private ShareCompat$IntentReader(Activity activity) {
        this.mActivity = activity;
        this.mIntent = activity.getIntent();
        this.mCallingPackage = ShareCompat.getCallingPackage(activity);
        this.mCallingActivity = ShareCompat.getCallingActivity(activity);
    }

    public static ShareCompat$IntentReader from(Activity activity) {
        return new ShareCompat$IntentReader(activity);
    }

    public ComponentName getCallingActivity() {
        return this.mCallingActivity;
    }

    public Drawable getCallingActivityIcon() {
        if (this.mCallingActivity == null) {
            return null;
        }
        PackageManager packageManager = this.mActivity.getPackageManager();
        try {
            Drawable drawable2 = packageManager.getActivityIcon(this.mCallingActivity);
            return drawable2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"Could not retrieve icon for calling activity", (Throwable)nameNotFoundException);
            return null;
        }
    }

    public Drawable getCallingApplicationIcon() {
        if (this.mCallingPackage == null) {
            return null;
        }
        PackageManager packageManager = this.mActivity.getPackageManager();
        try {
            Drawable drawable2 = packageManager.getApplicationIcon(this.mCallingPackage);
            return drawable2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"Could not retrieve icon for calling application", (Throwable)nameNotFoundException);
            return null;
        }
    }

    public CharSequence getCallingApplicationLabel() {
        if (this.mCallingPackage == null) {
            return null;
        }
        PackageManager packageManager = this.mActivity.getPackageManager();
        try {
            CharSequence charSequence = packageManager.getApplicationLabel(packageManager.getApplicationInfo(this.mCallingPackage, 0));
            return charSequence;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"Could not retrieve label for calling application", (Throwable)nameNotFoundException);
            return null;
        }
    }

    public String getCallingPackage() {
        return this.mCallingPackage;
    }

    public String[] getEmailBcc() {
        return this.mIntent.getStringArrayExtra("android.intent.extra.BCC");
    }

    public String[] getEmailCc() {
        return this.mIntent.getStringArrayExtra("android.intent.extra.CC");
    }

    public String[] getEmailTo() {
        return this.mIntent.getStringArrayExtra("android.intent.extra.EMAIL");
    }

    public String getHtmlText() {
        String string2 = this.mIntent.getStringExtra("android.intent.extra.HTML_TEXT");
        if (this.mIntent == null) {
            CharSequence charSequence = this.getText();
            if (charSequence instanceof Spanned) {
                return Html.toHtml((Spanned)((Spanned)charSequence));
            }
            if (charSequence != null) {
                return ShareCompat.access$000().escapeHtml(charSequence);
            }
        }
        return string2;
    }

    public Uri getStream() {
        return (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
    }

    public Uri getStream(int n2) {
        if (this.mStreams == null && this.isMultipleShare()) {
            this.mStreams = this.mIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
        }
        if (this.mStreams != null) {
            return this.mStreams.get(n2);
        }
        if (n2 == 0) {
            return (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
        }
        throw new IndexOutOfBoundsException("Stream items available: " + this.getStreamCount() + " index requested: " + n2);
    }

    public int getStreamCount() {
        if (this.mStreams == null && this.isMultipleShare()) {
            this.mStreams = this.mIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
        }
        if (this.mStreams != null) {
            return this.mStreams.size();
        }
        if (this.mIntent.hasExtra("android.intent.extra.STREAM")) {
            return 1;
        }
        return 0;
    }

    public String getSubject() {
        return this.mIntent.getStringExtra("android.intent.extra.SUBJECT");
    }

    public CharSequence getText() {
        return this.mIntent.getCharSequenceExtra("android.intent.extra.TEXT");
    }

    public String getType() {
        return this.mIntent.getType();
    }

    public boolean isMultipleShare() {
        return "android.intent.action.SEND_MULTIPLE".equals(this.mIntent.getAction());
    }

    public boolean isShareIntent() {
        String string2 = this.mIntent.getAction();
        return "android.intent.action.SEND".equals(string2) || "android.intent.action.SEND_MULTIPLE".equals(string2);
    }

    public boolean isSingleShare() {
        return "android.intent.action.SEND".equals(this.mIntent.getAction());
    }
}

