/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.NavUtils$NavUtilsImpl;
import android.support.v4.app.NavUtils$NavUtilsImplBase;
import android.support.v4.app.NavUtils$NavUtilsImplJB;
import android.support.v4.content.IntentCompat;

public class NavUtils {
    private static final NavUtils$NavUtilsImpl IMPL = Build.VERSION.SDK_INT >= 16 ? new NavUtils$NavUtilsImplJB() : new NavUtils$NavUtilsImplBase();
    public static final String PARENT_ACTIVITY = "android.support.PARENT_ACTIVITY";
    private static final String TAG = "NavUtils";

    private NavUtils() {
    }

    public static Intent getParentActivityIntent(Activity activity) {
        return IMPL.getParentActivityIntent(activity);
    }

    public static Intent getParentActivityIntent(Context context, ComponentName componentName) {
        String string2 = NavUtils.getParentActivityName(context, componentName);
        if (string2 == null) {
            return null;
        }
        ComponentName componentName2 = new ComponentName(componentName.getPackageName(), string2);
        if (NavUtils.getParentActivityName(context, componentName2) == null) {
            return IntentCompat.makeMainActivity(componentName2);
        }
        return new Intent().setComponent(componentName2);
    }

    public static Intent getParentActivityIntent(Context context, Class<?> clazz) {
        String string2 = NavUtils.getParentActivityName(context, new ComponentName(context, clazz));
        if (string2 == null) {
            return null;
        }
        ComponentName componentName = new ComponentName(context, string2);
        if (NavUtils.getParentActivityName(context, componentName) == null) {
            return IntentCompat.makeMainActivity(componentName);
        }
        return new Intent().setComponent(componentName);
    }

    public static String getParentActivityName(Activity activity) {
        try {
            String string2 = NavUtils.getParentActivityName((Context)activity, activity.getComponentName());
            return string2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalArgumentException(nameNotFoundException);
        }
    }

    public static String getParentActivityName(Context context, ComponentName componentName) {
        ActivityInfo activityInfo = context.getPackageManager().getActivityInfo(componentName, 128);
        return IMPL.getParentActivityName(context, activityInfo);
    }

    public static void navigateUpFromSameTask(Activity activity) {
        Intent intent = NavUtils.getParentActivityIntent(activity);
        if (intent == null) {
            throw new IllegalArgumentException("Activity " + activity.getClass().getSimpleName() + " does not have a parent activity name specified. (Did you forget to add the android.support.PARENT_ACTIVITY <meta-data>  element in your manifest?)");
        }
        NavUtils.navigateUpTo(activity, intent);
    }

    public static void navigateUpTo(Activity activity, Intent intent) {
        IMPL.navigateUpTo(activity, intent);
    }

    public static boolean shouldUpRecreateTask(Activity activity, Intent intent) {
        return IMPL.shouldUpRecreateTask(activity, intent);
    }
}

