/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.support.v4.app.NavUtils;
import android.support.v4.app.NavUtils$NavUtilsImpl;
import android.support.v4.content.IntentCompat;
import android.util.Log;

class NavUtils$NavUtilsImplBase
implements NavUtils$NavUtilsImpl {
    NavUtils$NavUtilsImplBase() {
    }

    @Override
    public Intent getParentActivityIntent(Activity activity) {
        String string2 = NavUtils.getParentActivityName(activity);
        if (string2 == null) {
            return null;
        }
        ComponentName componentName = new ComponentName((Context)activity, string2);
        try {
            if (NavUtils.getParentActivityName((Context)activity, componentName) == null) {
                return IntentCompat.makeMainActivity(componentName);
            }
            Intent intent = new Intent().setComponent(componentName);
            return intent;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"NavUtils", (String)("getParentActivityIntent: bad parentActivityName '" + string2 + "' in manifest"));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getParentActivityName(Context context, ActivityInfo activityInfo) {
        if (activityInfo.metaData == null) {
            return null;
        }
        String string2 = activityInfo.metaData.getString("android.support.PARENT_ACTIVITY");
        if (string2 == null) {
            return null;
        }
        if (string2.charAt(0) != '.') return string2;
        return context.getPackageName() + string2;
    }

    @Override
    public void navigateUpTo(Activity activity, Intent intent) {
        intent.addFlags(0x4000000);
        activity.startActivity(intent);
        activity.finish();
    }

    @Override
    public boolean shouldUpRecreateTask(Activity activity, Intent intent) {
        String string2 = activity.getIntent().getAction();
        return string2 != null && !string2.equals("android.intent.action.MAIN");
    }
}

