/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.app.LoaderManager$LoaderCallbacks;
import android.support.v4.app.LoaderManagerImpl$LoaderInfo;
import android.support.v4.content.Loader;
import android.support.v4.util.DebugUtils;
import android.support.v4.util.SparseArrayCompat;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;

class LoaderManagerImpl
extends LoaderManager {
    static boolean DEBUG = false;
    static final String TAG = "LoaderManager";
    FragmentActivity mActivity;
    boolean mCreatingLoader;
    final SparseArrayCompat<LoaderManagerImpl$LoaderInfo> mInactiveLoaders;
    final SparseArrayCompat<LoaderManagerImpl$LoaderInfo> mLoaders = new SparseArrayCompat();
    boolean mRetaining;
    boolean mRetainingStarted;
    boolean mStarted;
    final String mWho;

    static {
        DEBUG = false;
    }

    LoaderManagerImpl(String string2, FragmentActivity fragmentActivity, boolean bl2) {
        this.mInactiveLoaders = new SparseArrayCompat();
        this.mWho = string2;
        this.mActivity = fragmentActivity;
        this.mStarted = bl2;
    }

    private LoaderManagerImpl$LoaderInfo createAndInstallLoader(int n2, Bundle bundle, LoaderManager$LoaderCallbacks<Object> loaderManager$LoaderCallbacks) {
        try {
            this.mCreatingLoader = true;
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.createLoader(n2, bundle, loaderManager$LoaderCallbacks);
            this.installLoader(loaderManagerImpl$LoaderInfo);
            return loaderManagerImpl$LoaderInfo;
        }
        finally {
            this.mCreatingLoader = false;
        }
    }

    private LoaderManagerImpl$LoaderInfo createLoader(int n2, Bundle bundle, LoaderManager$LoaderCallbacks<Object> loaderManager$LoaderCallbacks) {
        LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = new LoaderManagerImpl$LoaderInfo(this, n2, bundle, loaderManager$LoaderCallbacks);
        loaderManagerImpl$LoaderInfo.mLoader = loaderManager$LoaderCallbacks.onCreateLoader(n2, bundle);
        return loaderManagerImpl$LoaderInfo;
    }

    @Override
    public void destroyLoader(int n2) {
        int n3;
        int n4;
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("destroyLoader in " + this + " of " + n2));
        }
        if ((n4 = this.mLoaders.indexOfKey(n2)) >= 0) {
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.mLoaders.valueAt(n4);
            this.mLoaders.removeAt(n4);
            loaderManagerImpl$LoaderInfo.destroy();
        }
        if ((n3 = this.mInactiveLoaders.indexOfKey(n2)) >= 0) {
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.mInactiveLoaders.valueAt(n3);
            this.mInactiveLoaders.removeAt(n3);
            loaderManagerImpl$LoaderInfo.destroy();
        }
        if (this.mActivity != null && !this.hasRunningLoaders()) {
            this.mActivity.mFragments.startPendingDeferredFragments();
        }
    }

    void doDestroy() {
        if (!this.mRetaining) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Destroying Active in " + this));
            }
            for (int i2 = -1 + this.mLoaders.size(); i2 >= 0; --i2) {
                this.mLoaders.valueAt(i2).destroy();
            }
            this.mLoaders.clear();
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Destroying Inactive in " + this));
        }
        for (int i3 = -1 + this.mInactiveLoaders.size(); i3 >= 0; --i3) {
            this.mInactiveLoaders.valueAt(i3).destroy();
        }
        this.mInactiveLoaders.clear();
    }

    void doReportNextStart() {
        for (int i2 = -1 + this.mLoaders.size(); i2 >= 0; --i2) {
            this.mLoaders.valueAt((int)i2).mReportNextStart = true;
        }
    }

    void doReportStart() {
        for (int i2 = -1 + this.mLoaders.size(); i2 >= 0; --i2) {
            this.mLoaders.valueAt(i2).reportStart();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void doRetain() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("Retaining in " + this));
        }
        if (!this.mStarted) {
            RuntimeException runtimeException = new RuntimeException("here");
            runtimeException.fillInStackTrace();
            Log.w((String)TAG, (String)("Called doRetain when not started: " + this), (Throwable)runtimeException);
            return;
        } else {
            this.mRetaining = true;
            this.mStarted = false;
            for (int i2 = -1 + this.mLoaders.size(); i2 >= 0; --i2) {
                this.mLoaders.valueAt(i2).retain();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void doStart() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("Starting in " + this));
        }
        if (this.mStarted) {
            RuntimeException runtimeException = new RuntimeException("here");
            runtimeException.fillInStackTrace();
            Log.w((String)TAG, (String)("Called doStart when already started: " + this), (Throwable)runtimeException);
            return;
        } else {
            this.mStarted = true;
            for (int i2 = -1 + this.mLoaders.size(); i2 >= 0; --i2) {
                this.mLoaders.valueAt(i2).start();
            }
        }
    }

    void doStop() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("Stopping in " + this));
        }
        if (!this.mStarted) {
            RuntimeException runtimeException = new RuntimeException("here");
            runtimeException.fillInStackTrace();
            Log.w((String)TAG, (String)("Called doStop when not started: " + this), (Throwable)runtimeException);
            return;
        }
        for (int i2 = -1 + this.mLoaders.size(); i2 >= 0; --i2) {
            this.mLoaders.valueAt(i2).stop();
        }
        this.mStarted = false;
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        int n2 = 0;
        if (this.mLoaders.size() > 0) {
            printWriter.print(string2);
            printWriter.println("Active Loaders:");
            String string3 = string2 + "    ";
            for (int i2 = 0; i2 < this.mLoaders.size(); ++i2) {
                LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.mLoaders.valueAt(i2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(this.mLoaders.keyAt(i2));
                printWriter.print(": ");
                printWriter.println(loaderManagerImpl$LoaderInfo.toString());
                loaderManagerImpl$LoaderInfo.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
        if (this.mInactiveLoaders.size() > 0) {
            printWriter.print(string2);
            printWriter.println("Inactive Loaders:");
            String string4 = string2 + "    ";
            while (n2 < this.mInactiveLoaders.size()) {
                LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.mInactiveLoaders.valueAt(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(this.mInactiveLoaders.keyAt(n2));
                printWriter.print(": ");
                printWriter.println(loaderManagerImpl$LoaderInfo.toString());
                loaderManagerImpl$LoaderInfo.dump(string4, fileDescriptor, printWriter, stringArray);
                ++n2;
            }
        }
    }

    void finishRetain() {
        if (this.mRetaining) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Finished Retaining in " + this));
            }
            this.mRetaining = false;
            for (int i2 = -1 + this.mLoaders.size(); i2 >= 0; --i2) {
                this.mLoaders.valueAt(i2).finishRetain();
            }
        }
    }

    @Override
    public <D> Loader<D> getLoader(int n2) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.mLoaders.get(n2);
        if (loaderManagerImpl$LoaderInfo != null) {
            if (loaderManagerImpl$LoaderInfo.mPendingLoader != null) {
                return loaderManagerImpl$LoaderInfo.mPendingLoader.mLoader;
            }
            return loaderManagerImpl$LoaderInfo.mLoader;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasRunningLoaders() {
        int n2 = this.mLoaders.size();
        int n3 = 0;
        boolean bl2 = false;
        while (n3 < n2) {
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.mLoaders.valueAt(n3);
            boolean bl3 = loaderManagerImpl$LoaderInfo.mStarted && !loaderManagerImpl$LoaderInfo.mDeliveredData;
            bl2 |= bl3;
            ++n3;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <D> Loader<D> initLoader(int n2, Bundle bundle, LoaderManager$LoaderCallbacks<D> loaderManager$LoaderCallbacks) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = this.mLoaders.get(n2);
        if (DEBUG) {
            Log.v((String)TAG, (String)("initLoader in " + this + ": args=" + bundle));
        }
        if (loaderManagerImpl$LoaderInfo == null) {
            loaderManagerImpl$LoaderInfo = this.createAndInstallLoader(n2, bundle, loaderManager$LoaderCallbacks);
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Created new loader " + loaderManagerImpl$LoaderInfo));
            }
        } else {
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Re-using existing loader " + loaderManagerImpl$LoaderInfo));
            }
            loaderManagerImpl$LoaderInfo.mCallbacks = loaderManager$LoaderCallbacks;
        }
        if (loaderManagerImpl$LoaderInfo.mHaveData && this.mStarted) {
            loaderManagerImpl$LoaderInfo.callOnLoadFinished(loaderManagerImpl$LoaderInfo.mLoader, loaderManagerImpl$LoaderInfo.mData);
        }
        return loaderManagerImpl$LoaderInfo.mLoader;
    }

    void installLoader(LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo) {
        this.mLoaders.put(loaderManagerImpl$LoaderInfo.mId, loaderManagerImpl$LoaderInfo);
        if (this.mStarted) {
            loaderManagerImpl$LoaderInfo.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <D> Loader<D> restartLoader(int n2, Bundle bundle, LoaderManager$LoaderCallbacks<D> loaderManager$LoaderCallbacks) {
        LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo;
        block12: {
            if (this.mCreatingLoader) {
                throw new IllegalStateException("Called while creating a loader");
            }
            loaderManagerImpl$LoaderInfo = this.mLoaders.get(n2);
            if (DEBUG) {
                Log.v((String)TAG, (String)("restartLoader in " + this + ": args=" + bundle));
            }
            if (loaderManagerImpl$LoaderInfo == null) return this.createAndInstallLoader((int)n2, (Bundle)bundle, loaderManager$LoaderCallbacks).mLoader;
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo2 = this.mInactiveLoaders.get(n2);
            if (loaderManagerImpl$LoaderInfo2 != null) {
                if (loaderManagerImpl$LoaderInfo.mHaveData) {
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("  Removing last inactive loader: " + loaderManagerImpl$LoaderInfo));
                    }
                    loaderManagerImpl$LoaderInfo2.mDeliveredData = false;
                    loaderManagerImpl$LoaderInfo2.destroy();
                    break block12;
                } else {
                    if (!loaderManagerImpl$LoaderInfo.mStarted) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)"  Current loader is stopped; replacing");
                        }
                        this.mLoaders.put(n2, null);
                        loaderManagerImpl$LoaderInfo.destroy();
                        return this.createAndInstallLoader((int)n2, (Bundle)bundle, loaderManager$LoaderCallbacks).mLoader;
                    }
                    if (loaderManagerImpl$LoaderInfo.mPendingLoader != null) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("  Removing pending loader: " + loaderManagerImpl$LoaderInfo.mPendingLoader));
                        }
                        loaderManagerImpl$LoaderInfo.mPendingLoader.destroy();
                        loaderManagerImpl$LoaderInfo.mPendingLoader = null;
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)"  Enqueuing as new pending loader");
                    }
                    loaderManagerImpl$LoaderInfo.mPendingLoader = this.createLoader(n2, bundle, loaderManager$LoaderCallbacks);
                    return loaderManagerImpl$LoaderInfo.mPendingLoader.mLoader;
                }
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Making last loader inactive: " + loaderManagerImpl$LoaderInfo));
            }
        }
        loaderManagerImpl$LoaderInfo.mLoader.abandon();
        this.mInactiveLoaders.put(n2, loaderManagerImpl$LoaderInfo);
        return this.createAndInstallLoader((int)n2, (Bundle)bundle, loaderManager$LoaderCallbacks).mLoader;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("LoaderManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        DebugUtils.buildShortClassTag((Object)this.mActivity, stringBuilder);
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }

    void updateActivity(FragmentActivity fragmentActivity) {
        this.mActivity = fragmentActivity;
    }
}

