/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Bundle;
import android.support.v4.app.LoaderManager$LoaderCallbacks;
import android.support.v4.app.LoaderManagerImpl;
import android.support.v4.content.Loader;
import android.support.v4.content.Loader$OnLoadCompleteListener;
import android.support.v4.util.DebugUtils;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

final class LoaderManagerImpl$LoaderInfo
implements Loader$OnLoadCompleteListener<Object> {
    final Bundle mArgs;
    LoaderManager$LoaderCallbacks<Object> mCallbacks;
    Object mData;
    boolean mDeliveredData;
    boolean mDestroyed;
    boolean mHaveData;
    final int mId;
    boolean mListenerRegistered;
    Loader<Object> mLoader;
    LoaderManagerImpl$LoaderInfo mPendingLoader;
    boolean mReportNextStart;
    boolean mRetaining;
    boolean mRetainingStarted;
    boolean mStarted;
    final /* synthetic */ LoaderManagerImpl this$0;

    public LoaderManagerImpl$LoaderInfo(LoaderManagerImpl loaderManagerImpl, int n2, Bundle bundle, LoaderManager$LoaderCallbacks<Object> loaderManager$LoaderCallbacks) {
        this.this$0 = loaderManagerImpl;
        this.mId = n2;
        this.mArgs = bundle;
        this.mCallbacks = loaderManager$LoaderCallbacks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void callOnLoadFinished(Loader<Object> loader, Object object) {
        String string2;
        if (this.mCallbacks != null) {
            if (this.this$0.mActivity != null) {
                String string3 = this.this$0.mActivity.mFragments.mNoTransactionsBecause;
                this.this$0.mActivity.mFragments.mNoTransactionsBecause = "onLoadFinished";
                string2 = string3;
            } else {
                string2 = null;
            }
            if (LoaderManagerImpl.DEBUG) {
                Log.v((String)"LoaderManager", (String)("  onLoadFinished in " + loader + ": " + loader.dataToString(object)));
            }
            this.mCallbacks.onLoadFinished(loader, object);
            this.mDeliveredData = true;
        }
        return;
        finally {
            if (this.this$0.mActivity != null) {
                this.this$0.mActivity.mFragments.mNoTransactionsBecause = string2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void destroy() {
        String string2;
        while (true) {
            if (LoaderManagerImpl.DEBUG) {
                Log.v((String)"LoaderManager", (String)("  Destroying: " + loaderManagerImpl$LoaderInfo));
            }
            loaderManagerImpl$LoaderInfo.mDestroyed = true;
            boolean bl2 = loaderManagerImpl$LoaderInfo.mDeliveredData;
            loaderManagerImpl$LoaderInfo.mDeliveredData = false;
            if (loaderManagerImpl$LoaderInfo.mCallbacks != null && loaderManagerImpl$LoaderInfo.mLoader != null && loaderManagerImpl$LoaderInfo.mHaveData && bl2) {
                if (LoaderManagerImpl.DEBUG) {
                    Log.v((String)"LoaderManager", (String)("  Reseting: " + loaderManagerImpl$LoaderInfo));
                }
                if (loaderManagerImpl$LoaderInfo.this$0.mActivity != null) {
                    String string3 = loaderManagerImpl$LoaderInfo.this$0.mActivity.mFragments.mNoTransactionsBecause;
                    loaderManagerImpl$LoaderInfo.this$0.mActivity.mFragments.mNoTransactionsBecause = "onLoaderReset";
                    string2 = string3;
                } else {
                    string2 = null;
                }
                loaderManagerImpl$LoaderInfo.mCallbacks.onLoaderReset(loaderManagerImpl$LoaderInfo.mLoader);
            }
            loaderManagerImpl$LoaderInfo.mCallbacks = null;
            loaderManagerImpl$LoaderInfo.mData = null;
            loaderManagerImpl$LoaderInfo.mHaveData = false;
            if (loaderManagerImpl$LoaderInfo.mLoader != null) {
                if (loaderManagerImpl$LoaderInfo.mListenerRegistered) {
                    loaderManagerImpl$LoaderInfo.mListenerRegistered = false;
                    loaderManagerImpl$LoaderInfo.mLoader.unregisterListener(loaderManagerImpl$LoaderInfo);
                }
                loaderManagerImpl$LoaderInfo.mLoader.reset();
            }
            if (loaderManagerImpl$LoaderInfo.mPendingLoader == null) {
                return;
            }
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = loaderManagerImpl$LoaderInfo.mPendingLoader;
        }
        finally {
            if (loaderManagerImpl$LoaderInfo.this$0.mActivity != null) {
                loaderManagerImpl$LoaderInfo.this$0.mActivity.mFragments.mNoTransactionsBecause = string2;
            }
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        while (true) {
            printWriter.print(string2);
            printWriter.print("mId=");
            printWriter.print(loaderManagerImpl$LoaderInfo.mId);
            printWriter.print(" mArgs=");
            printWriter.println(loaderManagerImpl$LoaderInfo.mArgs);
            printWriter.print(string2);
            printWriter.print("mCallbacks=");
            printWriter.println(loaderManagerImpl$LoaderInfo.mCallbacks);
            printWriter.print(string2);
            printWriter.print("mLoader=");
            printWriter.println(loaderManagerImpl$LoaderInfo.mLoader);
            if (loaderManagerImpl$LoaderInfo.mLoader != null) {
                loaderManagerImpl$LoaderInfo.mLoader.dump(string2 + "  ", fileDescriptor, printWriter, stringArray);
            }
            if (loaderManagerImpl$LoaderInfo.mHaveData || loaderManagerImpl$LoaderInfo.mDeliveredData) {
                printWriter.print(string2);
                printWriter.print("mHaveData=");
                printWriter.print(loaderManagerImpl$LoaderInfo.mHaveData);
                printWriter.print("  mDeliveredData=");
                printWriter.println(loaderManagerImpl$LoaderInfo.mDeliveredData);
                printWriter.print(string2);
                printWriter.print("mData=");
                printWriter.println(loaderManagerImpl$LoaderInfo.mData);
            }
            printWriter.print(string2);
            printWriter.print("mStarted=");
            printWriter.print(loaderManagerImpl$LoaderInfo.mStarted);
            printWriter.print(" mReportNextStart=");
            printWriter.print(loaderManagerImpl$LoaderInfo.mReportNextStart);
            printWriter.print(" mDestroyed=");
            printWriter.println(loaderManagerImpl$LoaderInfo.mDestroyed);
            printWriter.print(string2);
            printWriter.print("mRetaining=");
            printWriter.print(loaderManagerImpl$LoaderInfo.mRetaining);
            printWriter.print(" mRetainingStarted=");
            printWriter.print(loaderManagerImpl$LoaderInfo.mRetainingStarted);
            printWriter.print(" mListenerRegistered=");
            printWriter.println(loaderManagerImpl$LoaderInfo.mListenerRegistered);
            if (loaderManagerImpl$LoaderInfo.mPendingLoader == null) break;
            printWriter.print(string2);
            printWriter.println("Pending Loader ");
            printWriter.print(loaderManagerImpl$LoaderInfo.mPendingLoader);
            printWriter.println(":");
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo = loaderManagerImpl$LoaderInfo.mPendingLoader;
            string2 = string2 + "  ";
        }
    }

    final void finishRetain() {
        if (this.mRetaining) {
            if (LoaderManagerImpl.DEBUG) {
                Log.v((String)"LoaderManager", (String)("  Finished Retaining: " + this));
            }
            this.mRetaining = false;
            if (this.mStarted != this.mRetainingStarted && !this.mStarted) {
                this.stop();
            }
        }
        if (this.mStarted && this.mHaveData && !this.mReportNextStart) {
            this.callOnLoadFinished(this.mLoader, this.mData);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void onLoadComplete(Loader<Object> loader, Object object) {
        if (LoaderManagerImpl.DEBUG) {
            Log.v((String)"LoaderManager", (String)("onLoadComplete: " + this));
        }
        if (this.mDestroyed) {
            if (!LoaderManagerImpl.DEBUG) return;
            Log.v((String)"LoaderManager", (String)"  Ignoring load complete -- destroyed");
            return;
        }
        if (this.this$0.mLoaders.get(this.mId) != this) {
            if (!LoaderManagerImpl.DEBUG) return;
            Log.v((String)"LoaderManager", (String)"  Ignoring load complete -- not active");
            return;
        } else {
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo;
            LoaderManagerImpl$LoaderInfo loaderManagerImpl$LoaderInfo2 = this.mPendingLoader;
            if (loaderManagerImpl$LoaderInfo2 != null) {
                if (LoaderManagerImpl.DEBUG) {
                    Log.v((String)"LoaderManager", (String)("  Switching to pending loader: " + loaderManagerImpl$LoaderInfo2));
                }
                this.mPendingLoader = null;
                this.this$0.mLoaders.put(this.mId, null);
                this.destroy();
                this.this$0.installLoader(loaderManagerImpl$LoaderInfo2);
                return;
            }
            if (this.mData != object || !this.mHaveData) {
                this.mData = object;
                this.mHaveData = true;
                if (this.mStarted) {
                    this.callOnLoadFinished(loader, object);
                }
            }
            if ((loaderManagerImpl$LoaderInfo = this.this$0.mInactiveLoaders.get(this.mId)) != null && loaderManagerImpl$LoaderInfo != this) {
                loaderManagerImpl$LoaderInfo.mDeliveredData = false;
                loaderManagerImpl$LoaderInfo.destroy();
                this.this$0.mInactiveLoaders.remove(this.mId);
            }
            if (this.this$0.mActivity == null || this.this$0.hasRunningLoaders()) return;
            this.this$0.mActivity.mFragments.startPendingDeferredFragments();
            return;
        }
    }

    final void reportStart() {
        if (this.mStarted && this.mReportNextStart) {
            this.mReportNextStart = false;
            if (this.mHaveData) {
                this.callOnLoadFinished(this.mLoader, this.mData);
            }
        }
    }

    final void retain() {
        if (LoaderManagerImpl.DEBUG) {
            Log.v((String)"LoaderManager", (String)("  Retaining: " + this));
        }
        this.mRetaining = true;
        this.mRetainingStarted = this.mStarted;
        this.mStarted = false;
        this.mCallbacks = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void start() {
        if (this.mRetaining && this.mRetainingStarted) {
            this.mStarted = true;
            return;
        }
        if (this.mStarted) return;
        this.mStarted = true;
        if (LoaderManagerImpl.DEBUG) {
            Log.v((String)"LoaderManager", (String)("  Starting: " + this));
        }
        if (this.mLoader == null && this.mCallbacks != null) {
            this.mLoader = this.mCallbacks.onCreateLoader(this.mId, this.mArgs);
        }
        if (this.mLoader == null) return;
        if (this.mLoader.getClass().isMemberClass() && !Modifier.isStatic(this.mLoader.getClass().getModifiers())) {
            throw new IllegalArgumentException("Object returned from onCreateLoader must not be a non-static inner member class: " + this.mLoader);
        }
        if (!this.mListenerRegistered) {
            this.mLoader.registerListener(this.mId, this);
            this.mListenerRegistered = true;
        }
        this.mLoader.startLoading();
    }

    final void stop() {
        if (LoaderManagerImpl.DEBUG) {
            Log.v((String)"LoaderManager", (String)("  Stopping: " + this));
        }
        this.mStarted = false;
        if (!this.mRetaining && this.mLoader != null && this.mListenerRegistered) {
            this.mListenerRegistered = false;
            this.mLoader.unregisterListener(this);
            this.mLoader.stopLoading();
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("LoaderInfo{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" #");
        stringBuilder.append(this.mId);
        stringBuilder.append(" : ");
        DebugUtils.buildShortClassTag(this.mLoader, stringBuilder);
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }
}

