/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.BackStackState;
import android.support.v4.app.Fragment;
import android.support.v4.app.Fragment$SavedState;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentContainer;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManager$BackStackEntry;
import android.support.v4.app.FragmentManager$OnBackStackChangedListener;
import android.support.v4.app.FragmentManagerImpl$1;
import android.support.v4.app.FragmentManagerImpl$2;
import android.support.v4.app.FragmentManagerImpl$3;
import android.support.v4.app.FragmentManagerImpl$4;
import android.support.v4.app.FragmentManagerImpl$5;
import android.support.v4.app.FragmentManagerState;
import android.support.v4.app.FragmentState;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NoSaveStateFrameLayout;
import android.support.v4.app.SuperNotCalledException;
import android.support.v4.util.DebugUtils;
import android.support.v4.util.LogWriter;
import android.util.Log;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class FragmentManagerImpl
extends FragmentManager {
    static final Interpolator ACCELERATE_CUBIC;
    static final Interpolator ACCELERATE_QUINT;
    static final int ANIM_DUR = 220;
    public static final int ANIM_STYLE_CLOSE_ENTER = 3;
    public static final int ANIM_STYLE_CLOSE_EXIT = 4;
    public static final int ANIM_STYLE_FADE_ENTER = 5;
    public static final int ANIM_STYLE_FADE_EXIT = 6;
    public static final int ANIM_STYLE_OPEN_ENTER = 1;
    public static final int ANIM_STYLE_OPEN_EXIT = 2;
    static boolean DEBUG = false;
    static final Interpolator DECELERATE_CUBIC;
    static final Interpolator DECELERATE_QUINT;
    static final boolean HONEYCOMB = false;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    static final String VIEW_STATE_TAG = "android:view_state";
    ArrayList<Fragment> mActive;
    FragmentActivity mActivity;
    ArrayList<Fragment> mAdded;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<Integer> mAvailIndices;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<FragmentManager$OnBackStackChangedListener> mBackStackChangeListeners;
    ArrayList<BackStackRecord> mBackStackIndices;
    FragmentContainer mContainer;
    ArrayList<Fragment> mCreatedMenus;
    int mCurState = 0;
    boolean mDestroyed;
    Runnable mExecCommit = new FragmentManagerImpl$1(this);
    boolean mExecutingActions;
    boolean mHavePendingDeferredStart;
    boolean mNeedMenuInvalidate;
    String mNoTransactionsBecause;
    Fragment mParent;
    ArrayList<Runnable> mPendingActions;
    SparseArray<Parcelable> mStateArray = null;
    Bundle mStateBundle = null;
    boolean mStateSaved;
    Runnable[] mTmpActions;

    static {
        DEBUG = false;
        int n2 = Build.VERSION.SDK_INT;
        boolean bl2 = false;
        if (n2 >= 11) {
            bl2 = true;
        }
        HONEYCOMB = bl2;
        DECELERATE_QUINT = new DecelerateInterpolator(2.5f);
        DECELERATE_CUBIC = new DecelerateInterpolator(1.5f);
        ACCELERATE_QUINT = new AccelerateInterpolator(2.5f);
        ACCELERATE_CUBIC = new AccelerateInterpolator(1.5f);
    }

    FragmentManagerImpl() {
    }

    private void checkStateLoss() {
        if (this.mStateSaved) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mNoTransactionsBecause != null) {
            throw new IllegalStateException("Can not perform this action inside of " + this.mNoTransactionsBecause);
        }
    }

    static Animation makeFadeAnimation(Context context, float f2, float f3) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(f2, f3);
        alphaAnimation.setInterpolator(DECELERATE_CUBIC);
        alphaAnimation.setDuration(220L);
        return alphaAnimation;
    }

    static Animation makeOpenCloseAnimation(Context context, float f2, float f3, float f4, float f5) {
        AnimationSet animationSet = new AnimationSet(false);
        ScaleAnimation scaleAnimation = new ScaleAnimation(f2, f3, f2, f3, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setInterpolator(DECELERATE_QUINT);
        scaleAnimation.setDuration(220L);
        animationSet.addAnimation((Animation)scaleAnimation);
        AlphaAnimation alphaAnimation = new AlphaAnimation(f4, f5);
        alphaAnimation.setInterpolator(DECELERATE_CUBIC);
        alphaAnimation.setDuration(220L);
        animationSet.addAnimation((Animation)alphaAnimation);
        return animationSet;
    }

    public static int reverseTransit(int n2) {
        switch (n2) {
            default: {
                return 0;
            }
            case 4097: {
                return 8194;
            }
            case 8194: {
                return 4097;
            }
            case 4099: 
        }
        return 4099;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void throwException(RuntimeException runtimeException) {
        Log.e((String)TAG, (String)runtimeException.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        PrintWriter printWriter = new PrintWriter(new LogWriter(TAG));
        if (this.mActivity != null) {
            try {
                this.mActivity.dump("  ", null, printWriter, new String[0]);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
                throw runtimeException;
            }
            throw runtimeException;
        }
        try {
            this.dump("  ", null, printWriter, new String[0]);
            throw runtimeException;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
            throw runtimeException;
        }
    }

    public static int transitToStyleIndex(int n2, boolean bl2) {
        switch (n2) {
            default: {
                return -1;
            }
            case 4097: {
                if (bl2) {
                    return 1;
                }
                return 2;
            }
            case 8194: {
                if (bl2) {
                    return 3;
                }
                return 4;
            }
            case 4099: 
        }
        if (bl2) {
            return 5;
        }
        return 6;
    }

    final void addBackStackState(BackStackRecord backStackRecord) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(backStackRecord);
        this.reportBackStackChanged();
    }

    public final void addFragment(Fragment fragment, boolean bl2) {
        if (this.mAdded == null) {
            this.mAdded = new ArrayList();
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("add: " + fragment));
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            if (this.mAdded.contains(fragment)) {
                throw new IllegalStateException("Fragment already added: " + fragment);
            }
            this.mAdded.add(fragment);
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            if (bl2) {
                this.moveToState(fragment);
            }
        }
    }

    @Override
    public final void addOnBackStackChangedListener(FragmentManager$OnBackStackChangedListener fragmentManager$OnBackStackChangedListener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(fragmentManager$OnBackStackChangedListener);
    }

    public final int allocBackStackIndex(BackStackRecord backStackRecord) {
        synchronized (this) {
            block7: {
                if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) break block7;
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                int n2 = this.mBackStackIndices.size();
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + n2 + " to " + backStackRecord));
                }
                this.mBackStackIndices.add(backStackRecord);
                return n2;
            }
            int n3 = this.mAvailBackStackIndices.remove(-1 + this.mAvailBackStackIndices.size());
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adding back stack index " + n3 + " with " + backStackRecord));
            }
            this.mBackStackIndices.set(n3, backStackRecord);
            return n3;
        }
    }

    public final void attachActivity(FragmentActivity fragmentActivity, FragmentContainer fragmentContainer, Fragment fragment) {
        if (this.mActivity != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mActivity = fragmentActivity;
        this.mContainer = fragmentContainer;
        this.mParent = fragment;
    }

    public final void attachFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("attach: " + fragment));
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded == null) {
                    this.mAdded = new ArrayList();
                }
                if (this.mAdded.contains(fragment)) {
                    throw new IllegalStateException("Fragment already added: " + fragment);
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("add from attach: " + fragment));
                }
                this.mAdded.add(fragment);
                fragment.mAdded = true;
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                this.moveToState(fragment, this.mCurState, n2, n3, false);
            }
        }
    }

    @Override
    public final FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    public final void detachFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("detach: " + fragment));
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (this.mAdded != null) {
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("remove from detach: " + fragment));
                    }
                    this.mAdded.remove(fragment);
                }
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
                this.moveToState(fragment, 1, n2, n3, false);
            }
        }
    }

    public final void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.moveToState(2, false);
    }

    public final void dispatchConfigurationChanged(Configuration configuration) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performConfigurationChanged(configuration);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean dispatchContextItemSelected(MenuItem menuItem) {
        ArrayList<Fragment> arrayList = this.mAdded;
        boolean bl2 = false;
        if (arrayList == null) return bl2;
        int n2 = 0;
        while (true) {
            int n3 = this.mAdded.size();
            bl2 = false;
            if (n2 >= n3) return bl2;
            Fragment fragment = this.mAdded.get(n2);
            if (fragment != null && fragment.performContextItemSelected(menuItem)) {
                return true;
            }
            ++n2;
        }
    }

    public final void dispatchCreate() {
        this.mStateSaved = false;
        this.moveToState(1, false);
    }

    public final boolean dispatchCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        boolean bl2;
        ArrayList<Fragment> arrayList = null;
        if (this.mAdded != null) {
            bl2 = false;
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment != null && fragment.performCreateOptionsMenu(menu2, menuInflater)) {
                    bl2 = true;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Fragment>();
                    }
                    arrayList.add(fragment);
                }
                boolean bl3 = bl2;
                bl2 = bl3;
            }
        } else {
            bl2 = false;
        }
        ArrayList<Fragment> arrayList2 = this.mCreatedMenus;
        if (arrayList2 != null) {
            for (int i3 = 0; i3 < this.mCreatedMenus.size(); ++i3) {
                Fragment fragment = this.mCreatedMenus.get(i3);
                if (arrayList != null && arrayList.contains(fragment)) continue;
                fragment.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = arrayList;
        return bl2;
    }

    public final void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.moveToState(0, false);
        this.mActivity = null;
        this.mContainer = null;
        this.mParent = null;
    }

    public final void dispatchDestroyView() {
        this.moveToState(1, false);
    }

    public final void dispatchLowMemory() {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performLowMemory();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        ArrayList<Fragment> arrayList = this.mAdded;
        boolean bl2 = false;
        if (arrayList == null) return bl2;
        int n2 = 0;
        while (true) {
            int n3 = this.mAdded.size();
            bl2 = false;
            if (n2 >= n3) return bl2;
            Fragment fragment = this.mAdded.get(n2);
            if (fragment != null && fragment.performOptionsItemSelected(menuItem)) {
                return true;
            }
            ++n2;
        }
    }

    public final void dispatchOptionsMenuClosed(Menu menu2) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performOptionsMenuClosed(menu2);
            }
        }
    }

    public final void dispatchPause() {
        this.moveToState(4, false);
    }

    public final boolean dispatchPrepareOptionsMenu(Menu menu2) {
        boolean bl2;
        if (this.mAdded != null) {
            bl2 = false;
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null || !fragment.performPrepareOptionsMenu(menu2)) continue;
                bl2 = true;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public final void dispatchReallyStop() {
        this.moveToState(2, false);
    }

    public final void dispatchResume() {
        this.mStateSaved = false;
        this.moveToState(5, false);
    }

    public final void dispatchStart() {
        this.mStateSaved = false;
        this.moveToState(4, false);
    }

    public final void dispatchStop() {
        this.mStateSaved = true;
        this.moveToState(3, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        int n2;
        int n8;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        String string3 = string2 + "    ";
        if (this.mActive != null && (n6 = this.mActive.size()) > 0) {
            printWriter.print(string2);
            printWriter.print("Active Fragments in ");
            printWriter.print(Integer.toHexString(System.identityHashCode(this)));
            printWriter.println(":");
            for (int i2 = 0; i2 < n6; ++i2) {
                Fragment fragment = this.mActive.get(i2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i2);
                printWriter.print(": ");
                printWriter.println(fragment);
                if (fragment == null) continue;
                fragment.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
        if (this.mAdded != null && (n5 = this.mAdded.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Added Fragments:");
            for (int i3 = 0; i3 < n5; ++i3) {
                Fragment fragment = this.mAdded.get(i3);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i3);
                printWriter.print(": ");
                printWriter.println(fragment.toString());
            }
        }
        if (this.mCreatedMenus != null && (n4 = this.mCreatedMenus.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Fragments Created Menus:");
            for (int i4 = 0; i4 < n4; ++i4) {
                Fragment fragment = this.mCreatedMenus.get(i4);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i4);
                printWriter.print(": ");
                printWriter.println(fragment.toString());
            }
        }
        if (this.mBackStack != null && (n3 = this.mBackStack.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack:");
            for (int i5 = 0; i5 < n3; ++i5) {
                BackStackRecord backStackRecord = this.mBackStack.get(i5);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i5);
                printWriter.print(": ");
                printWriter.println(backStackRecord.toString());
                backStackRecord.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
        // MONITORENTER : this
        if (this.mBackStackIndices != null && (n8 = this.mBackStackIndices.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack Indices:");
            for (int i6 = 0; i6 < n8; ++i6) {
                BackStackRecord backStackRecord = this.mBackStackIndices.get(i6);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i6);
                printWriter.print(": ");
                printWriter.println(backStackRecord);
            }
        }
        if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
            printWriter.print(string2);
            printWriter.print("mAvailBackStackIndices: ");
            printWriter.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
        }
        // MONITOREXIT : this
        if (this.mPendingActions != null && (n2 = this.mPendingActions.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Pending Actions:");
            while (n7 < n2) {
                Runnable runnable = this.mPendingActions.get(n7);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n7);
                printWriter.print(": ");
                printWriter.println(runnable);
                ++n7;
            }
        }
        printWriter.print(string2);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(string2);
        printWriter.print("  mActivity=");
        printWriter.println((Object)this.mActivity);
        printWriter.print(string2);
        printWriter.print("  mContainer=");
        printWriter.println(this.mContainer);
        if (this.mParent != null) {
            printWriter.print(string2);
            printWriter.print("  mParent=");
            printWriter.println(this.mParent);
        }
        printWriter.print(string2);
        printWriter.print("  mCurState=");
        printWriter.print(this.mCurState);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.mStateSaved);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            printWriter.print(string2);
            printWriter.print("  mNeedMenuInvalidate=");
            printWriter.println(this.mNeedMenuInvalidate);
        }
        if (this.mNoTransactionsBecause != null) {
            printWriter.print(string2);
            printWriter.print("  mNoTransactionsBecause=");
            printWriter.println(this.mNoTransactionsBecause);
        }
        if (this.mAvailIndices == null) return;
        if (this.mAvailIndices.size() <= 0) return;
        printWriter.print(string2);
        printWriter.print("  mAvailIndices: ");
        printWriter.println(Arrays.toString(this.mAvailIndices.toArray()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void enqueueAction(Runnable runnable, boolean bl2) {
        if (!bl2) {
            this.checkStateLoss();
        }
        synchronized (this) {
            if (this.mActivity == null) {
                throw new IllegalStateException("Activity has been destroyed");
            }
            if (this.mPendingActions == null) {
                this.mPendingActions = new ArrayList();
            }
            this.mPendingActions.add(runnable);
            if (this.mPendingActions.size() == 1) {
                this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                this.mActivity.mHandler.post(this.mExecCommit);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean execPendingActions() {
        boolean bl2;
        block11: {
            boolean bl3;
            if (this.mExecutingActions) {
                throw new IllegalStateException("Recursive entry to executePendingTransactions");
            }
            if (Looper.myLooper() != this.mActivity.mHandler.getLooper()) {
                throw new IllegalStateException("Must be called from main thread of process");
            }
            bl2 = false;
            while (true) {
                int n2;
                synchronized (this) {
                    if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                        // MONITOREXIT @DISABLED, blocks:[2, 3, 10] lbl9 : MonitorExitStatement: MONITOREXIT : this
                        if (!this.mHavePendingDeferredStart) break block11;
                        bl3 = false;
                        for (int i2 = 0; i2 < this.mActive.size(); ++i2) {
                            Fragment fragment = this.mActive.get(i2);
                            if (fragment == null || fragment.mLoaderManager == null) continue;
                            bl3 |= fragment.mLoaderManager.hasRunningLoaders();
                        }
                        break;
                    }
                    n2 = this.mPendingActions.size();
                    if (this.mTmpActions == null || this.mTmpActions.length < n2) {
                        this.mTmpActions = new Runnable[n2];
                    }
                    this.mPendingActions.toArray(this.mTmpActions);
                    this.mPendingActions.clear();
                    this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                }
                this.mExecutingActions = true;
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.mTmpActions[i3].run();
                    this.mTmpActions[i3] = null;
                }
                this.mExecutingActions = false;
                bl2 = true;
            }
            if (!bl3) {
                this.mHavePendingDeferredStart = false;
                this.startPendingDeferredFragments();
            }
        }
        return bl2;
    }

    @Override
    public final boolean executePendingTransactions() {
        return this.execPendingActions();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Fragment findFragmentById(int n2) {
        Fragment fragment;
        if (this.mAdded != null) {
            for (int i2 = -1 + this.mAdded.size(); i2 >= 0; --i2) {
                fragment = this.mAdded.get(i2);
                if (fragment != null && fragment.mFragmentId == n2) return fragment;
            }
        }
        if (this.mActive == null) return null;
        for (int i3 = -1 + this.mActive.size(); i3 >= 0; --i3) {
            fragment = this.mActive.get(i3);
            if (fragment == null || fragment.mFragmentId != n2) continue;
            return fragment;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Fragment findFragmentByTag(String string2) {
        Fragment fragment;
        if (this.mAdded != null && string2 != null) {
            for (int i2 = -1 + this.mAdded.size(); i2 >= 0; --i2) {
                fragment = this.mAdded.get(i2);
                if (fragment != null && string2.equals(fragment.mTag)) return fragment;
            }
        }
        if (this.mActive == null || string2 == null) return null;
        for (int i3 = -1 + this.mActive.size(); i3 >= 0; --i3) {
            fragment = this.mActive.get(i3);
            if (fragment == null || !string2.equals(fragment.mTag)) continue;
            return fragment;
        }
        return null;
    }

    public final Fragment findFragmentByWho(String string2) {
        if (this.mActive != null && string2 != null) {
            for (int i2 = -1 + this.mActive.size(); i2 >= 0; --i2) {
                Fragment fragment;
                Fragment fragment2 = this.mActive.get(i2);
                if (fragment2 == null || (fragment = fragment2.findFragmentByWho(string2)) == null) continue;
                return fragment;
            }
        }
        return null;
    }

    public final void freeBackStackIndex(int n2) {
        synchronized (this) {
            this.mBackStackIndices.set(n2, null);
            if (this.mAvailBackStackIndices == null) {
                this.mAvailBackStackIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Freeing back stack index " + n2));
            }
            this.mAvailBackStackIndices.add(n2);
            return;
        }
    }

    @Override
    public final FragmentManager$BackStackEntry getBackStackEntryAt(int n2) {
        return this.mBackStack.get(n2);
    }

    @Override
    public final int getBackStackEntryCount() {
        if (this.mBackStack != null) {
            return this.mBackStack.size();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Fragment getFragment(Bundle bundle, String string2) {
        Fragment fragment;
        int n2 = bundle.getInt(string2, -1);
        if (n2 == -1) {
            return null;
        }
        if (n2 >= this.mActive.size()) {
            this.throwException(new IllegalStateException("Fragement no longer exists for key " + string2 + ": index " + n2));
        }
        if ((fragment = this.mActive.get(n2)) != null) return fragment;
        this.throwException(new IllegalStateException("Fragement no longer exists for key " + string2 + ": index " + n2));
        return fragment;
    }

    @Override
    public final List<Fragment> getFragments() {
        return this.mActive;
    }

    public final void hideFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("hide: " + fragment));
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n2, true, n3);
                if (animation != null) {
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(8);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final Animation loadAnimation(Fragment fragment, int n2, boolean bl2, int n3) {
        Animation animation = fragment.onCreateAnimation(n2, bl2, fragment.mNextAnim);
        if (animation != null || fragment.mNextAnim != 0 && (animation = AnimationUtils.loadAnimation((Context)this.mActivity, (int)fragment.mNextAnim)) != null) {
            return animation;
        }
        if (n2 == 0) {
            return null;
        }
        int n4 = FragmentManagerImpl.transitToStyleIndex(n2, bl2);
        if (n4 < 0) {
            return null;
        }
        switch (n4) {
            default: {
                if (n3 == 0 && this.mActivity.getWindow() != null) {
                    n3 = this.mActivity.getWindow().getAttributes().windowAnimations;
                }
                if (n3 != 0) break;
                return null;
            }
            case 1: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.125f, 1.0f, 0.0f, 1.0f);
            }
            case 2: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.0f, 0.975f, 1.0f, 0.0f);
            }
            case 3: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 0.975f, 1.0f, 0.0f, 1.0f);
            }
            case 4: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.0f, 1.075f, 1.0f, 0.0f);
            }
            case 5: {
                return FragmentManagerImpl.makeFadeAnimation((Context)this.mActivity, 0.0f, 1.0f);
            }
            case 6: {
                return FragmentManagerImpl.makeFadeAnimation((Context)this.mActivity, 1.0f, 0.0f);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void makeActive(Fragment fragment) {
        block7: {
            block6: {
                if (fragment.mIndex >= 0) break block6;
                if (this.mAvailIndices == null || this.mAvailIndices.size() <= 0) {
                    if (this.mActive == null) {
                        this.mActive = new ArrayList();
                    }
                    fragment.setIndex(this.mActive.size(), this.mParent);
                    this.mActive.add(fragment);
                } else {
                    fragment.setIndex(this.mAvailIndices.remove(-1 + this.mAvailIndices.size()), this.mParent);
                    this.mActive.set(fragment.mIndex, fragment);
                }
                if (DEBUG) break block7;
            }
            return;
        }
        Log.v((String)TAG, (String)("Allocated fragment index " + fragment));
    }

    final void makeInactive(Fragment fragment) {
        if (fragment.mIndex < 0) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Freeing fragment index " + fragment));
        }
        this.mActive.set(fragment.mIndex, null);
        if (this.mAvailIndices == null) {
            this.mAvailIndices = new ArrayList();
        }
        this.mAvailIndices.add(fragment.mIndex);
        this.mActivity.invalidateSupportFragment(fragment.mWho);
        fragment.initState();
    }

    /*
     * Unable to fully structure code
     */
    final void moveToState(int var1_1, int var2_2, int var3_3, boolean var4_4) {
        block8: {
            if (this.mActivity == null && var1_1 != 0) {
                throw new IllegalStateException("No activity");
            }
            if (!var4_4 && this.mCurState == var1_1) lbl-1000:
            // 3 sources

            {
                return;
            }
            this.mCurState = var1_1;
            if (this.mActive == null) ** GOTO lbl-1000
            var6_6 = false;
            block1: for (var5_5 = 0; var5_5 < this.mActive.size(); ++var5_5) {
                var7_7 = this.mActive.get(var5_5);
                if (var7_7 != null) {
                    this.moveToState(var7_7, var1_1, var2_2, var3_3, false);
                    if (var7_7.mLoaderManager != null) {
                        var8_8 = var6_6 | var7_7.mLoaderManager.hasRunningLoaders();
lbl15:
                        // 2 sources

                        while (true) {
                            var6_6 = var8_8;
                            continue block1;
                            break;
                        }
                    }
                }
                break block8;
            }
            if (!var6_6) {
                this.startPendingDeferredFragments();
            }
            if (this.mNeedMenuInvalidate && this.mActivity != null && this.mCurState == 5) ** break;
            ** while (true)
            this.mActivity.supportInvalidateOptionsMenu();
            this.mNeedMenuInvalidate = false;
            return;
        }
        var8_8 = var6_6;
        ** while (true)
    }

    final void moveToState(int n2, boolean bl2) {
        this.moveToState(n2, 0, 0, bl2);
    }

    final void moveToState(Fragment fragment) {
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    final void moveToState(Fragment var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block57: {
            if ((!var1_1.mAdded || var1_1.mDetached) && var2_2 > 1) {
                var2_2 = 1;
            }
            if (var1_1.mRemoving && var2_2 > var1_1.mState) {
                var2_2 = var1_1.mState;
            }
            if (var1_1.mDeferStart && var1_1.mState < 4 && var2_2 > 3) {
                var2_2 = 3;
            }
            if (var1_1.mState >= var2_2) ** GOTO lbl65
            if (var1_1.mFromLayout && !var1_1.mInLayout) {
                return;
            }
            if (var1_1.mAnimatingAway != null) {
                var1_1.mAnimatingAway = null;
                this.moveToState(var1_1, var1_1.mStateAfterAnimating, 0, 0, true);
            }
            cfr_temp_0 = -2147483648;
lbl14:
            // 2 sources

            block13: while (true) {
                switch (cfr_temp_0 == -2147483648 ? var1_1.mState : cfr_temp_0) {
                    case 0: {
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("moveto CREATED: " + var1_1));
                        }
                        if (var1_1.mSavedFragmentState != null) {
                            var1_1.mSavedViewState = var1_1.mSavedFragmentState.getSparseParcelableArray("android:view_state");
                            var1_1.mTarget = this.getFragment(var1_1.mSavedFragmentState, "android:target_state");
                            if (var1_1.mTarget != null) {
                                var1_1.mTargetRequestCode = var1_1.mSavedFragmentState.getInt("android:target_req_state", 0);
                            }
                            var1_1.mUserVisibleHint = var1_1.mSavedFragmentState.getBoolean("android:user_visible_hint", true);
                            if (!var1_1.mUserVisibleHint) {
                                var1_1.mDeferStart = true;
                                if (var2_2 > 3) {
                                    var2_2 = 3;
                                }
                            }
                        }
                        var1_1.mActivity = this.mActivity;
                        var1_1.mParentFragment = this.mParent;
                        var18_6 = this.mParent != null ? this.mParent.mChildFragmentManager : this.mActivity.mFragments;
                        var1_1.mFragmentManager = var18_6;
                        var1_1.mCalled = false;
                        var1_1.onAttach(this.mActivity);
                        if (!var1_1.mCalled) {
                            throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onAttach()");
                        }
                        if (var1_1.mParentFragment == null) {
                            this.mActivity.onAttachFragment(var1_1);
                        }
                        if (!var1_1.mRetaining) {
                            var1_1.performCreate(var1_1.mSavedFragmentState);
                        }
                        var1_1.mRetaining = false;
                        if (!var1_1.mFromLayout) ** GOTO lbl51
                        var1_1.mView = var1_1.performCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), null, var1_1.mSavedFragmentState);
                        if (var1_1.mView == null) ** GOTO lbl53
                        var1_1.mInnerView = var1_1.mView;
                        var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                        if (var1_1.mHidden) {
                            var1_1.mView.setVisibility(8);
                        }
                        var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
                    }
lbl51:
                    // 3 sources

                    case 1: {
                        ** GOTO lbl54
                    }
lbl53:
                    // 1 sources

                    var1_1.mInnerView = null;
lbl54:
                    // 2 sources

                    cfr_temp_0 = 2;
                    if (var2_2 <= 1) continue block13;
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)"FragmentManager", (String)("moveto ACTIVITY_CREATED: " + var1_1));
                    }
                    if (var1_1.mFromLayout) ** GOTO lbl150
                    if (var1_1.mContainerId == 0) ** GOTO lbl134
                    var15_7 = (ViewGroup)this.mContainer.findViewById(var1_1.mContainerId);
                    if (var15_7 == null && !var1_1.mRestored) {
                        this.throwException(new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(var1_1.mContainerId) + " (" + var1_1.getResources().getResourceName(var1_1.mContainerId) + ") for fragment " + var1_1));
                    }
                    ** GOTO lbl135
lbl65:
                    // 1 sources

                    if (var1_1.mState > var2_2) {
                        switch (var1_1.mState) {
                            default: {
                                break;
                            }
                            case 5: {
                                if (var2_2 < 5) {
                                    if (FragmentManagerImpl.DEBUG) {
                                        Log.v((String)"FragmentManager", (String)("movefrom RESUMED: " + var1_1));
                                    }
                                    var1_1.performPause();
                                    var1_1.mResumed = false;
                                }
                            }
                            case 4: {
                                if (var2_2 < 4) {
                                    if (FragmentManagerImpl.DEBUG) {
                                        Log.v((String)"FragmentManager", (String)("movefrom STARTED: " + var1_1));
                                    }
                                    var1_1.performStop();
                                }
                            }
                            case 3: {
                                if (var2_2 < 3) {
                                    if (FragmentManagerImpl.DEBUG) {
                                        Log.v((String)"FragmentManager", (String)("movefrom STOPPED: " + var1_1));
                                    }
                                    var1_1.performReallyStop();
                                }
                            }
                            case 2: {
                                if (var2_2 < 2) {
                                    if (FragmentManagerImpl.DEBUG) {
                                        Log.v((String)"FragmentManager", (String)("movefrom ACTIVITY_CREATED: " + var1_1));
                                    }
                                    if (var1_1.mView != null && !this.mActivity.isFinishing() && var1_1.mSavedViewState == null) {
                                        this.saveFragmentViewState(var1_1);
                                    }
                                    var1_1.performDestroyView();
                                    if (var1_1.mView != null && var1_1.mContainer != null) {
                                        var8_10 = this.mCurState > 0 && this.mDestroyed == false ? this.loadAnimation(var1_1, var3_3, false, var4_4) : null;
                                        if (var8_10 != null) {
                                            var1_1.mAnimatingAway = var1_1.mView;
                                            var1_1.mStateAfterAnimating = var2_2;
                                            var8_10.setAnimationListener((Animation.AnimationListener)new FragmentManagerImpl$5(this, var1_1));
                                            var1_1.mView.startAnimation(var8_10);
                                        }
                                        var1_1.mContainer.removeView(var1_1.mView);
                                    }
                                    var1_1.mContainer = null;
                                    var1_1.mView = null;
                                    var1_1.mInnerView = null;
                                }
                            }
                            case 1: {
                                if (var2_2 > 0) break;
                                if (this.mDestroyed && var1_1.mAnimatingAway != null) {
                                    var7_9 = var1_1.mAnimatingAway;
                                    var1_1.mAnimatingAway = null;
                                    var7_9.clearAnimation();
                                }
                                if (var1_1.mAnimatingAway != null) {
                                    var1_1.mStateAfterAnimating = var2_2;
                                    var2_2 = 1;
                                    break;
                                }
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v((String)"FragmentManager", (String)("movefrom CREATED: " + var1_1));
                                }
                                if (!var1_1.mRetaining) {
                                    var1_1.performDestroy();
                                }
                                var1_1.mCalled = false;
                                var1_1.onDetach();
                                if (!var1_1.mCalled) {
                                    throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onDetach()");
                                }
                                if (var5_5) break;
                                if (!var1_1.mRetaining) {
                                    this.makeInactive(var1_1);
                                    break;
                                }
                                var1_1.mActivity = null;
                                var1_1.mFragmentManager = null;
                                break;
                            }
                        }
                    }
                    break block57;
lbl134:
                    // 1 sources

                    var15_7 = null;
lbl135:
                    // 2 sources

                    var1_1.mContainer = var15_7;
                    var1_1.mView = var1_1.performCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), var15_7, var1_1.mSavedFragmentState);
                    if (var1_1.mView != null) {
                        var1_1.mInnerView = var1_1.mView;
                        var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                        if (var15_7 != null) {
                            var16_8 = this.loadAnimation(var1_1, var3_3, true, var4_4);
                            if (var16_8 != null) {
                                var1_1.mView.startAnimation(var16_8);
                            }
                            var15_7.addView(var1_1.mView);
                        }
                        if (var1_1.mHidden) {
                            var1_1.mView.setVisibility(8);
                        }
                        var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
                    } else {
                        var1_1.mInnerView = null;
                    }
lbl150:
                    // 3 sources

                    var1_1.performActivityCreated(var1_1.mSavedFragmentState);
                    if (var1_1.mView != null) {
                        var1_1.restoreViewState(var1_1.mSavedFragmentState);
                    }
                    cfr_temp_0 = 2;
                    var1_1.mSavedFragmentState = null;
                    case 2: 
                    case 3: {
                        if (var2_2 > 3) {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("moveto STARTED: " + var1_1));
                            }
                            var1_1.performStart();
                        }
                    }
                    case 4: {
                        if (var2_2 <= 4) break block13;
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("moveto RESUMED: " + var1_1));
                        }
                        var1_1.mResumed = true;
                        var1_1.performResume();
                        var1_1.mSavedFragmentState = null;
                        var1_1.mSavedViewState = null;
                    }
                }
                break;
            }
            break block57;
            ** while (true)
        }
        var1_1.mState = var2_2;
    }

    public final void noteStateNotSaved() {
        this.mStateSaved = false;
    }

    public final void performPendingDeferredStart(Fragment fragment) {
        block3: {
            block2: {
                if (!fragment.mDeferStart) break block2;
                if (!this.mExecutingActions) break block3;
                this.mHavePendingDeferredStart = true;
            }
            return;
        }
        fragment.mDeferStart = false;
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    @Override
    public final void popBackStack() {
        this.enqueueAction(new FragmentManagerImpl$2(this), false);
    }

    @Override
    public final void popBackStack(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad id: " + n2);
        }
        this.enqueueAction(new FragmentManagerImpl$4(this, n2, n3), false);
    }

    @Override
    public final void popBackStack(String string2, int n2) {
        this.enqueueAction(new FragmentManagerImpl$3(this, string2, n2), false);
    }

    @Override
    public final boolean popBackStackImmediate() {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, null, -1, 0);
    }

    @Override
    public final boolean popBackStackImmediate(int n2, int n3) {
        this.checkStateLoss();
        this.executePendingTransactions();
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad id: " + n2);
        }
        return this.popBackStackState(this.mActivity.mHandler, null, n2, n3);
    }

    @Override
    public final boolean popBackStackImmediate(String string2, int n2) {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, string2, -1, n2);
    }

    /*
     * Unable to fully structure code
     */
    final boolean popBackStackState(Handler var1_1, String var2_2, int var3_3, int var4_4) {
        block11: {
            block10: {
                if (this.mBackStack == null) lbl-1000:
                // 4 sources

                {
                    return false;
                }
                if (var2_2 != null || var3_3 >= 0 || (var4_4 & 1) != 0) break block10;
                var17_5 = -1 + this.mBackStack.size();
                if (var17_5 < 0) ** GOTO lbl-1000
                this.mBackStack.remove(var17_5).popFromBackStack(true);
                while (true) {
                    this.reportBackStackChanged();
                    return true;
                }
            }
            var5_6 = -1;
            if (var2_2 == null && var3_3 < 0) break block11;
            for (var6_7 = -1 + this.mBackStack.size(); var6_7 >= 0; --var6_7) {
                var16_8 = this.mBackStack.get(var6_7);
                if (var2_2 != null && var2_2.equals(var16_8.getName()) || var3_3 >= 0 && var3_3 == var16_8.mIndex) break;
            }
            if (var6_7 < 0) ** GOTO lbl-1000
            if ((var4_4 & 1) != 0) {
                --var6_7;
                while (var6_7 >= 0) {
                    var15_9 = this.mBackStack.get(var6_7);
                    if ((var2_2 == null || !var2_2.equals(var15_9.getName())) && (var3_3 < 0 || var3_3 != var15_9.mIndex)) break;
                    --var6_7;
                }
            }
            var5_6 = var6_7;
        }
        if (var5_6 != -1 + this.mBackStack.size()) ** break;
        ** while (true)
        var7_10 = new ArrayList<BackStackRecord>();
        for (var8_11 = -1 + this.mBackStack.size(); var8_11 > var5_6; --var8_11) {
            var7_10.add(this.mBackStack.remove(var8_11));
        }
        var9_12 = -1 + var7_10.size();
        var10_13 = 0;
        block5: while (true) {
            if (var10_13 > var9_12) ** continue;
            if (FragmentManagerImpl.DEBUG) {
                Log.v((String)"FragmentManager", (String)("Popping back stack state: " + var7_10.get(var10_13)));
            }
            var11_14 = (BackStackRecord)var7_10.get(var10_13);
            if (var10_13 != var9_12) break;
            var12_15 = true;
lbl45:
            // 2 sources

            while (true) {
                var11_14.popFromBackStack(var12_15);
                ++var10_13;
                continue block5;
                break;
            }
            break;
        }
        var12_15 = false;
        ** while (true)
    }

    @Override
    public final void putFragment(Bundle bundle, String string2, Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putInt(string2, fragment.mIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void removeFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("remove: " + fragment + " nesting=" + fragment.mBackStackNesting));
        }
        boolean bl2 = !fragment.isInBackStack();
        if (!fragment.mDetached || bl2) {
            if (this.mAdded != null) {
                this.mAdded.remove(fragment);
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
            int n4 = bl2 ? 0 : 1;
            this.moveToState(fragment, n4, n2, n3, false);
        }
    }

    @Override
    public final void removeOnBackStackChangedListener(FragmentManager$OnBackStackChangedListener fragmentManager$OnBackStackChangedListener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(fragmentManager$OnBackStackChangedListener);
        }
    }

    final void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i2 = 0; i2 < this.mBackStackChangeListeners.size(); ++i2) {
                this.mBackStackChangeListeners.get(i2).onBackStackChanged();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void restoreAllState(Parcelable parcelable, ArrayList<Fragment> arrayList) {
        if (parcelable != null) {
            FragmentManagerState fragmentManagerState = (FragmentManagerState)parcelable;
            if (fragmentManagerState.mActive != null) {
                if (arrayList != null) {
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        Fragment fragment = arrayList.get(i2);
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("restoreAllState: re-attaching retained " + fragment));
                        }
                        FragmentState fragmentState = fragmentManagerState.mActive[fragment.mIndex];
                        fragmentState.mInstance = fragment;
                        fragment.mSavedViewState = null;
                        fragment.mBackStackNesting = 0;
                        fragment.mInLayout = false;
                        fragment.mAdded = false;
                        fragment.mTarget = null;
                        if (fragmentState.mSavedFragmentState == null) continue;
                        fragmentState.mSavedFragmentState.setClassLoader(this.mActivity.getClassLoader());
                        fragment.mSavedViewState = fragmentState.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                    }
                }
                this.mActive = new ArrayList(fragmentManagerState.mActive.length);
                if (this.mAvailIndices != null) {
                    this.mAvailIndices.clear();
                }
                for (int i3 = 0; i3 < fragmentManagerState.mActive.length; ++i3) {
                    FragmentState fragmentState = fragmentManagerState.mActive[i3];
                    if (fragmentState != null) {
                        Fragment fragment = fragmentState.instantiate(this.mActivity, this.mParent);
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("restoreAllState: active #" + i3 + ": " + fragment));
                        }
                        this.mActive.add(fragment);
                        fragmentState.mInstance = null;
                        continue;
                    }
                    this.mActive.add(null);
                    if (this.mAvailIndices == null) {
                        this.mAvailIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("restoreAllState: avail #" + i3));
                    }
                    this.mAvailIndices.add(i3);
                }
                if (arrayList != null) {
                    for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                        Fragment fragment = arrayList.get(i4);
                        if (fragment.mTargetIndex < 0) continue;
                        if (fragment.mTargetIndex < this.mActive.size()) {
                            fragment.mTarget = this.mActive.get(fragment.mTargetIndex);
                            continue;
                        }
                        Log.w((String)TAG, (String)("Re-attaching retained fragment " + fragment + " target no longer exists: " + fragment.mTargetIndex));
                        fragment.mTarget = null;
                    }
                }
                if (fragmentManagerState.mAdded == null) {
                    this.mAdded = null;
                } else {
                    this.mAdded = new ArrayList(fragmentManagerState.mAdded.length);
                    for (int i5 = 0; i5 < fragmentManagerState.mAdded.length; ++i5) {
                        Fragment fragment = this.mActive.get(fragmentManagerState.mAdded[i5]);
                        if (fragment == null) {
                            this.throwException(new IllegalStateException("No instantiated fragment for index #" + fragmentManagerState.mAdded[i5]));
                        }
                        fragment.mAdded = true;
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("restoreAllState: added #" + i5 + ": " + fragment));
                        }
                        if (this.mAdded.contains(fragment)) {
                            throw new IllegalStateException("Already added!");
                        }
                        this.mAdded.add(fragment);
                    }
                }
                if (fragmentManagerState.mBackStack == null) {
                    this.mBackStack = null;
                    return;
                }
                this.mBackStack = new ArrayList(fragmentManagerState.mBackStack.length);
                for (int i6 = 0; i6 < fragmentManagerState.mBackStack.length; ++i6) {
                    BackStackRecord backStackRecord = fragmentManagerState.mBackStack[i6].instantiate(this);
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("restoreAllState: back stack #" + i6 + " (index " + backStackRecord.mIndex + "): " + backStackRecord));
                        backStackRecord.dump("  ", new PrintWriter(new LogWriter(TAG)), false);
                    }
                    this.mBackStack.add(backStackRecord);
                    if (backStackRecord.mIndex < 0) continue;
                    this.setBackStackIndex(backStackRecord.mIndex, backStackRecord);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final ArrayList<Fragment> retainNonConfig() {
        ArrayList<Fragment> arrayList = this.mActive;
        ArrayList<Fragment> arrayList2 = null;
        if (arrayList != null) {
            for (int i2 = 0; i2 < this.mActive.size(); ++i2) {
                Fragment fragment = this.mActive.get(i2);
                if (fragment == null || !fragment.mRetainInstance) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Fragment>();
                }
                arrayList2.add(fragment);
                fragment.mRetaining = true;
                int n2 = fragment.mTarget != null ? fragment.mTarget.mIndex : -1;
                fragment.mTargetIndex = n2;
                if (!DEBUG) continue;
                Log.v((String)TAG, (String)("retainNonConfig: keeping retained " + fragment));
            }
        }
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Parcelable saveAllState() {
        block16: {
            this.execPendingActions();
            if (HONEYCOMB) {
                this.mStateSaved = true;
            }
            if (this.mActive == null || this.mActive.size() <= 0) break block16;
            int n2 = this.mActive.size();
            FragmentState[] fragmentStateArray = new FragmentState[n2];
            int n3 = 0;
            boolean bl2 = false;
            while (true) {
                boolean bl3;
                block21: {
                    block18: {
                        int[] nArray;
                        int n4;
                        block17: {
                            FragmentState fragmentState;
                            Fragment fragment;
                            block20: {
                                block19: {
                                    if (n3 >= n2) break block17;
                                    fragment = this.mActive.get(n3);
                                    if (fragment == null) break block18;
                                    if (fragment.mIndex < 0) {
                                        this.throwException(new IllegalStateException("Failure saving state: active " + fragment + " has cleared index: " + fragment.mIndex));
                                    }
                                    fragmentStateArray[n3] = fragmentState = new FragmentState(fragment);
                                    if (fragment.mState <= 0 || fragmentState.mSavedFragmentState != null) break block19;
                                    fragmentState.mSavedFragmentState = this.saveFragmentBasicState(fragment);
                                    if (fragment.mTarget != null) {
                                        if (fragment.mTarget.mIndex < 0) {
                                            this.throwException(new IllegalStateException("Failure saving state: " + fragment + " has target not in fragment manager: " + fragment.mTarget));
                                        }
                                        if (fragmentState.mSavedFragmentState == null) {
                                            fragmentState.mSavedFragmentState = new Bundle();
                                        }
                                        this.putFragment(fragmentState.mSavedFragmentState, TARGET_STATE_TAG, fragment.mTarget);
                                        if (fragment.mTargetRequestCode != 0) {
                                            fragmentState.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, fragment.mTargetRequestCode);
                                        }
                                    }
                                    break block20;
                                }
                                fragmentState.mSavedFragmentState = fragment.mSavedFragmentState;
                            }
                            if (DEBUG) {
                                Log.v((String)TAG, (String)("Saved state of " + fragment + ": " + fragmentState.mSavedFragmentState));
                            }
                            bl3 = true;
                            break block21;
                        }
                        if (!bl2) {
                            if (!DEBUG) break;
                            Log.v((String)TAG, (String)"saveAllState: no fragments!");
                            return null;
                        }
                        if (this.mAdded != null && (n4 = this.mAdded.size()) > 0) {
                            nArray = new int[n4];
                            for (int i2 = 0; i2 < n4; ++i2) {
                                nArray[i2] = this.mAdded.get((int)i2).mIndex;
                                if (nArray[i2] < 0) {
                                    this.throwException(new IllegalStateException("Failure saving state: active " + this.mAdded.get(i2) + " has cleared index: " + nArray[i2]));
                                }
                                if (!DEBUG) continue;
                                Log.v((String)TAG, (String)("saveAllState: adding fragment #" + i2 + ": " + this.mAdded.get(i2)));
                            }
                        } else {
                            nArray = null;
                        }
                        ArrayList<BackStackRecord> arrayList = this.mBackStack;
                        BackStackState[] backStackStateArray = null;
                        if (arrayList != null) {
                            int n5 = this.mBackStack.size();
                            backStackStateArray = null;
                            if (n5 > 0) {
                                backStackStateArray = new BackStackState[n5];
                                for (int i3 = 0; i3 < n5; ++i3) {
                                    backStackStateArray[i3] = new BackStackState(this, this.mBackStack.get(i3));
                                    if (!DEBUG) continue;
                                    Log.v((String)TAG, (String)("saveAllState: adding back stack #" + i3 + ": " + this.mBackStack.get(i3)));
                                }
                            }
                        }
                        FragmentManagerState fragmentManagerState = new FragmentManagerState();
                        fragmentManagerState.mActive = fragmentStateArray;
                        fragmentManagerState.mAdded = nArray;
                        fragmentManagerState.mBackStack = backStackStateArray;
                        return fragmentManagerState;
                    }
                    bl3 = bl2;
                }
                ++n3;
                bl2 = bl3;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Bundle saveFragmentBasicState(Fragment fragment) {
        Bundle bundle;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        fragment.performSaveInstanceState(this.mStateBundle);
        if (!this.mStateBundle.isEmpty()) {
            bundle = this.mStateBundle;
            this.mStateBundle = null;
        } else {
            bundle = null;
        }
        if (fragment.mView != null) {
            this.saveFragmentViewState(fragment);
        }
        if (fragment.mSavedViewState != null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putSparseParcelableArray(VIEW_STATE_TAG, fragment.mSavedViewState);
        }
        if (!fragment.mUserVisibleHint) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putBoolean(USER_VISIBLE_HINT_TAG, fragment.mUserVisibleHint);
        }
        return bundle;
    }

    @Override
    public final Fragment$SavedState saveFragmentInstanceState(Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        int n2 = fragment.mState;
        Fragment$SavedState fragment$SavedState = null;
        if (n2 > 0) {
            Bundle bundle = this.saveFragmentBasicState(fragment);
            fragment$SavedState = null;
            if (bundle != null) {
                fragment$SavedState = new Fragment$SavedState(bundle);
            }
        }
        return fragment$SavedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void saveFragmentViewState(Fragment fragment) {
        block6: {
            block5: {
                if (fragment.mInnerView == null) break block5;
                if (this.mStateArray == null) {
                    this.mStateArray = new SparseArray();
                } else {
                    this.mStateArray.clear();
                }
                fragment.mInnerView.saveHierarchyState(this.mStateArray);
                if (this.mStateArray.size() > 0) break block6;
            }
            return;
        }
        fragment.mSavedViewState = this.mStateArray;
        this.mStateArray = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setBackStackIndex(int n2, BackStackRecord backStackRecord) {
        synchronized (this) {
            int n3;
            block14: {
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                if (n2 >= (n3 = this.mBackStackIndices.size())) break block14;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + n2 + " to " + backStackRecord));
                }
                this.mBackStackIndices.set(n2, backStackRecord);
                return;
            }
            while (n3 < n2) {
                this.mBackStackIndices.add(null);
                if (this.mAvailBackStackIndices == null) {
                    this.mAvailBackStackIndices = new ArrayList();
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adding available back stack index " + n3));
                }
                this.mAvailBackStackIndices.add(n3);
                ++n3;
            }
            try {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adding back stack index " + n2 + " with " + backStackRecord));
                }
                this.mBackStackIndices.add(backStackRecord);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    public final void showFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("show: " + fragment));
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n2, true, n3);
                if (animation != null) {
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(0);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void startPendingDeferredFragments() {
        if (this.mActive != null) {
            for (int i2 = 0; i2 < this.mActive.size(); ++i2) {
                Fragment fragment = this.mActive.get(i2);
                if (fragment == null) continue;
                this.performPendingDeferredStart(fragment);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        if (this.mParent != null) {
            DebugUtils.buildShortClassTag(this.mParent, stringBuilder);
        } else {
            DebugUtils.buildShortClassTag((Object)this.mActivity, stringBuilder);
        }
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }
}

