/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.support.v4.app.BackStackRecord$Op;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager$BackStackEntry;
import android.support.v4.app.FragmentManagerImpl;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.util.LogWriter;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

final class BackStackRecord
extends FragmentTransaction
implements FragmentManager$BackStackEntry,
Runnable {
    static final int OP_ADD = 1;
    static final int OP_ATTACH = 7;
    static final int OP_DETACH = 6;
    static final int OP_HIDE = 4;
    static final int OP_NULL = 0;
    static final int OP_REMOVE = 3;
    static final int OP_REPLACE = 2;
    static final int OP_SHOW = 5;
    static final String TAG = "FragmentManager";
    boolean mAddToBackStack;
    boolean mAllowAddToBackStack = true;
    int mBreadCrumbShortTitleRes;
    CharSequence mBreadCrumbShortTitleText;
    int mBreadCrumbTitleRes;
    CharSequence mBreadCrumbTitleText;
    boolean mCommitted;
    int mEnterAnim;
    int mExitAnim;
    BackStackRecord$Op mHead;
    int mIndex = -1;
    final FragmentManagerImpl mManager;
    String mName;
    int mNumOp;
    int mPopEnterAnim;
    int mPopExitAnim;
    BackStackRecord$Op mTail;
    int mTransition;
    int mTransitionStyle;

    public BackStackRecord(FragmentManagerImpl fragmentManagerImpl) {
        this.mManager = fragmentManagerImpl;
    }

    private void doAddOp(int n2, Fragment fragment, String string2, int n3) {
        fragment.mFragmentManager = this.mManager;
        if (string2 != null) {
            if (fragment.mTag != null && !string2.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + string2);
            }
            fragment.mTag = string2;
        }
        if (n2 != 0) {
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != n2) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + n2);
            }
            fragment.mFragmentId = n2;
            fragment.mContainerId = n2;
        }
        BackStackRecord$Op backStackRecord$Op = new BackStackRecord$Op();
        backStackRecord$Op.cmd = n3;
        backStackRecord$Op.fragment = fragment;
        this.addOp(backStackRecord$Op);
    }

    @Override
    public final FragmentTransaction add(int n2, Fragment fragment) {
        this.doAddOp(n2, fragment, null, 1);
        return this;
    }

    @Override
    public final FragmentTransaction add(int n2, Fragment fragment, String string2) {
        this.doAddOp(n2, fragment, string2, 1);
        return this;
    }

    @Override
    public final FragmentTransaction add(Fragment fragment, String string2) {
        this.doAddOp(0, fragment, string2, 1);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void addOp(BackStackRecord$Op backStackRecord$Op) {
        if (this.mHead == null) {
            this.mTail = backStackRecord$Op;
            this.mHead = backStackRecord$Op;
        } else {
            backStackRecord$Op.prev = this.mTail;
            this.mTail.next = backStackRecord$Op;
            this.mTail = backStackRecord$Op;
        }
        backStackRecord$Op.enterAnim = this.mEnterAnim;
        backStackRecord$Op.exitAnim = this.mExitAnim;
        backStackRecord$Op.popEnterAnim = this.mPopEnterAnim;
        backStackRecord$Op.popExitAnim = this.mPopExitAnim;
        this.mNumOp = 1 + this.mNumOp;
    }

    @Override
    public final FragmentTransaction addToBackStack(String string2) {
        if (!this.mAllowAddToBackStack) {
            throw new IllegalStateException("This FragmentTransaction is not allowed to be added to the back stack.");
        }
        this.mAddToBackStack = true;
        this.mName = string2;
        return this;
    }

    @Override
    public final FragmentTransaction attach(Fragment fragment) {
        BackStackRecord$Op backStackRecord$Op = new BackStackRecord$Op();
        backStackRecord$Op.cmd = 7;
        backStackRecord$Op.fragment = fragment;
        this.addOp(backStackRecord$Op);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void bumpBackStackNesting(int n2) {
        if (this.mAddToBackStack) {
            if (FragmentManagerImpl.DEBUG) {
                Log.v((String)TAG, (String)("Bump nesting in " + this + " by " + n2));
            }
            BackStackRecord$Op backStackRecord$Op = this.mHead;
            while (backStackRecord$Op != null) {
                if (backStackRecord$Op.fragment != null) {
                    Fragment fragment = backStackRecord$Op.fragment;
                    fragment.mBackStackNesting = n2 + fragment.mBackStackNesting;
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)TAG, (String)("Bump nesting of " + backStackRecord$Op.fragment + " to " + backStackRecord$Op.fragment.mBackStackNesting));
                    }
                }
                if (backStackRecord$Op.removed != null) {
                    for (int i2 = -1 + backStackRecord$Op.removed.size(); i2 >= 0; --i2) {
                        Fragment fragment = backStackRecord$Op.removed.get(i2);
                        fragment.mBackStackNesting = n2 + fragment.mBackStackNesting;
                        if (!FragmentManagerImpl.DEBUG) continue;
                        Log.v((String)TAG, (String)("Bump nesting of " + fragment + " to " + fragment.mBackStackNesting));
                    }
                }
                backStackRecord$Op = backStackRecord$Op.next;
            }
        }
    }

    @Override
    public final int commit() {
        return this.commitInternal(false);
    }

    @Override
    public final int commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    final int commitInternal(boolean bl2) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("Commit: " + this));
            this.dump("  ", null, new PrintWriter(new LogWriter(TAG)), null);
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex(this) : -1;
        this.mManager.enqueueAction(this, bl2);
        return this.mIndex;
    }

    @Override
    public final FragmentTransaction detach(Fragment fragment) {
        BackStackRecord$Op backStackRecord$Op = new BackStackRecord$Op();
        backStackRecord$Op.cmd = 6;
        backStackRecord$Op.fragment = fragment;
        this.addOp(backStackRecord$Op);
        return this;
    }

    @Override
    public final FragmentTransaction disallowAddToBackStack() {
        if (this.mAddToBackStack) {
            throw new IllegalStateException("This transaction is already being added to the back stack");
        }
        this.mAllowAddToBackStack = false;
        return this;
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        this.dump(string2, printWriter, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void dump(String string2, PrintWriter printWriter, boolean bl2) {
        if (bl2) {
            printWriter.print(string2);
            printWriter.print("mName=");
            printWriter.print(this.mName);
            printWriter.print(" mIndex=");
            printWriter.print(this.mIndex);
            printWriter.print(" mCommitted=");
            printWriter.println(this.mCommitted);
            if (this.mTransition != 0) {
                printWriter.print(string2);
                printWriter.print("mTransition=#");
                printWriter.print(Integer.toHexString(this.mTransition));
                printWriter.print(" mTransitionStyle=#");
                printWriter.println(Integer.toHexString(this.mTransitionStyle));
            }
            if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
                printWriter.print(string2);
                printWriter.print("mEnterAnim=#");
                printWriter.print(Integer.toHexString(this.mEnterAnim));
                printWriter.print(" mExitAnim=#");
                printWriter.println(Integer.toHexString(this.mExitAnim));
            }
            if (this.mPopEnterAnim != 0 || this.mPopExitAnim != 0) {
                printWriter.print(string2);
                printWriter.print("mPopEnterAnim=#");
                printWriter.print(Integer.toHexString(this.mPopEnterAnim));
                printWriter.print(" mPopExitAnim=#");
                printWriter.println(Integer.toHexString(this.mPopExitAnim));
            }
            if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
                printWriter.print(string2);
                printWriter.print("mBreadCrumbTitleRes=#");
                printWriter.print(Integer.toHexString(this.mBreadCrumbTitleRes));
                printWriter.print(" mBreadCrumbTitleText=");
                printWriter.println(this.mBreadCrumbTitleText);
            }
            if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
                printWriter.print(string2);
                printWriter.print("mBreadCrumbShortTitleRes=#");
                printWriter.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
                printWriter.print(" mBreadCrumbShortTitleText=");
                printWriter.println(this.mBreadCrumbShortTitleText);
            }
        }
        if (this.mHead != null) {
            printWriter.print(string2);
            printWriter.println("Operations:");
            String string3 = string2 + "    ";
            BackStackRecord$Op backStackRecord$Op = this.mHead;
            int n2 = 0;
            BackStackRecord$Op backStackRecord$Op2 = backStackRecord$Op;
            while (backStackRecord$Op2 != null) {
                String string4;
                switch (backStackRecord$Op2.cmd) {
                    default: {
                        string4 = "cmd=" + backStackRecord$Op2.cmd;
                        break;
                    }
                    case 0: {
                        string4 = "NULL";
                        break;
                    }
                    case 1: {
                        string4 = "ADD";
                        break;
                    }
                    case 2: {
                        string4 = "REPLACE";
                        break;
                    }
                    case 3: {
                        string4 = "REMOVE";
                        break;
                    }
                    case 4: {
                        string4 = "HIDE";
                        break;
                    }
                    case 5: {
                        string4 = "SHOW";
                        break;
                    }
                    case 6: {
                        string4 = "DETACH";
                        break;
                    }
                    case 7: {
                        string4 = "ATTACH";
                    }
                }
                printWriter.print(string2);
                printWriter.print("  Op #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.print(string4);
                printWriter.print(" ");
                printWriter.println(backStackRecord$Op2.fragment);
                if (bl2) {
                    if (backStackRecord$Op2.enterAnim != 0 || backStackRecord$Op2.exitAnim != 0) {
                        printWriter.print(string2);
                        printWriter.print("enterAnim=#");
                        printWriter.print(Integer.toHexString(backStackRecord$Op2.enterAnim));
                        printWriter.print(" exitAnim=#");
                        printWriter.println(Integer.toHexString(backStackRecord$Op2.exitAnim));
                    }
                    if (backStackRecord$Op2.popEnterAnim != 0 || backStackRecord$Op2.popExitAnim != 0) {
                        printWriter.print(string2);
                        printWriter.print("popEnterAnim=#");
                        printWriter.print(Integer.toHexString(backStackRecord$Op2.popEnterAnim));
                        printWriter.print(" popExitAnim=#");
                        printWriter.println(Integer.toHexString(backStackRecord$Op2.popExitAnim));
                    }
                }
                if (backStackRecord$Op2.removed != null && backStackRecord$Op2.removed.size() > 0) {
                    for (int i2 = 0; i2 < backStackRecord$Op2.removed.size(); ++i2) {
                        printWriter.print(string3);
                        if (backStackRecord$Op2.removed.size() == 1) {
                            printWriter.print("Removed: ");
                        } else {
                            if (i2 == 0) {
                                printWriter.println("Removed:");
                            }
                            printWriter.print(string3);
                            printWriter.print("  #");
                            printWriter.print(i2);
                            printWriter.print(": ");
                        }
                        printWriter.println(backStackRecord$Op2.removed.get(i2));
                    }
                }
                backStackRecord$Op2 = backStackRecord$Op2.next;
                ++n2;
            }
        }
    }

    @Override
    public final CharSequence getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes != 0) {
            return this.mManager.mActivity.getText(this.mBreadCrumbShortTitleRes);
        }
        return this.mBreadCrumbShortTitleText;
    }

    @Override
    public final int getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    @Override
    public final CharSequence getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes != 0) {
            return this.mManager.mActivity.getText(this.mBreadCrumbTitleRes);
        }
        return this.mBreadCrumbTitleText;
    }

    @Override
    public final int getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    @Override
    public final int getId() {
        return this.mIndex;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    public final int getTransition() {
        return this.mTransition;
    }

    public final int getTransitionStyle() {
        return this.mTransitionStyle;
    }

    @Override
    public final FragmentTransaction hide(Fragment fragment) {
        BackStackRecord$Op backStackRecord$Op = new BackStackRecord$Op();
        backStackRecord$Op.cmd = 4;
        backStackRecord$Op.fragment = fragment;
        this.addOp(backStackRecord$Op);
        return this;
    }

    @Override
    public final boolean isAddToBackStackAllowed() {
        return this.mAllowAddToBackStack;
    }

    @Override
    public final boolean isEmpty() {
        return this.mNumOp == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void popFromBackStack(boolean bl2) {
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("popFromBackStack: " + this));
            this.dump("  ", null, new PrintWriter(new LogWriter(TAG)), null);
        }
        this.bumpBackStackNesting(-1);
        BackStackRecord$Op backStackRecord$Op = this.mTail;
        while (backStackRecord$Op != null) {
            switch (backStackRecord$Op.cmd) {
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + backStackRecord$Op.cmd);
                }
                case 1: {
                    Fragment fragment = backStackRecord$Op.fragment;
                    fragment.mNextAnim = backStackRecord$Op.popExitAnim;
                    this.mManager.removeFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 2: {
                    Fragment fragment = backStackRecord$Op.fragment;
                    if (fragment != null) {
                        fragment.mNextAnim = backStackRecord$Op.popExitAnim;
                        this.mManager.removeFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    }
                    if (backStackRecord$Op.removed == null) break;
                    for (int i2 = 0; i2 < backStackRecord$Op.removed.size(); ++i2) {
                        Fragment fragment2 = backStackRecord$Op.removed.get(i2);
                        fragment2.mNextAnim = backStackRecord$Op.popEnterAnim;
                        this.mManager.addFragment(fragment2, false);
                    }
                    break;
                }
                case 3: {
                    Fragment fragment = backStackRecord$Op.fragment;
                    fragment.mNextAnim = backStackRecord$Op.popEnterAnim;
                    this.mManager.addFragment(fragment, false);
                    break;
                }
                case 4: {
                    Fragment fragment = backStackRecord$Op.fragment;
                    fragment.mNextAnim = backStackRecord$Op.popEnterAnim;
                    this.mManager.showFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment fragment = backStackRecord$Op.fragment;
                    fragment.mNextAnim = backStackRecord$Op.popExitAnim;
                    this.mManager.hideFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment fragment = backStackRecord$Op.fragment;
                    fragment.mNextAnim = backStackRecord$Op.popEnterAnim;
                    this.mManager.attachFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment fragment = backStackRecord$Op.fragment;
                    fragment.mNextAnim = backStackRecord$Op.popEnterAnim;
                    this.mManager.detachFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                }
            }
            backStackRecord$Op = backStackRecord$Op.prev;
        }
        if (bl2) {
            this.mManager.moveToState(this.mManager.mCurState, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle, true);
        }
        if (this.mIndex >= 0) {
            this.mManager.freeBackStackIndex(this.mIndex);
            this.mIndex = -1;
        }
    }

    @Override
    public final FragmentTransaction remove(Fragment fragment) {
        BackStackRecord$Op backStackRecord$Op = new BackStackRecord$Op();
        backStackRecord$Op.cmd = 3;
        backStackRecord$Op.fragment = fragment;
        this.addOp(backStackRecord$Op);
        return this;
    }

    @Override
    public final FragmentTransaction replace(int n2, Fragment fragment) {
        return this.replace(n2, fragment, null);
    }

    @Override
    public final FragmentTransaction replace(int n2, Fragment fragment, String string2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(n2, fragment, string2, 2);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)"FragmentManager", (String)("Run: " + this));
        }
        if (this.mAddToBackStack && this.mIndex < 0) {
            throw new IllegalStateException("addToBackStack() called after commit()");
        }
        this.bumpBackStackNesting(1);
        var1_1 = this.mHead;
        block9: while (var1_1 != null) {
            switch (var1_1.cmd) {
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + var1_1.cmd);
                }
                case 1: {
                    var14_11 = var1_1.fragment;
                    var14_11.mNextAnim = var1_1.enterAnim;
                    this.mManager.addFragment(var14_11, false);
lbl16:
                    // 8 sources

                    while (true) {
                        var1_1 = var1_1.next;
                        continue block9;
                        break;
                    }
                }
                case 2: {
                    var7_7 = var1_1.fragment;
                    if (this.mManager.mAdded == null) ** GOTO lbl47
                    var8_8 = var7_7;
                    block11: for (var9_9 = 0; var9_9 < this.mManager.mAdded.size(); ++var9_9) {
                        var10_10 = this.mManager.mAdded.get(var9_9);
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("OP_REPLACE: adding=" + var8_8 + " old=" + var10_10));
                        }
                        if (var8_8 != null && var10_10.mContainerId != var8_8.mContainerId) ** GOTO lbl32
                        if (var10_10 != var8_8) ** GOTO lbl34
                        var8_8 = null;
                        var1_1.fragment = null;
lbl32:
                        // 3 sources

                        continue block11;
lbl34:
                        // 1 sources

                        if (var1_1.removed == null) {
                            var1_1.removed = new ArrayList<E>();
                        }
                        var1_1.removed.add(var10_10);
                        var10_10.mNextAnim = var1_1.exitAnim;
                        if (this.mAddToBackStack) {
                            var10_10.mBackStackNesting = 1 + var10_10.mBackStackNesting;
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("Bump nesting of " + var10_10 + " to " + var10_10.mBackStackNesting));
                            }
                        }
                        this.mManager.removeFragment(var10_10, this.mTransition, this.mTransitionStyle);
                        ** continue;
                    }
                    ** GOTO lbl48
lbl47:
                    // 1 sources

                    var8_8 = var7_7;
lbl48:
                    // 2 sources

                    if (var8_8 == null) ** GOTO lbl16
                    var8_8.mNextAnim = var1_1.enterAnim;
                    this.mManager.addFragment(var8_8, false);
                    ** GOTO lbl16
                }
                case 3: {
                    var6_6 = var1_1.fragment;
                    var6_6.mNextAnim = var1_1.exitAnim;
                    this.mManager.removeFragment(var6_6, this.mTransition, this.mTransitionStyle);
                    ** GOTO lbl16
                }
                case 4: {
                    var5_5 = var1_1.fragment;
                    var5_5.mNextAnim = var1_1.exitAnim;
                    this.mManager.hideFragment(var5_5, this.mTransition, this.mTransitionStyle);
                    ** GOTO lbl16
                }
                case 5: {
                    var4_4 = var1_1.fragment;
                    var4_4.mNextAnim = var1_1.enterAnim;
                    this.mManager.showFragment(var4_4, this.mTransition, this.mTransitionStyle);
                    ** GOTO lbl16
                }
                case 6: {
                    var3_3 = var1_1.fragment;
                    var3_3.mNextAnim = var1_1.exitAnim;
                    this.mManager.detachFragment(var3_3, this.mTransition, this.mTransitionStyle);
                    ** GOTO lbl16
                }
                case 7: 
            }
            var2_2 = var1_1.fragment;
            var2_2.mNextAnim = var1_1.enterAnim;
            this.mManager.attachFragment(var2_2, this.mTransition, this.mTransitionStyle);
            ** continue;
        }
        this.mManager.moveToState(this.mManager.mCurState, this.mTransition, this.mTransitionStyle, true);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
    }

    @Override
    public final FragmentTransaction setBreadCrumbShortTitle(int n2) {
        this.mBreadCrumbShortTitleRes = n2;
        this.mBreadCrumbShortTitleText = null;
        return this;
    }

    @Override
    public final FragmentTransaction setBreadCrumbShortTitle(CharSequence charSequence) {
        this.mBreadCrumbShortTitleRes = 0;
        this.mBreadCrumbShortTitleText = charSequence;
        return this;
    }

    @Override
    public final FragmentTransaction setBreadCrumbTitle(int n2) {
        this.mBreadCrumbTitleRes = n2;
        this.mBreadCrumbTitleText = null;
        return this;
    }

    @Override
    public final FragmentTransaction setBreadCrumbTitle(CharSequence charSequence) {
        this.mBreadCrumbTitleRes = 0;
        this.mBreadCrumbTitleText = charSequence;
        return this;
    }

    @Override
    public final FragmentTransaction setCustomAnimations(int n2, int n3) {
        return this.setCustomAnimations(n2, n3, 0, 0);
    }

    @Override
    public final FragmentTransaction setCustomAnimations(int n2, int n3, int n4, int n5) {
        this.mEnterAnim = n2;
        this.mExitAnim = n3;
        this.mPopEnterAnim = n4;
        this.mPopExitAnim = n5;
        return this;
    }

    @Override
    public final FragmentTransaction setTransition(int n2) {
        this.mTransition = n2;
        return this;
    }

    @Override
    public final FragmentTransaction setTransitionStyle(int n2) {
        this.mTransitionStyle = n2;
        return this;
    }

    @Override
    public final FragmentTransaction show(Fragment fragment) {
        BackStackRecord$Op backStackRecord$Op = new BackStackRecord$Op();
        backStackRecord$Op.cmd = 5;
        backStackRecord$Op.fragment = fragment;
        this.addOp(backStackRecord$Op);
        return this;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("BackStackEntry{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.mIndex >= 0) {
            stringBuilder.append(" #");
            stringBuilder.append(this.mIndex);
        }
        if (this.mName != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.mName);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

