/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.ActionBarDrawerToggle$ActionBarDrawerToggleImpl;
import android.support.v4.app.ActionBarDrawerToggle$ActionBarDrawerToggleImplBase;
import android.support.v4.app.ActionBarDrawerToggle$ActionBarDrawerToggleImplHC;
import android.support.v4.app.ActionBarDrawerToggle$Delegate;
import android.support.v4.app.ActionBarDrawerToggle$DelegateProvider;
import android.support.v4.app.ActionBarDrawerToggle$SlideDrawable;
import android.support.v4.widget.DrawerLayout;
import android.support.v4.widget.DrawerLayout$DrawerListener;
import android.view.MenuItem;
import android.view.View;

public class ActionBarDrawerToggle
implements DrawerLayout$DrawerListener {
    private static final int ID_HOME = 16908332;
    private static final ActionBarDrawerToggle$ActionBarDrawerToggleImpl IMPL = Build.VERSION.SDK_INT >= 11 ? new ActionBarDrawerToggle$ActionBarDrawerToggleImplHC(null) : new ActionBarDrawerToggle$ActionBarDrawerToggleImplBase(null);
    private final Activity mActivity;
    private final ActionBarDrawerToggle$Delegate mActivityImpl;
    private final int mCloseDrawerContentDescRes;
    private Drawable mDrawerImage;
    private final int mDrawerImageResource;
    private boolean mDrawerIndicatorEnabled = true;
    private final DrawerLayout mDrawerLayout;
    private final int mOpenDrawerContentDescRes;
    private Object mSetIndicatorInfo;
    private ActionBarDrawerToggle$SlideDrawable mSlider;
    private Drawable mThemeImage;

    public ActionBarDrawerToggle(Activity activity, DrawerLayout drawerLayout, int n2, int n3, int n4) {
        this.mActivity = activity;
        this.mDrawerLayout = drawerLayout;
        this.mDrawerImageResource = n2;
        this.mOpenDrawerContentDescRes = n3;
        this.mCloseDrawerContentDescRes = n4;
        this.mThemeImage = this.getThemeUpIndicator();
        this.mDrawerImage = activity.getResources().getDrawable(n2);
        this.mSlider = new ActionBarDrawerToggle$SlideDrawable(this.mDrawerImage);
        this.mSlider.setOffsetBy(0.33333334f);
        if (activity instanceof ActionBarDrawerToggle$DelegateProvider) {
            this.mActivityImpl = ((ActionBarDrawerToggle$DelegateProvider)activity).getDrawerToggleDelegate();
            return;
        }
        this.mActivityImpl = null;
    }

    Drawable getThemeUpIndicator() {
        if (this.mActivityImpl != null) {
            return this.mActivityImpl.getThemeUpIndicator();
        }
        return IMPL.getThemeUpIndicator(this.mActivity);
    }

    public boolean isDrawerIndicatorEnabled() {
        return this.mDrawerIndicatorEnabled;
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.mThemeImage = this.getThemeUpIndicator();
        this.mDrawerImage = this.mActivity.getResources().getDrawable(this.mDrawerImageResource);
        this.syncState();
    }

    @Override
    public void onDrawerClosed(View view) {
        this.mSlider.setOffset(0.0f);
        if (this.mDrawerIndicatorEnabled) {
            this.setActionBarDescription(this.mCloseDrawerContentDescRes);
        }
    }

    @Override
    public void onDrawerOpened(View view) {
        this.mSlider.setOffset(1.0f);
        if (this.mDrawerIndicatorEnabled) {
            this.setActionBarDescription(this.mOpenDrawerContentDescRes);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onDrawerSlide(View view, float f2) {
        float f3 = this.mSlider.getOffset();
        float f4 = f2 > 0.5f ? Math.max(f3, 2.0f * Math.max(0.0f, f2 - 0.5f)) : Math.min(f3, f2 * 2.0f);
        this.mSlider.setOffset(f4);
    }

    @Override
    public void onDrawerStateChanged(int n2) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem == null || menuItem.getItemId() != 16908332 || !this.mDrawerIndicatorEnabled) return false;
        if (this.mDrawerLayout.isDrawerVisible(0x800003)) {
            this.mDrawerLayout.closeDrawer(0x800003);
            return true;
        }
        this.mDrawerLayout.openDrawer(0x800003);
        return true;
    }

    void setActionBarDescription(int n2) {
        if (this.mActivityImpl != null) {
            this.mActivityImpl.setActionBarDescription(n2);
            return;
        }
        this.mSetIndicatorInfo = IMPL.setActionBarDescription(this.mSetIndicatorInfo, this.mActivity, n2);
    }

    void setActionBarUpIndicator(Drawable drawable2, int n2) {
        if (this.mActivityImpl != null) {
            this.mActivityImpl.setActionBarUpIndicator(drawable2, n2);
            return;
        }
        this.mSetIndicatorInfo = IMPL.setActionBarUpIndicator(this.mSetIndicatorInfo, this.mActivity, drawable2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDrawerIndicatorEnabled(boolean bl2) {
        if (bl2 != this.mDrawerIndicatorEnabled) {
            if (bl2) {
                ActionBarDrawerToggle$SlideDrawable actionBarDrawerToggle$SlideDrawable = this.mSlider;
                int n2 = this.mDrawerLayout.isDrawerOpen(0x800003) ? this.mOpenDrawerContentDescRes : this.mCloseDrawerContentDescRes;
                this.setActionBarUpIndicator(actionBarDrawerToggle$SlideDrawable, n2);
            } else {
                this.setActionBarUpIndicator(this.mThemeImage, 0);
            }
            this.mDrawerIndicatorEnabled = bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void syncState() {
        if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
            this.mSlider.setOffset(1.0f);
        } else {
            this.mSlider.setOffset(0.0f);
        }
        if (this.mDrawerIndicatorEnabled) {
            ActionBarDrawerToggle$SlideDrawable actionBarDrawerToggle$SlideDrawable = this.mSlider;
            int n2 = this.mDrawerLayout.isDrawerOpen(0x800003) ? this.mOpenDrawerContentDescRes : this.mCloseDrawerContentDescRes;
            this.setActionBarUpIndicator(actionBarDrawerToggle$SlideDrawable, n2);
        }
    }
}

