/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.library.viewdelegates;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;
import android.widget.AbsListView;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.ViewDelegate;

public class AbsListViewDelegate
implements ViewDelegate {
    public static final Class[] SUPPORTED_VIEW_CLASSES = new Class[]{AbsListView.class};

    int getVerticalScrollbarPosition(AbsListView absListView) {
        if (Build.VERSION.SDK_INT >= 11) {
            return CompatV11.getVerticalScrollbarPosition(absListView);
        }
        return Compat.getVerticalScrollbarPosition(absListView);
    }

    boolean isFastScrollAlwaysVisible(AbsListView absListView) {
        if (Build.VERSION.SDK_INT >= 11) {
            return CompatV11.isFastScrollAlwaysVisible(absListView);
        }
        return Compat.isFastScrollAlwaysVisible(absListView);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isReadyForPull(View view, float f2, float f3) {
        boolean bl2;
        AbsListView absListView = (AbsListView)view;
        if (absListView.getCount() == 0) {
            bl2 = true;
        } else {
            int n2 = absListView.getFirstVisiblePosition();
            bl2 = false;
            if (n2 == 0) {
                View view2 = absListView.getChildAt(0);
                if (view2 == null) return false;
                if (view2.getTop() < 0) return false;
                bl2 = true;
            }
        }
        if (!bl2) return bl2;
        if (!absListView.isFastScrollEnabled()) return bl2;
        if (!this.isFastScrollAlwaysVisible(absListView)) return bl2;
        switch (this.getVerticalScrollbarPosition(absListView)) {
            default: {
                return bl2;
            }
            case 2: {
                if (!(f2 < (float)(absListView.getRight() - absListView.getVerticalScrollbarWidth()))) return false;
                return true;
            }
            case 1: 
        }
        if (!(f2 > (float)absListView.getVerticalScrollbarWidth())) return false;
        return true;
    }

    static class Compat {
        Compat() {
        }

        static int getVerticalScrollbarPosition(AbsListView absListView) {
            return 2;
        }

        static boolean isFastScrollAlwaysVisible(AbsListView absListView) {
            return false;
        }
    }

    @TargetApi(value=11)
    static class CompatV11 {
        CompatV11() {
        }

        static int getVerticalScrollbarPosition(AbsListView absListView) {
            return absListView.getVerticalScrollbarPosition();
        }

        static boolean isFastScrollAlwaysVisible(AbsListView absListView) {
            return absListView.isFastScrollAlwaysVisible();
        }
    }
}

