/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.library;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import uk.co.senab.actionbarpulltorefresh.library.HeaderTransformer;
import uk.co.senab.actionbarpulltorefresh.library.InstanceCreationUtils;
import uk.co.senab.actionbarpulltorefresh.library.Options;
import uk.co.senab.actionbarpulltorefresh.library.PullToRefreshAttacher;
import uk.co.senab.actionbarpulltorefresh.library.R;
import uk.co.senab.actionbarpulltorefresh.library.listeners.HeaderViewListener;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.ViewDelegate;

public class PullToRefreshLayout
extends FrameLayout {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "PullToRefreshLayout";
    private PullToRefreshAttacher mPullToRefreshAttacher;

    public PullToRefreshLayout(Context context) {
        this(context, null);
    }

    public PullToRefreshLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PullToRefreshLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    private void ensureAttacher() {
        if (this.mPullToRefreshAttacher == null) {
            throw new IllegalStateException("You need to setup the PullToRefreshLayout before using it");
        }
    }

    void addAllChildrenAsPullable() {
        this.ensureAttacher();
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addRefreshableView(this.getChildAt(i2));
        }
    }

    void addChildrenAsPullable(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.findViewById(nArray[i2]) == null) continue;
            this.addRefreshableView(this.findViewById(nArray[i2]));
        }
    }

    void addChildrenAsPullable(View[] viewArray) {
        int n2 = viewArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (viewArray[i2] == null) continue;
            this.addRefreshableView(viewArray[i2]);
        }
    }

    void addRefreshableView(View view) {
        if (this.mPullToRefreshAttacher != null) {
            this.mPullToRefreshAttacher.addRefreshableView(view, this.getViewDelegateFromLayoutParams(view));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PullToRefreshAttacher createPullToRefreshAttacher(Activity activity, Options options) {
        if (options != null) {
            return new PullToRefreshAttacher(activity, options);
        }
        options = new Options();
        return new PullToRefreshAttacher(activity, options);
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public HeaderTransformer getHeaderTransformer() {
        this.ensureAttacher();
        return this.mPullToRefreshAttacher.getHeaderTransformer();
    }

    public final View getHeaderView() {
        this.ensureAttacher();
        return this.mPullToRefreshAttacher.getHeaderView();
    }

    /*
     * Enabled aggressive block sorting
     */
    ViewDelegate getViewDelegateFromLayoutParams(View view) {
        if (view == null) return null;
        if (!(view.getLayoutParams() instanceof LayoutParams)) return null;
        String string2 = ((LayoutParams)view.getLayoutParams()).getViewDelegateClassName();
        if (TextUtils.isEmpty((CharSequence)string2)) return null;
        int n2 = string2.indexOf(46);
        if (n2 == -1) {
            string2 = this.getContext().getPackageName() + "." + string2;
            return (ViewDelegate)InstanceCreationUtils.instantiateViewDelegate(this.getContext(), string2);
        }
        if (n2 != 0) return (ViewDelegate)InstanceCreationUtils.instantiateViewDelegate(this.getContext(), string2);
        string2 = this.getContext().getPackageName() + string2;
        return (ViewDelegate)InstanceCreationUtils.instantiateViewDelegate(this.getContext(), string2);
    }

    public final boolean isRefreshing() {
        this.ensureAttacher();
        return this.mPullToRefreshAttacher.isRefreshing();
    }

    protected void onConfigurationChanged(Configuration configuration) {
        if (this.mPullToRefreshAttacher != null) {
            this.mPullToRefreshAttacher.onConfigurationChanged(configuration);
        }
        super.onConfigurationChanged(configuration);
    }

    protected void onDetachedFromWindow() {
        if (this.mPullToRefreshAttacher != null) {
            this.mPullToRefreshAttacher.destroy();
        }
        super.onDetachedFromWindow();
    }

    public final boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.isEnabled() && this.mPullToRefreshAttacher != null && this.getChildCount() > 0) {
            return this.mPullToRefreshAttacher.onInterceptTouchEvent(motionEvent);
        }
        return false;
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isEnabled() && this.mPullToRefreshAttacher != null) {
            return this.mPullToRefreshAttacher.onTouchEvent(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public final void setHeaderViewListener(HeaderViewListener headerViewListener) {
        this.ensureAttacher();
        this.mPullToRefreshAttacher.setHeaderViewListener(headerViewListener);
    }

    void setPullToRefreshAttacher(PullToRefreshAttacher pullToRefreshAttacher) {
        if (this.mPullToRefreshAttacher != null) {
            this.mPullToRefreshAttacher.destroy();
        }
        this.mPullToRefreshAttacher = pullToRefreshAttacher;
    }

    public final void setRefreshComplete() {
        this.ensureAttacher();
        this.mPullToRefreshAttacher.setRefreshComplete();
    }

    public final void setRefreshing(boolean bl2) {
        this.ensureAttacher();
        this.mPullToRefreshAttacher.setRefreshing(bl2);
    }

    static class LayoutParams
    extends FrameLayout.LayoutParams {
        private final String mViewDelegateClassName;

        LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.PullToRefreshView);
            this.mViewDelegateClassName = typedArray.getString(0);
            typedArray.recycle();
        }

        String getViewDelegateClassName() {
            return this.mViewDelegateClassName;
        }
    }
}

