/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.library;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.util.Iterator;
import java.util.WeakHashMap;
import uk.co.senab.actionbarpulltorefresh.library.DefaultHeaderTransformer;
import uk.co.senab.actionbarpulltorefresh.library.EnvironmentDelegate;
import uk.co.senab.actionbarpulltorefresh.library.HeaderTransformer;
import uk.co.senab.actionbarpulltorefresh.library.InstanceCreationUtils;
import uk.co.senab.actionbarpulltorefresh.library.Options;
import uk.co.senab.actionbarpulltorefresh.library.listeners.HeaderViewListener;
import uk.co.senab.actionbarpulltorefresh.library.listeners.OnRefreshListener;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.ViewDelegate;

public class PullToRefreshAttacher {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "PullToRefreshAttacher";
    private Activity mActivity;
    private EnvironmentDelegate mEnvironmentDelegate;
    private boolean mHandlingTouchEventFromDown;
    private HeaderTransformer mHeaderTransformer;
    private View mHeaderView;
    private HeaderViewListener mHeaderViewListener;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private boolean mIsBeingDragged;
    private boolean mIsDestroyed = false;
    private boolean mIsRefreshing;
    private float mLastMotionY;
    private OnRefreshListener mOnRefreshListener;
    private float mPullBeginY;
    private final Rect mRect;
    private final boolean mRefreshMinimize;
    private final int mRefreshMinimizeDelay;
    private final Runnable mRefreshMinimizeRunnable;
    private final boolean mRefreshOnUp;
    private final float mRefreshScrollDistance;
    private final WeakHashMap<View, ViewDelegate> mRefreshableViews;
    private final int mTouchSlop;
    private View mViewBeingDragged;
    private final int[] mViewLocationResult = new int[2];

    /*
     * Enabled aggressive block sorting
     */
    protected PullToRefreshAttacher(Activity activity, Options options) {
        this.mRect = new Rect();
        this.mRefreshMinimizeRunnable = new Runnable(){

            @Override
            public void run() {
                PullToRefreshAttacher.this.minimizeHeader();
            }
        };
        if (activity == null) {
            throw new IllegalArgumentException("activity cannot be null");
        }
        if (options == null) {
            Log.i((String)LOG_TAG, (String)"Given null options so using default options.");
            options = new Options();
        }
        this.mActivity = activity;
        this.mRefreshableViews = new WeakHashMap();
        this.mRefreshScrollDistance = options.refreshScrollDistance;
        this.mRefreshOnUp = options.refreshOnUp;
        this.mRefreshMinimizeDelay = options.refreshMinimizeDelay;
        this.mRefreshMinimize = options.refreshMinimize;
        EnvironmentDelegate environmentDelegate = options.environmentDelegate != null ? options.environmentDelegate : this.createDefaultEnvironmentDelegate();
        this.mEnvironmentDelegate = environmentDelegate;
        HeaderTransformer headerTransformer = options.headerTransformer != null ? options.headerTransformer : this.createDefaultHeaderTransformer();
        this.mHeaderTransformer = headerTransformer;
        this.mTouchSlop = ViewConfiguration.get((Context)activity).getScaledTouchSlop();
        final ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView();
        this.mHeaderView = LayoutInflater.from((Context)this.mEnvironmentDelegate.getContextForInflater(activity)).inflate(options.headerLayout, viewGroup, false);
        if (this.mHeaderView == null) {
            throw new IllegalArgumentException("Must supply valid layout id for header.");
        }
        this.mHeaderView.setVisibility(4);
        this.mHeaderTransformer.onViewCreated(activity, this.mHeaderView);
        viewGroup.post(new Runnable(){

            @Override
            public void run() {
                if (viewGroup.getWindowToken() != null) {
                    PullToRefreshAttacher.this.addHeaderViewToActivity(PullToRefreshAttacher.this.mHeaderView);
                    return;
                }
                viewGroup.post((Runnable)this);
            }
        });
    }

    private boolean canRefresh(boolean bl2) {
        return !this.mIsRefreshing && (!bl2 || this.mOnRefreshListener != null);
    }

    private boolean checkScrollForRefresh(View view) {
        if (this.mIsBeingDragged && this.mRefreshOnUp && view != null && this.mLastMotionY - this.mPullBeginY >= this.getScrollNeededForRefresh(view)) {
            this.setRefreshingInt(view, true, true);
            return true;
        }
        return false;
    }

    private float getScrollNeededForRefresh(View view) {
        return (float)view.getHeight() * this.mRefreshScrollDistance;
    }

    private boolean isDestroyed() {
        if (this.mIsDestroyed) {
            Log.i((String)LOG_TAG, (String)"PullToRefreshAttacher is destroyed.");
        }
        return this.mIsDestroyed;
    }

    private void reset(boolean bl2) {
        this.mIsRefreshing = false;
        if (this.mRefreshMinimize) {
            this.getHeaderView().removeCallbacks(this.mRefreshMinimizeRunnable);
        }
        this.hideHeaderView();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRefreshingInt(View view, boolean bl2, boolean bl3) {
        if (this.isDestroyed() || this.mIsRefreshing == bl2) {
            return;
        }
        this.resetTouch();
        if (bl2 && this.canRefresh(bl3)) {
            this.startRefresh(view, bl3);
            return;
        }
        this.reset(bl3);
    }

    private void startRefresh(View view, boolean bl2) {
        block5: {
            block4: {
                this.mIsRefreshing = true;
                if (bl2 && this.mOnRefreshListener != null) {
                    this.mOnRefreshListener.onRefreshStarted(view);
                }
                this.mHeaderTransformer.onRefreshStarted();
                this.showHeaderView();
                if (!this.mRefreshMinimize) break block4;
                if (this.mRefreshMinimizeDelay <= 0) break block5;
                this.getHeaderView().postDelayed(this.mRefreshMinimizeRunnable, (long)this.mRefreshMinimizeDelay);
            }
            return;
        }
        this.getHeaderView().post(this.mRefreshMinimizeRunnable);
    }

    protected void addHeaderViewToActivity(View view) {
        this.mActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(this.mRect);
        int n2 = -1;
        int n3 = -2;
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams != null) {
            n2 = layoutParams.width;
            n3 = layoutParams.height;
        }
        WindowManager.LayoutParams layoutParams2 = new WindowManager.LayoutParams(n2, n3, 1000, 24, -3);
        layoutParams2.x = 0;
        layoutParams2.y = this.mRect.top;
        layoutParams2.gravity = 48;
        view.setTag((Object)layoutParams2);
        this.mActivity.getWindowManager().addView(view, (ViewGroup.LayoutParams)layoutParams2);
    }

    void addRefreshableView(View view, ViewDelegate viewDelegate) {
        if (this.isDestroyed()) {
            return;
        }
        if (view == null) {
            Log.i((String)LOG_TAG, (String)"Refreshable View is null.");
            return;
        }
        if (viewDelegate == null) {
            viewDelegate = InstanceCreationUtils.getBuiltInViewDelegate(view);
        }
        this.mRefreshableViews.put(view, viewDelegate);
    }

    void clearRefreshableViews() {
        this.mRefreshableViews.clear();
    }

    protected EnvironmentDelegate createDefaultEnvironmentDelegate() {
        return new EnvironmentDelegate(){

            @Override
            public Context getContextForInflater(Activity activity) {
                int n2 = Build.VERSION.SDK_INT;
                Activity activity2 = null;
                if (n2 >= 14) {
                    ActionBar actionBar = activity.getActionBar();
                    activity2 = null;
                    if (actionBar != null) {
                        activity2 = actionBar.getThemedContext();
                    }
                }
                if (activity2 == null) {
                    activity2 = activity;
                }
                return activity2;
            }
        };
    }

    protected HeaderTransformer createDefaultHeaderTransformer() {
        return new DefaultHeaderTransformer();
    }

    void destroy() {
        if (this.mIsDestroyed) {
            return;
        }
        this.removeHeaderViewFromActivity(this.mHeaderView);
        this.clearRefreshableViews();
        this.mActivity = null;
        this.mHeaderView = null;
        this.mHeaderViewListener = null;
        this.mEnvironmentDelegate = null;
        this.mHeaderTransformer = null;
        this.mIsDestroyed = true;
    }

    protected final Activity getAttachedActivity() {
        return this.mActivity;
    }

    HeaderTransformer getHeaderTransformer() {
        return this.mHeaderTransformer;
    }

    final View getHeaderView() {
        return this.mHeaderView;
    }

    void hideHeaderView() {
        if (this.mHeaderTransformer.hideHeaderView() && this.mHeaderViewListener != null) {
            this.mHeaderViewListener.onStateChanged(this.mHeaderView, 2);
        }
    }

    final boolean isRefreshing() {
        return this.mIsRefreshing;
    }

    final boolean isViewBeingDragged(View view, MotionEvent motionEvent) {
        boolean bl2 = view.isShown();
        boolean bl3 = false;
        if (bl2) {
            boolean bl4 = this.mRefreshableViews.containsKey(view);
            bl3 = false;
            if (bl4) {
                view.getLocationOnScreen(this.mViewLocationResult);
                int n2 = this.mViewLocationResult[0];
                int n3 = this.mViewLocationResult[1];
                this.mRect.set(n2, n3, n2 + view.getWidth(), n3 + view.getHeight());
                int n4 = (int)motionEvent.getRawX();
                int n5 = (int)motionEvent.getRawY();
                boolean bl5 = this.mRect.contains(n4, n5);
                bl3 = false;
                if (bl5) {
                    ViewDelegate viewDelegate = this.mRefreshableViews.get(view);
                    bl3 = false;
                    if (viewDelegate != null) {
                        bl3 = viewDelegate.isReadyForPull(view, n4 - this.mRect.left, n5 - this.mRect.top);
                    }
                }
            }
        }
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    void minimizeHeader() {
        block3: {
            block2: {
                if (this.isDestroyed()) break block2;
                this.mHeaderTransformer.onRefreshMinimized();
                if (this.mHeaderViewListener != null) break block3;
            }
            return;
        }
        this.mHeaderViewListener.onStateChanged(this.mHeaderView, 1);
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.mHeaderTransformer.onConfigurationChanged(this.mActivity, configuration);
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.isRefreshing()) {
            return false;
        }
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 2: {
                if (this.mIsBeingDragged) return this.mIsBeingDragged;
                if (!(this.mInitialMotionY > 0.0f)) return this.mIsBeingDragged;
                float f4 = f3 - this.mInitialMotionY;
                if (f4 > f2 - this.mInitialMotionX && f4 > (float)this.mTouchSlop) {
                    this.mIsBeingDragged = true;
                    this.onPullStarted(f3);
                } else {
                    if (!(f4 < (float)(-this.mTouchSlop))) return this.mIsBeingDragged;
                    this.resetTouch();
                }
            }
            default: {
                return this.mIsBeingDragged;
            }
            case 0: {
                if (!this.canRefresh(true)) return this.mIsBeingDragged;
                Iterator<View> iterator = this.mRefreshableViews.keySet().iterator();
                while (iterator.hasNext()) {
                    View view = iterator.next();
                    if (!this.isViewBeingDragged(view, motionEvent)) continue;
                    this.mInitialMotionX = f2;
                    this.mInitialMotionY = f3;
                    this.mViewBeingDragged = view;
                }
                return this.mIsBeingDragged;
            }
            case 1: 
            case 3: 
        }
        this.resetTouch();
        return this.mIsBeingDragged;
    }

    void onPull(View view, float f2) {
        float f3 = f2 - this.mPullBeginY;
        float f4 = this.getScrollNeededForRefresh(view);
        if (f3 < f4) {
            this.mHeaderTransformer.onPulled(f3 / f4);
            return;
        }
        if (this.mRefreshOnUp) {
            this.mHeaderTransformer.onReleaseToRefresh();
            return;
        }
        this.setRefreshingInt(view, true, true);
    }

    void onPullEnded() {
        if (!this.mIsRefreshing) {
            this.reset(true);
        }
    }

    void onPullStarted(float f2) {
        this.showHeaderView();
        this.mPullBeginY = f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.mHandlingTouchEventFromDown = true;
        }
        if (this.mHandlingTouchEventFromDown && !this.mIsBeingDragged) {
            this.onInterceptTouchEvent(motionEvent);
            return true;
        } else {
            if (this.mViewBeingDragged == null) {
                return false;
            }
            switch (motionEvent.getAction()) {
                default: {
                    return true;
                }
                case 1: 
                case 3: {
                    this.checkScrollForRefresh(this.mViewBeingDragged);
                    if (this.mIsBeingDragged) {
                        this.onPullEnded();
                    }
                    this.resetTouch();
                    return true;
                }
                case 2: 
            }
            if (this.isRefreshing()) {
                return false;
            }
            float f2 = motionEvent.getY();
            if (!this.mIsBeingDragged || f2 == this.mLastMotionY) return true;
            float f3 = f2 - this.mLastMotionY;
            if (!(f3 >= (float)(-this.mTouchSlop))) {
                this.onPullEnded();
                this.resetTouch();
                return true;
            }
            this.onPull(this.mViewBeingDragged, f2);
            if (!(f3 > 0.0f)) return true;
            this.mLastMotionY = f2;
            return true;
        }
    }

    protected void removeHeaderViewFromActivity(View view) {
        if (view.getWindowToken() != null) {
            this.mActivity.getWindowManager().removeViewImmediate(view);
        }
    }

    void resetTouch() {
        this.mIsBeingDragged = false;
        this.mHandlingTouchEventFromDown = false;
        this.mPullBeginY = -1.0f;
        this.mLastMotionY = -1.0f;
        this.mInitialMotionY = -1.0f;
    }

    final void setHeaderViewListener(HeaderViewListener headerViewListener) {
        this.mHeaderViewListener = headerViewListener;
    }

    void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    final void setRefreshComplete() {
        this.setRefreshingInt(null, false, false);
    }

    final void setRefreshing(boolean bl2) {
        this.setRefreshingInt(null, bl2, false);
    }

    void showHeaderView() {
        this.updateHeaderViewPosition(this.mHeaderView);
        if (this.mHeaderTransformer.showHeaderView() && this.mHeaderViewListener != null) {
            this.mHeaderViewListener.onStateChanged(this.mHeaderView, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateHeaderViewPosition(View view) {
        WindowManager.LayoutParams layoutParams;
        this.mActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(this.mRect);
        if (view.getLayoutParams() instanceof WindowManager.LayoutParams) {
            layoutParams = (WindowManager.LayoutParams)view.getLayoutParams();
        } else {
            boolean bl2 = view.getTag() instanceof WindowManager.LayoutParams;
            layoutParams = null;
            if (bl2) {
                layoutParams = (WindowManager.LayoutParams)view.getTag();
            }
        }
        if (layoutParams != null && layoutParams.y != this.mRect.top) {
            layoutParams.y = this.mRect.top;
            this.mActivity.getWindowManager().updateViewLayout(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    void useViewDelegate(Class<?> clazz, ViewDelegate viewDelegate) {
        for (View view : this.mRefreshableViews.keySet()) {
            if (!clazz.isInstance(view)) continue;
            this.mRefreshableViews.put(view, viewDelegate);
        }
    }
}

