/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.library;

import android.content.Context;
import android.util.Log;
import android.view.View;
import java.util.HashMap;
import java.util.Map;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.AbsListViewDelegate;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.ScrollYDelegate;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.ViewDelegate;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.WebViewDelegate;

class InstanceCreationUtils {
    private static final HashMap<Class, Class> BUILT_IN_DELEGATES;
    private static final String LOG_TAG = "InstanceCreationUtils";
    private static final Class<?>[] TRANSFORMER_CONSTRUCTOR_SIGNATURE;
    private static final Class<?>[] VIEW_DELEGATE_CONSTRUCTOR_SIGNATURE;

    static {
        VIEW_DELEGATE_CONSTRUCTOR_SIGNATURE = new Class[0];
        TRANSFORMER_CONSTRUCTOR_SIGNATURE = new Class[0];
        BUILT_IN_DELEGATES = new HashMap();
        InstanceCreationUtils.addBuiltinDelegates(AbsListViewDelegate.SUPPORTED_VIEW_CLASSES, AbsListViewDelegate.class);
        InstanceCreationUtils.addBuiltinDelegates(ScrollYDelegate.SUPPORTED_VIEW_CLASSES, ScrollYDelegate.class);
        InstanceCreationUtils.addBuiltinDelegates(WebViewDelegate.SUPPORTED_VIEW_CLASSES, WebViewDelegate.class);
    }

    InstanceCreationUtils() {
    }

    private static void addBuiltinDelegates(Class[] classArray, Class<?> clazz) {
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BUILT_IN_DELEGATES.put(classArray[i2], clazz);
        }
    }

    static ViewDelegate getBuiltInViewDelegate(View view) {
        for (Map.Entry<Class, Class> entry : BUILT_IN_DELEGATES.entrySet()) {
            if (!entry.getKey().isInstance(view)) continue;
            return (ViewDelegate)InstanceCreationUtils.newInstance(view.getContext(), entry.getValue(), VIEW_DELEGATE_CONSTRUCTOR_SIGNATURE, new Object[0]);
        }
        return null;
    }

    static <T> T instantiateTransformer(Context context, String string2) {
        T t2;
        try {
            t2 = InstanceCreationUtils.newInstance(context, context.getClassLoader().loadClass(string2), TRANSFORMER_CONSTRUCTOR_SIGNATURE, new Object[0]);
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)("Cannot instantiate class: " + string2), (Throwable)exception);
            return null;
        }
        return t2;
    }

    static <T> T instantiateViewDelegate(Context context, String string2) {
        T t2;
        try {
            t2 = InstanceCreationUtils.newInstance(context, context.getClassLoader().loadClass(string2), VIEW_DELEGATE_CONSTRUCTOR_SIGNATURE, new Object[0]);
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)("Cannot instantiate class: " + string2), (Throwable)exception);
            return null;
        }
        return t2;
    }

    private static <T> T newInstance(Context context, Class clazz, Class[] classArray, Object ... objectArray) {
        Object t2;
        try {
            t2 = clazz.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)("Cannot instantiate class: " + clazz.getName()), (Throwable)exception);
            return null;
        }
        return t2;
    }
}

