/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.library;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.TextView;
import fr.castorflex.android.smoothprogressbar.SmoothProgressBar;
import fr.castorflex.android.smoothprogressbar.SmoothProgressDrawable;
import uk.co.senab.actionbarpulltorefresh.library.HeaderTransformer;
import uk.co.senab.actionbarpulltorefresh.library.R;
import uk.co.senab.actionbarpulltorefresh.library.sdk.Compat;

public class DefaultHeaderTransformer
extends HeaderTransformer {
    public static final int PROGRESS_BAR_STYLE_INSIDE = 0;
    public static final int PROGRESS_BAR_STYLE_OUTSIDE = 1;
    private long mAnimationDuration;
    private ViewGroup mContentLayout;
    private SmoothProgressBar mHeaderProgressBar;
    private TextView mHeaderTextView;
    private View mHeaderView;
    private final Interpolator mInterpolator = new AccelerateInterpolator();
    private int mProgressBarHeight = -2;
    private int mProgressBarStyle;
    private int mProgressDrawableColor;
    private CharSequence mPullRefreshLabel;
    private CharSequence mRefreshingLabel;
    private CharSequence mReleaseLabel;

    protected DefaultHeaderTransformer() {
        int n2 = this.getMinimumApiLevel();
        if (Build.VERSION.SDK_INT < n2) {
            throw new IllegalStateException("This HeaderTransformer is designed to run on SDK " + n2 + "+. If using ActionBarSherlock or ActionBarCompat you should use the appropriate provided extra.");
        }
    }

    private void applyProgressBarSettings() {
        if (this.mHeaderProgressBar != null) {
            int n2 = this.mHeaderProgressBar.getResources().getDimensionPixelSize(R.dimen.ptr_progress_bar_stroke_width);
            this.mHeaderProgressBar.setIndeterminateDrawable(new SmoothProgressDrawable.Builder(this.mHeaderProgressBar.getContext()).color(this.mProgressDrawableColor).width(n2).build());
            ShapeDrawable shapeDrawable = new ShapeDrawable();
            shapeDrawable.setShape((Shape)new RectShape());
            shapeDrawable.getPaint().setColor(this.mProgressDrawableColor);
            ClipDrawable clipDrawable = new ClipDrawable((Drawable)shapeDrawable, 17, 1);
            this.mHeaderProgressBar.setProgressDrawable((Drawable)clipDrawable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyProgressBarStyle() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, this.mProgressBarHeight);
        switch (this.mProgressBarStyle) {
            case 0: {
                layoutParams.addRule(8, R.id.ptr_content);
            }
            default: {
                break;
            }
            case 1: {
                layoutParams.addRule(3, R.id.ptr_content);
            }
        }
        this.mHeaderProgressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected static TypedArray obtainStyledAttrsFromThemeAttr(Context context, int n2, int[] nArray) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(n2, typedValue, true);
        return context.obtainStyledAttributes(typedValue.resourceId, nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupViewsFromStyles(Activity activity, View view) {
        Context context;
        int n2;
        Drawable drawable2;
        TypedArray typedArray = DefaultHeaderTransformer.obtainStyledAttrsFromThemeAttr((Context)activity, R.attr.ptrHeaderStyle, R.styleable.PullToRefreshHeader);
        if (this.mContentLayout != null) {
            int n3;
            this.mContentLayout.getLayoutParams().height = n3 = typedArray.getDimensionPixelSize(1, this.getActionBarSize((Context)activity));
            this.mContentLayout.requestLayout();
        }
        if ((drawable2 = typedArray.hasValue(0) ? typedArray.getDrawable(0) : this.getActionBarBackground((Context)activity)) != null) {
            this.mHeaderTextView.setBackgroundDrawable(drawable2);
            if (this.mContentLayout != null && drawable2.getOpacity() == -1) {
                this.mContentLayout.setBackgroundResource(0);
            }
        }
        if ((n2 = typedArray.getResourceId(2, this.getActionBarTitleStyle(context = view.getContext()))) != 0) {
            this.mHeaderTextView.setTextAppearance(context, n2);
        }
        if (typedArray.hasValue(3)) {
            this.mProgressDrawableColor = typedArray.getColor(3, this.mProgressDrawableColor);
        }
        this.mProgressBarStyle = typedArray.getInt(4, 1);
        if (typedArray.hasValue(5)) {
            this.mProgressBarHeight = typedArray.getDimensionPixelSize(5, this.mProgressBarHeight);
        }
        if (typedArray.hasValue(6)) {
            this.mPullRefreshLabel = typedArray.getString(6);
        }
        if (typedArray.hasValue(7)) {
            this.mRefreshingLabel = typedArray.getString(7);
        }
        if (typedArray.hasValue(8)) {
            this.mReleaseLabel = typedArray.getString(8);
        }
        typedArray.recycle();
    }

    protected Drawable getActionBarBackground(Context context) {
        TypedArray typedArray = DefaultHeaderTransformer.obtainStyledAttrsFromThemeAttr(context, 16843470, new int[]{16842964});
        try {
            Drawable drawable2 = typedArray.getDrawable(0);
            return drawable2;
        }
        finally {
            typedArray.recycle();
        }
    }

    protected int getActionBarSize(Context context) {
        int[] nArray = new int[]{16843499};
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(nArray);
        try {
            int n2 = typedArray.getDimensionPixelSize(0, 0);
            return n2;
        }
        finally {
            typedArray.recycle();
        }
    }

    protected int getActionBarTitleStyle(Context context) {
        TypedArray typedArray = DefaultHeaderTransformer.obtainStyledAttrsFromThemeAttr(context, 16843470, new int[]{16843512});
        try {
            int n2 = typedArray.getResourceId(0, 0);
            return n2;
        }
        finally {
            typedArray.recycle();
        }
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    protected int getMinimumApiLevel() {
        return 14;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hideHeaderView() {
        AnimatorSet animatorSet;
        if (this.mHeaderView.getVisibility() == 8) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (this.mContentLayout.getAlpha() >= 0.5f) {
            animatorSet = new AnimatorSet();
            ViewGroup viewGroup = this.mContentLayout;
            float[] fArray = new float[]{0.0f, -this.mContentLayout.getHeight()};
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)viewGroup, (String)"translationY", (float[])fArray);
            ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.mHeaderView, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            animatorSet.playTogether(new Animator[]{objectAnimator, objectAnimator2});
        } else {
            animatorSet = ObjectAnimator.ofFloat((Object)this.mHeaderView, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        }
        animatorSet.setDuration(this.mAnimationDuration);
        animatorSet.addListener((Animator.AnimatorListener)new HideAnimationCallback());
        animatorSet.start();
        return bl2;
    }

    @Override
    public void onConfigurationChanged(Activity activity, Configuration configuration) {
        this.setupViewsFromStyles(activity, this.getHeaderView());
    }

    @Override
    public void onPulled(float f2) {
        if (this.mHeaderProgressBar != null) {
            this.mHeaderProgressBar.setVisibility(0);
            float f3 = this.mInterpolator.getInterpolation(f2);
            this.mHeaderProgressBar.setProgress(Math.round(f3 * (float)this.mHeaderProgressBar.getMax()));
        }
    }

    @Override
    public void onRefreshMinimized() {
        if (this.mContentLayout != null) {
            ObjectAnimator.ofFloat((Object)this.mContentLayout, (String)"alpha", (float[])new float[]{1.0f, 0.0f}).start();
        }
    }

    @Override
    public void onRefreshStarted() {
        if (this.mHeaderTextView != null) {
            this.mHeaderTextView.setText(this.mRefreshingLabel);
        }
        if (this.mHeaderProgressBar != null) {
            this.mHeaderProgressBar.setVisibility(0);
            this.mHeaderProgressBar.setIndeterminate(true);
        }
    }

    @Override
    public void onReleaseToRefresh() {
        if (this.mHeaderTextView != null) {
            this.mHeaderTextView.setText(this.mReleaseLabel);
        }
        if (this.mHeaderProgressBar != null) {
            this.mHeaderProgressBar.setProgress(this.mHeaderProgressBar.getMax());
        }
    }

    @Override
    public void onReset() {
        if (this.mHeaderProgressBar != null) {
            this.mHeaderProgressBar.setVisibility(0);
            this.mHeaderProgressBar.setProgress(0);
            this.mHeaderProgressBar.setIndeterminate(false);
        }
        if (this.mHeaderTextView != null) {
            this.mHeaderTextView.setVisibility(0);
            this.mHeaderTextView.setText(this.mPullRefreshLabel);
        }
        if (this.mContentLayout != null) {
            this.mContentLayout.setVisibility(0);
            Compat.setAlpha((View)this.mContentLayout, 1.0f);
        }
    }

    @Override
    public void onViewCreated(Activity activity, View view) {
        this.mHeaderView = view;
        this.mHeaderProgressBar = (SmoothProgressBar)view.findViewById(R.id.ptr_progress);
        this.mHeaderTextView = (TextView)view.findViewById(R.id.ptr_text);
        this.mContentLayout = (ViewGroup)view.findViewById(R.id.ptr_content);
        this.mPullRefreshLabel = activity.getString(R.string.pull_to_refresh_pull_label);
        this.mRefreshingLabel = activity.getString(R.string.pull_to_refresh_refreshing_label);
        this.mReleaseLabel = activity.getString(R.string.pull_to_refresh_release_label);
        this.mAnimationDuration = activity.getResources().getInteger(0x10E0000);
        this.mProgressDrawableColor = activity.getResources().getColor(R.color.default_progress_bar_color);
        this.setupViewsFromStyles(activity, view);
        this.applyProgressBarStyle();
        this.applyProgressBarSettings();
        this.onReset();
    }

    public void setProgressBarColor(int n2) {
        if (n2 != this.mProgressDrawableColor) {
            this.mProgressDrawableColor = n2;
            this.applyProgressBarSettings();
        }
    }

    public void setProgressBarHeight(int n2) {
        if (this.mProgressBarHeight != n2) {
            this.mProgressBarHeight = n2;
            this.applyProgressBarStyle();
        }
    }

    public void setProgressBarStyle(int n2) {
        if (this.mProgressBarStyle != n2) {
            this.mProgressBarStyle = n2;
            this.applyProgressBarStyle();
        }
    }

    public void setPullText(CharSequence charSequence) {
        this.mPullRefreshLabel = charSequence;
        if (this.mHeaderTextView != null) {
            this.mHeaderTextView.setText(this.mPullRefreshLabel);
        }
    }

    public void setRefreshingText(CharSequence charSequence) {
        this.mRefreshingLabel = charSequence;
    }

    public void setReleaseText(CharSequence charSequence) {
        this.mReleaseLabel = charSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean showHeaderView() {
        if (this.mHeaderView.getVisibility() == 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        this.mHeaderView.setVisibility(0);
        AnimatorSet animatorSet = new AnimatorSet();
        ViewGroup viewGroup = this.mContentLayout;
        float[] fArray = new float[]{-this.mContentLayout.getHeight(), 0.0f};
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)viewGroup, (String)"translationY", (float[])fArray), ObjectAnimator.ofFloat((Object)this.mHeaderView, (String)"alpha", (float[])new float[]{0.0f, 1.0f})});
        animatorSet.setDuration(this.mAnimationDuration);
        animatorSet.start();
        return bl2;
    }

    class HideAnimationCallback
    extends AnimatorListenerAdapter {
        HideAnimationCallback() {
        }

        public void onAnimationEnd(Animator animator) {
            View view = DefaultHeaderTransformer.this.getHeaderView();
            if (view != null) {
                view.setVisibility(8);
            }
            DefaultHeaderTransformer.this.onReset();
        }
    }
}

