/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.library;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashMap;
import java.util.Map;
import uk.co.senab.actionbarpulltorefresh.library.Options;
import uk.co.senab.actionbarpulltorefresh.library.PullToRefreshAttacher;
import uk.co.senab.actionbarpulltorefresh.library.PullToRefreshLayout;
import uk.co.senab.actionbarpulltorefresh.library.listeners.OnRefreshListener;
import uk.co.senab.actionbarpulltorefresh.library.viewdelegates.ViewDelegate;

public class ActionBarPullToRefresh {
    public static SetupWizard from(Activity activity) {
        return new SetupWizard(activity);
    }

    public static final class SetupWizard {
        private final Activity mActivity;
        private OnRefreshListener mOnRefreshListener;
        private Options mOptions;
        private HashMap<Class, ViewDelegate> mViewDelegates;
        private ViewGroup mViewGroupToInsertInto;
        private int[] refreshableViewIds;
        private View[] refreshableViews;

        private SetupWizard(Activity activity) {
            this.mActivity = activity;
        }

        private static void insertLayoutIntoViewGroup(ViewGroup viewGroup, PullToRefreshLayout pullToRefreshLayout) {
            View view = viewGroup.getChildAt(0);
            while (view != null) {
                viewGroup.removeViewAt(0);
                pullToRefreshLayout.addView(view);
                view = viewGroup.getChildAt(0);
            }
            viewGroup.addView((View)pullToRefreshLayout, -1, -1);
        }

        public SetupWizard allChildrenArePullable() {
            this.refreshableViewIds = null;
            this.refreshableViews = null;
            return this;
        }

        public SetupWizard insertLayoutInto(ViewGroup viewGroup) {
            this.mViewGroupToInsertInto = viewGroup;
            return this;
        }

        public SetupWizard listener(OnRefreshListener onRefreshListener) {
            this.mOnRefreshListener = onRefreshListener;
            return this;
        }

        public SetupWizard options(Options options) {
            this.mOptions = options;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setup(PullToRefreshLayout pullToRefreshLayout) {
            PullToRefreshAttacher pullToRefreshAttacher = pullToRefreshLayout.createPullToRefreshAttacher(this.mActivity, this.mOptions);
            pullToRefreshAttacher.setOnRefreshListener(this.mOnRefreshListener);
            if (this.mViewGroupToInsertInto != null) {
                SetupWizard.insertLayoutIntoViewGroup(this.mViewGroupToInsertInto, pullToRefreshLayout);
            }
            pullToRefreshLayout.setPullToRefreshAttacher(pullToRefreshAttacher);
            if (this.refreshableViewIds != null) {
                pullToRefreshLayout.addChildrenAsPullable(this.refreshableViewIds);
            } else if (this.refreshableViews != null) {
                pullToRefreshLayout.addChildrenAsPullable(this.refreshableViews);
            } else {
                pullToRefreshLayout.addAllChildrenAsPullable();
            }
            if (this.mViewDelegates != null) {
                for (Map.Entry<Class, ViewDelegate> entry : this.mViewDelegates.entrySet()) {
                    pullToRefreshAttacher.useViewDelegate(entry.getKey(), entry.getValue());
                }
            }
        }

        public SetupWizard theseChildrenArePullable(int ... nArray) {
            this.refreshableViewIds = nArray;
            this.refreshableViews = null;
            return this;
        }

        public SetupWizard theseChildrenArePullable(View ... viewArray) {
            this.refreshableViews = viewArray;
            this.refreshableViewIds = null;
            return this;
        }

        public SetupWizard useViewDelegate(Class<?> clazz, ViewDelegate viewDelegate) {
            if (this.mViewDelegates == null) {
                this.mViewDelegates = new HashMap();
            }
            this.mViewDelegates.put(clazz, viewDelegate);
            return this;
        }
    }
}

