/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.extras.actionbarcompat;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.view.View;
import android.widget.FrameLayout;
import uk.co.senab.actionbarpulltorefresh.extras.actionbarcompat.AbcDefaultHeaderTransformer;
import uk.co.senab.actionbarpulltorefresh.library.EnvironmentDelegate;
import uk.co.senab.actionbarpulltorefresh.library.HeaderTransformer;
import uk.co.senab.actionbarpulltorefresh.library.Options;
import uk.co.senab.actionbarpulltorefresh.library.PullToRefreshAttacher;

class AbcPullToRefreshAttacher
extends PullToRefreshAttacher {
    private FrameLayout mHeaderViewWrapper;

    protected AbcPullToRefreshAttacher(Activity activity, Options options) {
        super(activity, options);
    }

    @Override
    protected void addHeaderViewToActivity(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.addHeaderViewToActivity(view);
            return;
        }
        this.mHeaderViewWrapper = new FrameLayout((Context)this.getAttachedActivity());
        this.mHeaderViewWrapper.addView(view);
        super.addHeaderViewToActivity((View)this.mHeaderViewWrapper);
    }

    @Override
    protected EnvironmentDelegate createDefaultEnvironmentDelegate() {
        return new AbcEnvironmentDelegate();
    }

    @Override
    protected HeaderTransformer createDefaultHeaderTransformer() {
        return new AbcDefaultHeaderTransformer();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void removeHeaderViewFromActivity(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.removeHeaderViewFromActivity(view);
            return;
        } else {
            if (this.mHeaderViewWrapper == null) return;
            super.removeHeaderViewFromActivity((View)this.mHeaderViewWrapper);
            this.mHeaderViewWrapper = null;
            return;
        }
    }

    @Override
    protected void updateHeaderViewPosition(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.updateHeaderViewPosition(view);
            return;
        }
        super.updateHeaderViewPosition((View)this.mHeaderViewWrapper);
    }

    public static class AbcEnvironmentDelegate
    implements EnvironmentDelegate {
        @Override
        public Context getContextForInflater(Activity activity) {
            ActionBar actionBar = ((ActionBarActivity)activity).getSupportActionBar();
            Context context = null;
            if (actionBar != null) {
                context = actionBar.getThemedContext();
            }
            if (context == null) {
                context = activity;
            }
            return context;
        }
    }
}

