/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.actionbarpulltorefresh.extras.actionbarcompat;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import uk.co.senab.actionbarpulltorefresh.extras.actionbarcompat.R;
import uk.co.senab.actionbarpulltorefresh.library.DefaultHeaderTransformer;

public class AbcDefaultHeaderTransformer
extends DefaultHeaderTransformer {
    private Animation mHeaderInAnimation;
    private Animation mHeaderOutAnimation;

    @Override
    protected Drawable getActionBarBackground(Context context) {
        if (Build.VERSION.SDK_INT >= super.getMinimumApiLevel()) {
            return super.getActionBarBackground(context);
        }
        TypedArray typedArray = AbcDefaultHeaderTransformer.obtainStyledAttrsFromThemeAttr(context, R.attr.actionBarStyle, R.styleable.ActionBar);
        try {
            Drawable drawable2 = typedArray.getDrawable(10);
            return drawable2;
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    protected int getActionBarSize(Context context) {
        if (Build.VERSION.SDK_INT >= super.getMinimumApiLevel()) {
            return super.getActionBarSize(context);
        }
        int[] nArray = new int[]{R.attr.actionBarSize};
        TypedArray typedArray = context.obtainStyledAttributes(nArray);
        try {
            int n2 = typedArray.getDimensionPixelSize(0, 0);
            return n2;
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    protected int getActionBarTitleStyle(Context context) {
        if (Build.VERSION.SDK_INT >= super.getMinimumApiLevel()) {
            return super.getActionBarTitleStyle(context);
        }
        TypedArray typedArray = AbcDefaultHeaderTransformer.obtainStyledAttrsFromThemeAttr(context, R.attr.actionBarStyle, R.styleable.ActionBar);
        try {
            int n2 = typedArray.getResourceId(5, 0);
            return n2;
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    protected int getMinimumApiLevel() {
        return 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hideHeaderView() {
        if (Build.VERSION.SDK_INT >= super.getMinimumApiLevel()) {
            return super.hideHeaderView();
        }
        View view = this.getHeaderView();
        if (view == null) return false;
        if (view.getVisibility() == 8) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (this.mHeaderOutAnimation != null) {
            view.startAnimation(this.mHeaderOutAnimation);
            return bl2;
        }
        view.setVisibility(8);
        this.onReset();
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRefreshMinimized() {
        if (Build.VERSION.SDK_INT >= super.getMinimumApiLevel()) {
            super.onRefreshMinimized();
            return;
        } else {
            View view = this.getHeaderView().findViewById(R.id.ptr_content);
            if (view == null) return;
            view.startAnimation(AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.fade_out));
            view.setVisibility(4);
            return;
        }
    }

    @Override
    public void onViewCreated(Activity activity, View view) {
        super.onViewCreated(activity, view);
        this.mHeaderInAnimation = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.fade_in);
        this.mHeaderOutAnimation = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.fade_out);
        if (this.mHeaderOutAnimation != null || this.mHeaderInAnimation != null) {
            AnimationCallback animationCallback = new AnimationCallback();
            if (this.mHeaderOutAnimation != null) {
                this.mHeaderOutAnimation.setAnimationListener((Animation.AnimationListener)animationCallback);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean showHeaderView() {
        if (Build.VERSION.SDK_INT >= super.getMinimumApiLevel()) {
            return super.showHeaderView();
        }
        View view = this.getHeaderView();
        if (view == null) return false;
        if (view.getVisibility() == 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (this.mHeaderInAnimation != null) {
            view.startAnimation(this.mHeaderInAnimation);
        }
        view.setVisibility(0);
        return bl2;
    }

    class AnimationCallback
    implements Animation.AnimationListener {
        AnimationCallback() {
        }

        public void onAnimationEnd(Animation animation) {
            if (animation == AbcDefaultHeaderTransformer.this.mHeaderOutAnimation) {
                View view = AbcDefaultHeaderTransformer.this.getHeaderView();
                if (view != null) {
                    view.setVisibility(8);
                }
                AbcDefaultHeaderTransformer.this.onReset();
            }
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }
}

