/*
 * Decompiled with CFR 0.152.
 */
package roboguice.util.temp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Strings {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private Strings() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String capitalize(String string2) {
        String string3 = Strings.toString(string2);
        if (string3.length() >= 2) {
            return string3.substring(0, 1).toUpperCase() + string3.substring(1);
        }
        if (string3.length() < 1) return string3;
        return string3.toUpperCase();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] chunk(String string2, int n2) {
        if (Strings.isEmpty(string2)) return new String[0];
        if (n2 == 0) {
            return new String[0];
        }
        int n3 = string2.length();
        int n4 = 1 + (n3 - 1) / n2;
        String[] stringArray = new String[n4];
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 * n2;
            int n7 = n2 + n5 * n2 < n3 ? n2 + n5 * n2 : n3;
            stringArray[n5] = string2.substring(n6, n7);
            ++n5;
        }
        return stringArray;
    }

    public static int copy(Reader reader, Writer writer) {
        long l2 = Strings.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long copyLarge(Reader reader, Writer writer) {
        int n2;
        long l2;
        char[] cArray;
        try {
            cArray = new char[4096];
            l2 = 0L;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static boolean equals(Object object, Object object2) {
        return Strings.toString(object).equals(Strings.toString(object2));
    }

    public static boolean equalsIgnoreCase(Object object, Object object2) {
        return Strings.toString(object).toLowerCase().equals(Strings.toString(object2).toLowerCase());
    }

    public static boolean isEmpty(Object object) {
        return Strings.toString(object).trim().length() == 0;
    }

    public static <T> String join(String string2, Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Iterator<T> iterator = collection.iterator();
        StringBuilder stringBuilder = new StringBuilder(Strings.toString(iterator.next()));
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (!Strings.notEmpty(t2)) continue;
            stringBuilder.append(string2).append(Strings.toString(t2));
        }
        return stringBuilder.toString();
    }

    public static <T> String join(String string2, T ... TArray) {
        return Strings.join(string2, Arrays.asList(TArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> String joinAnd(String string2, String string3, Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Iterator<T> iterator = collection.iterator();
        StringBuilder stringBuilder = new StringBuilder(Strings.toString(iterator.next()));
        int n2 = 1;
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (!Strings.notEmpty(t2)) continue;
            String string4 = ++n2 == collection.size() ? string3 : string2;
            stringBuilder.append(string4).append(Strings.toString(t2));
        }
        return stringBuilder.toString();
    }

    public static <T> String joinAnd(String string2, String string3, T ... TArray) {
        return Strings.joinAnd(string2, string3, Arrays.asList(TArray));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String md5(String var0) {
        try {
            var2_1 = MessageDigest.getInstance("MD5").digest(var0.getBytes("UTF-8"));
            var3_2 = new StringBuilder();
            var4_3 = var2_1.length;
            var5_4 = 0;
lbl6:
            // 2 sources

            while (true) {
                if (var5_4 >= var4_3) return var3_2.toString();
                var6_5 = Integer.toHexString(var2_1[var5_4]);
                if (var6_5.length() == 1) {
                    var3_2.append('0');
                    var3_2.append(var6_5.charAt(-1 + var6_5.length()));
                } else {
                    var3_2.append(var6_5.substring(-2 + var6_5.length()));
                }
                break;
            }
        }
        catch (Exception var1_6) {
            throw new RuntimeException(var1_6);
        }
        ++var5_4;
        ** while (true)
    }

    public static String namedFormat(String string2, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = string2.replace('$' + entry.getKey(), entry.getValue());
        }
        return string2;
    }

    public static String namedFormat(String string2, Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new InvalidParameterException("You must include one value for each parameter");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(objectArray.length / 2);
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            hashMap.put(Strings.toString(objectArray[i2]), Strings.toString(objectArray[i2 + 1]));
        }
        return Strings.namedFormat(string2, hashMap);
    }

    public static boolean notEmpty(Object object) {
        return Strings.toString(object).trim().length() != 0;
    }

    public static String toString(InputStream inputStream) {
        StringWriter stringWriter = new StringWriter();
        Strings.copy(new InputStreamReader(inputStream, Charset.forName("UTF-8")), stringWriter);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) {
        StringWriter stringWriter = new StringWriter();
        Strings.copy(reader, stringWriter);
        return stringWriter.toString();
    }

    public static String toString(Object object) {
        return Strings.toString(object, "");
    }

    public static String toString(Object object, String string2) {
        if (object == null) {
            return string2;
        }
        if (object instanceof InputStream) {
            return Strings.toString((InputStream)object);
        }
        if (object instanceof Reader) {
            return Strings.toString((Reader)object);
        }
        if (object instanceof Object[]) {
            return Strings.join(", ", (Object[])object);
        }
        if (object instanceof Collection) {
            return Strings.join(", ", (Collection)object);
        }
        return object.toString();
    }
}

