/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.Provider;

public class ZoneInfoProvider
implements Provider {
    private final File iFileDir;
    private final ClassLoader iLoader;
    private final String iResourcePath;
    private final Map<String, Object> iZoneInfoMap;

    public ZoneInfoProvider(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("No file directory provided");
        }
        if (!file.exists()) {
            throw new IOException("File directory doesn't exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IOException("File doesn't refer to a directory: " + file);
        }
        this.iFileDir = file;
        this.iResourcePath = null;
        this.iLoader = null;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public ZoneInfoProvider(String string2) throws IOException {
        this(string2, null, false);
    }

    public ZoneInfoProvider(String string2, ClassLoader classLoader) throws IOException {
        this(string2, classLoader, true);
    }

    private ZoneInfoProvider(String string2, ClassLoader classLoader, boolean bl2) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("No resource path provided");
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        this.iFileDir = null;
        this.iResourcePath = string2;
        if (classLoader == null && !bl2) {
            classLoader = this.getClass().getClassLoader();
        }
        this.iLoader = classLoader;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    /*
     * Unable to fully structure code
     */
    private DateTimeZone loadZoneData(String var1_1) {
        block18: {
            var3_3 = var8_2 = this.openResource(var1_1);
            var9_4 = DateTimeZoneBuilder.readFrom(var3_3, var1_1);
            this.iZoneInfoMap.put(var1_1, new SoftReference<DateTimeZone>(var9_4));
            if (var3_3 == null) break block18;
            try {
                var3_3.close();
            }
            catch (IOException var11_11) {
                return var9_4;
            }
        }
        return var9_4;
        catch (IOException var5_5) {
            var3_3 = null;
lbl14:
            // 2 sources

            while (true) {
                block19: {
                    this.uncaughtException((Exception)var5_6);
                    this.iZoneInfoMap.remove(var1_1);
                    if (var3_3 == null) break block19;
                    var3_3.close();
                }
lbl23:
                // 2 sources

                return null;
            }
        }
        catch (Throwable var2_8) {
            var3_3 = null;
lbl27:
            // 2 sources

            while (true) {
                if (var3_3 != null) {
                    var3_3.close();
                }
lbl31:
                // 4 sources

                throw var2_9;
            }
        }
        {
            catch (IOException var7_12) {
                ** continue;
            }
        }
        {
            catch (IOException var4_13) {
                ** continue;
            }
        }
        {
            catch (Throwable var2_10) {
                ** continue;
            }
        }
        catch (IOException var5_7) {
            ** continue;
        }
    }

    private static Map<String, Object> loadZoneInfoMap(InputStream inputStream) throws IOException {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ZoneInfoProvider.readZoneInfoMap(dataInputStream, concurrentHashMap);
        concurrentHashMap.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return concurrentHashMap;
        finally {
            dataInputStream.close();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private InputStream openResource(String string2) throws IOException {
        String string3;
        void var2_5;
        void var2_3;
        if (this.iFileDir != null) {
            FileInputStream fileInputStream = new FileInputStream(new File(this.iFileDir, string2));
            return var2_3;
        }
        String string4 = this.iResourcePath.concat(string2);
        if (this.iLoader != null) {
            InputStream inputStream = this.iLoader.getResourceAsStream(string4);
        } else {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string4);
        }
        if (var2_5 != null) return var2_3;
        StringBuilder stringBuilder = new StringBuilder(40).append("Resource not found: \"").append(string4).append("\" ClassLoader: ");
        if (this.iLoader != null) {
            string3 = this.iLoader.toString();
            throw new IOException(stringBuilder.append(string3).toString());
        }
        string3 = "system";
        throw new IOException(stringBuilder.append(string3).toString());
    }

    private static void readZoneInfoMap(DataInputStream dataInputStream, Map<String, Object> map) throws IOException {
        int n2 = 0;
        int n3 = dataInputStream.readUnsignedShort();
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            stringArray[i2] = dataInputStream.readUTF().intern();
        }
        int n4 = dataInputStream.readUnsignedShort();
        while (n2 < n4) {
            try {
                map.put(stringArray[dataInputStream.readUnsignedShort()], stringArray[dataInputStream.readUnsignedShort()]);
                ++n2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Corrupt zone info map");
            }
        }
    }

    @Override
    public Set<String> getAvailableIDs() {
        return new TreeSet<String>(this.iZoneInfoMap.keySet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DateTimeZone getZone(String string2) {
        if (string2 == null) {
            return null;
        }
        Object object = this.iZoneInfoMap.get(string2);
        if (object == null) {
            return null;
        }
        if (string2.equals(object)) {
            return this.loadZoneData(string2);
        }
        if (!(object instanceof SoftReference)) return this.getZone((String)object);
        DateTimeZone dateTimeZone = (DateTimeZone)((SoftReference)object).get();
        if (dateTimeZone != null) return dateTimeZone;
        return this.loadZoneData(string2);
    }

    protected void uncaughtException(Exception exception) {
        Thread thread = Thread.currentThread();
        thread.getThreadGroup().uncaughtException(thread, exception);
    }
}

