/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.MutableDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.LenientChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.DateTimeZoneBuilder;

public class ZoneInfoCompiler {
    static Chronology cLenientISO;
    static DateTimeOfYear cStartOfYear;
    static ThreadLocal<Boolean> cVerbose;
    private List<String> iLinks;
    private Map<String, RuleSet> iRuleSets = new HashMap<String, RuleSet>();
    private List<Zone> iZones = new ArrayList<Zone>();

    static {
        cVerbose = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }

    public ZoneInfoCompiler() {
        this.iLinks = new ArrayList<String>();
    }

    static Chronology getLenientISOChronology() {
        if (cLenientISO == null) {
            cLenientISO = LenientChronology.getInstance(ISOChronology.getInstanceUTC());
        }
        return cLenientISO;
    }

    static DateTimeOfYear getStartOfYear() {
        if (cStartOfYear == null) {
            cStartOfYear = new DateTimeOfYear();
        }
        return cStartOfYear;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        int n2;
        File file = null;
        int n3 = 0;
        if (stringArray.length == 0) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        boolean bl2 = false;
        File file2 = null;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            try {
                if ("-src".equals(stringArray[n2])) {
                    file2 = new File(stringArray[++n2]);
                    continue;
                }
                if ("-dst".equals(stringArray[n2])) {
                    file = new File(stringArray[++n2]);
                    continue;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ZoneInfoCompiler.printUsage();
                return;
            }
            {
                if ("-verbose".equals(stringArray[n2])) {
                    bl2 = true;
                    continue;
                }
                if (!"-?".equals(stringArray[n2])) break;
                ZoneInfoCompiler.printUsage();
                return;
            }
        }
        if (n2 >= stringArray.length) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File[] fileArray = new File[stringArray.length - n2];
        while (true) {
            if (n2 >= stringArray.length) {
                cVerbose.set(bl2);
                new ZoneInfoCompiler().compile(file, fileArray);
                return;
            }
            File file3 = file2 == null ? new File(stringArray[n2]) : new File(file2, stringArray[n2]);
            fileArray[n3] = file3;
            ++n2;
            ++n3;
        }
    }

    static int parseDayOfWeek(String string2) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().dayOfWeek();
        return dateTimeField.get(dateTimeField.set(0L, string2, Locale.ENGLISH));
    }

    static int parseMonth(String string2) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().monthOfYear();
        return dateTimeField.get(dateTimeField.set(0L, string2, Locale.ENGLISH));
    }

    static String parseOptional(String string2) {
        if (string2.equals("-")) {
            string2 = null;
        }
        return string2;
    }

    static int parseTime(String string2) {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.hourMinuteSecondFraction();
        MutableDateTime mutableDateTime = new MutableDateTime(0L, ZoneInfoCompiler.getLenientISOChronology());
        boolean bl2 = string2.startsWith("-");
        int n2 = 0;
        if (bl2) {
            n2 = 1;
        }
        if (dateTimeFormatter.parseInto(mutableDateTime, string2, n2) == ~n2) {
            throw new IllegalArgumentException(string2);
        }
        int n3 = (int)mutableDateTime.getMillis();
        if (n2 == 1) {
            return -n3;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int parseYear(String string2, int n2) {
        String string3 = string2.toLowerCase();
        if (string3.equals("minimum")) return Integer.MIN_VALUE;
        if (string3.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (string3.equals("maximum")) return Integer.MAX_VALUE;
        if (string3.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (string3.equals("only")) return n2;
        return Integer.parseInt(string3);
    }

    static char parseZoneChar(char c2) {
        switch (c2) {
            default: {
                return 'w';
            }
            case 'S': 
            case 's': {
                return 's';
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': 
        }
        return 'u';
    }

    private static void printUsage() {
        System.out.println("Usage: java org.joda.time.tz.ZoneInfoCompiler <options> <source files>");
        System.out.println("where possible options include:");
        System.out.println("  -src <directory>    Specify where to read source files");
        System.out.println("  -dst <directory>    Specify where to write generated files");
        System.out.println("  -verbose            Output verbosely (default false)");
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean test(String string2, DateTimeZone dateTimeZone) {
        if (!string2.equals(dateTimeZone.getID())) {
            return true;
        }
        long l2 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        long l3 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        int n2 = dateTimeZone.getOffset(l2);
        String string3 = dateTimeZone.getNameKey(l2);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l4 = l2;
        int n3 = n2;
        while (true) {
            long l5;
            if ((l5 = dateTimeZone.nextTransition(l4)) == l4 || l5 > l3) break;
            int n4 = dateTimeZone.getOffset(l5);
            String string4 = dateTimeZone.getNameKey(l5);
            if (n3 == n4 && string3.equals(string4)) {
                System.out.println("*d* Error in " + dateTimeZone.getID() + " " + new DateTime(l5, (Chronology)ISOChronology.getInstanceUTC()));
                return false;
            }
            if (string4 == null || string4.length() < 3 && !"??".equals(string4)) {
                System.out.println("*s* Error in " + dateTimeZone.getID() + " " + new DateTime(l5, (Chronology)ISOChronology.getInstanceUTC()) + ", nameKey=" + string4);
                return false;
            }
            arrayList.add(l5);
            string3 = string4;
            n3 = n4;
            l4 = l5;
        }
        long l6 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        long l7 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        int n5 = arrayList.size();
        long l8 = l6;
        long l9;
        int n6;
        while ((n6 = n5 - 1) >= 0 && (l9 = dateTimeZone.previousTransition(l8)) != l8 && l9 >= l7) {
            long l10 = (Long)arrayList.get(n6);
            if (l10 - 1L != l9) {
                System.out.println("*r* Error in " + dateTimeZone.getID() + " " + new DateTime(l9, (Chronology)ISOChronology.getInstanceUTC()) + " != " + new DateTime(l10 - 1L, (Chronology)ISOChronology.getInstanceUTC()));
                return false;
            }
            n5 = n6;
            l8 = l9;
        }
        return true;
    }

    public static boolean verbose() {
        return cVerbose.get();
    }

    static void writeZoneInfoMap(DataOutputStream dataOutputStream, Map<String, DateTimeZone> map) throws IOException {
        HashMap<String, Short> hashMap = new HashMap<String, Short>(map.size());
        TreeMap<Short, String> treeMap = new TreeMap<Short, String>();
        Iterator<Map.Entry<String, DateTimeZone>> iterator = map.entrySet().iterator();
        short s2 = 0;
        while (iterator.hasNext()) {
            short s3;
            String string2;
            Map.Entry<String, DateTimeZone> entry = iterator.next();
            String string3 = entry.getKey();
            if (!hashMap.containsKey(string3)) {
                Short s4 = s2;
                hashMap.put(string3, s4);
                treeMap.put(s4, string3);
                s2 = (short)(s2 + 1);
                if (s2 == 0) {
                    throw new InternalError("Too many time zone ids");
                }
            }
            if (!hashMap.containsKey(string2 = entry.getValue().getID())) {
                Short s5 = s2;
                hashMap.put(string2, s5);
                treeMap.put(s5, string2);
                s3 = (short)(s2 + 1);
                if (s3 == 0) {
                    throw new InternalError("Too many time zone ids");
                }
            } else {
                s3 = s2;
            }
            s2 = s3;
        }
        dataOutputStream.writeShort(treeMap.size());
        Iterator iterator2 = treeMap.values().iterator();
        while (iterator2.hasNext()) {
            dataOutputStream.writeUTF((String)iterator2.next());
        }
        dataOutputStream.writeShort(map.size());
        for (Map.Entry<String, DateTimeZone> entry : map.entrySet()) {
            dataOutputStream.writeShort(((Short)hashMap.get(entry.getKey())).shortValue());
            dataOutputStream.writeShort(((Short)hashMap.get(entry.getValue().getID())).shortValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, DateTimeZone> compile(File file, File[] fileArray) throws IOException {
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i2]));
                this.parseDataFile(bufferedReader);
                bufferedReader.close();
            }
        }
        if (file != null) {
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Destination directory doesn't exist and cannot be created: " + file);
            }
            if (!file.isDirectory()) {
                throw new IOException("Destination is not a directory: " + file);
            }
        }
        TreeMap<String, DateTimeZone> treeMap = new TreeMap<String, DateTimeZone>();
        System.out.println("Writing zoneinfo files");
        for (int i3 = 0; i3 < this.iZones.size(); ++i3) {
            File file2;
            Zone zone = this.iZones.get(i3);
            DateTimeZoneBuilder dateTimeZoneBuilder = new DateTimeZoneBuilder();
            zone.addToBuilder(dateTimeZoneBuilder, this.iRuleSets);
            DateTimeZone dateTimeZone = dateTimeZoneBuilder.toDateTimeZone(zone.iName, true);
            if (!ZoneInfoCompiler.test(dateTimeZone.getID(), dateTimeZone)) continue;
            treeMap.put(dateTimeZone.getID(), dateTimeZone);
            if (file == null) continue;
            if (ZoneInfoCompiler.verbose()) {
                System.out.println("Writing " + dateTimeZone.getID());
            }
            if (!(file2 = new File(file, dateTimeZone.getID())).getParentFile().exists()) {
                file2.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            dateTimeZoneBuilder.writeTo(zone.iName, fileOutputStream);
            FileInputStream fileInputStream = new FileInputStream(file2);
            DateTimeZone dateTimeZone2 = DateTimeZoneBuilder.readFrom(fileInputStream, dateTimeZone.getID());
            ((InputStream)fileInputStream).close();
            if (dateTimeZone.equals(dateTimeZone2)) continue;
            System.out.println("*e* Error in " + dateTimeZone.getID() + ": Didn't read properly from file");
            continue;
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        int n2 = 0;
        while (true) {
            if (n2 < 2) {
            } else {
                if (file == null) return treeMap;
                System.out.println("Writing ZoneInfoMap");
                File file3 = new File(file, "ZoneInfoMap");
                if (!file3.getParentFile().exists()) {
                    file3.getParentFile().mkdirs();
                }
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file3));
                try {
                    TreeMap<String, DateTimeZone> treeMap2 = new TreeMap<String, DateTimeZone>(String.CASE_INSENSITIVE_ORDER);
                    treeMap2.putAll(treeMap);
                    ZoneInfoCompiler.writeZoneInfoMap(dataOutputStream, treeMap2);
                    return treeMap;
                }
                finally {
                    dataOutputStream.close();
                }
            }
            for (int i4 = 0; i4 < this.iLinks.size(); i4 += 2) {
                String string2 = this.iLinks.get(i4);
                String string3 = this.iLinks.get(i4 + 1);
                DateTimeZone dateTimeZone = (DateTimeZone)treeMap.get(string2);
                if (dateTimeZone == null) {
                    if (n2 <= 0) continue;
                    System.out.println("Cannot find time zone '" + string2 + "' to link alias '" + string3 + "' to");
                    continue;
                }
                treeMap.put(string3, dateTimeZone);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseDataFile(BufferedReader bufferedReader) throws IOException {
        String string2;
        Zone zone = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3 = string2.trim();
            if (string3.length() == 0 || string3.charAt(0) == '#') continue;
            int n2 = string2.indexOf(35);
            if (n2 >= 0) {
                string2 = string2.substring(0, n2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
            if (Character.isWhitespace(string2.charAt(0)) && stringTokenizer.hasMoreTokens()) {
                if (zone == null) continue;
                zone.chain(stringTokenizer);
                continue;
            }
            if (zone != null) {
                this.iZones.add(zone);
            }
            if (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equalsIgnoreCase("Rule")) {
                    Rule rule = new Rule(stringTokenizer);
                    RuleSet ruleSet = this.iRuleSets.get(rule.iName);
                    if (ruleSet == null) {
                        RuleSet ruleSet2 = new RuleSet(rule);
                        this.iRuleSets.put(rule.iName, ruleSet2);
                    } else {
                        ruleSet.addRule(rule);
                    }
                    zone = null;
                    continue;
                }
                if (string4.equalsIgnoreCase("Zone")) {
                    zone = new Zone(stringTokenizer);
                    continue;
                }
                if (string4.equalsIgnoreCase("Link")) {
                    this.iLinks.add(stringTokenizer.nextToken());
                    this.iLinks.add(stringTokenizer.nextToken());
                    zone = null;
                    continue;
                }
                System.out.println("Unknown line: " + string2);
            }
            zone = null;
        }
        if (zone != null) {
            this.iZones.add(zone);
        }
    }

    static class DateTimeOfYear {
        public final boolean iAdvanceDayOfWeek;
        public final int iDayOfMonth;
        public final int iDayOfWeek;
        public final int iMillisOfDay;
        public final int iMonthOfYear;
        public final char iZoneChar;

        DateTimeOfYear() {
            this.iMonthOfYear = 1;
            this.iDayOfMonth = 1;
            this.iDayOfWeek = 0;
            this.iAdvanceDayOfWeek = false;
            this.iMillisOfDay = 0;
            this.iZoneChar = (char)119;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        DateTimeOfYear(StringTokenizer stringTokenizer) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block11: {
                int n8;
                block12: {
                    int n9;
                    block13: {
                        int n10;
                        n8 = 1;
                        if (!stringTokenizer.hasMoreTokens()) break block12;
                        n9 = ZoneInfoCompiler.parseMonth(stringTokenizer.nextToken());
                        if (!stringTokenizer.hasMoreTokens()) break block13;
                        String string2 = stringTokenizer.nextToken();
                        if (string2.startsWith("last")) {
                            n7 = ZoneInfoCompiler.parseDayOfWeek(string2.substring(4));
                            n6 = -1;
                            n10 = 0;
                        } else {
                            try {
                                int n11;
                                n6 = n11 = Integer.parseInt(string2);
                                n10 = 0;
                                n7 = 0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                int n12 = string2.indexOf(">=");
                                if (n12 > 0) {
                                    int n13 = Integer.parseInt(string2.substring(n12 + 2));
                                    int n14 = ZoneInfoCompiler.parseDayOfWeek(string2.substring(0, n12));
                                    n6 = n13;
                                    n7 = n14;
                                    n10 = n8;
                                }
                                int n15 = string2.indexOf("<=");
                                if (n15 <= 0) {
                                    throw new IllegalArgumentException(string2);
                                }
                                int n16 = Integer.parseInt(string2.substring(n15 + 2));
                                int n17 = ZoneInfoCompiler.parseDayOfWeek(string2.substring(0, n15));
                                n6 = n16;
                                n7 = n17;
                                n10 = 0;
                            }
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            String string3 = stringTokenizer.nextToken();
                            char c2 = ZoneInfoCompiler.parseZoneChar(string3.charAt(-1 + string3.length()));
                            if (string3.equals("24:00")) {
                                LocalDate localDate = n6 == -1 ? new LocalDate(2001, n9, n8).plusMonths(n8) : new LocalDate(2001, n9, n6).plusDays(n8);
                                if (n6 == -1) {
                                    n8 = 0;
                                }
                                int n18 = localDate.getMonthOfYear();
                                n6 = localDate.getDayOfMonth();
                                n7 = 1 + (1 + (n7 - 1)) % 7;
                                n5 = n18;
                                n4 = c2;
                                n3 = n8;
                                n2 = 0;
                                break block11;
                            } else {
                                n2 = ZoneInfoCompiler.parseTime(string3);
                                n5 = n9;
                                n3 = n10;
                                n4 = c2;
                            }
                            break block11;
                        } else {
                            n5 = n9;
                            n3 = n10;
                            n4 = 119;
                            n2 = 0;
                        }
                        break block11;
                    }
                    n4 = 119;
                    n6 = n8;
                    n5 = n9;
                    n3 = 0;
                    n2 = 0;
                    n7 = 0;
                    break block11;
                }
                n4 = 119;
                n6 = n8;
                n5 = n8;
                n3 = 0;
                n2 = 0;
                n7 = 0;
            }
            this.iMonthOfYear = n5;
            this.iDayOfMonth = n6;
            this.iDayOfWeek = n7;
            this.iAdvanceDayOfWeek = n3;
            this.iMillisOfDay = n2;
            this.iZoneChar = (char)n4;
        }

        public void addCutover(DateTimeZoneBuilder dateTimeZoneBuilder, int n2) {
            dateTimeZoneBuilder.addCutover(n2, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string2, int n2, int n3, int n4) {
            dateTimeZoneBuilder.addRecurringSavings(string2, n2, n3, n4, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public String toString() {
            return "MonthOfYear: " + this.iMonthOfYear + "\n" + "DayOfMonth: " + this.iDayOfMonth + "\n" + "DayOfWeek: " + this.iDayOfWeek + "\n" + "AdvanceDayOfWeek: " + this.iAdvanceDayOfWeek + "\n" + "MillisOfDay: " + this.iMillisOfDay + "\n" + "ZoneChar: " + this.iZoneChar + "\n";
        }
    }

    private static class Rule {
        public final DateTimeOfYear iDateTimeOfYear;
        public final int iFromYear;
        public final String iLetterS;
        public final String iName;
        public final int iSaveMillis;
        public final int iToYear;
        public final String iType;

        Rule(StringTokenizer stringTokenizer) {
            this.iName = stringTokenizer.nextToken().intern();
            this.iFromYear = ZoneInfoCompiler.parseYear(stringTokenizer.nextToken(), 0);
            this.iToYear = ZoneInfoCompiler.parseYear(stringTokenizer.nextToken(), this.iFromYear);
            if (this.iToYear < this.iFromYear) {
                throw new IllegalArgumentException();
            }
            this.iType = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
            this.iDateTimeOfYear = new DateTimeOfYear(stringTokenizer);
            this.iSaveMillis = ZoneInfoCompiler.parseTime(stringTokenizer.nextToken());
            this.iLetterS = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String formatName(String string2) {
            String string3;
            int n2 = string2.indexOf(47);
            if (n2 > 0) {
                if (this.iSaveMillis != 0) return string2.substring(n2 + 1).intern();
                return string2.substring(0, n2).intern();
            }
            int n3 = string2.indexOf("%s");
            if (n3 < 0) return string2;
            String string4 = string2.substring(0, n3);
            String string5 = string2.substring(n3 + 2);
            if (this.iLetterS == null) {
                string3 = string4.concat(string5);
                return string3.intern();
            }
            string3 = string4 + this.iLetterS + string5;
            return string3.intern();
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string2) {
            String string3 = this.formatName(string2);
            this.iDateTimeOfYear.addRecurring(dateTimeZoneBuilder, string3, this.iSaveMillis, this.iFromYear, this.iToYear);
        }

        public String toString() {
            return "[Rule]\nName: " + this.iName + "\n" + "FromYear: " + this.iFromYear + "\n" + "ToYear: " + this.iToYear + "\n" + "Type: " + this.iType + "\n" + this.iDateTimeOfYear + "SaveMillis: " + this.iSaveMillis + "\n" + "LetterS: " + this.iLetterS + "\n";
        }
    }

    private static class RuleSet {
        private List<Rule> iRules = new ArrayList<Rule>();

        RuleSet(Rule rule) {
            this.iRules.add(rule);
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string2) {
            for (int i2 = 0; i2 < this.iRules.size(); ++i2) {
                this.iRules.get(i2).addRecurring(dateTimeZoneBuilder, string2);
            }
        }

        void addRule(Rule rule) {
            if (!rule.iName.equals(this.iRules.get((int)0).iName)) {
                throw new IllegalArgumentException("Rule name mismatch");
            }
            this.iRules.add(rule);
        }
    }

    private static class Zone {
        public final String iFormat;
        public final String iName;
        private Zone iNext;
        public final int iOffsetMillis;
        public final String iRules;
        public final DateTimeOfYear iUntilDateTimeOfYear;
        public final int iUntilYear;

        private Zone(String string2, StringTokenizer stringTokenizer) {
            this.iName = string2.intern();
            this.iOffsetMillis = ZoneInfoCompiler.parseTime(stringTokenizer.nextToken());
            this.iRules = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
            this.iFormat = stringTokenizer.nextToken().intern();
            int n2 = Integer.MAX_VALUE;
            DateTimeOfYear dateTimeOfYear = ZoneInfoCompiler.getStartOfYear();
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    dateTimeOfYear = new DateTimeOfYear(stringTokenizer);
                }
            }
            this.iUntilYear = n2;
            this.iUntilDateTimeOfYear = dateTimeOfYear;
        }

        Zone(StringTokenizer stringTokenizer) {
            this(stringTokenizer.nextToken(), stringTokenizer);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void addToBuilder(Zone zone, DateTimeZoneBuilder dateTimeZoneBuilder, Map<String, RuleSet> map) {
            while (zone != null) {
                dateTimeZoneBuilder.setStandardOffset(zone.iOffsetMillis);
                if (zone.iRules == null) {
                    dateTimeZoneBuilder.setFixedSavings(zone.iFormat, 0);
                } else {
                    try {
                        int n2 = ZoneInfoCompiler.parseTime(zone.iRules);
                        dateTimeZoneBuilder.setFixedSavings(zone.iFormat, n2);
                    }
                    catch (Exception exception) {
                        RuleSet ruleSet = map.get(zone.iRules);
                        if (ruleSet == null) {
                            throw new IllegalArgumentException("Rules not found: " + zone.iRules);
                        }
                        ruleSet.addRecurring(dateTimeZoneBuilder, zone.iFormat);
                    }
                }
                if (zone.iUntilYear == Integer.MAX_VALUE) break;
                zone.iUntilDateTimeOfYear.addCutover(dateTimeZoneBuilder, zone.iUntilYear);
                zone = zone.iNext;
            }
        }

        public void addToBuilder(DateTimeZoneBuilder dateTimeZoneBuilder, Map<String, RuleSet> map) {
            Zone.addToBuilder(this, dateTimeZoneBuilder, map);
        }

        void chain(StringTokenizer stringTokenizer) {
            if (this.iNext != null) {
                this.iNext.chain(stringTokenizer);
                return;
            }
            this.iNext = new Zone(this.iName, stringTokenizer);
        }

        public String toString() {
            String string2 = "[Zone]\nName: " + this.iName + "\n" + "OffsetMillis: " + this.iOffsetMillis + "\n" + "Rules: " + this.iRules + "\n" + "Format: " + this.iFormat + "\n" + "UntilYear: " + this.iUntilYear + "\n" + this.iUntilDateTimeOfYear;
            if (this.iNext == null) {
                return string2;
            }
            return string2 + "...\n" + this.iNext.toString();
        }
    }
}

