/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.tz.CachedDateTimeZone;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.ZoneInfoCompiler;

public class DateTimeZoneBuilder {
    private final ArrayList<RuleSet> iRuleSets = new ArrayList(10);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addTransition(ArrayList<Transition> arrayList, Transition transition) {
        int n2 = arrayList.size();
        if (n2 == 0) {
            arrayList.add(transition);
            return true;
        }
        Transition transition2 = arrayList.get(n2 - 1);
        boolean bl2 = transition.isTransitionFrom(transition2);
        boolean bl3 = false;
        if (!bl2) return bl3;
        int n3 = 0;
        if (n2 >= 2) {
            n3 = arrayList.get(n2 - 2).getWallOffset();
        }
        int n4 = transition2.getWallOffset();
        long l2 = transition2.getMillis() + (long)n3;
        if (transition.getMillis() + (long)n4 != l2) {
            arrayList.add(transition);
            return true;
        }
        arrayList.remove(n2 - 1);
        return this.addTransition(arrayList, transition);
    }

    private static DateTimeZone buildFixedZone(String string2, String string3, int n2, int n3) {
        if ("UTC".equals(string2) && string2.equals(string3) && n2 == 0 && n3 == 0) {
            return DateTimeZone.UTC;
        }
        return new FixedDateTimeZone(string2, string3, n2, n3);
    }

    private RuleSet getLastRuleSet() {
        if (this.iRuleSets.size() == 0) {
            this.addCutover(Integer.MIN_VALUE, 'w', 1, 1, 0, false, 0);
        }
        return this.iRuleSets.get(-1 + this.iRuleSets.size());
    }

    public static DateTimeZone readFrom(DataInput dataInput, String string2) throws IOException {
        switch (dataInput.readUnsignedByte()) {
            default: {
                throw new IOException("Invalid encoding");
            }
            case 70: {
                DateTimeZone dateTimeZone = new FixedDateTimeZone(string2, dataInput.readUTF(), (int)DateTimeZoneBuilder.readMillis(dataInput), (int)DateTimeZoneBuilder.readMillis(dataInput));
                if (((DateTimeZone)dateTimeZone).equals(DateTimeZone.UTC)) {
                    dateTimeZone = DateTimeZone.UTC;
                }
                return dateTimeZone;
            }
            case 67: {
                return CachedDateTimeZone.forZone(PrecalculatedZone.readFrom(dataInput, string2));
            }
            case 80: 
        }
        return PrecalculatedZone.readFrom(dataInput, string2);
    }

    public static DateTimeZone readFrom(InputStream inputStream, String string2) throws IOException {
        if (inputStream instanceof DataInput) {
            return DateTimeZoneBuilder.readFrom((DataInput)((Object)inputStream), string2);
        }
        return DateTimeZoneBuilder.readFrom(new DataInputStream(inputStream), string2);
    }

    static long readMillis(DataInput dataInput) throws IOException {
        int n2 = dataInput.readUnsignedByte();
        switch (n2 >> 6) {
            default: {
                return 1800000L * (long)(n2 << 26 >> 26);
            }
            case 1: {
                return 60000L * (long)(n2 << 26 >> 2 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte());
            }
            case 2: {
                return 1000L * ((long)n2 << 58 >> 26 | (long)(dataInput.readUnsignedByte() << 24) | (long)(dataInput.readUnsignedByte() << 16) | (long)(dataInput.readUnsignedByte() << 8) | (long)dataInput.readUnsignedByte());
            }
            case 3: 
        }
        return dataInput.readLong();
    }

    /*
     * Enabled aggressive block sorting
     */
    static void writeMillis(DataOutput dataOutput, long l2) throws IOException {
        long l3;
        long l4;
        long l5;
        if (l2 % 1800000L == 0L && (l5 = l2 / 1800000L) << 58 >> 58 == l5) {
            dataOutput.writeByte((int)(l5 & 0x3FL));
            return;
        }
        if (l2 % 60000L == 0L && (l4 = l2 / 60000L) << 34 >> 34 == l4) {
            dataOutput.writeInt(0x40000000 | (int)(l4 & 0x3FFFFFFFL));
            return;
        }
        if (l2 % 1000L == 0L && (l3 = l2 / 1000L) << 26 >> 26 == l3) {
            dataOutput.writeByte(0x80 | (int)(0x3FL & l3 >> 32));
            dataOutput.writeInt((int)(l3 & 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        int n2 = l2 < 0L ? 255 : 192;
        dataOutput.writeByte(n2);
        dataOutput.writeLong(l2);
    }

    public DateTimeZoneBuilder addCutover(int n2, char c2, int n3, int n4, int n5, boolean bl2, int n6) {
        if (this.iRuleSets.size() > 0) {
            OfYear ofYear = new OfYear(c2, n3, n4, n5, bl2, n6);
            this.iRuleSets.get(-1 + this.iRuleSets.size()).setUpperLimit(n2, ofYear);
        }
        this.iRuleSets.add(new RuleSet());
        return this;
    }

    public DateTimeZoneBuilder addRecurringSavings(String string2, int n2, int n3, int n4, char c2, int n5, int n6, int n7, boolean bl2, int n8) {
        if (n3 <= n4) {
            Rule rule = new Rule(new Recurrence(new OfYear(c2, n5, n6, n7, bl2, n8), string2, n2), n3, n4);
            this.getLastRuleSet().addRule(rule);
        }
        return this;
    }

    public DateTimeZoneBuilder setFixedSavings(String string2, int n2) {
        this.getLastRuleSet().setFixedSavings(string2, n2);
        return this;
    }

    public DateTimeZoneBuilder setStandardOffset(int n2) {
        this.getLastRuleSet().setStandardOffset(n2);
        return this;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DateTimeZone toDateTimeZone(String var1_1, boolean var2_2) {
        if (var1_1 == null) {
            throw new IllegalArgumentException();
        }
        var3_3 = new ArrayList<Transition>();
        var4_4 = null;
        var5_5 = -9223372036854775808L;
        var7_6 = this.iRuleSets.size();
        block0: for (var8_7 = 0; var8_7 < var7_6; ++var8_7) {
            var10_8 = this.iRuleSets.get(var8_7);
            var11_9 = var10_8.firstTransition(var5_5);
            if (var11_9 == null) {
                var22_17 = var5_5;
lbl12:
                // 2 sources

                while (true) {
                    var5_5 = var22_17;
                    continue block0;
                    break;
                }
            }
            this.addTransition(var3_3, var11_9);
            var13_10 = var11_9.getMillis();
            var15_11 = var11_9.getSaveMillis();
            var16_12 = new RuleSet(var10_8);
            var17_13 = var15_11;
            var18_14 = var13_10;
            var20_15 /* !! */  = var4_4;
            while (true) {
                if ((var21_16 = var16_12.nextTransition(var18_14, var17_13)) == null || this.addTransition(var3_3, var21_16) && var20_15 /* !! */  != null) {
                    var22_17 = var16_12.getUpperLimit(var17_13);
                    var4_4 = var20_15 /* !! */ ;
                    ** continue;
                }
                var18_14 = var21_16.getMillis();
                var17_13 = var21_16.getSaveMillis();
                if (var20_15 /* !! */  != null || var8_7 != var7_6 - 1) continue;
                var20_15 /* !! */  = var16_12.buildTailZone(var1_1);
            }
        }
        if (var3_3.size() == 0) {
            if (var4_4 != null) lbl-1000:
            // 2 sources

            {
                return var4_4;
            }
            return DateTimeZoneBuilder.buildFixedZone(var1_1, "UTC", 0, 0);
        }
        if (var3_3.size() == 1 && var4_4 == null) {
            var9_18 = (Transition)var3_3.get(0);
            return DateTimeZoneBuilder.buildFixedZone(var1_1, var9_18.getNameKey(), var9_18.getWallOffset(), var9_18.getStandardOffset());
        }
        ** while (!(var4_4 = PrecalculatedZone.create((String)var1_1, (boolean)var2_2, var3_3, var4_4)).isCachable())
lbl42:
        // 1 sources

        return CachedDateTimeZone.forZone(var4_4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeTo(String string2, DataOutput dataOutput) throws IOException {
        DateTimeZone dateTimeZone = this.toDateTimeZone(string2, false);
        if (dateTimeZone instanceof FixedDateTimeZone) {
            dataOutput.writeByte(70);
            dataOutput.writeUTF(dateTimeZone.getNameKey(0L));
            DateTimeZoneBuilder.writeMillis(dataOutput, dateTimeZone.getOffset(0L));
            DateTimeZoneBuilder.writeMillis(dataOutput, dateTimeZone.getStandardOffset(0L));
            return;
        }
        if (dateTimeZone instanceof CachedDateTimeZone) {
            dataOutput.writeByte(67);
            dateTimeZone = ((CachedDateTimeZone)dateTimeZone).getUncachedZone();
        } else {
            dataOutput.writeByte(80);
        }
        ((PrecalculatedZone)dateTimeZone).writeTo(dataOutput);
    }

    public void writeTo(String string2, OutputStream outputStream) throws IOException {
        if (outputStream instanceof DataOutput) {
            this.writeTo(string2, (DataOutput)((Object)outputStream));
            return;
        }
        this.writeTo(string2, new DataOutputStream(outputStream));
    }

    private static final class DSTZone
    extends DateTimeZone {
        private static final long serialVersionUID = 6941492635554961361L;
        final Recurrence iEndRecurrence;
        final int iStandardOffset;
        final Recurrence iStartRecurrence;

        DSTZone(String string2, int n2, Recurrence recurrence, Recurrence recurrence2) {
            super(string2);
            this.iStandardOffset = n2;
            this.iStartRecurrence = recurrence;
            this.iEndRecurrence = recurrence2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Recurrence findMatchingRecurrence(long l2) {
            long l3;
            int n2 = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                long l4;
                l3 = l4 = recurrence.next(l2, n2, recurrence2.getSaveMillis());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l2;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l2;
            }
            try {
                long l5;
                l2 = l5 = recurrence2.next(l2, n2, recurrence.getSaveMillis());
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (l3 > l2) {
                return recurrence;
            }
            return recurrence2;
        }

        static DSTZone readFrom(DataInput dataInput, String string2) throws IOException {
            return new DSTZone(string2, (int)DateTimeZoneBuilder.readMillis(dataInput), Recurrence.readFrom(dataInput), Recurrence.readFrom(dataInput));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (!(object instanceof DSTZone)) {
                        return false;
                    }
                    DSTZone dSTZone = (DSTZone)object;
                    if (!this.getID().equals(dSTZone.getID()) || this.iStandardOffset != dSTZone.iStandardOffset || !this.iStartRecurrence.equals(dSTZone.iStartRecurrence) || !this.iEndRecurrence.equals(dSTZone.iEndRecurrence)) break block5;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getNameKey(long l2) {
            return this.findMatchingRecurrence(l2).getNameKey();
        }

        @Override
        public int getOffset(long l2) {
            return this.iStandardOffset + this.findMatchingRecurrence(l2).getSaveMillis();
        }

        @Override
        public int getStandardOffset(long l2) {
            return this.iStandardOffset;
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long nextTransition(long l2) {
            long l3;
            long l4;
            block10: {
                block9: {
                    long l5;
                    block8: {
                        int n2 = this.iStandardOffset;
                        Recurrence recurrence = this.iStartRecurrence;
                        Recurrence recurrence2 = this.iEndRecurrence;
                        try {
                            long l6;
                            long l7 = l6 = recurrence.next(l2, n2, recurrence2.getSaveMillis());
                            if (l2 > 0L && l7 < 0L) {
                                l7 = l2;
                            }
                            l4 = l7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            l4 = l2;
                        }
                        catch (ArithmeticException arithmeticException) {
                            l4 = l2;
                        }
                        try {
                            l5 = recurrence2.next(l2, n2, recurrence.getSaveMillis());
                            if (l2 <= 0L || l5 >= 0L) break block8;
                            break block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            l3 = l2;
                            break block10;
                        }
                        catch (ArithmeticException arithmeticException) {
                            l3 = l2;
                            break block10;
                        }
                    }
                    l2 = l5;
                }
                l3 = l2;
            }
            if (l4 > l3) {
                return l3;
            }
            return l4;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long previousTransition(long l2) {
            long l3;
            long l4;
            block10: {
                long l5;
                block9: {
                    long l6;
                    block8: {
                        l5 = l2 + 1L;
                        int n2 = this.iStandardOffset;
                        Recurrence recurrence = this.iStartRecurrence;
                        Recurrence recurrence2 = this.iEndRecurrence;
                        try {
                            long l7;
                            long l8 = l7 = recurrence.previous(l5, n2, recurrence2.getSaveMillis());
                            if (l5 < 0L && l8 > 0L) {
                                l8 = l5;
                            }
                            l4 = l8;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            l4 = l5;
                        }
                        catch (ArithmeticException arithmeticException) {
                            l4 = l5;
                        }
                        try {
                            l6 = recurrence2.previous(l5, n2, recurrence.getSaveMillis());
                            if (l5 >= 0L || l6 <= 0L) break block8;
                            break block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            l3 = l5;
                            break block10;
                        }
                        catch (ArithmeticException arithmeticException) {
                            l3 = l5;
                            break block10;
                        }
                    }
                    l5 = l6;
                }
                l3 = l5;
            }
            if (l4 > l3) {
                l3 = l4;
            }
            return l3 - 1L;
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            DateTimeZoneBuilder.writeMillis(dataOutput, this.iStandardOffset);
            this.iStartRecurrence.writeTo(dataOutput);
            this.iEndRecurrence.writeTo(dataOutput);
        }
    }

    private static final class OfYear {
        final boolean iAdvance;
        final int iDayOfMonth;
        final int iDayOfWeek;
        final int iMillisOfDay;
        final char iMode;
        final int iMonthOfYear;

        OfYear(char c2, int n2, int n3, int n4, boolean bl2, int n5) {
            if (c2 != 'u' && c2 != 'w' && c2 != 's') {
                throw new IllegalArgumentException("Unknown mode: " + c2);
            }
            this.iMode = c2;
            this.iMonthOfYear = n2;
            this.iDayOfMonth = n3;
            this.iDayOfWeek = n4;
            this.iAdvance = bl2;
            this.iMillisOfDay = n5;
        }

        static OfYear readFrom(DataInput dataInput) throws IOException {
            return new OfYear((char)dataInput.readUnsignedByte(), dataInput.readUnsignedByte(), dataInput.readByte(), dataInput.readUnsignedByte(), dataInput.readBoolean(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        private long setDayOfMonth(Chronology chronology, long l2) {
            if (this.iDayOfMonth >= 0) {
                return chronology.dayOfMonth().set(l2, this.iDayOfMonth);
            }
            long l3 = chronology.dayOfMonth().set(l2, 1);
            long l4 = chronology.monthOfYear().add(l3, 1);
            return chronology.dayOfMonth().add(l4, this.iDayOfMonth);
        }

        private long setDayOfMonthNext(Chronology chronology, long l2) {
            try {
                long l3 = this.setDayOfMonth(chronology, l2);
                return l3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l2)) {
                        l2 = chronology.year().add(l2, 1);
                    }
                    return this.setDayOfMonth(chronology, l2);
                }
                throw illegalArgumentException;
            }
        }

        private long setDayOfMonthPrevious(Chronology chronology, long l2) {
            try {
                long l3 = this.setDayOfMonth(chronology, l2);
                return l3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l2)) {
                        l2 = chronology.year().add(l2, -1);
                    }
                    return this.setDayOfMonth(chronology, l2);
                }
                throw illegalArgumentException;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long setDayOfWeek(Chronology chronology, long l2) {
            int n2 = chronology.dayOfWeek().get(l2);
            int n3 = this.iDayOfWeek - n2;
            if (n3 == 0) return l2;
            if (this.iAdvance) {
                if (n3 >= 0) return chronology.dayOfWeek().add(l2, n3);
                n3 += 7;
                return chronology.dayOfWeek().add(l2, n3);
            }
            if (n3 <= 0) return chronology.dayOfWeek().add(l2, n3);
            n3 -= 7;
            return chronology.dayOfWeek().add(l2, n3);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (!(object instanceof OfYear)) {
                        return false;
                    }
                    OfYear ofYear = (OfYear)object;
                    if (this.iMode != ofYear.iMode || this.iMonthOfYear != ofYear.iMonthOfYear || this.iDayOfMonth != ofYear.iDayOfMonth || this.iDayOfWeek != ofYear.iDayOfWeek || this.iAdvance != ofYear.iAdvance || this.iMillisOfDay != ofYear.iMillisOfDay) break block5;
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long next(long l2, int n2, int n3) {
            if (this.iMode == 'w') {
                n2 += n3;
            } else if (this.iMode != 's') {
                n2 = 0;
            }
            long l3 = l2 + (long)n2;
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l4 = ((Chronology)iSOChronology).monthOfYear().set(l3, this.iMonthOfYear);
            long l5 = ((Chronology)iSOChronology).millisOfDay().set(l4, 0);
            long l6 = this.setDayOfMonthNext(iSOChronology, ((Chronology)iSOChronology).millisOfDay().add(l5, this.iMillisOfDay));
            if (this.iDayOfWeek == 0) {
                if (l6 > l3) return l6 - (long)n2;
                l6 = this.setDayOfMonthNext(iSOChronology, ((Chronology)iSOChronology).year().add(l6, 1));
                return l6 - (long)n2;
            }
            if ((l6 = this.setDayOfWeek(iSOChronology, l6)) > l3) return l6 - (long)n2;
            long l7 = ((Chronology)iSOChronology).year().add(l6, 1);
            l6 = this.setDayOfWeek(iSOChronology, this.setDayOfMonthNext(iSOChronology, ((Chronology)iSOChronology).monthOfYear().set(l7, this.iMonthOfYear)));
            return l6 - (long)n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long previous(long l2, int n2, int n3) {
            if (this.iMode == 'w') {
                n2 += n3;
            } else if (this.iMode != 's') {
                n2 = 0;
            }
            long l3 = l2 + (long)n2;
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l4 = ((Chronology)iSOChronology).monthOfYear().set(l3, this.iMonthOfYear);
            long l5 = ((Chronology)iSOChronology).millisOfDay().set(l4, 0);
            long l6 = this.setDayOfMonthPrevious(iSOChronology, ((Chronology)iSOChronology).millisOfDay().add(l5, this.iMillisOfDay));
            if (this.iDayOfWeek == 0) {
                if (l6 < l3) return l6 - (long)n2;
                l6 = this.setDayOfMonthPrevious(iSOChronology, ((Chronology)iSOChronology).year().add(l6, -1));
                return l6 - (long)n2;
            }
            if ((l6 = this.setDayOfWeek(iSOChronology, l6)) < l3) return l6 - (long)n2;
            long l7 = ((Chronology)iSOChronology).year().add(l6, -1);
            l6 = this.setDayOfWeek(iSOChronology, this.setDayOfMonthPrevious(iSOChronology, ((Chronology)iSOChronology).monthOfYear().set(l7, this.iMonthOfYear)));
            return l6 - (long)n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long setInstant(int n2, int n3, int n4) {
            if (this.iMode == 'w') {
                n3 += n4;
            } else if (this.iMode != 's') {
                n3 = 0;
            }
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).year().set(0L, n2);
            long l3 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
            long l4 = this.setDayOfMonth(iSOChronology, ((Chronology)iSOChronology).millisOfDay().set(l3, this.iMillisOfDay));
            if (this.iDayOfWeek != 0) {
                l4 = this.setDayOfWeek(iSOChronology, l4);
            }
            return l4 - (long)n3;
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.iMode);
            dataOutput.writeByte(this.iMonthOfYear);
            dataOutput.writeByte(this.iDayOfMonth);
            dataOutput.writeByte(this.iDayOfWeek);
            dataOutput.writeBoolean(this.iAdvance);
            DateTimeZoneBuilder.writeMillis(dataOutput, this.iMillisOfDay);
        }
    }

    private static final class PrecalculatedZone
    extends DateTimeZone {
        private static final long serialVersionUID = 7811976468055766265L;
        private final String[] iNameKeys;
        private final int[] iStandardOffsets;
        private final DSTZone iTailZone;
        private final long[] iTransitions;
        private final int[] iWallOffsets;

        private PrecalculatedZone(String string2, long[] lArray, int[] nArray, int[] nArray2, String[] stringArray, DSTZone dSTZone) {
            super(string2);
            this.iTransitions = lArray;
            this.iWallOffsets = nArray;
            this.iStandardOffsets = nArray2;
            this.iNameKeys = stringArray;
            this.iTailZone = dSTZone;
        }

        /*
         * Enabled aggressive block sorting
         */
        static PrecalculatedZone create(String string2, boolean bl2, ArrayList<Transition> arrayList, DSTZone dSTZone) {
            String string3;
            DSTZone dSTZone2;
            ISOChronology iSOChronology;
            int n2 = arrayList.size();
            if (n2 == 0) {
                throw new IllegalArgumentException();
            }
            long[] lArray = new long[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray = new String[n2];
            Transition transition = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                Transition transition2 = arrayList.get(i2);
                if (!transition2.isTransitionFrom(transition)) {
                    throw new IllegalArgumentException(string2);
                }
                lArray[i2] = transition2.getMillis();
                nArray[i2] = transition2.getWallOffset();
                nArray2[i2] = transition2.getStandardOffset();
                stringArray[i2] = transition2.getNameKey();
                transition = transition2;
            }
            String[] stringArray2 = new String[5];
            String[][] stringArray3 = new DateFormatSymbols(Locale.ENGLISH).getZoneStrings();
            int n3 = 0;
            String[] stringArray4 = stringArray2;
            while (true) {
                String[] stringArray5;
                block13: {
                    block12: {
                        block11: {
                            if (n3 >= stringArray3.length) break block11;
                            stringArray5 = stringArray3[n3];
                            if (stringArray5 == null || stringArray5.length != 5 || !string2.equals(stringArray5[0])) break block12;
                            break block13;
                        }
                        iSOChronology = ISOChronology.getInstanceUTC();
                        break;
                    }
                    stringArray5 = stringArray4;
                }
                ++n3;
                stringArray4 = stringArray5;
            }
            for (int i3 = 0; i3 < -1 + stringArray.length; ++i3) {
                String string4 = stringArray[i3];
                String string5 = stringArray[i3 + 1];
                long l2 = nArray[i3];
                long l3 = nArray[i3 + 1];
                long l4 = nArray2[i3];
                long l5 = nArray2[i3 + 1];
                Period period = new Period(lArray[i3], lArray[i3 + 1], PeriodType.yearMonthDay(), iSOChronology);
                if (l2 == l3 || l4 != l5 || !string4.equals(string5) || period.getYears() != 0 || period.getMonths() <= 4 || period.getMonths() >= 8 || !string4.equals(stringArray4[2]) || !string4.equals(stringArray4[4])) continue;
                if (ZoneInfoCompiler.verbose()) {
                    System.out.println("Fixing duplicate name key - " + string5);
                    System.out.println("     - " + new DateTime(lArray[i3], (Chronology)iSOChronology) + " - " + new DateTime(lArray[i3 + 1], (Chronology)iSOChronology));
                }
                if (l2 > l3) {
                    stringArray[i3] = (string4 + "-Summer").intern();
                    continue;
                }
                if (l2 >= l3) continue;
                stringArray[i3 + 1] = (string5 + "-Summer").intern();
                ++i3;
            }
            if (dSTZone != null && dSTZone.iStartRecurrence.getNameKey().equals(dSTZone.iEndRecurrence.getNameKey())) {
                if (ZoneInfoCompiler.verbose()) {
                    System.out.println("Fixing duplicate recurrent name key - " + dSTZone.iStartRecurrence.getNameKey());
                }
                dSTZone2 = dSTZone.iStartRecurrence.getSaveMillis() > 0 ? new DSTZone(dSTZone.getID(), dSTZone.iStandardOffset, dSTZone.iStartRecurrence.renameAppend("-Summer"), dSTZone.iEndRecurrence) : new DSTZone(dSTZone.getID(), dSTZone.iStandardOffset, dSTZone.iStartRecurrence, dSTZone.iEndRecurrence.renameAppend("-Summer"));
            } else {
                dSTZone2 = dSTZone;
            }
            if (bl2) {
                string3 = string2;
                return new PrecalculatedZone(string3, lArray, nArray, nArray2, stringArray, dSTZone2);
            }
            string3 = "";
            return new PrecalculatedZone(string3, lArray, nArray, nArray2, stringArray, dSTZone2);
        }

        /*
         * Unable to fully structure code
         */
        static PrecalculatedZone readFrom(DataInput var0, String var1_1) throws IOException {
            var2_2 = var0.readUnsignedShort();
            var3_3 = new String[var2_2];
            for (var4_4 = 0; var4_4 < var2_2; ++var4_4) {
                var3_3[var4_4] = var0.readUTF();
            }
            var5_5 = var0.readInt();
            var6_6 = new long[var5_5];
            var7_7 = new int[var5_5];
            var8_8 = new int[var5_5];
            var9_9 = new String[var5_5];
            block4: for (var10_10 = 0; var10_10 < var5_5; ++var10_10) {
                var6_6[var10_10] = DateTimeZoneBuilder.readMillis(var0);
                var7_7[var10_10] = (int)DateTimeZoneBuilder.readMillis(var0);
                var8_8[var10_10] = (int)DateTimeZoneBuilder.readMillis(var0);
                if (var2_2 < 256) {
                    var15_12 = var0.readUnsignedByte();
lbl18:
                    // 2 sources

                    while (true) {
                        var9_9[var10_10] = var3_3[var15_12];
                        continue block4;
                        break;
                    }
                }
                try {
                    var15_12 = var14_11 = var0.readUnsignedShort();
                    ** continue;
                }
                catch (ArrayIndexOutOfBoundsException var13_13) {
                    throw new IOException("Invalid encoding");
                }
            }
            var11_14 = var0.readBoolean();
            var12_15 = null;
            if (var11_14) {
                var12_15 = DSTZone.readFrom(var0, var1_1);
            }
            return new PrecalculatedZone(var1_1, var6_6, var7_7, var8_8, var9_9, var12_15);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            if (this == object) return true;
            if (!(object instanceof PrecalculatedZone)) {
                return false;
            }
            PrecalculatedZone precalculatedZone = (PrecalculatedZone)object;
            if (!this.getID().equals(precalculatedZone.getID()) || !Arrays.equals(this.iTransitions, precalculatedZone.iTransitions) || !Arrays.equals(this.iNameKeys, precalculatedZone.iNameKeys) || !Arrays.equals(this.iWallOffsets, precalculatedZone.iWallOffsets) || !Arrays.equals(this.iStandardOffsets, precalculatedZone.iStandardOffsets)) return false;
            if (this.iTailZone == null) {
                if (precalculatedZone.iTailZone != null) return false;
                return true;
            }
            if (this.iTailZone.equals(precalculatedZone.iTailZone)) return true;
            return false;
        }

        @Override
        public String getNameKey(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                return this.iNameKeys[n2];
            }
            int n3 = ~n2;
            if (n3 < lArray.length) {
                if (n3 > 0) {
                    return this.iNameKeys[n3 - 1];
                }
                return "UTC";
            }
            if (this.iTailZone == null) {
                return this.iNameKeys[n3 - 1];
            }
            return this.iTailZone.getNameKey(l2);
        }

        @Override
        public int getOffset(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                return this.iWallOffsets[n2];
            }
            int n3 = ~n2;
            if (n3 < lArray.length) {
                if (n3 > 0) {
                    return this.iWallOffsets[n3 - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iWallOffsets[n3 - 1];
            }
            return this.iTailZone.getOffset(l2);
        }

        @Override
        public int getStandardOffset(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                return this.iStandardOffsets[n2];
            }
            int n3 = ~n2;
            if (n3 < lArray.length) {
                if (n3 > 0) {
                    return this.iStandardOffsets[n3 - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iStandardOffsets[n3 - 1];
            }
            return this.iTailZone.getStandardOffset(l2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean isCachable() {
            block6: {
                block5: {
                    if (this.iTailZone != null) break block5;
                    long[] lArray = this.iTransitions;
                    if (lArray.length <= 1) {
                        return false;
                    }
                    double d2 = 0.0;
                    int n2 = 0;
                    for (int i2 = 1; i2 < lArray.length; ++i2) {
                        long l2 = lArray[i2] - lArray[i2 - 1];
                        if (l2 >= 63158400000L) continue;
                        d2 += (double)l2;
                        ++n2;
                    }
                    if (n2 <= 0 || !(d2 / (double)n2 / 8.64E7 >= 25.0)) break block6;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long nextTransition(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            int n3 = n2 >= 0 ? n2 + 1 : ~n2;
            if (n3 < lArray.length) {
                return lArray[n3];
            }
            if (this.iTailZone == null) return l2;
            long l3 = lArray[-1 + lArray.length];
            if (l2 >= l3) return this.iTailZone.nextTransition(l2);
            l2 = l3;
            return this.iTailZone.nextTransition(l2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long previousTransition(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                if (l2 <= Long.MIN_VALUE) return l2;
                --l2;
                return l2;
            }
            int n3 = ~n2;
            if (n3 < lArray.length) {
                long l3;
                if (n3 <= 0 || (l3 = lArray[n3 - 1]) <= Long.MIN_VALUE) return l2;
                return l3 - 1L;
            } else {
                long l4;
                if (this.iTailZone != null && (l4 = this.iTailZone.previousTransition(l2)) < l2) {
                    return l4;
                }
                long l5 = lArray[n3 - 1];
                if (l5 <= Long.MIN_VALUE) return l2;
                return l5 - 1L;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeTo(DataOutput dataOutput) throws IOException {
            int n2 = this.iTransitions.length;
            HashSet<String> hashSet = new HashSet<String>();
            for (int i2 = 0; i2 < n2; ++i2) {
                hashSet.add(this.iNameKeys[i2]);
            }
            int n3 = hashSet.size();
            if (n3 > 65535) {
                throw new UnsupportedOperationException("String pool is too large");
            }
            String[] stringArray = new String[n3];
            Iterator iterator = hashSet.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                stringArray[n4] = (String)iterator.next();
                ++n4;
            }
            dataOutput.writeShort(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                dataOutput.writeUTF(stringArray[i3]);
            }
            dataOutput.writeInt(n2);
            int n5 = 0;
            while (true) {
                String string2;
                if (n5 < n2) {
                    DateTimeZoneBuilder.writeMillis(dataOutput, this.iTransitions[n5]);
                    DateTimeZoneBuilder.writeMillis(dataOutput, this.iWallOffsets[n5]);
                    DateTimeZoneBuilder.writeMillis(dataOutput, this.iStandardOffsets[n5]);
                    string2 = this.iNameKeys[n5];
                } else {
                    DSTZone dSTZone = this.iTailZone;
                    boolean bl2 = false;
                    if (dSTZone != null) {
                        bl2 = true;
                    }
                    dataOutput.writeBoolean(bl2);
                    if (this.iTailZone != null) {
                        this.iTailZone.writeTo(dataOutput);
                    }
                    return;
                }
                for (int i4 = 0; i4 < n3; ++i4) {
                    if (!stringArray[i4].equals(string2)) continue;
                    if (n3 < 256) {
                        dataOutput.writeByte(i4);
                        break;
                    }
                    dataOutput.writeShort(i4);
                    break;
                }
                ++n5;
            }
        }
    }

    private static final class Recurrence {
        final String iNameKey;
        final OfYear iOfYear;
        final int iSaveMillis;

        Recurrence(OfYear ofYear, String string2, int n2) {
            this.iOfYear = ofYear;
            this.iNameKey = string2;
            this.iSaveMillis = n2;
        }

        static Recurrence readFrom(DataInput dataInput) throws IOException {
            return new Recurrence(OfYear.readFrom(dataInput), dataInput.readUTF(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (!(object instanceof Recurrence)) {
                        return false;
                    }
                    Recurrence recurrence = (Recurrence)object;
                    if (this.iSaveMillis != recurrence.iSaveMillis || !this.iNameKey.equals(recurrence.iNameKey) || !this.iOfYear.equals(recurrence.iOfYear)) break block5;
                }
                return true;
            }
            return false;
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public OfYear getOfYear() {
            return this.iOfYear;
        }

        public int getSaveMillis() {
            return this.iSaveMillis;
        }

        public long next(long l2, int n2, int n3) {
            return this.iOfYear.next(l2, n2, n3);
        }

        public long previous(long l2, int n2, int n3) {
            return this.iOfYear.previous(l2, n2, n3);
        }

        Recurrence rename(String string2) {
            return new Recurrence(this.iOfYear, string2, this.iSaveMillis);
        }

        Recurrence renameAppend(String string2) {
            return this.rename((this.iNameKey + string2).intern());
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            this.iOfYear.writeTo(dataOutput);
            dataOutput.writeUTF(this.iNameKey);
            DateTimeZoneBuilder.writeMillis(dataOutput, this.iSaveMillis);
        }
    }

    private static final class Rule {
        final int iFromYear;
        final Recurrence iRecurrence;
        final int iToYear;

        Rule(Recurrence recurrence, int n2, int n3) {
            this.iRecurrence = recurrence;
            this.iFromYear = n2;
            this.iToYear = n3;
        }

        public int getFromYear() {
            return this.iFromYear;
        }

        public String getNameKey() {
            return this.iRecurrence.getNameKey();
        }

        public OfYear getOfYear() {
            return this.iRecurrence.getOfYear();
        }

        public int getSaveMillis() {
            return this.iRecurrence.getSaveMillis();
        }

        public int getToYear() {
            return this.iToYear;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long next(long l2, int n2, int n3) {
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            int n4 = n2 + n3;
            int n5 = l2 == Long.MIN_VALUE ? Integer.MIN_VALUE : ((Chronology)iSOChronology).year().get(l2 + (long)n4);
            long l3 = n5 < this.iFromYear ? ((Chronology)iSOChronology).year().set(0L, this.iFromYear) - (long)n4 - 1L : l2;
            long l4 = this.iRecurrence.next(l3, n2, n3);
            if (l4 > l2 && ((Chronology)iSOChronology).year().get(l4 + (long)n4) > this.iToYear) {
                return l2;
            }
            return l4;
        }
    }

    private static final class RuleSet {
        private static final int YEAR_LIMIT;
        private String iInitialNameKey;
        private int iInitialSaveMillis;
        private ArrayList<Rule> iRules;
        private int iStandardOffset;
        private OfYear iUpperOfYear;
        private int iUpperYear;

        static {
            long l2 = DateTimeUtils.currentTimeMillis();
            YEAR_LIMIT = 100 + ISOChronology.getInstanceUTC().year().get(l2);
        }

        RuleSet() {
            this.iRules = new ArrayList(10);
            this.iUpperYear = Integer.MAX_VALUE;
        }

        RuleSet(RuleSet ruleSet) {
            this.iStandardOffset = ruleSet.iStandardOffset;
            this.iRules = new ArrayList<Rule>(ruleSet.iRules);
            this.iInitialNameKey = ruleSet.iInitialNameKey;
            this.iInitialSaveMillis = ruleSet.iInitialSaveMillis;
            this.iUpperYear = ruleSet.iUpperYear;
            this.iUpperOfYear = ruleSet.iUpperOfYear;
        }

        public void addRule(Rule rule) {
            if (!this.iRules.contains(rule)) {
                this.iRules.add(rule);
            }
        }

        public DSTZone buildTailZone(String string2) {
            if (this.iRules.size() == 2) {
                Rule rule = this.iRules.get(0);
                Rule rule2 = this.iRules.get(1);
                if (rule.getToYear() == Integer.MAX_VALUE && rule2.getToYear() == Integer.MAX_VALUE) {
                    return new DSTZone(string2, this.iStandardOffset, rule.iRecurrence, rule2.iRecurrence);
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Transition firstTransition(long l2) {
            Transition transition;
            ArrayList<Rule> arrayList;
            block8: {
                Transition transition2;
                if (this.iInitialNameKey != null) {
                    return new Transition(l2, this.iInitialNameKey, this.iStandardOffset + this.iInitialSaveMillis, this.iStandardOffset);
                }
                arrayList = new ArrayList<Rule>(this.iRules);
                long l3 = Long.MIN_VALUE;
                int n2 = 0;
                Transition transition3 = null;
                while ((transition2 = this.nextTransition(l3, n2)) != null) {
                    block9: {
                        l3 = transition2.getMillis();
                        if (l3 == l2) {
                            transition = new Transition(l2, transition2);
                            break block8;
                        }
                        if (l3 > l2) {
                            if (transition3 == null) {
                                for (Rule rule : arrayList) {
                                    if (rule.getSaveMillis() != 0) continue;
                                    transition = new Transition(l2, rule, this.iStandardOffset);
                                    break block9;
                                }
                            }
                        } else {
                            Transition transition4 = new Transition(l2, transition2);
                            n2 = transition2.getSaveMillis();
                            transition3 = transition4;
                            continue;
                        }
                        transition = transition3;
                    }
                    if (transition == null) {
                        transition = new Transition(l2, transition2.getNameKey(), this.iStandardOffset, this.iStandardOffset);
                    }
                    break block8;
                }
                transition = transition3;
            }
            this.iRules = arrayList;
            return transition;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public long getUpperLimit(int n2) {
            if (this.iUpperYear == Integer.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Transition nextTransition(long l2, int n2) {
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l3 = Long.MAX_VALUE;
            Iterator<Rule> iterator = this.iRules.iterator();
            Rule rule = null;
            while (iterator.hasNext()) {
                long l4;
                Rule rule2;
                Rule rule3 = iterator.next();
                long l5 = rule3.next(l2, this.iStandardOffset, n2);
                if (l5 <= l2) {
                    iterator.remove();
                    continue;
                }
                if (l5 <= l3) {
                    rule2 = rule3;
                    l4 = l5;
                } else {
                    l4 = l3;
                    rule2 = rule;
                }
                l3 = l4;
                rule = rule2;
            }
            if (rule == null || ((Chronology)iSOChronology).year().get(l3) >= YEAR_LIMIT || this.iUpperYear < Integer.MAX_VALUE && l3 >= this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, n2)) {
                return null;
            }
            return new Transition(l3, rule, this.iStandardOffset);
        }

        public void setFixedSavings(String string2, int n2) {
            this.iInitialNameKey = string2;
            this.iInitialSaveMillis = n2;
        }

        public void setStandardOffset(int n2) {
            this.iStandardOffset = n2;
        }

        public void setUpperLimit(int n2, OfYear ofYear) {
            this.iUpperYear = n2;
            this.iUpperOfYear = ofYear;
        }
    }

    private static final class Transition {
        private final long iMillis;
        private final String iNameKey;
        private final int iStandardOffset;
        private final int iWallOffset;

        Transition(long l2, String string2, int n2, int n3) {
            this.iMillis = l2;
            this.iNameKey = string2;
            this.iWallOffset = n2;
            this.iStandardOffset = n3;
        }

        Transition(long l2, Rule rule, int n2) {
            this.iMillis = l2;
            this.iNameKey = rule.getNameKey();
            this.iWallOffset = n2 + rule.getSaveMillis();
            this.iStandardOffset = n2;
        }

        Transition(long l2, Transition transition) {
            this.iMillis = l2;
            this.iNameKey = transition.iNameKey;
            this.iWallOffset = transition.iWallOffset;
            this.iStandardOffset = transition.iStandardOffset;
        }

        public long getMillis() {
            return this.iMillis;
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public int getSaveMillis() {
            return this.iWallOffset - this.iStandardOffset;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public int getWallOffset() {
            return this.iWallOffset;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean isTransitionFrom(Transition transition) {
            return transition == null || this.iMillis > transition.iMillis && (this.iWallOffset != transition.iWallOffset || !this.iNameKey.equals(transition.iNameKey));
        }
    }
}

