/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import org.joda.time.DateTimeZone;

public class CachedDateTimeZone
extends DateTimeZone {
    private static final int cInfoCacheMask = 0;
    private static final long serialVersionUID = 5472298452022250685L;
    private final Info[] iInfoCache = new Info[1 + cInfoCacheMask];
    private final DateTimeZone iZone;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        int n2;
        Integer n3;
        try {
            Integer n4;
            n3 = n4 = Integer.getInteger("org.joda.time.tz.CachedDateTimeZone.size");
        }
        catch (SecurityException securityException) {
            n3 = null;
        }
        if (n3 == null) {
            n2 = 512;
        } else {
            int n5 = 0;
            for (int i2 = -1 + n3; i2 > 0; ++n5, i2 >>= 1) {
            }
            n2 = 1 << n5;
        }
        cInfoCacheMask = n2 - 1;
    }

    private CachedDateTimeZone(DateTimeZone dateTimeZone) {
        super(dateTimeZone.getID());
        this.iZone = dateTimeZone;
    }

    private Info createInfo(long l2) {
        long l3 = l2 & 0xFFFFFFFF00000000L;
        Info info = new Info(this.iZone, l3);
        long l4 = l3 | 0xFFFFFFFFL;
        Info info2 = info;
        long l5;
        while ((l5 = this.iZone.nextTransition(l3)) != l3 && l5 <= l4) {
            Info info3;
            info2.iNextInfo = info3 = new Info(this.iZone, l5);
            info2 = info3;
            l3 = l5;
        }
        return info;
    }

    public static CachedDateTimeZone forZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone instanceof CachedDateTimeZone) {
            return (CachedDateTimeZone)dateTimeZone;
        }
        return new CachedDateTimeZone(dateTimeZone);
    }

    private Info getInfo(long l2) {
        Info[] infoArray = this.iInfoCache;
        int n2 = (int)(l2 >> 32);
        int n3 = n2 & cInfoCacheMask;
        Info info = infoArray[n3];
        if (info == null || (int)(info.iPeriodStart >> 32) != n2) {
            infoArray[n3] = info = this.createInfo(l2);
        }
        return info;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CachedDateTimeZone) {
            return this.iZone.equals(((CachedDateTimeZone)object).iZone);
        }
        return false;
    }

    @Override
    public String getNameKey(long l2) {
        return this.getInfo(l2).getNameKey(l2);
    }

    @Override
    public int getOffset(long l2) {
        return this.getInfo(l2).getOffset(l2);
    }

    @Override
    public int getStandardOffset(long l2) {
        return this.getInfo(l2).getStandardOffset(l2);
    }

    public DateTimeZone getUncachedZone() {
        return this.iZone;
    }

    @Override
    public int hashCode() {
        return this.iZone.hashCode();
    }

    @Override
    public boolean isFixed() {
        return this.iZone.isFixed();
    }

    @Override
    public long nextTransition(long l2) {
        return this.iZone.nextTransition(l2);
    }

    @Override
    public long previousTransition(long l2) {
        return this.iZone.previousTransition(l2);
    }

    private static final class Info {
        private String iNameKey;
        Info iNextInfo;
        private int iOffset = Integer.MIN_VALUE;
        public final long iPeriodStart;
        private int iStandardOffset = Integer.MIN_VALUE;
        public final DateTimeZone iZoneRef;

        Info(DateTimeZone dateTimeZone, long l2) {
            this.iPeriodStart = l2;
            this.iZoneRef = dateTimeZone;
        }

        public String getNameKey(long l2) {
            if (this.iNextInfo == null || l2 < this.iNextInfo.iPeriodStart) {
                if (this.iNameKey == null) {
                    this.iNameKey = this.iZoneRef.getNameKey(this.iPeriodStart);
                }
                return this.iNameKey;
            }
            return this.iNextInfo.getNameKey(l2);
        }

        public int getOffset(long l2) {
            if (this.iNextInfo == null || l2 < this.iNextInfo.iPeriodStart) {
                if (this.iOffset == Integer.MIN_VALUE) {
                    this.iOffset = this.iZoneRef.getOffset(this.iPeriodStart);
                }
                return this.iOffset;
            }
            return this.iNextInfo.getOffset(l2);
        }

        public int getStandardOffset(long l2) {
            if (this.iNextInfo == null || l2 < this.iNextInfo.iPeriodStart) {
                if (this.iStandardOffset == Integer.MIN_VALUE) {
                    this.iStandardOffset = this.iZoneRef.getStandardOffset(this.iPeriodStart);
                }
                return this.iStandardOffset;
            }
            return this.iNextInfo.getStandardOffset(l2);
        }
    }
}

