/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class PeriodFormatterBuilder {
    private static final int DAYS = 3;
    private static final int HOURS = 4;
    private static final int MAX_FIELD = 9;
    private static final int MILLIS = 7;
    private static final int MINUTES = 5;
    private static final int MONTHS = 1;
    private static final int PRINT_ZERO_ALWAYS = 4;
    private static final int PRINT_ZERO_IF_SUPPORTED = 3;
    private static final int PRINT_ZERO_NEVER = 5;
    private static final int PRINT_ZERO_RARELY_FIRST = 1;
    private static final int PRINT_ZERO_RARELY_LAST = 2;
    private static final int SECONDS = 6;
    private static final int SECONDS_MILLIS = 8;
    private static final int SECONDS_OPTIONAL_MILLIS = 9;
    private static final int WEEKS = 2;
    private static final int YEARS;
    private List<Object> iElementPairs;
    private FieldFormatter[] iFieldFormatters;
    private int iMaxParsedDigits;
    private int iMinPrintedDigits;
    private boolean iNotParser;
    private boolean iNotPrinter;
    private PeriodFieldAffix iPrefix;
    private int iPrintZeroSetting;
    private boolean iRejectSignedValues;

    public PeriodFormatterBuilder() {
        this.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private PeriodFormatterBuilder append0(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        boolean bl2 = true;
        this.iElementPairs.add(periodPrinter);
        this.iElementPairs.add(periodParser);
        boolean bl3 = this.iNotPrinter;
        boolean bl4 = periodPrinter == null ? bl2 : false;
        this.iNotPrinter = bl4 | bl3;
        boolean bl5 = this.iNotParser;
        if (periodParser != null) {
            bl2 = false;
        }
        this.iNotParser = bl5 | bl2;
        return this;
    }

    private void appendField(int n2) {
        this.appendField(n2, this.iMinPrintedDigits);
    }

    private void appendField(int n2, int n3) {
        FieldFormatter fieldFormatter = new FieldFormatter(n3, this.iPrintZeroSetting, this.iMaxParsedDigits, this.iRejectSignedValues, n2, this.iFieldFormatters, this.iPrefix, null);
        this.append0(fieldFormatter, fieldFormatter);
        this.iFieldFormatters[n2] = fieldFormatter;
        this.iPrefix = null;
    }

    private PeriodFormatterBuilder appendPrefix(PeriodFieldAffix periodFieldAffix) {
        if (periodFieldAffix == null) {
            throw new IllegalArgumentException();
        }
        if (this.iPrefix != null) {
            periodFieldAffix = new CompositeAffix(this.iPrefix, periodFieldAffix);
        }
        this.iPrefix = periodFieldAffix;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private PeriodFormatterBuilder appendSeparator(String string2, String string3, String[] stringArray, boolean bl2, boolean bl3) {
        List<Object> list;
        Separator separator;
        block6: {
            int n2;
            if (string2 == null || string3 == null) {
                throw new IllegalArgumentException();
            }
            this.clearPrefix();
            List<Object> list2 = this.iElementPairs;
            if (list2.size() == 0) {
                if (bl3 && !bl2) {
                    Separator separator2 = new Separator(string2, string3, stringArray, Literal.EMPTY, Literal.EMPTY, bl2, bl3);
                    this.append0(separator2, separator2);
                }
                return this;
            }
            int n3 = list2.size();
            while ((n2 = n3 - 1) >= 0) {
                if (list2.get(n2) instanceof Separator) {
                    separator = (Separator)list2.get(n2);
                    list = list2.subList(n2 + 1, list2.size());
                    break block6;
                }
                n3 = n2 - 1;
            }
            list = list2;
            separator = null;
        }
        if (separator != null && list.size() == 0) {
            throw new IllegalStateException("Cannot have two adjacent separators");
        }
        Object[] objectArray = PeriodFormatterBuilder.createComposite(list);
        list.clear();
        Separator separator3 = new Separator(string2, string3, stringArray, (PeriodPrinter)objectArray[0], (PeriodParser)objectArray[1], bl2, bl3);
        list.add(separator3);
        list.add(separator3);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private PeriodFormatterBuilder appendSuffix(PeriodFieldAffix periodFieldAffix) {
        Object object;
        Object object2;
        if (this.iElementPairs.size() > 0) {
            Object object3 = this.iElementPairs.get(-2 + this.iElementPairs.size());
            Object object4 = this.iElementPairs.get(-1 + this.iElementPairs.size());
            object2 = object3;
            object = object4;
        } else {
            object2 = null;
            object = null;
        }
        if (object2 != null && object != null && object2 == object && object2 instanceof FieldFormatter) {
            this.clearPrefix();
            FieldFormatter fieldFormatter = new FieldFormatter((FieldFormatter)object2, periodFieldAffix);
            this.iElementPairs.set(-2 + this.iElementPairs.size(), fieldFormatter);
            this.iElementPairs.set(-1 + this.iElementPairs.size(), fieldFormatter);
            this.iFieldFormatters[fieldFormatter.getFieldType()] = fieldFormatter;
            return this;
        }
        throw new IllegalStateException("No field to apply suffix to");
    }

    private void clearPrefix() throws IllegalStateException {
        if (this.iPrefix != null) {
            throw new IllegalStateException("Prefix not followed by field");
        }
        this.iPrefix = null;
    }

    private static Object[] createComposite(List<Object> list) {
        switch (list.size()) {
            default: {
                Composite composite = new Composite(list);
                return new Object[]{composite, composite};
            }
            case 0: {
                Object[] objectArray = new Object[]{Literal.EMPTY, Literal.EMPTY};
                return objectArray;
            }
            case 1: 
        }
        Object[] objectArray = new Object[]{list.get(0), list.get(1)};
        return objectArray;
    }

    private static PeriodFormatter toFormatter(List<Object> list, boolean bl2, boolean bl3) {
        Separator separator;
        if (bl2 && bl3) {
            throw new IllegalStateException("Builder has created neither a printer nor a parser");
        }
        int n2 = list.size();
        if (n2 >= 2 && list.get(0) instanceof Separator && (separator = (Separator)list.get(0)).iAfterParser == null && separator.iAfterPrinter == null) {
            PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(list.subList(2, n2), bl2, bl3);
            Separator separator2 = separator.finish(periodFormatter.getPrinter(), periodFormatter.getParser());
            return new PeriodFormatter(separator2, separator2);
        }
        Object[] objectArray = PeriodFormatterBuilder.createComposite(list);
        if (bl2) {
            return new PeriodFormatter(null, (PeriodParser)objectArray[1]);
        }
        if (bl3) {
            return new PeriodFormatter((PeriodPrinter)objectArray[0], null);
        }
        return new PeriodFormatter((PeriodPrinter)objectArray[0], (PeriodParser)objectArray[1]);
    }

    public PeriodFormatterBuilder append(PeriodFormatter periodFormatter) {
        if (periodFormatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        this.clearPrefix();
        this.append0(periodFormatter.getPrinter(), periodFormatter.getParser());
        return this;
    }

    public PeriodFormatterBuilder append(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        if (periodPrinter == null && periodParser == null) {
            throw new IllegalArgumentException("No printer or parser supplied");
        }
        this.clearPrefix();
        this.append0(periodPrinter, periodParser);
        return this;
    }

    public PeriodFormatterBuilder appendDays() {
        this.appendField(3);
        return this;
    }

    public PeriodFormatterBuilder appendHours() {
        this.appendField(4);
        return this;
    }

    public PeriodFormatterBuilder appendLiteral(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        this.clearPrefix();
        Literal literal = new Literal(string2);
        this.append0(literal, literal);
        return this;
    }

    public PeriodFormatterBuilder appendMillis() {
        this.appendField(7);
        return this;
    }

    public PeriodFormatterBuilder appendMillis3Digit() {
        this.appendField(7, 3);
        return this;
    }

    public PeriodFormatterBuilder appendMinutes() {
        this.appendField(5);
        return this;
    }

    public PeriodFormatterBuilder appendMonths() {
        this.appendField(1);
        return this;
    }

    public PeriodFormatterBuilder appendPrefix(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new SimpleAffix(string2));
    }

    public PeriodFormatterBuilder appendPrefix(String string2, String string3) {
        if (string2 == null || string3 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new PluralAffix(string2, string3));
    }

    public PeriodFormatterBuilder appendSeconds() {
        this.appendField(6);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithMillis() {
        this.appendField(8);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithOptionalMillis() {
        this.appendField(9);
        return this;
    }

    public PeriodFormatterBuilder appendSeparator(String string2) {
        return this.appendSeparator(string2, string2, null, true, true);
    }

    public PeriodFormatterBuilder appendSeparator(String string2, String string3) {
        return this.appendSeparator(string2, string3, null, true, true);
    }

    public PeriodFormatterBuilder appendSeparator(String string2, String string3, String[] stringArray) {
        return this.appendSeparator(string2, string3, stringArray, true, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsAfter(String string2) {
        return this.appendSeparator(string2, string2, null, false, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsBefore(String string2) {
        return this.appendSeparator(string2, string2, null, true, false);
    }

    public PeriodFormatterBuilder appendSuffix(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new SimpleAffix(string2));
    }

    public PeriodFormatterBuilder appendSuffix(String string2, String string3) {
        if (string2 == null || string3 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new PluralAffix(string2, string3));
    }

    public PeriodFormatterBuilder appendWeeks() {
        this.appendField(2);
        return this;
    }

    public PeriodFormatterBuilder appendYears() {
        this.appendField(0);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void clear() {
        this.iMinPrintedDigits = 1;
        this.iPrintZeroSetting = 2;
        this.iMaxParsedDigits = 10;
        this.iRejectSignedValues = false;
        this.iPrefix = null;
        if (this.iElementPairs == null) {
            this.iElementPairs = new ArrayList<Object>();
        } else {
            this.iElementPairs.clear();
        }
        this.iNotPrinter = false;
        this.iNotParser = false;
        this.iFieldFormatters = new FieldFormatter[10];
    }

    public PeriodFormatterBuilder maximumParsedDigits(int n2) {
        this.iMaxParsedDigits = n2;
        return this;
    }

    public PeriodFormatterBuilder minimumPrintedDigits(int n2) {
        this.iMinPrintedDigits = n2;
        return this;
    }

    public PeriodFormatterBuilder printZeroAlways() {
        this.iPrintZeroSetting = 4;
        return this;
    }

    public PeriodFormatterBuilder printZeroIfSupported() {
        this.iPrintZeroSetting = 3;
        return this;
    }

    public PeriodFormatterBuilder printZeroNever() {
        this.iPrintZeroSetting = 5;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyFirst() {
        this.iPrintZeroSetting = 1;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyLast() {
        this.iPrintZeroSetting = 2;
        return this;
    }

    public PeriodFormatterBuilder rejectSignedValues(boolean bl2) {
        this.iRejectSignedValues = bl2;
        return this;
    }

    public PeriodFormatter toFormatter() {
        PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(this.iElementPairs, this.iNotPrinter, this.iNotParser);
        this.iFieldFormatters = (FieldFormatter[])this.iFieldFormatters.clone();
        return periodFormatter;
    }

    public PeriodParser toParser() {
        if (this.iNotParser) {
            return null;
        }
        return this.toFormatter().getParser();
    }

    public PeriodPrinter toPrinter() {
        if (this.iNotPrinter) {
            return null;
        }
        return this.toFormatter().getPrinter();
    }

    static class Composite
    implements PeriodPrinter,
    PeriodParser {
        private final PeriodParser[] iParsers;
        private final PeriodPrinter[] iPrinters;

        /*
         * Enabled aggressive block sorting
         */
        Composite(List<Object> list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            this.decompose(list, arrayList, arrayList2);
            this.iPrinters = arrayList.size() <= 0 ? null : arrayList.toArray(new PeriodPrinter[arrayList.size()]);
            if (arrayList2.size() <= 0) {
                this.iParsers = null;
                return;
            }
            this.iParsers = arrayList2.toArray(new PeriodParser[arrayList2.size()]);
        }

        private void addArrayToList(List<Object> list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    list.add(objectArray[i2]);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void decompose(List<Object> list, List<Object> list2, List<Object> list3) {
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                Object object2 = list.get(n3);
                if (object2 instanceof PeriodPrinter) {
                    if (object2 instanceof Composite) {
                        this.addArrayToList(list2, ((Composite)object2).iPrinters);
                    } else {
                        list2.add(object2);
                    }
                }
                if ((object = list.get(n3 + 1)) instanceof PeriodParser) {
                    if (object instanceof Composite) {
                        this.addArrayToList(list3, ((Composite)object).iParsers);
                    } else {
                        list3.add(object);
                    }
                }
                n3 += 2;
            }
            return;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            int n2 = 0;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n3 = periodPrinterArray.length;
            while (--n3 >= 0) {
                n2 += periodPrinterArray[n3].calculatePrintedLength(readablePeriod, locale);
            }
            return n2;
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            int n3;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n4 = periodPrinterArray.length;
            for (n3 = 0; n3 < n2 && --n4 >= 0; n3 += periodPrinterArray[n4].countFieldsToPrint(readablePeriod, Integer.MAX_VALUE, locale)) {
            }
            return n3;
        }

        @Override
        public int parseInto(ReadWritablePeriod readWritablePeriod, String string2, int n2, Locale locale) {
            PeriodParser[] periodParserArray = this.iParsers;
            if (periodParserArray == null) {
                throw new UnsupportedOperationException();
            }
            int n3 = periodParserArray.length;
            for (int i2 = 0; i2 < n3 && n2 >= 0; ++i2) {
                n2 = periodParserArray[i2].parseInto(readWritablePeriod, string2, n2, locale);
            }
            return n2;
        }

        @Override
        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = periodPrinterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                periodPrinterArray[i2].printTo(writer, readablePeriod, locale);
            }
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = periodPrinterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                periodPrinterArray[i2].printTo(stringBuffer, readablePeriod, locale);
            }
        }
    }

    static class CompositeAffix
    implements PeriodFieldAffix {
        private final PeriodFieldAffix iLeft;
        private final PeriodFieldAffix iRight;

        CompositeAffix(PeriodFieldAffix periodFieldAffix, PeriodFieldAffix periodFieldAffix2) {
            this.iLeft = periodFieldAffix;
            this.iRight = periodFieldAffix2;
        }

        @Override
        public int calculatePrintedLength(int n2) {
            return this.iLeft.calculatePrintedLength(n2) + this.iRight.calculatePrintedLength(n2);
        }

        @Override
        public int parse(String string2, int n2) {
            int n3 = this.iLeft.parse(string2, n2);
            if (n3 >= 0) {
                n3 = this.iRight.parse(string2, n3);
            }
            return n3;
        }

        @Override
        public void printTo(Writer writer, int n2) throws IOException {
            this.iLeft.printTo(writer, n2);
            this.iRight.printTo(writer, n2);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, int n2) {
            this.iLeft.printTo(stringBuffer, n2);
            this.iRight.printTo(stringBuffer, n2);
        }

        @Override
        public int scan(String string2, int n2) {
            int n3 = this.iLeft.scan(string2, n2);
            if (n3 >= 0) {
                return this.iRight.scan(string2, n3);
            }
            return ~n2;
        }
    }

    static class FieldFormatter
    implements PeriodPrinter,
    PeriodParser {
        private final FieldFormatter[] iFieldFormatters;
        private final int iFieldType;
        private final int iMaxParsedDigits;
        private final int iMinPrintedDigits;
        private final PeriodFieldAffix iPrefix;
        private final int iPrintZeroSetting;
        private final boolean iRejectSignedValues;
        private final PeriodFieldAffix iSuffix;

        FieldFormatter(int n2, int n3, int n4, boolean bl2, int n5, FieldFormatter[] fieldFormatterArray, PeriodFieldAffix periodFieldAffix, PeriodFieldAffix periodFieldAffix2) {
            this.iMinPrintedDigits = n2;
            this.iPrintZeroSetting = n3;
            this.iMaxParsedDigits = n4;
            this.iRejectSignedValues = bl2;
            this.iFieldType = n5;
            this.iFieldFormatters = fieldFormatterArray;
            this.iPrefix = periodFieldAffix;
            this.iSuffix = periodFieldAffix2;
        }

        FieldFormatter(FieldFormatter fieldFormatter, PeriodFieldAffix periodFieldAffix) {
            this.iMinPrintedDigits = fieldFormatter.iMinPrintedDigits;
            this.iPrintZeroSetting = fieldFormatter.iPrintZeroSetting;
            this.iMaxParsedDigits = fieldFormatter.iMaxParsedDigits;
            this.iRejectSignedValues = fieldFormatter.iRejectSignedValues;
            this.iFieldType = fieldFormatter.iFieldType;
            this.iFieldFormatters = fieldFormatter.iFieldFormatters;
            this.iPrefix = fieldFormatter.iPrefix;
            if (fieldFormatter.iSuffix != null) {
                periodFieldAffix = new CompositeAffix(fieldFormatter.iSuffix, periodFieldAffix);
            }
            this.iSuffix = periodFieldAffix;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int parseInt(String string2, int n2, int n3) {
            int n4;
            boolean bl2;
            if (n3 >= 10) {
                return Integer.parseInt(string2.substring(n2, n2 + n3));
            }
            int n5 = 0;
            if (n3 <= 0) return n5;
            int n6 = n2 + 1;
            char c2 = string2.charAt(n2);
            int n7 = n3 - 1;
            if (c2 == '-') {
                n5 = 0;
                if (--n7 < 0) return n5;
                bl2 = true;
                n4 = n6 + 1;
                c2 = string2.charAt(n6);
            } else {
                n4 = n6;
                bl2 = false;
            }
            int n8 = c2 - 48;
            int n9 = n4;
            while (true) {
                int n10 = n7 - 1;
                if (n7 <= 0) break;
                int n11 = (n8 << 3) + (n8 << 1);
                int n12 = n9 + 1;
                n8 = -48 + (n11 + string2.charAt(n9));
                n9 = n12;
                n7 = n10;
            }
            if (!bl2) return n8;
            return -n8;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            long l2 = this.getFieldValue(readablePeriod);
            if (l2 == Long.MAX_VALUE) {
                return 0;
            }
            int n2 = Math.max(FormatUtils.calculateDigitCount(l2), this.iMinPrintedDigits);
            if (this.iFieldType >= 8) {
                int n3 = l2 < 0L ? Math.max(n2, 5) : Math.max(n2, 4);
                n2 = n3 + 1;
                if (this.iFieldType == 9 && Math.abs(l2) % 1000L == 0L) {
                    n2 -= 4;
                }
                l2 /= 1000L;
            }
            int n4 = (int)l2;
            if (this.iPrefix != null) {
                n2 += this.iPrefix.calculatePrintedLength(n4);
            }
            if (this.iSuffix == null) return n2;
            return n2 + this.iSuffix.calculatePrintedLength(n4);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            if (n2 <= 0 || this.iPrintZeroSetting != 4 && this.getFieldValue(readablePeriod) == Long.MAX_VALUE) {
                return 0;
            }
            return 1;
        }

        int getFieldType() {
            return this.iFieldType;
        }

        /*
         * Enabled aggressive block sorting
         */
        long getFieldValue(ReadablePeriod readablePeriod) {
            long l2;
            PeriodType periodType = this.iPrintZeroSetting == 4 ? null : readablePeriod.getPeriodType();
            if (periodType != null && !this.isSupported(periodType, this.iFieldType)) {
                return Long.MAX_VALUE;
            }
            switch (this.iFieldType) {
                default: {
                    return Long.MAX_VALUE;
                }
                case 0: {
                    l2 = readablePeriod.get(DurationFieldType.years());
                    break;
                }
                case 1: {
                    l2 = readablePeriod.get(DurationFieldType.months());
                    break;
                }
                case 2: {
                    l2 = readablePeriod.get(DurationFieldType.weeks());
                    break;
                }
                case 3: {
                    l2 = readablePeriod.get(DurationFieldType.days());
                    break;
                }
                case 4: {
                    l2 = readablePeriod.get(DurationFieldType.hours());
                    break;
                }
                case 5: {
                    l2 = readablePeriod.get(DurationFieldType.minutes());
                    break;
                }
                case 6: {
                    l2 = readablePeriod.get(DurationFieldType.seconds());
                    break;
                }
                case 7: {
                    l2 = readablePeriod.get(DurationFieldType.millis());
                    break;
                }
                case 8: 
                case 9: {
                    int n2 = readablePeriod.get(DurationFieldType.seconds());
                    int n3 = readablePeriod.get(DurationFieldType.millis());
                    l2 = 1000L * (long)n2 + (long)n3;
                }
            }
            if (l2 != 0L) return l2;
            switch (this.iPrintZeroSetting) {
                case 5: {
                    return Long.MAX_VALUE;
                }
                default: {
                    return l2;
                }
                case 2: {
                    if (!this.isZero(readablePeriod)) return Long.MAX_VALUE;
                    if (this.iFieldFormatters[this.iFieldType] != this) return Long.MAX_VALUE;
                    int n4 = 1 + this.iFieldType;
                    while (n4 <= 9) {
                        if (this.isSupported(periodType, n4)) {
                            if (this.iFieldFormatters[n4] != null) return Long.MAX_VALUE;
                        }
                        ++n4;
                    }
                    return l2;
                }
                case 1: 
            }
            if (!this.isZero(readablePeriod)) return Long.MAX_VALUE;
            if (this.iFieldFormatters[this.iFieldType] != this) return Long.MAX_VALUE;
            int n5 = -1 + Math.min(this.iFieldType, 8);
            while (n5 >= 0) {
                if (n5 > 9) return l2;
                if (this.isSupported(periodType, n5)) {
                    if (this.iFieldFormatters[n5] != null) return Long.MAX_VALUE;
                }
                --n5;
            }
            return l2;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean isSupported(PeriodType periodType, int n2) {
            switch (n2) {
                default: {
                    return false;
                }
                case 0: {
                    return periodType.isSupported(DurationFieldType.years());
                }
                case 1: {
                    return periodType.isSupported(DurationFieldType.months());
                }
                case 2: {
                    return periodType.isSupported(DurationFieldType.weeks());
                }
                case 3: {
                    return periodType.isSupported(DurationFieldType.days());
                }
                case 4: {
                    return periodType.isSupported(DurationFieldType.hours());
                }
                case 5: {
                    return periodType.isSupported(DurationFieldType.minutes());
                }
                case 6: {
                    return periodType.isSupported(DurationFieldType.seconds());
                }
                case 7: {
                    return periodType.isSupported(DurationFieldType.millis());
                }
                case 8: 
                case 9: {
                    if (!periodType.isSupported(DurationFieldType.seconds()) && !periodType.isSupported(DurationFieldType.millis())) return false;
                    return true;
                }
            }
        }

        boolean isZero(ReadablePeriod readablePeriod) {
            int n2 = readablePeriod.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (readablePeriod.getValue(i2) == 0) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int parseInto(ReadWritablePeriod readWritablePeriod, String string2, int n2, Locale locale) {
            int n3;
            int n4;
            boolean bl2;
            block23: {
                block21: {
                    int n5;
                    block22: {
                        block20: {
                            block19: {
                                bl2 = this.iPrintZeroSetting == 4;
                                if (n2 >= string2.length()) {
                                    if (!bl2) return n2;
                                    n2 ^= 0xFFFFFFFF;
                                    return n2;
                                }
                                if (this.iPrefix == null) break block19;
                                if ((n2 = this.iPrefix.parse(string2, n2)) < 0) break block20;
                                bl2 = true;
                            }
                            if (this.iSuffix == null || bl2) break block21;
                            n5 = this.iSuffix.scan(string2, n2);
                            if (n5 < 0) break block22;
                            bl2 = true;
                            n4 = n5;
                            break block23;
                        }
                        if (bl2) return n2;
                        return ~n2;
                    }
                    if (bl2) return n5;
                    return ~n5;
                }
                n4 = -1;
            }
            if (!bl2) {
                if (!this.isSupported(readWritablePeriod.getPeriodType(), this.iFieldType)) return n2;
            }
            int n6 = n4 > 0 ? Math.min(this.iMaxParsedDigits, n4 - n2) : Math.min(this.iMaxParsedDigits, string2.length() - n2);
            int n7 = -1;
            boolean bl3 = false;
            int n8 = n6;
            int n9 = 0;
            int n10 = n2;
            while (n9 < n8) {
                char c2 = string2.charAt(n10 + n9);
                if (!(n9 != 0 || c2 != '-' && c2 != '+' || this.iRejectSignedValues)) {
                    char c3;
                    boolean bl4 = c2 == '-';
                    if (n9 + 1 >= n8 || (c3 = string2.charAt(1 + (n10 + n9))) < '0' || c3 > '9') break;
                    if (bl4) {
                        ++n9;
                    } else {
                        ++n10;
                    }
                    n8 = Math.min(n8 + 1, string2.length() - n10);
                    continue;
                }
                if (c2 >= '0' && c2 <= '9') {
                    bl3 = true;
                } else {
                    if (c2 != '.' && c2 != ',' || this.iFieldType != 8 && this.iFieldType != 9 || n7 >= 0) break;
                    n7 = 1 + (n10 + n9);
                    n8 = Math.min(n8 + 1, string2.length() - n10);
                }
                ++n9;
            }
            if (!bl3) {
                return ~n10;
            }
            if (n4 >= 0 && n10 + n9 != n4) {
                return n10;
            }
            if (this.iFieldType != 8 && this.iFieldType != 9) {
                this.setFieldValue(readWritablePeriod, this.iFieldType, this.parseInt(string2, n10, n9));
            } else if (n7 < 0) {
                this.setFieldValue(readWritablePeriod, 6, this.parseInt(string2, n10, n9));
                this.setFieldValue(readWritablePeriod, 7, 0);
            } else {
                int n11;
                int n12 = this.parseInt(string2, n10, -1 + (n7 - n10));
                this.setFieldValue(readWritablePeriod, 6, n12);
                int n13 = n10 + n9 - n7;
                if (n13 <= 0) {
                    n11 = 0;
                } else {
                    if (n13 >= 3) {
                        n11 = this.parseInt(string2, n7, 3);
                    } else {
                        int n14 = this.parseInt(string2, n7, n13);
                        n11 = n13 == 1 ? n14 * 100 : n14 * 10;
                    }
                    if (n12 < 0) {
                        n11 = -n11;
                    }
                }
                this.setFieldValue(readWritablePeriod, 7, n11);
            }
            if ((n3 = n9 + n10) < 0) return n3;
            if (this.iSuffix == null) return n3;
            return this.iSuffix.parse(string2, n3);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            int n2;
            block10: {
                block9: {
                    int n3;
                    long l2 = this.getFieldValue(readablePeriod);
                    if (l2 == Long.MAX_VALUE) break block9;
                    n2 = (int)l2;
                    if (this.iFieldType >= 8) {
                        n2 = (int)(l2 / 1000L);
                    }
                    if (this.iPrefix != null) {
                        this.iPrefix.printTo(writer, n2);
                    }
                    if ((n3 = this.iMinPrintedDigits) <= 1) {
                        FormatUtils.writeUnpaddedInteger(writer, n2);
                    } else {
                        FormatUtils.writePaddedInteger(writer, n2, n3);
                    }
                    if (this.iFieldType >= 8) {
                        int n4 = (int)(Math.abs(l2) % 1000L);
                        if (this.iFieldType == 8 || n4 > 0) {
                            writer.write(46);
                            FormatUtils.writePaddedInteger(writer, n4, 3);
                        }
                    }
                    if (this.iSuffix != null) break block10;
                }
                return;
            }
            this.iSuffix.printTo(writer, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            int n2;
            block11: {
                block10: {
                    long l2 = this.getFieldValue(readablePeriod);
                    if (l2 == Long.MAX_VALUE) break block10;
                    n2 = (int)l2;
                    if (this.iFieldType >= 8) {
                        n2 = (int)(l2 / 1000L);
                    }
                    if (this.iPrefix != null) {
                        this.iPrefix.printTo(stringBuffer, n2);
                    }
                    int n3 = stringBuffer.length();
                    int n4 = this.iMinPrintedDigits;
                    if (n4 <= 1) {
                        FormatUtils.appendUnpaddedInteger(stringBuffer, n2);
                    } else {
                        FormatUtils.appendPaddedInteger(stringBuffer, n2, n4);
                    }
                    if (this.iFieldType >= 8) {
                        int n5 = (int)(Math.abs(l2) % 1000L);
                        if (this.iFieldType == 8 || n5 > 0) {
                            if (l2 < 0L && l2 > -1000L) {
                                stringBuffer.insert(n3, '-');
                            }
                            stringBuffer.append('.');
                            FormatUtils.appendPaddedInteger(stringBuffer, n5, 3);
                        }
                    }
                    if (this.iSuffix != null) break block11;
                }
                return;
            }
            this.iSuffix.printTo(stringBuffer, n2);
        }

        void setFieldValue(ReadWritablePeriod readWritablePeriod, int n2, int n3) {
            switch (n2) {
                default: {
                    return;
                }
                case 0: {
                    readWritablePeriod.setYears(n3);
                    return;
                }
                case 1: {
                    readWritablePeriod.setMonths(n3);
                    return;
                }
                case 2: {
                    readWritablePeriod.setWeeks(n3);
                    return;
                }
                case 3: {
                    readWritablePeriod.setDays(n3);
                    return;
                }
                case 4: {
                    readWritablePeriod.setHours(n3);
                    return;
                }
                case 5: {
                    readWritablePeriod.setMinutes(n3);
                    return;
                }
                case 6: {
                    readWritablePeriod.setSeconds(n3);
                    return;
                }
                case 7: 
            }
            readWritablePeriod.setMillis(n3);
        }
    }

    static class Literal
    implements PeriodPrinter,
    PeriodParser {
        static final Literal EMPTY = new Literal("");
        private final String iText;

        Literal(String string2) {
            this.iText = string2;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            return this.iText.length();
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            return 0;
        }

        @Override
        public int parseInto(ReadWritablePeriod readWritablePeriod, String string2, int n2, Locale locale) {
            if (string2.regionMatches(true, n2, this.iText, 0, this.iText.length())) {
                return n2 + this.iText.length();
            }
            return ~n2;
        }

        @Override
        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            writer.write(this.iText);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            stringBuffer.append(this.iText);
        }
    }

    static interface PeriodFieldAffix {
        public int calculatePrintedLength(int var1);

        public int parse(String var1, int var2);

        public void printTo(Writer var1, int var2) throws IOException;

        public void printTo(StringBuffer var1, int var2);

        public int scan(String var1, int var2);
    }

    static class PluralAffix
    implements PeriodFieldAffix {
        private final String iPluralText;
        private final String iSingularText;

        PluralAffix(String string2, String string3) {
            this.iSingularText = string2;
            this.iPluralText = string3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int calculatePrintedLength(int n2) {
            String string2;
            if (n2 == 1) {
                string2 = this.iSingularText;
                return string2.length();
            }
            string2 = this.iPluralText;
            return string2.length();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int parse(String string2, int n2) {
            String string3;
            String string4;
            String string5 = this.iPluralText;
            String string6 = this.iSingularText;
            if (string5.length() < string6.length()) {
                string4 = string5;
                string3 = string6;
            } else {
                string4 = string6;
                string3 = string5;
            }
            if (string2.regionMatches(true, n2, string3, 0, string3.length())) {
                return n2 + string3.length();
            }
            int n3 = string4.length();
            if (string2.regionMatches(true, n2, string4, 0, n3)) {
                return n2 + string4.length();
            }
            return ~n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(Writer writer, int n2) throws IOException {
            String string2 = n2 == 1 ? this.iSingularText : this.iPluralText;
            writer.write(string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(StringBuffer stringBuffer, int n2) {
            String string2 = n2 == 1 ? this.iSingularText : this.iPluralText;
            stringBuffer.append(string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int scan(String string2, int n2) {
            String string3;
            String string4 = this.iPluralText;
            String string5 = this.iSingularText;
            if (string4.length() < string5.length()) {
                string3 = string5;
            } else {
                string3 = string4;
                string4 = string5;
            }
            int n3 = string3.length();
            int n4 = string4.length();
            int n5 = string2.length();
            int n6 = n2;
            while (n6 < n5) {
                if (string2.regionMatches(true, n6, string3, 0, n3) || string2.regionMatches(true, n6, string4, 0, n4)) {
                    return n6;
                }
                ++n6;
            }
            return ~n2;
        }
    }

    static class Separator
    implements PeriodPrinter,
    PeriodParser {
        private volatile PeriodParser iAfterParser;
        private volatile PeriodPrinter iAfterPrinter;
        private final PeriodParser iBeforeParser;
        private final PeriodPrinter iBeforePrinter;
        private final String iFinalText;
        private final String[] iParsedForms;
        private final String iText;
        private final boolean iUseAfter;
        private final boolean iUseBefore;

        /*
         * Enabled aggressive block sorting
         */
        Separator(String string2, String string3, String[] stringArray, PeriodPrinter periodPrinter, PeriodParser periodParser, boolean bl2, boolean bl3) {
            this.iText = string2;
            this.iFinalText = string3;
            if (!(string3 != null && !string2.equals(string3) || stringArray != null && stringArray.length != 0)) {
                this.iParsedForms = new String[]{string2};
            } else {
                TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                treeSet.add(string2);
                treeSet.add(string3);
                if (stringArray != null) {
                    int n2 = stringArray.length;
                    while (--n2 >= 0) {
                        treeSet.add(stringArray[n2]);
                    }
                }
                ArrayList arrayList = new ArrayList(treeSet);
                Collections.reverse(arrayList);
                this.iParsedForms = arrayList.toArray(new String[arrayList.size()]);
            }
            this.iBeforePrinter = periodPrinter;
            this.iBeforeParser = periodParser;
            this.iUseBefore = bl2;
            this.iUseAfter = bl3;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            int n2;
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            int n3 = periodPrinter.calculatePrintedLength(readablePeriod, locale) + periodPrinter2.calculatePrintedLength(readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) <= 0) return n3;
                if (!this.iUseAfter) {
                    return n3 + this.iText.length();
                }
                int n4 = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                if (n4 > 0) {
                    String string2 = n4 > 1 ? this.iText : this.iFinalText;
                    n2 = n3 + string2.length();
                    return n2;
                }
            } else {
                if (!this.iUseAfter) return n3;
                if (periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) <= 0) return n3;
                return n3 + this.iText.length();
            }
            n2 = n3;
            return n2;
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            int n3 = this.iBeforePrinter.countFieldsToPrint(readablePeriod, n2, locale);
            if (n3 < n2) {
                n3 += this.iAfterPrinter.countFieldsToPrint(readablePeriod, n2, locale);
            }
            return n3;
        }

        Separator finish(PeriodPrinter periodPrinter, PeriodParser periodParser) {
            this.iAfterPrinter = periodPrinter;
            this.iAfterParser = periodParser;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int parseInto(ReadWritablePeriod readWritablePeriod, String string2, int n2, Locale locale) {
            int n3;
            int n4;
            boolean bl2 = true;
            int n5 = this.iBeforeParser.parseInto(readWritablePeriod, string2, n2, locale);
            if (n5 < 0) {
                return n5;
            }
            if (n5 > n2) {
                for (String string3 : this.iParsedForms) {
                    if (string3 != null && string3.length() != 0 && !string2.regionMatches(bl2, n5, string3, 0, string3.length())) continue;
                    n4 = 0;
                    if (string3 != null) {
                        n4 = string3.length();
                    }
                    n5 += n4;
                    break;
                }
            } else {
                n4 = -1;
                bl2 = false;
            }
            if ((n3 = this.iAfterParser.parseInto(readWritablePeriod, string2, n5, locale)) < 0) {
                return n3;
            }
            if (bl2 && n3 == n5 && n4 > 0) {
                return ~n5;
            }
            if (n3 > n5 && !bl2 && !this.iUseBefore) {
                return ~n5;
            }
            return n3;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            PeriodPrinter periodPrinter;
            block6: {
                block5: {
                    PeriodPrinter periodPrinter2 = this.iBeforePrinter;
                    periodPrinter = this.iAfterPrinter;
                    periodPrinter2.printTo(writer, readablePeriod, locale);
                    if (!this.iUseBefore) break block5;
                    if (periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                        if (this.iUseAfter) {
                            int n2 = periodPrinter.countFieldsToPrint(readablePeriod, 2, locale);
                            if (n2 > 0) {
                                String string2 = n2 > 1 ? this.iText : this.iFinalText;
                                writer.write(string2);
                            }
                            break block6;
                        } else {
                            writer.write(this.iText);
                        }
                    }
                    break block6;
                }
                if (this.iUseAfter && periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    writer.write(this.iText);
                }
            }
            periodPrinter.printTo(writer, readablePeriod, locale);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter periodPrinter;
            block6: {
                block5: {
                    PeriodPrinter periodPrinter2 = this.iBeforePrinter;
                    periodPrinter = this.iAfterPrinter;
                    periodPrinter2.printTo(stringBuffer, readablePeriod, locale);
                    if (!this.iUseBefore) break block5;
                    if (periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                        if (this.iUseAfter) {
                            int n2 = periodPrinter.countFieldsToPrint(readablePeriod, 2, locale);
                            if (n2 > 0) {
                                String string2 = n2 > 1 ? this.iText : this.iFinalText;
                                stringBuffer.append(string2);
                            }
                            break block6;
                        } else {
                            stringBuffer.append(this.iText);
                        }
                    }
                    break block6;
                }
                if (this.iUseAfter && periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    stringBuffer.append(this.iText);
                }
            }
            periodPrinter.printTo(stringBuffer, readablePeriod, locale);
        }
    }

    static class SimpleAffix
    implements PeriodFieldAffix {
        private final String iText;

        SimpleAffix(String string2) {
            this.iText = string2;
        }

        @Override
        public int calculatePrintedLength(int n2) {
            return this.iText.length();
        }

        @Override
        public int parse(String string2, int n2) {
            String string3 = this.iText;
            int n3 = string3.length();
            if (string2.regionMatches(true, n2, string3, 0, n3)) {
                return n2 + n3;
            }
            return ~n2;
        }

        @Override
        public void printTo(Writer writer, int n2) throws IOException {
            writer.write(this.iText);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append(this.iText);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int scan(String string2, int n2) {
            String string3 = this.iText;
            int n3 = string3.length();
            int n4 = string2.length();
            int n5 = n2;
            while (n5 < n4) {
                if (string2.regionMatches(true, n5, string3, 0, n3)) {
                    return n5;
                }
                switch (string2.charAt(n5)) {
                    default: {
                        return ~n2;
                    }
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                }
                ++n5;
            }
            return ~n2;
        }
    }
}

