/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;

public class FormatUtils {
    private static final double LOG_10 = Math.log(10.0);

    private FormatUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void appendPaddedInteger(StringBuffer stringBuffer, int n2, int n3) {
        if (n2 < 0) {
            stringBuffer.append('-');
            if (n2 == Integer.MIN_VALUE) {
                while (true) {
                    if (n3 <= 10) {
                        stringBuffer.append("2147483648");
                        return;
                    }
                    stringBuffer.append('0');
                    --n3;
                }
            }
            n2 = -n2;
        }
        if (n2 < 10) {
            while (true) {
                if (n3 <= 1) {
                    stringBuffer.append((char)(n2 + 48));
                    return;
                }
                stringBuffer.append('0');
                --n3;
            }
        }
        if (n2 < 100) {
            while (true) {
                if (n3 <= 2) {
                    int n4 = 0xCCCCCC * (n2 + 1) >> 27;
                    stringBuffer.append((char)(n4 + 48));
                    stringBuffer.append((char)(48 + (n2 - (n4 << 3) - (n4 << 1))));
                    return;
                }
                stringBuffer.append('0');
                --n3;
            }
        }
        int n5 = n2 < 1000 ? 3 : (n2 < 10000 ? 4 : 1 + (int)(Math.log(n2) / LOG_10));
        while (true) {
            if (n3 <= n5) {
                stringBuffer.append(Integer.toString(n2));
                return;
            }
            stringBuffer.append('0');
            --n3;
        }
    }

    public static void appendPaddedInteger(StringBuffer stringBuffer, long l2, int n2) {
        int n3 = (int)l2;
        if ((long)n3 == l2) {
            FormatUtils.appendPaddedInteger(stringBuffer, n3, n2);
            return;
        }
        if (n2 <= 19) {
            stringBuffer.append(Long.toString(l2));
            return;
        }
        if (l2 < 0L) {
            stringBuffer.append('-');
            if (l2 == Long.MIN_VALUE) {
                while (n2 > 19) {
                    stringBuffer.append('0');
                    --n2;
                }
                stringBuffer.append("9223372036854775808");
                return;
            }
            l2 = -l2;
        }
        int n4 = 1 + (int)(Math.log(l2) / LOG_10);
        while (n2 > n4) {
            stringBuffer.append('0');
            --n2;
        }
        stringBuffer.append(Long.toString(l2));
    }

    public static void appendUnpaddedInteger(StringBuffer stringBuffer, int n2) {
        if (n2 < 0) {
            stringBuffer.append('-');
            if (n2 == Integer.MIN_VALUE) {
                stringBuffer.append("2147483648");
                return;
            }
            n2 = -n2;
        }
        if (n2 < 10) {
            stringBuffer.append((char)(n2 + 48));
            return;
        }
        if (n2 < 100) {
            int n3 = 0xCCCCCC * (n2 + 1) >> 27;
            stringBuffer.append((char)(n3 + 48));
            stringBuffer.append((char)(48 + (n2 - (n3 << 3) - (n3 << 1))));
            return;
        }
        stringBuffer.append(Integer.toString(n2));
    }

    public static void appendUnpaddedInteger(StringBuffer stringBuffer, long l2) {
        int n2 = (int)l2;
        if ((long)n2 == l2) {
            FormatUtils.appendUnpaddedInteger(stringBuffer, n2);
            return;
        }
        stringBuffer.append(Long.toString(l2));
    }

    public static int calculateDigitCount(long l2) {
        if (l2 < 0L) {
            if (l2 != Long.MIN_VALUE) {
                return 1 + FormatUtils.calculateDigitCount(-l2);
            }
            return 20;
        }
        if (l2 < 10L) {
            return 1;
        }
        if (l2 < 100L) {
            return 2;
        }
        if (l2 < 1000L) {
            return 3;
        }
        if (l2 < 10000L) {
            return 4;
        }
        return 1 + (int)(Math.log(l2) / LOG_10);
    }

    /*
     * Enabled aggressive block sorting
     */
    static String createErrorMessage(String string2, int n2) {
        int n3 = n2 + 32;
        String string3 = string2.length() <= n3 + 3 ? string2 : string2.substring(0, n3).concat("...");
        if (n2 <= 0) {
            return "Invalid format: \"" + string3 + '\"';
        }
        if (n2 >= string2.length()) {
            return "Invalid format: \"" + string3 + "\" is too short";
        }
        return "Invalid format: \"" + string3 + "\" is malformed at \"" + string3.substring(n2) + '\"';
    }

    static int parseTwoDigits(String string2, int n2) {
        int n3 = -48 + string2.charAt(n2);
        return -48 + ((n3 << 3) + (n3 << 1) + string2.charAt(n2 + 1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writePaddedInteger(Writer writer, int n2, int n3) throws IOException {
        if (n2 < 0) {
            writer.write(45);
            if (n2 == Integer.MIN_VALUE) {
                while (true) {
                    if (n3 <= 10) {
                        writer.write("2147483648");
                        return;
                    }
                    writer.write(48);
                    --n3;
                }
            }
            n2 = -n2;
        }
        if (n2 < 10) {
            while (true) {
                if (n3 <= 1) {
                    writer.write(n2 + 48);
                    return;
                }
                writer.write(48);
                --n3;
            }
        }
        if (n2 < 100) {
            while (true) {
                if (n3 <= 2) {
                    int n4 = 0xCCCCCC * (n2 + 1) >> 27;
                    writer.write(n4 + 48);
                    writer.write(48 + (n2 - (n4 << 3) - (n4 << 1)));
                    return;
                }
                writer.write(48);
                --n3;
            }
        }
        int n5 = n2 < 1000 ? 3 : (n2 < 10000 ? 4 : 1 + (int)(Math.log(n2) / LOG_10));
        while (true) {
            if (n3 <= n5) {
                writer.write(Integer.toString(n2));
                return;
            }
            writer.write(48);
            --n3;
        }
    }

    public static void writePaddedInteger(Writer writer, long l2, int n2) throws IOException {
        int n3 = (int)l2;
        if ((long)n3 == l2) {
            FormatUtils.writePaddedInteger(writer, n3, n2);
            return;
        }
        if (n2 <= 19) {
            writer.write(Long.toString(l2));
            return;
        }
        if (l2 < 0L) {
            writer.write(45);
            if (l2 == Long.MIN_VALUE) {
                while (n2 > 19) {
                    writer.write(48);
                    --n2;
                }
                writer.write("9223372036854775808");
                return;
            }
            l2 = -l2;
        }
        int n4 = 1 + (int)(Math.log(l2) / LOG_10);
        while (n2 > n4) {
            writer.write(48);
            --n2;
        }
        writer.write(Long.toString(l2));
    }

    public static void writeUnpaddedInteger(Writer writer, int n2) throws IOException {
        if (n2 < 0) {
            writer.write(45);
            if (n2 == Integer.MIN_VALUE) {
                writer.write("2147483648");
                return;
            }
            n2 = -n2;
        }
        if (n2 < 10) {
            writer.write(n2 + 48);
            return;
        }
        if (n2 < 100) {
            int n3 = 0xCCCCCC * (n2 + 1) >> 27;
            writer.write(n3 + 48);
            writer.write(48 + (n2 - (n3 << 3) - (n3 << 1)));
            return;
        }
        writer.write(Integer.toString(n2));
    }

    public static void writeUnpaddedInteger(Writer writer, long l2) throws IOException {
        int n2 = (int)l2;
        if ((long)n2 == l2) {
            FormatUtils.writeUnpaddedInteger(writer, n2);
            return;
        }
        writer.write(Long.toString(l2));
    }
}

