/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;

public class DateTimeParserBucket {
    private final Chronology iChrono;
    private int iDefaultYear;
    private Locale iLocale;
    private final long iMillis;
    private Integer iOffset;
    private Integer iPivotYear;
    private SavedField[] iSavedFields = new SavedField[8];
    private int iSavedFieldsCount;
    private boolean iSavedFieldsShared;
    private Object iSavedState;
    private DateTimeZone iZone;

    @Deprecated
    public DateTimeParserBucket(long l2, Chronology chronology, Locale locale) {
        this(l2, chronology, locale, null, 2000);
    }

    @Deprecated
    public DateTimeParserBucket(long l2, Chronology chronology, Locale locale, Integer n2) {
        this(l2, chronology, locale, n2, 2000);
    }

    public DateTimeParserBucket(long l2, Chronology chronology, Locale locale, Integer n2, int n3) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology);
        this.iMillis = l2;
        this.iZone = chronology2.getZone();
        this.iChrono = chronology2.withUTC();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.iLocale = locale;
        this.iPivotYear = n2;
        this.iDefaultYear = n3;
    }

    static /* synthetic */ DateTimeZone access$002(DateTimeParserBucket dateTimeParserBucket, DateTimeZone dateTimeZone) {
        dateTimeParserBucket.iZone = dateTimeZone;
        return dateTimeZone;
    }

    static /* synthetic */ Integer access$102(DateTimeParserBucket dateTimeParserBucket, Integer n2) {
        dateTimeParserBucket.iOffset = n2;
        return n2;
    }

    static /* synthetic */ SavedField[] access$202(DateTimeParserBucket dateTimeParserBucket, SavedField[] savedFieldArray) {
        dateTimeParserBucket.iSavedFields = savedFieldArray;
        return savedFieldArray;
    }

    static /* synthetic */ int access$302(DateTimeParserBucket dateTimeParserBucket, int n2) {
        dateTimeParserBucket.iSavedFieldsCount = n2;
        return n2;
    }

    static /* synthetic */ boolean access$402(DateTimeParserBucket dateTimeParserBucket, boolean bl2) {
        dateTimeParserBucket.iSavedFieldsShared = bl2;
        return bl2;
    }

    static int compareReverse(DurationField durationField, DurationField durationField2) {
        if (durationField == null || !durationField.isSupported()) {
            if (durationField2 == null || !durationField2.isSupported()) {
                return 0;
            }
            return -1;
        }
        if (durationField2 == null || !durationField2.isSupported()) {
            return 1;
        }
        return -durationField.compareTo(durationField2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveField(SavedField savedField) {
        SavedField[] savedFieldArray;
        int n2 = this.iSavedFieldsCount;
        SavedField[] savedFieldArray2 = this.iSavedFields;
        if (n2 == savedFieldArray2.length || this.iSavedFieldsShared) {
            int n3 = n2 == savedFieldArray2.length ? n2 * 2 : savedFieldArray2.length;
            savedFieldArray = new SavedField[n3];
            System.arraycopy(savedFieldArray2, 0, savedFieldArray, 0, n2);
            this.iSavedFields = savedFieldArray;
            this.iSavedFieldsShared = false;
        } else {
            savedFieldArray = savedFieldArray2;
        }
        this.iSavedState = null;
        savedFieldArray[n2] = savedField;
        this.iSavedFieldsCount = n2 + 1;
    }

    /*
     * Unable to fully structure code
     */
    private static void sort(SavedField[] var0, int var1_1) {
        var2_2 = 0;
        if (var1_1 <= 10) ** GOTO lbl7
        Arrays.sort(var0, 0, var1_1);
        return;
        {
            ++var2_2;
lbl7:
            // 2 sources

            if (var2_2 >= var1_1) ** continue;
            var3_3 = var2_2;
            while (true) {
                if (var3_3 <= 0 || var0[var3_3 - 1].compareTo(var0[var3_3]) <= 0) continue block1;
                var4_4 = var0[var3_3];
                var0[var3_3] = var0[var3_3 - 1];
                var0[var3_3 - 1] = var4_4;
                --var3_3;
            }
        }
    }

    public long computeMillis() {
        return this.computeMillis(false, null);
    }

    public long computeMillis(boolean bl2) {
        return this.computeMillis(bl2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long computeMillis(boolean bl2, String string2) {
        long l2;
        block10: {
            SavedField[] savedFieldArray = this.iSavedFields;
            int n2 = this.iSavedFieldsCount;
            if (this.iSavedFieldsShared) {
                savedFieldArray = (SavedField[])this.iSavedFields.clone();
                this.iSavedFields = savedFieldArray;
                this.iSavedFieldsShared = false;
            }
            DateTimeParserBucket.sort(savedFieldArray, n2);
            if (n2 > 0) {
                DurationField durationField = DurationFieldType.months().getField(this.iChrono);
                DurationField durationField2 = DurationFieldType.days().getField(this.iChrono);
                DurationField durationField3 = savedFieldArray[0].iField.getDurationField();
                if (DateTimeParserBucket.compareReverse(durationField3, durationField) >= 0 && DateTimeParserBucket.compareReverse(durationField3, durationField2) <= 0) {
                    this.saveField(DateTimeFieldType.year(), this.iDefaultYear);
                    return this.computeMillis(bl2, string2);
                }
            }
            l2 = this.iMillis;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = savedFieldArray[i2].set(l2, bl2);
                l2 = l3;
                continue;
            }
            if (!bl2) break block10;
            for (int i3 = 0; i3 < n2; ++i3) {
                boolean bl3;
                SavedField savedField;
                try {
                    savedField = savedFieldArray[i3];
                    bl3 = i3 == n2 - 1;
                }
                catch (IllegalFieldValueException illegalFieldValueException) {
                    if (string2 == null) throw illegalFieldValueException;
                    illegalFieldValueException.prependMessage("Cannot parse \"" + string2 + '\"');
                    throw illegalFieldValueException;
                }
                long l4 = savedField.set(l2, bl3);
                l2 = l4;
                continue;
            }
        }
        long l5 = l2;
        if (this.iOffset != null) {
            return l5 - (long)this.iOffset.intValue();
        }
        if (this.iZone == null) return l5;
        int n3 = this.iZone.getOffsetFromLocal(l5);
        if (n3 == this.iZone.getOffset(l5 -= (long)n3)) return l5;
        String string3 = "Illegal instant due to time zone offset transition (" + this.iZone + ')';
        if (string2 == null) throw new IllegalInstantException(string3);
        string3 = "Cannot parse \"" + string2 + "\": " + string3;
        throw new IllegalInstantException(string3);
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    @Deprecated
    public int getOffset() {
        if (this.iOffset != null) {
            return this.iOffset;
        }
        return 0;
    }

    public Integer getOffsetInteger() {
        return this.iOffset;
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public boolean restoreState(Object object) {
        if (object instanceof SavedState && ((SavedState)object).restoreState(this)) {
            this.iSavedState = object;
            return true;
        }
        return false;
    }

    public void saveField(DateTimeField dateTimeField, int n2) {
        this.saveField(new SavedField(dateTimeField, n2));
    }

    public void saveField(DateTimeFieldType dateTimeFieldType, int n2) {
        this.saveField(new SavedField(dateTimeFieldType.getField(this.iChrono), n2));
    }

    public void saveField(DateTimeFieldType dateTimeFieldType, String string2, Locale locale) {
        this.saveField(new SavedField(dateTimeFieldType.getField(this.iChrono), string2, locale));
    }

    public Object saveState() {
        if (this.iSavedState == null) {
            this.iSavedState = new SavedState();
        }
        return this.iSavedState;
    }

    @Deprecated
    public void setOffset(int n2) {
        this.iSavedState = null;
        this.iOffset = n2;
    }

    public void setOffset(Integer n2) {
        this.iSavedState = null;
        this.iOffset = n2;
    }

    public void setPivotYear(Integer n2) {
        this.iPivotYear = n2;
    }

    public void setZone(DateTimeZone dateTimeZone) {
        this.iSavedState = null;
        this.iZone = dateTimeZone;
    }

    static class SavedField
    implements Comparable<SavedField> {
        final DateTimeField iField;
        final Locale iLocale;
        final String iText;
        final int iValue;

        SavedField(DateTimeField dateTimeField, int n2) {
            this.iField = dateTimeField;
            this.iValue = n2;
            this.iText = null;
            this.iLocale = null;
        }

        SavedField(DateTimeField dateTimeField, String string2, Locale locale) {
            this.iField = dateTimeField;
            this.iValue = 0;
            this.iText = string2;
            this.iLocale = locale;
        }

        @Override
        public int compareTo(SavedField savedField) {
            DateTimeField dateTimeField = savedField.iField;
            int n2 = DateTimeParserBucket.compareReverse(this.iField.getRangeDurationField(), dateTimeField.getRangeDurationField());
            if (n2 != 0) {
                return n2;
            }
            return DateTimeParserBucket.compareReverse(this.iField.getDurationField(), dateTimeField.getDurationField());
        }

        /*
         * Enabled aggressive block sorting
         */
        long set(long l2, boolean bl2) {
            long l3 = this.iText == null ? this.iField.set(l2, this.iValue) : this.iField.set(l2, this.iText, this.iLocale);
            if (!bl2) return l3;
            return this.iField.roundFloor(l3);
        }
    }

    class SavedState {
        final Integer iOffset;
        final SavedField[] iSavedFields;
        final int iSavedFieldsCount;
        final DateTimeZone iZone;

        SavedState() {
            this.iZone = DateTimeParserBucket.this.iZone;
            this.iOffset = DateTimeParserBucket.this.iOffset;
            this.iSavedFields = DateTimeParserBucket.this.iSavedFields;
            this.iSavedFieldsCount = DateTimeParserBucket.this.iSavedFieldsCount;
        }

        boolean restoreState(DateTimeParserBucket dateTimeParserBucket) {
            if (dateTimeParserBucket != DateTimeParserBucket.this) {
                return false;
            }
            DateTimeParserBucket.access$002(dateTimeParserBucket, this.iZone);
            DateTimeParserBucket.access$102(dateTimeParserBucket, this.iOffset);
            DateTimeParserBucket.access$202(dateTimeParserBucket, this.iSavedFields);
            if (this.iSavedFieldsCount < dateTimeParserBucket.iSavedFieldsCount) {
                DateTimeParserBucket.access$402(dateTimeParserBucket, true);
            }
            DateTimeParserBucket.access$302(dateTimeParserBucket, this.iSavedFieldsCount);
            return true;
        }
    }
}

