/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatterBuilder {
    private ArrayList<Object> iElementPairs = new ArrayList();
    private Object iFormatter;

    private DateTimeFormatterBuilder append0(Object object) {
        this.iFormatter = null;
        this.iElementPairs.add(object);
        this.iElementPairs.add(object);
        return this;
    }

    private DateTimeFormatterBuilder append0(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.iFormatter = null;
        this.iElementPairs.add(dateTimePrinter);
        this.iElementPairs.add(dateTimeParser);
        return this;
    }

    static void appendUnknownString(StringBuffer stringBuffer, int n2) {
        while (--n2 >= 0) {
            stringBuffer.append('\ufffd');
        }
    }

    private void checkParser(DateTimeParser dateTimeParser) {
        if (dateTimeParser == null) {
            throw new IllegalArgumentException("No parser supplied");
        }
    }

    private void checkPrinter(DateTimePrinter dateTimePrinter) {
        if (dateTimePrinter == null) {
            throw new IllegalArgumentException("No printer supplied");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object getFormatter() {
        Object object = this.iFormatter;
        if (object == null) {
            if (this.iElementPairs.size() == 2) {
                Object object2 = this.iElementPairs.get(0);
                Object object3 = this.iElementPairs.get(1);
                if (object2 != null) {
                    if (object2 == object3 || object3 == null) {
                        object = object2;
                    }
                } else {
                    object = object3;
                }
            }
            if (object == null) {
                object = new Composite(this.iElementPairs);
            }
            this.iFormatter = object;
        }
        return object;
    }

    private boolean isFormatter(Object object) {
        return this.isPrinter(object) || this.isParser(object);
    }

    private boolean isParser(Object object) {
        if (object instanceof DateTimeParser) {
            if (object instanceof Composite) {
                return ((Composite)object).isParser();
            }
            return true;
        }
        return false;
    }

    private boolean isPrinter(Object object) {
        if (object instanceof DateTimePrinter) {
            if (object instanceof Composite) {
                return ((Composite)object).isPrinter();
            }
            return true;
        }
        return false;
    }

    static void printUnknownString(Writer writer, int n2) throws IOException {
        while (--n2 >= 0) {
            writer.write(65533);
        }
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        return this.append0(dateTimeFormatter.getPrinter(), dateTimeFormatter.getParser());
    }

    public DateTimeFormatterBuilder append(DateTimeParser dateTimeParser) {
        this.checkParser(dateTimeParser);
        return this.append0(null, dateTimeParser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter) {
        this.checkPrinter(dateTimePrinter);
        return this.append0(dateTimePrinter, null);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.checkPrinter(dateTimePrinter);
        this.checkParser(dateTimeParser);
        return this.append0(dateTimePrinter, dateTimeParser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser[] dateTimeParserArray) {
        int n2 = 0;
        if (dateTimePrinter != null) {
            this.checkPrinter(dateTimePrinter);
        }
        if (dateTimeParserArray == null) {
            throw new IllegalArgumentException("No parsers supplied");
        }
        int n3 = dateTimeParserArray.length;
        if (n3 == 1) {
            if (dateTimeParserArray[0] == null) {
                throw new IllegalArgumentException("No parser supplied");
            }
            return this.append0(dateTimePrinter, dateTimeParserArray[0]);
        }
        DateTimeParser[] dateTimeParserArray2 = new DateTimeParser[n3];
        while (n2 < n3 - 1) {
            DateTimeParser dateTimeParser;
            dateTimeParserArray2[n2] = dateTimeParser = dateTimeParserArray[n2];
            if (dateTimeParser == null) {
                throw new IllegalArgumentException("Incomplete parser array");
            }
            ++n2;
        }
        dateTimeParserArray2[n2] = dateTimeParserArray[n2];
        return this.append0(dateTimePrinter, new MatchingParser(dateTimeParserArray2));
    }

    public DateTimeFormatterBuilder appendCenturyOfEra(int n2, int n3) {
        return this.appendSignedDecimal(DateTimeFieldType.centuryOfEra(), n2, n3);
    }

    public DateTimeFormatterBuilder appendClockhourOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfDay(), n2, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfHalfday(int n2) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfHalfday(), n2, 2);
    }

    public DateTimeFormatterBuilder appendDayOfMonth(int n2) {
        return this.appendDecimal(DateTimeFieldType.dayOfMonth(), n2, 2);
    }

    public DateTimeFormatterBuilder appendDayOfWeek(int n2) {
        return this.appendDecimal(DateTimeFieldType.dayOfWeek(), n2, 1);
    }

    public DateTimeFormatterBuilder appendDayOfWeekShortText() {
        return this.appendShortText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendDayOfWeekText() {
        return this.appendText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendDayOfYear(int n2) {
        return this.appendDecimal(DateTimeFieldType.dayOfYear(), n2, 3);
    }

    public DateTimeFormatterBuilder appendDecimal(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n3 < n2) {
            n3 = n2;
        }
        if (n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n3, false));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n3, false, n2));
    }

    public DateTimeFormatterBuilder appendEraText() {
        return this.appendText(DateTimeFieldType.era());
    }

    public DateTimeFormatterBuilder appendFixedDecimal(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + n2);
        }
        return this.append0(new FixedNumber(dateTimeFieldType, n2, false));
    }

    public DateTimeFormatterBuilder appendFixedSignedDecimal(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + n2);
        }
        return this.append0(new FixedNumber(dateTimeFieldType, n2, true));
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n3 < n2) {
            n3 = n2;
        }
        if (n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        return this.append0(new Fraction(dateTimeFieldType, n2, n3));
    }

    public DateTimeFormatterBuilder appendFractionOfDay(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.dayOfYear(), n2, n3);
    }

    public DateTimeFormatterBuilder appendFractionOfHour(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.hourOfDay(), n2, n3);
    }

    public DateTimeFormatterBuilder appendFractionOfMinute(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.minuteOfDay(), n2, n3);
    }

    public DateTimeFormatterBuilder appendFractionOfSecond(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.secondOfDay(), n2, n3);
    }

    public DateTimeFormatterBuilder appendHalfdayOfDayText() {
        return this.appendText(DateTimeFieldType.halfdayOfDay());
    }

    public DateTimeFormatterBuilder appendHourOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.hourOfDay(), n2, 2);
    }

    public DateTimeFormatterBuilder appendHourOfHalfday(int n2) {
        return this.appendDecimal(DateTimeFieldType.hourOfHalfday(), n2, 2);
    }

    public DateTimeFormatterBuilder appendLiteral(char c2) {
        return this.append0(new CharacterLiteral(c2));
    }

    public DateTimeFormatterBuilder appendLiteral(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        switch (string2.length()) {
            default: {
                DateTimeFormatterBuilder dateTimeFormatterBuilder = dateTimeFormatterBuilder.append0(new StringLiteral(string2));
            }
            case 0: {
                return dateTimeFormatterBuilder;
            }
            case 1: 
        }
        return dateTimeFormatterBuilder.append0(new CharacterLiteral(string2.charAt(0)));
    }

    public DateTimeFormatterBuilder appendMillisOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.millisOfDay(), n2, 8);
    }

    public DateTimeFormatterBuilder appendMillisOfSecond(int n2) {
        return this.appendDecimal(DateTimeFieldType.millisOfSecond(), n2, 3);
    }

    public DateTimeFormatterBuilder appendMinuteOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.minuteOfDay(), n2, 4);
    }

    public DateTimeFormatterBuilder appendMinuteOfHour(int n2) {
        return this.appendDecimal(DateTimeFieldType.minuteOfHour(), n2, 2);
    }

    public DateTimeFormatterBuilder appendMonthOfYear(int n2) {
        return this.appendDecimal(DateTimeFieldType.monthOfYear(), n2, 2);
    }

    public DateTimeFormatterBuilder appendMonthOfYearShortText() {
        return this.appendShortText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendMonthOfYearText() {
        return this.appendText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeParser dateTimeParser) {
        this.checkParser(dateTimeParser);
        return this.append0(null, new MatchingParser(new DateTimeParser[]{dateTimeParser, null}));
    }

    public DateTimeFormatterBuilder appendPattern(String string2) {
        DateTimeFormat.appendPatternTo(this, string2);
        return this;
    }

    public DateTimeFormatterBuilder appendSecondOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.secondOfDay(), n2, 5);
    }

    public DateTimeFormatterBuilder appendSecondOfMinute(int n2) {
        return this.appendDecimal(DateTimeFieldType.secondOfMinute(), n2, 2);
    }

    public DateTimeFormatterBuilder appendShortText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, true));
    }

    public DateTimeFormatterBuilder appendSignedDecimal(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n3 < n2) {
            n3 = n2;
        }
        if (n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n3, true));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n3, true, n2));
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, false));
    }

    public DateTimeFormatterBuilder appendTimeZoneId() {
        return this.append0(TimeZoneId.INSTANCE, TimeZoneId.INSTANCE);
    }

    public DateTimeFormatterBuilder appendTimeZoneName() {
        return this.append0(new TimeZoneName(0, null), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneName(Map<String, DateTimeZone> map) {
        TimeZoneName timeZoneName = new TimeZoneName(0, map);
        return this.append0(timeZoneName, timeZoneName);
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String string2, String string3, boolean bl2, int n2, int n3) {
        return this.append0(new TimeZoneOffset(string2, string3, bl2, n2, n3));
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String string2, boolean bl2, int n2, int n3) {
        return this.append0(new TimeZoneOffset(string2, string2, bl2, n2, n3));
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName() {
        return this.append0(new TimeZoneName(1, null), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName(Map<String, DateTimeZone> map) {
        TimeZoneName timeZoneName = new TimeZoneName(1, map);
        return this.append0(timeZoneName, timeZoneName);
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int n2) {
        return this.appendTwoDigitWeekyear(n2, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int n2, boolean bl2) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.weekyear(), n2, bl2));
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int n2) {
        return this.appendTwoDigitYear(n2, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int n2, boolean bl2) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.year(), n2, bl2));
    }

    public DateTimeFormatterBuilder appendWeekOfWeekyear(int n2) {
        return this.appendDecimal(DateTimeFieldType.weekOfWeekyear(), n2, 2);
    }

    public DateTimeFormatterBuilder appendWeekyear(int n2, int n3) {
        return this.appendSignedDecimal(DateTimeFieldType.weekyear(), n2, n3);
    }

    public DateTimeFormatterBuilder appendYear(int n2, int n3) {
        return this.appendSignedDecimal(DateTimeFieldType.year(), n2, n3);
    }

    public DateTimeFormatterBuilder appendYearOfCentury(int n2, int n3) {
        return this.appendDecimal(DateTimeFieldType.yearOfCentury(), n2, n3);
    }

    public DateTimeFormatterBuilder appendYearOfEra(int n2, int n3) {
        return this.appendDecimal(DateTimeFieldType.yearOfEra(), n2, n3);
    }

    public boolean canBuildFormatter() {
        return this.isFormatter(this.getFormatter());
    }

    public boolean canBuildParser() {
        return this.isParser(this.getFormatter());
    }

    public boolean canBuildPrinter() {
        return this.isPrinter(this.getFormatter());
    }

    public void clear() {
        this.iFormatter = null;
        this.iElementPairs.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public DateTimeFormatter toFormatter() {
        Object object = this.getFormatter();
        DateTimePrinter dateTimePrinter = this.isPrinter(object) ? (DateTimePrinter)object : null;
        DateTimeParser dateTimeParser = this.isParser(object) ? (DateTimeParser)object : null;
        if (dateTimePrinter == null && dateTimeParser == null) {
            throw new UnsupportedOperationException("Both printing and parsing not supported");
        }
        return new DateTimeFormatter(dateTimePrinter, dateTimeParser);
    }

    public DateTimeParser toParser() {
        Object object = this.getFormatter();
        if (this.isParser(object)) {
            return (DateTimeParser)object;
        }
        throw new UnsupportedOperationException("Parsing is not supported");
    }

    public DateTimePrinter toPrinter() {
        Object object = this.getFormatter();
        if (this.isPrinter(object)) {
            return (DateTimePrinter)object;
        }
        throw new UnsupportedOperationException("Printing is not supported");
    }

    static class CharacterLiteral
    implements DateTimePrinter,
    DateTimeParser {
        private final char iValue;

        CharacterLiteral(char c2) {
            this.iValue = c2;
        }

        @Override
        public int estimateParsedLength() {
            return 1;
        }

        @Override
        public int estimatePrintedLength() {
            return 1;
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            char c2;
            char c3;
            char c4;
            if (n2 >= string2.length()) {
                return ~n2;
            }
            char c5 = string2.charAt(n2);
            if (c5 != (c4 = this.iValue) && (c3 = Character.toUpperCase(c5)) != (c2 = Character.toUpperCase(c4)) && Character.toLowerCase(c3) != Character.toLowerCase(c2)) {
                return ~n2;
            }
            return n2 + 1;
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            writer.write(this.iValue);
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            writer.write(this.iValue);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            stringBuffer.append(this.iValue);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            stringBuffer.append(this.iValue);
        }
    }

    static class Composite
    implements DateTimePrinter,
    DateTimeParser {
        private final int iParsedLengthEstimate;
        private final DateTimeParser[] iParsers;
        private final int iPrintedLengthEstimate;
        private final DateTimePrinter[] iPrinters;

        /*
         * Enabled aggressive block sorting
         */
        Composite(List<Object> list) {
            int n2 = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            this.decompose(list, arrayList, arrayList2);
            if (arrayList.contains(null) || arrayList.isEmpty()) {
                this.iPrinters = null;
                this.iPrintedLengthEstimate = 0;
            } else {
                DateTimePrinter dateTimePrinter;
                int n3 = arrayList.size();
                this.iPrinters = new DateTimePrinter[n3];
                int n4 = 0;
                for (int i2 = 0; i2 < n3; n4 += dateTimePrinter.estimatePrintedLength(), ++i2) {
                    dateTimePrinter = (DateTimePrinter)arrayList.get(i2);
                    this.iPrinters[i2] = dateTimePrinter;
                }
                this.iPrintedLengthEstimate = n4;
            }
            if (arrayList2.contains(null) || arrayList2.isEmpty()) {
                this.iParsers = null;
                this.iParsedLengthEstimate = 0;
                return;
            }
            int n5 = arrayList2.size();
            this.iParsers = new DateTimeParser[n5];
            int n6 = 0;
            while (true) {
                if (n2 >= n5) {
                    this.iParsedLengthEstimate = n6;
                    return;
                }
                DateTimeParser dateTimeParser = (DateTimeParser)arrayList2.get(n2);
                n6 += dateTimeParser.estimateParsedLength();
                this.iParsers[n2] = dateTimeParser;
                ++n2;
            }
        }

        private void addArrayToList(List<Object> list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    list.add(objectArray[i2]);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void decompose(List<Object> list, List<Object> list2, List<Object> list3) {
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                Object object2 = list.get(n3);
                if (object2 instanceof Composite) {
                    this.addArrayToList(list2, ((Composite)object2).iPrinters);
                } else {
                    list2.add(object2);
                }
                if ((object = list.get(n3 + 1)) instanceof Composite) {
                    this.addArrayToList(list3, ((Composite)object).iParsers);
                } else {
                    list3.add(object);
                }
                n3 += 2;
            }
            return;
        }

        @Override
        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        @Override
        public int estimatePrintedLength() {
            return this.iPrintedLengthEstimate;
        }

        boolean isParser() {
            return this.iParsers != null;
        }

        boolean isPrinter() {
            return this.iPrinters != null;
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            DateTimeParser[] dateTimeParserArray = this.iParsers;
            if (dateTimeParserArray == null) {
                throw new UnsupportedOperationException();
            }
            int n3 = dateTimeParserArray.length;
            for (int i2 = 0; i2 < n3 && n2 >= 0; ++i2) {
                n2 = dateTimeParserArray[i2].parseInto(dateTimeParserBucket, string2, n2);
            }
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            Locale locale2 = locale == null ? Locale.getDefault() : locale;
            int n3 = dateTimePrinterArray.length;
            int n4 = 0;
            while (n4 < n3) {
                dateTimePrinterArray[n4].printTo(writer, l2, chronology, n2, dateTimeZone, locale2);
                ++n4;
            }
            return;
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n2 = dateTimePrinterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                dateTimePrinterArray[i2].printTo(writer, readablePartial, locale);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            Locale locale2 = locale == null ? Locale.getDefault() : locale;
            int n3 = dateTimePrinterArray.length;
            int n4 = 0;
            while (n4 < n3) {
                dateTimePrinterArray[n4].printTo(stringBuffer, l2, chronology, n2, dateTimeZone, locale2);
                ++n4;
            }
            return;
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n2 = dateTimePrinterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                dateTimePrinterArray[i2].printTo(stringBuffer, readablePartial, locale);
            }
        }
    }

    static class FixedNumber
    extends PaddedNumber {
        protected FixedNumber(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            super(dateTimeFieldType, n2, bl2, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            int n3;
            block6: {
                block5: {
                    char c2;
                    int n4;
                    n3 = super.parseInto(dateTimeParserBucket, string2, n2);
                    if (n3 < 0 || n3 == (n4 = n2 + this.iMaxParsedDigits)) break block5;
                    if (this.iSigned && ((c2 = string2.charAt(n2)) == '-' || c2 == '+')) {
                        ++n4;
                    }
                    if (n3 > n4) {
                        return 0xFFFFFFFF ^ n4 + 1;
                    }
                    if (n3 < n4) break block6;
                }
                return n3;
            }
            return ~n3;
        }
    }

    static class Fraction
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimeFieldType iFieldType;
        protected int iMaxDigits;
        protected int iMinDigits;

        protected Fraction(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
            this.iFieldType = dateTimeFieldType;
            if (n3 > 18) {
                n3 = 18;
            }
            this.iMinDigits = n2;
            this.iMaxDigits = n3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private long[] getFractionData(long l2, DateTimeField dateTimeField) {
            long l3 = dateTimeField.getDurationField().getUnitMillis();
            int n2 = this.iMaxDigits;
            while (true) {
                long l4;
                switch (n2) {
                    default: {
                        l4 = 1L;
                        break;
                    }
                    case 1: {
                        l4 = 10L;
                        break;
                    }
                    case 2: {
                        l4 = 100L;
                        break;
                    }
                    case 3: {
                        l4 = 1000L;
                        break;
                    }
                    case 4: {
                        l4 = 10000L;
                        break;
                    }
                    case 5: {
                        l4 = 100000L;
                        break;
                    }
                    case 6: {
                        l4 = 1000000L;
                        break;
                    }
                    case 7: {
                        l4 = 10000000L;
                        break;
                    }
                    case 8: {
                        l4 = 100000000L;
                        break;
                    }
                    case 9: {
                        l4 = 1000000000L;
                        break;
                    }
                    case 10: {
                        l4 = 10000000000L;
                        break;
                    }
                    case 11: {
                        l4 = 100000000000L;
                        break;
                    }
                    case 12: {
                        l4 = 1000000000000L;
                        break;
                    }
                    case 13: {
                        l4 = 10000000000000L;
                        break;
                    }
                    case 14: {
                        l4 = 100000000000000L;
                        break;
                    }
                    case 15: {
                        l4 = 1000000000000000L;
                        break;
                    }
                    case 16: {
                        l4 = 10000000000000000L;
                        break;
                    }
                    case 17: {
                        l4 = 100000000000000000L;
                        break;
                    }
                    case 18: {
                        l4 = 1000000000000000000L;
                    }
                }
                if (l3 * l4 / l4 == l3) {
                    long[] lArray = new long[]{l4 * l2 / l3, n2};
                    return lArray;
                }
                --n2;
            }
        }

        @Override
        public int estimateParsedLength() {
            return this.iMaxDigits;
        }

        @Override
        public int estimatePrintedLength() {
            return this.iMaxDigits;
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            long l2;
            DateTimeField dateTimeField = this.iFieldType.getField(dateTimeParserBucket.getChronology());
            int n3 = Math.min(this.iMaxDigits, string2.length() - n2);
            long l3 = 0L;
            long l4 = 10L * dateTimeField.getDurationField().getUnitMillis();
            int n4 = 0;
            while (true) {
                char c2;
                if (n4 >= n3 || (c2 = string2.charAt(n2 + n4)) < '0' || c2 > '9') {
                    l2 = l3 / 10L;
                    if (n4 != 0) break;
                    return ~n2;
                }
                ++n4;
                l3 += (l4 /= 10L) * (long)(c2 - 48);
            }
            if (l2 > Integer.MAX_VALUE) {
                return ~n2;
            }
            dateTimeParserBucket.saveField(new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), MillisDurationField.INSTANCE, dateTimeField.getDurationField()), (int)l2);
            return n4 + n2;
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            this.printTo(null, writer, l2, chronology);
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            this.printTo(null, writer, readablePartial.getChronology().set(readablePartial, 0L), readablePartial.getChronology());
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            try {
                this.printTo(stringBuffer, null, l2, chronology);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        protected void printTo(StringBuffer var1_1, Writer var2_2, long var3_3, Chronology var5_4) throws IOException {
            block19: {
                block18: {
                    block17: {
                        block14: {
                            block15: {
                                block16: {
                                    var6_5 = this.iFieldType.getField(var5_4);
                                    var7_6 = this.iMinDigits;
                                    try {
                                        var9_7 = var6_5.remainder(var3_3);
                                        if (var9_7 != 0L) break block14;
                                        if (var1_1 == null) break block15;
                                    }
                                    catch (RuntimeException var8_8) {
                                        if (var1_1 == null) break block16;
                                        DateTimeFormatterBuilder.appendUnknownString(var1_1, var7_6);
                                    }
                                    while (--var7_6 >= 0) {
                                        var1_1.append('0');
                                    }
lbl16:
                                    // 4 sources

                                    return;
                                }
                                DateTimeFormatterBuilder.printUnknownString(var2_2, var7_6);
                                return;
                            }
                            while (true) {
                                if (--var7_6 < 0) ** GOTO lbl16
                                var2_2.write(48);
                            }
                        }
                        var11_9 = this.getFractionData(var9_7, var6_5);
                        var12_10 = var11_9[0];
                        var14_11 = (int)var11_9[1];
                        if ((0x7FFFFFFFL & var12_10) == var12_10) {
                            var15_12 = Integer.toString((int)var12_10);
lbl32:
                            // 2 sources

                            while (true) {
                                var16_13 = var15_12.length();
                                block6: while (var16_13 < var14_11) {
                                    if (var1_1 != null) {
                                        var1_1.append('0');
lbl38:
                                        // 2 sources

                                        while (true) {
                                            --var7_6;
                                            --var14_11;
                                            continue block6;
                                            break;
                                        }
                                    }
                                    break block17;
                                }
                                break block18;
                                break;
                            }
                        }
                        var15_12 = Long.toString(var12_10);
                        ** while (true)
                    }
                    var2_2.write(48);
                    ** while (true)
                }
                if (var7_6 >= var14_11) break block19;
                while (true) {
                    block21: {
                        if (var7_6 < var14_11 && var16_13 > 1 && var15_12.charAt(var16_13 - 1) == '0') break block21;
                        if (var16_13 >= var15_12.length()) break block19;
                        if (var1_1 == null) break;
                        var19_14 = 0;
                        while (true) {
                            if (var19_14 >= var16_13) ** GOTO lbl16
                            var1_1.append(var15_12.charAt(var19_14));
                            ++var19_14;
                        }
                    }
                    --var14_11;
                    --var16_13;
                }
                var18_15 = 0;
                while (true) {
                    if (var18_15 < var16_13) ** break;
                    ** continue;
                    var2_2.write(var15_12.charAt(var18_15));
                    ++var18_15;
                }
            }
            if (var1_1 != null) {
                var1_1.append(var15_12);
                return;
            }
            var2_2.write(var15_12);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            long l2 = readablePartial.getChronology().set(readablePartial, 0L);
            try {
                this.printTo(stringBuffer, null, l2, readablePartial.getChronology());
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    static class MatchingParser
    implements DateTimeParser {
        private final int iParsedLengthEstimate;
        private final DateTimeParser[] iParsers;

        /*
         * Enabled aggressive block sorting
         */
        MatchingParser(DateTimeParser[] dateTimeParserArray) {
            this.iParsers = dateTimeParserArray;
            int n2 = 0;
            int n3 = dateTimeParserArray.length;
            while (true) {
                int n4;
                int n5;
                if ((n5 = n3 - 1) < 0) {
                    this.iParsedLengthEstimate = n2;
                    return;
                }
                DateTimeParser dateTimeParser = dateTimeParserArray[n5];
                if (dateTimeParser == null || (n4 = dateTimeParser.estimateParsedLength()) <= n2) {
                    n4 = n2;
                }
                n2 = n4;
                n3 = n5;
            }
        }

        @Override
        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int parseInto(DateTimeParserBucket var1_1, String var2_2, int var3_3) {
            var4_4 = this.iParsers;
            var5_5 = var4_4.length;
            var6_6 = var1_1.saveState();
            var7_7 = null;
            var9_9 = var3_3;
            var10_10 = var3_3;
            block0: for (var8_8 = 0; var8_8 < var5_5; ++var8_8) {
                block11: {
                    block9: {
                        block10: {
                            var13_11 = var4_4[var8_8];
                            if (var13_11 == null) {
                                if (var10_10 <= var3_3) {
                                    return var3_3;
                                }
                                var11_16 = true;
lbl13:
                                // 2 sources

                                while (true) {
                                    if (var10_10 > var3_3 || var10_10 == var3_3 && var11_16) {
                                        if (var7_7 != null) {
                                            var1_1.restoreState(var7_7);
                                        }
                                        return var10_10;
                                    }
                                    break block9;
                                    break;
                                }
                            }
                            var14_12 = var13_11.parseInto(var1_1, var2_2, var3_3);
                            if (var14_12 < var3_3) break block10;
                            if (var14_12 > var10_10) {
                                if (var14_12 >= var2_2.length() || var8_8 + 1 >= var5_5 || var4_4[var8_8 + 1] == null) {
                                    return var14_12;
                                }
                                var15_13 = var1_1.saveState();
                                var16_14 = var14_12;
lbl27:
                                // 3 sources

                                while (true) {
                                    var1_1.restoreState(var6_6);
                                    var10_10 = var16_14;
                                    var7_7 = var15_13;
                                    continue block0;
                                    break;
                                }
                            }
                            break block11;
                        }
                        if (var14_12 >= 0 || (var18_15 = ~var14_12) <= var9_9) break block11;
                        var9_9 = var18_15;
                        var15_13 = var7_7;
                        var16_14 = var10_10;
                        ** GOTO lbl27
                    }
                    return ~var9_9;
                }
                var15_13 = var7_7;
                var16_14 = var10_10;
                ** continue;
            }
            var11_16 = false;
            ** while (true)
        }
    }

    static abstract class NumberFormatter
    implements DateTimePrinter,
    DateTimeParser {
        protected final DateTimeFieldType iFieldType;
        protected final int iMaxParsedDigits;
        protected final boolean iSigned;

        NumberFormatter(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            this.iFieldType = dateTimeFieldType;
            this.iMaxParsedDigits = n2;
            this.iSigned = bl2;
        }

        @Override
        public int estimateParsedLength() {
            return this.iMaxParsedDigits;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            int n3;
            int n4;
            block14: {
                boolean bl2;
                int n5;
                int n6;
                block13: {
                    block12: {
                        int n7 = Math.min(this.iMaxParsedDigits, string2.length() - n2);
                        boolean bl3 = false;
                        int n8 = n7;
                        n6 = n2;
                        n5 = 0;
                        while (n5 < n8) {
                            char c2 = string2.charAt(n6 + n5);
                            if (n5 == 0 && (c2 == '-' || c2 == '+') && this.iSigned) {
                                char c3;
                                bl3 = c2 == '-';
                                if (n5 + 1 >= n8 || (c3 = string2.charAt(1 + (n6 + n5))) < '0') break;
                                if (c3 > '9') {
                                    bl2 = bl3;
                                    break block12;
                                } else {
                                    if (bl3) {
                                        ++n5;
                                    } else {
                                        ++n6;
                                    }
                                    n8 = Math.min(n8 + 1, string2.length() - n6);
                                    continue;
                                }
                            }
                            if (c2 < '0') break;
                            if (c2 > '9') {
                                bl2 = bl3;
                                break block12;
                            }
                            ++n5;
                        }
                        bl2 = bl3;
                    }
                    if (n5 == 0) {
                        return ~n6;
                    }
                    if (n5 < 9) break block13;
                    int n9 = n6 + n5;
                    n4 = Integer.parseInt(string2.substring(n6, n9));
                    n3 = n9;
                    break block14;
                }
                int n10 = bl2 ? n6 + 1 : n6;
                int n11 = n10 + 1;
                try {
                    char c4 = string2.charAt(n10);
                    int n12 = c4 - 48;
                    n3 = n6 + n5;
                    n4 = n12;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ~n6;
                }
                while (n11 < n3) {
                    int n13 = (n4 << 3) + (n4 << 1);
                    int n14 = n11 + 1;
                    n4 = -48 + (n13 + string2.charAt(n11));
                    n11 = n14;
                }
                if (bl2) {
                    n4 = -n4;
                }
            }
            dateTimeParserBucket.saveField(this.iFieldType, n4);
            return n3;
        }
    }

    static class PaddedNumber
    extends NumberFormatter {
        protected final int iMinPrintedDigits;

        protected PaddedNumber(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2, int n3) {
            super(dateTimeFieldType, n2, bl2);
            this.iMinPrintedDigits = n3;
        }

        @Override
        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                FormatUtils.writePaddedInteger(writer, this.iFieldType.getField(chronology).get(l2), this.iMinPrintedDigits);
                return;
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.printUnknownString(writer, this.iMinPrintedDigits);
                return;
            }
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writePaddedInteger(writer, readablePartial.get(this.iFieldType), this.iMinPrintedDigits);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    DateTimeFormatterBuilder.printUnknownString(writer, this.iMinPrintedDigits);
                    return;
                }
            }
            DateTimeFormatterBuilder.printUnknownString(writer, this.iMinPrintedDigits);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            try {
                FormatUtils.appendPaddedInteger(stringBuffer, this.iFieldType.getField(chronology).get(l2), this.iMinPrintedDigits);
                return;
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(stringBuffer, this.iMinPrintedDigits);
                return;
            }
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendPaddedInteger(stringBuffer, readablePartial.get(this.iFieldType), this.iMinPrintedDigits);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    DateTimeFormatterBuilder.appendUnknownString(stringBuffer, this.iMinPrintedDigits);
                    return;
                }
            }
            DateTimeFormatterBuilder.appendUnknownString(stringBuffer, this.iMinPrintedDigits);
        }
    }

    static class StringLiteral
    implements DateTimePrinter,
    DateTimeParser {
        private final String iValue;

        StringLiteral(String string2) {
            this.iValue = string2;
        }

        @Override
        public int estimateParsedLength() {
            return this.iValue.length();
        }

        @Override
        public int estimatePrintedLength() {
            return this.iValue.length();
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            if (string2.regionMatches(true, n2, this.iValue, 0, this.iValue.length())) {
                return n2 + this.iValue.length();
            }
            return ~n2;
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            writer.write(this.iValue);
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            writer.write(this.iValue);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            stringBuffer.append(this.iValue);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            stringBuffer.append(this.iValue);
        }
    }

    static class TextField
    implements DateTimePrinter,
    DateTimeParser {
        private static Map<Locale, Map<DateTimeFieldType, Object[]>> cParseCache = new HashMap<Locale, Map<DateTimeFieldType, Object[]>>();
        private final DateTimeFieldType iFieldType;
        private final boolean iShort;

        TextField(DateTimeFieldType dateTimeFieldType, boolean bl2) {
            this.iFieldType = dateTimeFieldType;
            this.iShort = bl2;
        }

        private String print(long l2, Chronology chronology, Locale locale) {
            DateTimeField dateTimeField = this.iFieldType.getField(chronology);
            if (this.iShort) {
                return dateTimeField.getAsShortText(l2, locale);
            }
            return dateTimeField.getAsText(l2, locale);
        }

        private String print(ReadablePartial readablePartial, Locale locale) {
            if (readablePartial.isSupported(this.iFieldType)) {
                DateTimeField dateTimeField = this.iFieldType.getField(readablePartial.getChronology());
                if (this.iShort) {
                    return dateTimeField.getAsShortText(readablePartial, locale);
                }
                return dateTimeField.getAsText(readablePartial, locale);
            }
            return "\ufffd";
        }

        @Override
        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        @Override
        public int estimatePrintedLength() {
            if (this.iShort) {
                return 6;
            }
            return 20;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            int n3;
            Set<String> set;
            Locale locale = dateTimeParserBucket.getLocale();
            Map<Locale, Map<DateTimeFieldType, Object[]>> map = cParseCache;
            synchronized (map) {
                Object[] objectArray;
                Map<DateTimeFieldType, Object[]> map2;
                Map<DateTimeFieldType, Object[]> map3 = cParseCache.get(locale);
                if (map3 == null) {
                    HashMap<DateTimeFieldType, Object[]> hashMap = new HashMap<DateTimeFieldType, Object[]>();
                    cParseCache.put(locale, hashMap);
                    map2 = hashMap;
                } else {
                    map2 = map3;
                }
                if ((objectArray = map2.get(this.iFieldType)) == null) {
                    int n4;
                    set = new HashSet(32);
                    MutableDateTime.Property property = new MutableDateTime(0L, DateTimeZone.UTC).property(this.iFieldType);
                    int n5 = property.getMaximumValueOverall();
                    if (n5 - n4 > 32) {
                        return ~n2;
                    }
                    n3 = property.getMaximumTextLength(locale);
                    for (n4 = property.getMinimumValueOverall(); n4 <= n5; ++n4) {
                        property.set(n4);
                        set.add(property.getAsShortText(locale));
                        set.add(property.getAsShortText(locale).toLowerCase(locale));
                        set.add(property.getAsShortText(locale).toUpperCase(locale));
                        set.add(property.getAsText(locale));
                        set.add(property.getAsText(locale).toLowerCase(locale));
                        set.add(property.getAsText(locale).toUpperCase(locale));
                    }
                    if ("en".equals(locale.getLanguage()) && this.iFieldType == DateTimeFieldType.era()) {
                        set.add("BCE");
                        set.add("bce");
                        set.add("CE");
                        set.add("ce");
                        n3 = 3;
                    }
                    Object[] objectArray2 = new Object[]{set, n3};
                    map2.put(this.iFieldType, objectArray2);
                } else {
                    set = (Set)objectArray[0];
                    n3 = (Integer)objectArray[1];
                }
            }
            int n6 = Math.min(string2.length(), n3 + n2);
            while (n6 > n2) {
                String string3 = string2.substring(n2, n6);
                if (set.contains(string3)) {
                    dateTimeParserBucket.saveField(this.iFieldType, string3, locale);
                    return n6;
                }
                --n6;
            }
            return ~n2;
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                writer.write(this.print(l2, chronology, locale));
                return;
            }
            catch (RuntimeException runtimeException) {
                writer.write(65533);
                return;
            }
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            try {
                writer.write(this.print(readablePartial, locale));
                return;
            }
            catch (RuntimeException runtimeException) {
                writer.write(65533);
                return;
            }
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            try {
                stringBuffer.append(this.print(l2, chronology, locale));
                return;
            }
            catch (RuntimeException runtimeException) {
                stringBuffer.append('\ufffd');
                return;
            }
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            try {
                stringBuffer.append(this.print(readablePartial, locale));
                return;
            }
            catch (RuntimeException runtimeException) {
                stringBuffer.append('\ufffd');
                return;
            }
        }
    }

    static final class TimeZoneId
    extends Enum<TimeZoneId>
    implements DateTimePrinter,
    DateTimeParser {
        private static final /* synthetic */ TimeZoneId[] $VALUES;
        static final Set<String> ALL_IDS;
        public static final /* enum */ TimeZoneId INSTANCE;
        static final int MAX_LENGTH;

        static {
            INSTANCE = new TimeZoneId();
            TimeZoneId[] timeZoneIdArray = new TimeZoneId[]{INSTANCE};
            $VALUES = timeZoneIdArray;
            ALL_IDS = DateTimeZone.getAvailableIDs();
            Iterator<String> iterator = ALL_IDS.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                n2 = Math.max(n2, iterator.next().length());
            }
            MAX_LENGTH = n2;
        }

        public static TimeZoneId valueOf(String string2) {
            return Enum.valueOf(TimeZoneId.class, string2);
        }

        public static final TimeZoneId[] values() {
            return (TimeZoneId[])$VALUES.clone();
        }

        @Override
        public int estimateParsedLength() {
            return MAX_LENGTH;
        }

        @Override
        public int estimatePrintedLength() {
            return MAX_LENGTH;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            String string3 = string2.substring(n2);
            String string4 = null;
            Iterator<String> iterator = ALL_IDS.iterator();
            while (true) {
                String string5;
                block4: {
                    block3: {
                        block2: {
                            if (!iterator.hasNext()) break block2;
                            string5 = iterator.next();
                            if (!string3.startsWith(string5) || string4 != null && string5.length() <= string4.length()) break block3;
                            break block4;
                        }
                        if (string4 != null) {
                            dateTimeParserBucket.setZone(DateTimeZone.forID(string4));
                            return n2 + string4.length();
                        }
                        return ~n2;
                    }
                    string5 = string4;
                }
                string4 = string5;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            String string2 = dateTimeZone != null ? dateTimeZone.getID() : "";
            writer.write(string2);
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            String string2 = dateTimeZone != null ? dateTimeZone.getID() : "";
            stringBuffer.append(string2);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
        }
    }

    static class TimeZoneName
    implements DateTimePrinter,
    DateTimeParser {
        static final int LONG_NAME = 0;
        static final int SHORT_NAME = 1;
        private final Map<String, DateTimeZone> iParseLookup;
        private final int iType;

        TimeZoneName(int n2, Map<String, DateTimeZone> map) {
            this.iType = n2;
            this.iParseLookup = map;
        }

        private String print(long l2, DateTimeZone dateTimeZone, Locale locale) {
            if (dateTimeZone == null) {
                return "";
            }
            switch (this.iType) {
                default: {
                    return "";
                }
                case 0: {
                    return dateTimeZone.getName(l2, locale);
                }
                case 1: 
            }
            return dateTimeZone.getShortName(l2, locale);
        }

        @Override
        public int estimateParsedLength() {
            if (this.iType == 1) {
                return 4;
            }
            return 20;
        }

        @Override
        public int estimatePrintedLength() {
            if (this.iType == 1) {
                return 4;
            }
            return 20;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            Map<String, DateTimeZone> map = this.iParseLookup;
            Map<String, DateTimeZone> map2 = map != null ? map : DateTimeUtils.getDefaultTimeZoneNames();
            String string3 = string2.substring(n2);
            String string4 = null;
            Iterator<String> iterator = map2.keySet().iterator();
            while (true) {
                String string5;
                block4: {
                    block3: {
                        block2: {
                            if (!iterator.hasNext()) break block2;
                            string5 = iterator.next();
                            if (!string3.startsWith(string5) || string4 != null && string5.length() <= string4.length()) break block3;
                            break block4;
                        }
                        if (string4 != null) {
                            dateTimeParserBucket.setZone(map2.get(string4));
                            return n2 + string4.length();
                        }
                        return ~n2;
                    }
                    string5 = string4;
                }
                string4 = string5;
            }
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            writer.write(this.print(l2 - (long)n2, dateTimeZone, locale));
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            stringBuffer.append(this.print(l2 - (long)n2, dateTimeZone, locale));
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
        }
    }

    static class TimeZoneOffset
    implements DateTimePrinter,
    DateTimeParser {
        private final int iMaxFields;
        private final int iMinFields;
        private final boolean iShowSeparators;
        private final String iZeroOffsetParseText;
        private final String iZeroOffsetPrintText;

        /*
         * Enabled aggressive block sorting
         */
        TimeZoneOffset(String string2, String string3, boolean bl2, int n2, int n3) {
            int n4 = 4;
            this.iZeroOffsetPrintText = string2;
            this.iZeroOffsetParseText = string3;
            this.iShowSeparators = bl2;
            if (n2 <= 0 || n3 < n2) {
                throw new IllegalArgumentException();
            }
            if (n2 > n4) {
                n3 = n4;
            } else {
                n4 = n2;
            }
            this.iMinFields = n4;
            this.iMaxFields = n3;
        }

        private int digitCount(String string2, int n2, int n3) {
            int n4 = Math.min(string2.length() - n2, n3);
            int n5 = 0;
            char c2;
            while (n4 > 0 && (c2 = string2.charAt(n2 + n5)) >= '0' && c2 <= '9') {
                ++n5;
                --n4;
            }
            return n5;
        }

        @Override
        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        @Override
        public int estimatePrintedLength() {
            int n2 = 1 + this.iMinFields << 1;
            if (this.iShowSeparators) {
                n2 += -1 + this.iMinFields;
            }
            if (this.iZeroOffsetPrintText != null && this.iZeroOffsetPrintText.length() > n2) {
                n2 = this.iZeroOffsetPrintText.length();
            }
            return n2;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int parseInto(DateTimeParserBucket var1_1, String var2_2, int var3_3) {
            block33: {
                block17: {
                    block32: {
                        block30: {
                            block31: {
                                block29: {
                                    block28: {
                                        block26: {
                                            block27: {
                                                block25: {
                                                    block23: {
                                                        block24: {
                                                            block22: {
                                                                block21: {
                                                                    block19: {
                                                                        block20: {
                                                                            block18: {
                                                                                var4_4 = var2_2.length() - var3_3;
                                                                                if (this.iZeroOffsetParseText == null) break block18;
                                                                                if (this.iZeroOffsetParseText.length() != 0) break block19;
                                                                                if (var4_4 <= 0 || (var33_5 = var2_2.charAt(var3_3)) != '-' && var33_5 != '+') break block20;
                                                                            }
lbl6:
                                                                            // 2 sources

                                                                            while (var4_4 <= 1) {
                                                                                return ~var3_3;
                                                                            }
                                                                            break block21;
                                                                        }
                                                                        var1_1.setOffset((Integer)0);
                                                                        return var3_3;
                                                                    }
                                                                    if (!var2_2.regionMatches(true, var3_3, this.iZeroOffsetParseText, 0, this.iZeroOffsetParseText.length())) ** GOTO lbl6
                                                                    var1_1.setOffset((Integer)0);
                                                                    return var3_3 + this.iZeroOffsetParseText.length();
                                                                }
                                                                var5_6 = var2_2.charAt(var3_3);
                                                                if (var5_6 == '-') {
                                                                    var6_7 = true;
lbl20:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        var7_8 = var4_4 - 1;
                                                                        var8_9 = var3_3 + 1;
                                                                        if (this.digitCount(var2_2, var8_9, 2) < 2) {
                                                                            return ~var8_9;
                                                                        }
                                                                        break;
                                                                    }
                                                                } else {
                                                                    if (var5_6 == '+') {
                                                                        var6_7 = false;
                                                                        ** continue;
                                                                    }
                                                                    return ~var3_3;
                                                                }
                                                                var9_10 = FormatUtils.parseTwoDigits(var2_2, var8_9);
                                                                if (var9_10 > 23) {
                                                                    return ~var8_9;
                                                                }
                                                                var10_11 = var9_10 * 3600000;
                                                                var11_12 = var7_8 - 2;
                                                                var12_13 = var8_9 + 2;
                                                                if (var11_12 <= 0) {
                                                                    var15_14 = var10_11;
                                                                    var16_15 = var12_13;
lbl39:
                                                                    // 12 sources

                                                                    while (true) {
                                                                        if (var6_7) {
                                                                            var17_16 = -var15_14;
lbl42:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                var1_1.setOffset((Integer)var17_16);
                                                                                return var16_15;
                                                                            }
                                                                        }
                                                                        break block17;
                                                                        break;
                                                                    }
                                                                }
                                                                var13_17 = var2_2.charAt(var12_13);
                                                                if (var13_17 != ':') break block22;
                                                                --var11_12;
                                                                ++var12_13;
                                                                var14_18 = true;
lbl51:
                                                                // 2 sources

                                                                while ((var18_19 = this.digitCount(var2_2, var12_13, 2)) == 0 && !var14_18) {
                                                                    var15_14 = var10_11;
                                                                    var16_15 = var12_13;
                                                                    ** GOTO lbl39
                                                                }
                                                                break block23;
                                                            }
                                                            if (var13_17 < '0') break block24;
                                                            var14_18 = false;
                                                            if (var13_17 <= '9') ** GOTO lbl51
                                                        }
                                                        var15_14 = var10_11;
                                                        var16_15 = var12_13;
                                                        ** GOTO lbl39
                                                    }
                                                    if (var18_19 < 2) {
                                                        return ~var12_13;
                                                    }
                                                    var19_20 = FormatUtils.parseTwoDigits(var2_2, var12_13);
                                                    if (var19_20 > 59) {
                                                        return ~var12_13;
                                                    }
                                                    var20_21 = var10_11 + var19_20 * 60000;
                                                    var21_22 = var11_12 - 2;
                                                    var22_23 = var12_13 + 2;
                                                    if (var21_22 > 0) break block25;
                                                    var15_14 = var20_21;
                                                    var16_15 = var22_23;
                                                    ** GOTO lbl39
                                                }
                                                if (!var14_18) break block26;
                                                if (var2_2.charAt(var22_23) == ':') break block27;
                                                var15_14 = var20_21;
                                                var16_15 = var22_23;
                                                ** GOTO lbl39
                                            }
                                            --var21_22;
                                            ++var22_23;
                                        }
                                        if ((var23_24 = this.digitCount(var2_2, var22_23, 2)) != 0 || var14_18) break block28;
                                        var15_14 = var20_21;
                                        var16_15 = var22_23;
                                        ** GOTO lbl39
                                    }
                                    if (var23_24 < 2) {
                                        return ~var22_23;
                                    }
                                    var24_25 = FormatUtils.parseTwoDigits(var2_2, var22_23);
                                    if (var24_25 > 59) {
                                        return ~var22_23;
                                    }
                                    var25_26 = var20_21 + var24_25 * 1000;
                                    var26_27 = var21_22 - 2;
                                    var27_28 = var22_23 + 2;
                                    if (var26_27 > 0) break block29;
                                    var15_14 = var25_26;
                                    var16_15 = var27_28;
                                    ** GOTO lbl39
                                }
                                if (!var14_18) break block30;
                                if (var2_2.charAt(var27_28) == '.' || var2_2.charAt(var27_28) == ',') break block31;
                                var15_14 = var25_26;
                                var16_15 = var27_28;
                                ** GOTO lbl39
                            }
                            var26_27 - 1;
                            ++var27_28;
                        }
                        if ((var28_29 = this.digitCount(var2_2, var27_28, 3)) != 0 || var14_18) break block32;
                        var15_14 = var25_26;
                        var16_15 = var27_28;
                        ** GOTO lbl39
                    }
                    if (var28_29 < 1) {
                        return ~var27_28;
                    }
                    var29_30 = var27_28 + 1;
                    var30_31 = var25_26 + 100 * (-48 + var2_2.charAt(var27_28));
                    if (var28_29 <= 1) break block33;
                    var16_15 = var29_30 + 1;
                    var15_14 = var30_31 + 10 * (-48 + var2_2.charAt(var29_30));
                    if (var28_29 <= 2) ** GOTO lbl39
                    var31_32 = var16_15 + 1;
                    var15_14 += -48 + var2_2.charAt(var16_15);
                    var16_15 = var31_32;
                    ** GOTO lbl39
                }
                var17_16 = var15_14;
                ** while (true)
            }
            var15_14 = var30_31;
            var16_15 = var29_30;
            ** while (true)
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            int n3;
            block10: {
                block9: {
                    int n4;
                    int n5;
                    if (dateTimeZone == null) break block9;
                    if (n2 == 0 && this.iZeroOffsetPrintText != null) {
                        writer.write(this.iZeroOffsetPrintText);
                        return;
                    }
                    if (n2 >= 0) {
                        writer.write(43);
                    } else {
                        writer.write(45);
                        n2 = -n2;
                    }
                    int n6 = n2 / 3600000;
                    FormatUtils.writePaddedInteger(writer, n6, 2);
                    if (this.iMaxFields == 1 || (n5 = n2 - n6 * 3600000) == 0 && this.iMinFields == 1) break block9;
                    int n7 = n5 / 60000;
                    if (this.iShowSeparators) {
                        writer.write(58);
                    }
                    FormatUtils.writePaddedInteger(writer, n7, 2);
                    if (this.iMaxFields == 2 || (n4 = n5 - n7 * 60000) == 0 && this.iMinFields == 2) break block9;
                    int n8 = n4 / 1000;
                    if (this.iShowSeparators) {
                        writer.write(58);
                    }
                    FormatUtils.writePaddedInteger(writer, n8, 2);
                    if (this.iMaxFields != 3 && ((n3 = n4 - n8 * 1000) != 0 || this.iMinFields != 3)) break block10;
                }
                return;
            }
            if (this.iShowSeparators) {
                writer.write(46);
            }
            FormatUtils.writePaddedInteger(writer, n3, 3);
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            int n3;
            block10: {
                block9: {
                    int n4;
                    int n5;
                    if (dateTimeZone == null) break block9;
                    if (n2 == 0 && this.iZeroOffsetPrintText != null) {
                        stringBuffer.append(this.iZeroOffsetPrintText);
                        return;
                    }
                    if (n2 >= 0) {
                        stringBuffer.append('+');
                    } else {
                        stringBuffer.append('-');
                        n2 = -n2;
                    }
                    int n6 = n2 / 3600000;
                    FormatUtils.appendPaddedInteger(stringBuffer, n6, 2);
                    if (this.iMaxFields == 1 || (n5 = n2 - n6 * 3600000) == 0 && this.iMinFields <= 1) break block9;
                    int n7 = n5 / 60000;
                    if (this.iShowSeparators) {
                        stringBuffer.append(':');
                    }
                    FormatUtils.appendPaddedInteger(stringBuffer, n7, 2);
                    if (this.iMaxFields == 2 || (n4 = n5 - n7 * 60000) == 0 && this.iMinFields <= 2) break block9;
                    int n8 = n4 / 1000;
                    if (this.iShowSeparators) {
                        stringBuffer.append(':');
                    }
                    FormatUtils.appendPaddedInteger(stringBuffer, n8, 2);
                    if (this.iMaxFields != 3 && ((n3 = n4 - n8 * 1000) != 0 || this.iMinFields > 3)) break block10;
                }
                return;
            }
            if (this.iShowSeparators) {
                stringBuffer.append('.');
            }
            FormatUtils.appendPaddedInteger(stringBuffer, n3, 3);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
        }
    }

    static class TwoDigitYear
    implements DateTimePrinter,
    DateTimeParser {
        private final boolean iLenientParse;
        private final int iPivot;
        private final DateTimeFieldType iType;

        TwoDigitYear(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            this.iType = dateTimeFieldType;
            this.iPivot = n2;
            this.iLenientParse = bl2;
        }

        private int getTwoDigitYear(long l2, Chronology chronology) {
            int n2;
            block2: {
                try {
                    n2 = this.iType.getField(chronology).get(l2);
                    if (n2 >= 0) break block2;
                }
                catch (RuntimeException runtimeException) {
                    return -1;
                }
                n2 = -n2;
            }
            int n3 = n2 % 100;
            return n3;
        }

        private int getTwoDigitYear(ReadablePartial readablePartial) {
            if (readablePartial.isSupported(this.iType)) {
                int n2;
                block3: {
                    try {
                        n2 = readablePartial.get(this.iType);
                        if (n2 >= 0) break block3;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    n2 = -n2;
                }
                int n3 = n2 % 100;
                return n3;
            }
            return -1;
        }

        @Override
        public int estimateParsedLength() {
            if (this.iLenientParse) {
                return 4;
            }
            return 2;
        }

        @Override
        public int estimatePrintedLength() {
            return 2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            int n3;
            char c2;
            int n4 = string2.length() - n2;
            if (!this.iLenientParse) {
                if (Math.min(2, n4) < 2) {
                    return ~n2;
                }
            } else {
                int n5 = 0;
                boolean bl2 = false;
                boolean bl3 = false;
                int n6 = n4;
                while (n5 < n6) {
                    char c3 = string2.charAt(n2 + n5);
                    if (n5 == 0 && (c3 == '-' || c3 == '+')) {
                        boolean bl4 = c3 == '-';
                        if (bl4) {
                            ++n5;
                            bl2 = bl4;
                            bl3 = true;
                            continue;
                        }
                        ++n2;
                        int n7 = n6 - 1;
                        bl3 = true;
                        n6 = n7;
                        bl2 = bl4;
                        continue;
                    }
                    if (c3 < '0' || c3 > '9') break;
                    ++n5;
                }
                if (n5 == 0) {
                    return ~n2;
                }
                if (bl3 || n5 != 2) {
                    int n8;
                    int n9;
                    if (n5 >= 9) {
                        n9 = n2 + n5;
                        n8 = Integer.parseInt(string2.substring(n2, n9));
                    } else {
                        int n10;
                        int n11 = bl2 ? n2 + 1 : n2;
                        int n12 = n11 + 1;
                        try {
                            char c4 = string2.charAt(n11);
                            int n13 = c4 - 48;
                            n9 = n2 + n5;
                            n8 = n13;
                            n10 = n12;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            return ~n2;
                        }
                        while (n10 < n9) {
                            int n14 = (n8 << 3) + (n8 << 1);
                            int n15 = n10 + 1;
                            n8 = -48 + (n14 + string2.charAt(n10));
                            n10 = n15;
                        }
                        if (bl2) {
                            n8 = -n8;
                        }
                    }
                    dateTimeParserBucket.saveField(this.iType, n8);
                    return n9;
                }
            }
            if ((c2 = string2.charAt(n2)) < '0' || c2 > '9') {
                return ~n2;
            }
            int n16 = c2 - 48;
            char c5 = string2.charAt(n2 + 1);
            if (c5 < '0' || c5 > '9') {
                return ~n2;
            }
            int n17 = -48 + (c5 + ((n16 << 3) + (n16 << 1)));
            int n18 = this.iPivot;
            if (dateTimeParserBucket.getPivotYear() != null) {
                n18 = dateTimeParserBucket.getPivotYear();
            }
            int n19 = (n3 = n18 - 50) >= 0 ? n3 % 100 : 99 + (n3 + 1) % 100;
            int n20 = 0;
            if (n17 < n19) {
                n20 = 100;
            }
            int n21 = n17 + (n20 + n3 - n19);
            dateTimeParserBucket.saveField(this.iType, n21);
            return n2 + 2;
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            int n3 = this.getTwoDigitYear(l2, chronology);
            if (n3 < 0) {
                writer.write(65533);
                writer.write(65533);
                return;
            }
            FormatUtils.writePaddedInteger(writer, n3, 2);
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            int n2 = this.getTwoDigitYear(readablePartial);
            if (n2 < 0) {
                writer.write(65533);
                writer.write(65533);
                return;
            }
            FormatUtils.writePaddedInteger(writer, n2, 2);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            int n3 = this.getTwoDigitYear(l2, chronology);
            if (n3 < 0) {
                stringBuffer.append('\ufffd');
                stringBuffer.append('\ufffd');
                return;
            }
            FormatUtils.appendPaddedInteger(stringBuffer, n3, 2);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            int n2 = this.getTwoDigitYear(readablePartial);
            if (n2 < 0) {
                stringBuffer.append('\ufffd');
                stringBuffer.append('\ufffd');
                return;
            }
            FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
        }
    }

    static class UnpaddedNumber
    extends NumberFormatter {
        protected UnpaddedNumber(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            super(dateTimeFieldType, n2, bl2);
        }

        @Override
        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                FormatUtils.writeUnpaddedInteger(writer, this.iFieldType.getField(chronology).get(l2));
                return;
            }
            catch (RuntimeException runtimeException) {
                writer.write(65533);
                return;
            }
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writeUnpaddedInteger(writer, readablePartial.get(this.iFieldType));
                    return;
                }
                catch (RuntimeException runtimeException) {
                    writer.write(65533);
                    return;
                }
            }
            writer.write(65533);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            try {
                FormatUtils.appendUnpaddedInteger(stringBuffer, this.iFieldType.getField(chronology).get(l2));
                return;
            }
            catch (RuntimeException runtimeException) {
                stringBuffer.append('\ufffd');
                return;
            }
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendUnpaddedInteger(stringBuffer, readablePartial.get(this.iFieldType));
                    return;
                }
                catch (RuntimeException runtimeException) {
                    stringBuffer.append('\ufffd');
                    return;
                }
            }
            stringBuffer.append('\ufffd');
        }
    }
}

