/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatter {
    private final Chronology iChrono;
    private final int iDefaultYear;
    private final Locale iLocale;
    private final boolean iOffsetParsed;
    private final DateTimeParser iParser;
    private final Integer iPivotYear;
    private final DateTimePrinter iPrinter;
    private final DateTimeZone iZone;

    public DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = null;
        this.iOffsetParsed = false;
        this.iChrono = null;
        this.iZone = null;
        this.iPivotYear = null;
        this.iDefaultYear = 2000;
    }

    private DateTimeFormatter(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser, Locale locale, boolean bl2, Chronology chronology, DateTimeZone dateTimeZone, Integer n2, int n3) {
        this.iPrinter = dateTimePrinter;
        this.iParser = dateTimeParser;
        this.iLocale = locale;
        this.iOffsetParsed = bl2;
        this.iChrono = chronology;
        this.iZone = dateTimeZone;
        this.iPivotYear = n2;
        this.iDefaultYear = n3;
    }

    private void printTo(Writer writer, long l2, Chronology chronology) throws IOException {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        Chronology chronology2 = this.selectChronology(chronology);
        DateTimeZone dateTimeZone = chronology2.getZone();
        int n2 = dateTimeZone.getOffset(l2);
        long l3 = l2 + (long)n2;
        if ((l2 ^ l3) < 0L && (l2 ^ (long)n2) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n2 = 0;
            l3 = l2;
        }
        dateTimePrinter.printTo(writer, l3, chronology2.withUTC(), n2, dateTimeZone, this.iLocale);
    }

    private void printTo(StringBuffer stringBuffer, long l2, Chronology chronology) {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        Chronology chronology2 = this.selectChronology(chronology);
        DateTimeZone dateTimeZone = chronology2.getZone();
        int n2 = dateTimeZone.getOffset(l2);
        long l3 = l2 + (long)n2;
        if ((l2 ^ l3) < 0L && (l2 ^ (long)n2) >= 0L) {
            dateTimeZone = DateTimeZone.UTC;
            n2 = 0;
            l3 = l2;
        }
        dateTimePrinter.printTo(stringBuffer, l3, chronology2.withUTC(), n2, dateTimeZone, this.iLocale);
    }

    private DateTimeParser requireParser() {
        DateTimeParser dateTimeParser = this.iParser;
        if (dateTimeParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
        return dateTimeParser;
    }

    private DateTimePrinter requirePrinter() {
        DateTimePrinter dateTimePrinter = this.iPrinter;
        if (dateTimePrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        return dateTimePrinter;
    }

    private Chronology selectChronology(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology);
        if (this.iChrono != null) {
            chronology2 = this.iChrono;
        }
        if (this.iZone != null) {
            chronology2 = chronology2.withZone(this.iZone);
        }
        return chronology2;
    }

    @Deprecated
    public Chronology getChronolgy() {
        return this.iChrono;
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public int getDefaultYear() {
        return this.iDefaultYear;
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeParser getParser() {
        return this.iParser;
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public DateTimePrinter getPrinter() {
        return this.iPrinter;
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public boolean isOffsetParsed() {
        return this.iOffsetParsed;
    }

    public boolean isParser() {
        return this.iParser != null;
    }

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DateTime parseDateTime(String string2) {
        int n2;
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n3 = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n3 < 0) {
            n2 = ~n3;
            throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
        }
        if (n3 < string2.length()) {
            n2 = n3;
            throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
        }
        long l2 = dateTimeParserBucket.computeMillis(true, string2);
        if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
            chronology = chronology.withZone(DateTimeZone.forOffsetMillis(dateTimeParserBucket.getOffsetInteger()));
        } else if (dateTimeParserBucket.getZone() != null) {
            chronology = chronology.withZone(dateTimeParserBucket.getZone());
        }
        DateTime dateTime = new DateTime(l2, chronology);
        if (this.iZone == null) return dateTime;
        return dateTime.withZone(this.iZone);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int parseInto(ReadWritableInstant readWritableInstant, String string2, int n2) {
        DateTimeParser dateTimeParser = this.requireParser();
        if (readWritableInstant == null) {
            throw new IllegalArgumentException("Instant must not be null");
        }
        long l2 = readWritableInstant.getMillis();
        Chronology chronology = readWritableInstant.getChronology();
        int n3 = DateTimeUtils.getChronology(chronology).year().get(l2);
        long l3 = l2 + (long)chronology.getZone().getOffset(l2);
        Chronology chronology2 = this.selectChronology(chronology);
        DateTimeParserBucket dateTimeParserBucket = new DateTimeParserBucket(l3, chronology2, this.iLocale, this.iPivotYear, n3);
        int n4 = dateTimeParser.parseInto(dateTimeParserBucket, string2, n2);
        readWritableInstant.setMillis(dateTimeParserBucket.computeMillis(false, string2));
        if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
            chronology2 = chronology2.withZone(DateTimeZone.forOffsetMillis(dateTimeParserBucket.getOffsetInteger()));
        } else if (dateTimeParserBucket.getZone() != null) {
            chronology2 = chronology2.withZone(dateTimeParserBucket.getZone());
        }
        readWritableInstant.setChronology(chronology2);
        if (this.iZone != null) {
            readWritableInstant.setZone(this.iZone);
        }
        return n4;
    }

    public LocalDate parseLocalDate(String string2) {
        return this.parseLocalDateTime(string2).toLocalDate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public LocalDateTime parseLocalDateTime(String string2) {
        int n2;
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n3 = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null).withUTC(), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n3 < 0) {
            n2 = ~n3;
            throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
        }
        if (n3 < string2.length()) {
            n2 = n3;
            throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
        }
        long l2 = dateTimeParserBucket.computeMillis(true, string2);
        if (dateTimeParserBucket.getOffsetInteger() != null) {
            chronology = chronology.withZone(DateTimeZone.forOffsetMillis(dateTimeParserBucket.getOffsetInteger()));
            return new LocalDateTime(l2, chronology);
        }
        if (dateTimeParserBucket.getZone() == null) return new LocalDateTime(l2, chronology);
        chronology = chronology.withZone(dateTimeParserBucket.getZone());
        return new LocalDateTime(l2, chronology);
    }

    public LocalTime parseLocalTime(String string2) {
        return this.parseLocalDateTime(string2).toLocalTime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long parseMillis(String string2) {
        int n2;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n3 = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, this.selectChronology(this.iChrono), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n3 >= 0) {
            if (n3 >= string2.length()) {
                return dateTimeParserBucket.computeMillis(true, string2);
            }
        } else {
            n2 = ~n3;
            throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
        }
        n2 = n3;
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public MutableDateTime parseMutableDateTime(String string2) {
        int n2;
        Chronology chronology;
        DateTimeParserBucket dateTimeParserBucket;
        DateTimeParser dateTimeParser = this.requireParser();
        int n3 = dateTimeParser.parseInto(dateTimeParserBucket = new DateTimeParserBucket(0L, chronology = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), string2, 0);
        if (n3 < 0) {
            n2 = ~n3;
            throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
        }
        if (n3 < string2.length()) {
            n2 = n3;
            throw new IllegalArgumentException(FormatUtils.createErrorMessage(string2, n2));
        }
        long l2 = dateTimeParserBucket.computeMillis(true, string2);
        if (this.iOffsetParsed && dateTimeParserBucket.getOffsetInteger() != null) {
            chronology = chronology.withZone(DateTimeZone.forOffsetMillis(dateTimeParserBucket.getOffsetInteger()));
        } else if (dateTimeParserBucket.getZone() != null) {
            chronology = chronology.withZone(dateTimeParserBucket.getZone());
        }
        MutableDateTime mutableDateTime = new MutableDateTime(l2, chronology);
        if (this.iZone == null) return mutableDateTime;
        mutableDateTime.setZone(this.iZone);
        return mutableDateTime;
    }

    public String print(long l2) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, l2);
        return stringBuffer.toString();
    }

    public String print(ReadableInstant readableInstant) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, readableInstant);
        return stringBuffer.toString();
    }

    public String print(ReadablePartial readablePartial) {
        StringBuffer stringBuffer = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(stringBuffer, readablePartial);
        return stringBuffer.toString();
    }

    public void printTo(Writer writer, long l2) throws IOException {
        this.printTo(writer, l2, null);
    }

    public void printTo(Writer writer, ReadableInstant readableInstant) throws IOException {
        this.printTo(writer, DateTimeUtils.getInstantMillis(readableInstant), DateTimeUtils.getInstantChronology(readableInstant));
    }

    public void printTo(Writer writer, ReadablePartial readablePartial) throws IOException {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        dateTimePrinter.printTo(writer, readablePartial, this.iLocale);
    }

    public void printTo(Appendable appendable, long l2) throws IOException {
        appendable.append(this.print(l2));
    }

    public void printTo(Appendable appendable, ReadableInstant readableInstant) throws IOException {
        appendable.append(this.print(readableInstant));
    }

    public void printTo(Appendable appendable, ReadablePartial readablePartial) throws IOException {
        appendable.append(this.print(readablePartial));
    }

    public void printTo(StringBuffer stringBuffer, long l2) {
        this.printTo(stringBuffer, l2, null);
    }

    public void printTo(StringBuffer stringBuffer, ReadableInstant readableInstant) {
        this.printTo(stringBuffer, DateTimeUtils.getInstantMillis(readableInstant), DateTimeUtils.getInstantChronology(readableInstant));
    }

    public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial) {
        DateTimePrinter dateTimePrinter = this.requirePrinter();
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        dateTimePrinter.printTo(stringBuffer, readablePartial, this.iLocale);
    }

    public DateTimeFormatter withChronology(Chronology chronology) {
        if (this.iChrono == chronology) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, chronology, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeFormatter withDefaultYear(int n2) {
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, n2);
    }

    public DateTimeFormatter withLocale(Locale locale) {
        if (locale == this.getLocale() || locale != null && locale.equals(this.getLocale())) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, locale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeFormatter withOffsetParsed() {
        if (this.iOffsetParsed) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, true, this.iChrono, null, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeFormatter withPivotYear(int n2) {
        return this.withPivotYear((Integer)n2);
    }

    public DateTimeFormatter withPivotYear(Integer n2) {
        if (this.iPivotYear == n2 || this.iPivotYear != null && this.iPivotYear.equals(n2)) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, n2, this.iDefaultYear);
    }

    public DateTimeFormatter withZone(DateTimeZone dateTimeZone) {
        if (this.iZone == dateTimeZone) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, false, this.iChrono, dateTimeZone, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeFormatter withZoneUTC() {
        return this.withZone(DateTimeZone.UTC);
    }
}

