/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;

public class DateTimeFormat {
    static final int DATE = 0;
    static final int DATETIME = 2;
    static final int FULL = 0;
    static final int LONG = 1;
    static final int MEDIUM = 2;
    static final int NONE = 4;
    private static final Map<String, DateTimeFormatter> PATTERN_CACHE = new LinkedHashMap<String, DateTimeFormatter>(7){
        private static final long serialVersionUID = 23L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, DateTimeFormatter> entry) {
            return this.size() > 500;
        }
    };
    private static final int PATTERN_CACHE_SIZE = 500;
    static final int SHORT = 3;
    private static final DateTimeFormatter[] STYLE_CACHE = new DateTimeFormatter[25];
    static final int TIME = 1;

    protected DateTimeFormat() {
    }

    static void appendPatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string2) {
        DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DateTimeFormatter createDateTimeFormatter(int n2, int n3) {
        int n4 = 2;
        if (n2 == 4) {
            n4 = 1;
        } else if (n3 == 4) {
            n4 = 0;
        }
        StyleFormatter styleFormatter = new StyleFormatter(n2, n3, n4);
        return new DateTimeFormatter(styleFormatter, styleFormatter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DateTimeFormatter createFormatterForPattern(String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        Map<String, DateTimeFormatter> map = PATTERN_CACHE;
        synchronized (map) {
            DateTimeFormatter dateTimeFormatter = PATTERN_CACHE.get(string2);
            if (dateTimeFormatter == null) {
                DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
                DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, string2);
                dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
                PATTERN_CACHE.put(string2, dateTimeFormatter);
            }
            return dateTimeFormatter;
        }
    }

    private static DateTimeFormatter createFormatterForStyle(String string2) {
        if (string2 == null || string2.length() != 2) {
            throw new IllegalArgumentException("Invalid style specification: " + string2);
        }
        int n2 = DateTimeFormat.selectStyle(string2.charAt(0));
        int n3 = DateTimeFormat.selectStyle(string2.charAt(1));
        if (n2 == 4 && n3 == 4) {
            throw new IllegalArgumentException("Style '--' is invalid");
        }
        return DateTimeFormat.createFormatterForStyleIndex(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DateTimeFormatter createFormatterForStyleIndex(int n2, int n3) {
        int n4 = n3 + (n2 + (n2 << 2));
        if (n4 >= STYLE_CACHE.length) {
            return DateTimeFormat.createDateTimeFormatter(n2, n3);
        }
        DateTimeFormatter[] dateTimeFormatterArray = STYLE_CACHE;
        synchronized (dateTimeFormatterArray) {
            DateTimeFormatter dateTimeFormatter = STYLE_CACHE[n4];
            if (dateTimeFormatter == null) {
                DateTimeFormat.STYLE_CACHE[n4] = dateTimeFormatter = DateTimeFormat.createDateTimeFormatter(n2, n3);
            }
            return dateTimeFormatter;
        }
    }

    public static DateTimeFormatter forPattern(String string2) {
        return DateTimeFormat.createFormatterForPattern(string2);
    }

    public static DateTimeFormatter forStyle(String string2) {
        return DateTimeFormat.createFormatterForStyle(string2);
    }

    public static DateTimeFormatter fullDate() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 4);
    }

    public static DateTimeFormatter fullDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 0);
    }

    public static DateTimeFormatter fullTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 0);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private static boolean isNumericToken(String var0) {
        var1_1 = true;
        var2_2 = var0.length();
        if (var2_2 <= 0) ** GOTO lbl10
        switch (var0.charAt(0)) {
            default: {
                ** GOTO lbl10
            }
            case 'M': {
                if (var2_2 <= 2) {
                    return var1_1;
                }
lbl10:
                // 4 sources

                var1_1 = false;
            }
            case 'C': 
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'S': 
            case 'W': 
            case 'Y': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'w': 
            case 'x': 
            case 'y': 
        }
        return var1_1;
    }

    public static DateTimeFormatter longDate() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 4);
    }

    public static DateTimeFormatter longDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 1);
    }

    public static DateTimeFormatter longTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 1);
    }

    public static DateTimeFormatter mediumDate() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 4);
    }

    public static DateTimeFormatter mediumDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 2);
    }

    public static DateTimeFormatter mediumTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parsePatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string2) {
        int n2 = string2.length();
        int[] nArray = new int[1];
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            String string3;
            block47: {
                block46: {
                    if (n3 >= n2) break block46;
                    nArray[0] = n3;
                    string3 = DateTimeFormat.parseToken(string2, nArray);
                    n5 = nArray[0];
                    n4 = string3.length();
                    if (n4 != 0) break block47;
                }
                return;
            }
            char c2 = string3.charAt(0);
            block0 : switch (c2) {
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string3);
                }
                case 'G': {
                    dateTimeFormatterBuilder.appendEraText();
                    break;
                }
                case 'C': {
                    dateTimeFormatterBuilder.appendCenturyOfEra(n4, n4);
                    break;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (n4 == 2) {
                        boolean bl2 = true;
                        if (n5 + 1 < n2) {
                            nArray[0] = 1 + nArray[0];
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string2, nArray))) {
                                bl2 = false;
                            }
                            nArray[0] = -1 + nArray[0];
                        }
                        switch (c2) {
                            default: {
                                dateTimeFormatterBuilder.appendTwoDigitYear(-30 + new DateTime().getYear(), bl2);
                                break block0;
                            }
                            case 'x': 
                        }
                        dateTimeFormatterBuilder.appendTwoDigitWeekyear(-30 + new DateTime().getWeekyear(), bl2);
                        break;
                    }
                    int n6 = 9;
                    if (n5 + 1 < n2) {
                        nArray[0] = 1 + nArray[0];
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string2, nArray))) {
                            n6 = n4;
                        }
                        nArray[0] = -1 + nArray[0];
                    }
                    switch (c2) {
                        default: {
                            break block0;
                        }
                        case 'Y': {
                            dateTimeFormatterBuilder.appendYearOfEra(n4, n6);
                            break block0;
                        }
                        case 'x': {
                            dateTimeFormatterBuilder.appendWeekyear(n4, n6);
                            break block0;
                        }
                        case 'y': 
                    }
                    dateTimeFormatterBuilder.appendYear(n4, n6);
                    break;
                }
                case 'M': {
                    if (n4 >= 3) {
                        if (n4 >= 4) {
                            dateTimeFormatterBuilder.appendMonthOfYearText();
                            break;
                        }
                        dateTimeFormatterBuilder.appendMonthOfYearShortText();
                        break;
                    }
                    dateTimeFormatterBuilder.appendMonthOfYear(n4);
                    break;
                }
                case 'd': {
                    dateTimeFormatterBuilder.appendDayOfMonth(n4);
                    break;
                }
                case 'a': {
                    dateTimeFormatterBuilder.appendHalfdayOfDayText();
                    break;
                }
                case 'h': {
                    dateTimeFormatterBuilder.appendClockhourOfHalfday(n4);
                    break;
                }
                case 'H': {
                    dateTimeFormatterBuilder.appendHourOfDay(n4);
                    break;
                }
                case 'k': {
                    dateTimeFormatterBuilder.appendClockhourOfDay(n4);
                    break;
                }
                case 'K': {
                    dateTimeFormatterBuilder.appendHourOfHalfday(n4);
                    break;
                }
                case 'm': {
                    dateTimeFormatterBuilder.appendMinuteOfHour(n4);
                    break;
                }
                case 's': {
                    dateTimeFormatterBuilder.appendSecondOfMinute(n4);
                    break;
                }
                case 'S': {
                    dateTimeFormatterBuilder.appendFractionOfSecond(n4, n4);
                    break;
                }
                case 'e': {
                    dateTimeFormatterBuilder.appendDayOfWeek(n4);
                    break;
                }
                case 'E': {
                    if (n4 >= 4) {
                        dateTimeFormatterBuilder.appendDayOfWeekText();
                        break;
                    }
                    dateTimeFormatterBuilder.appendDayOfWeekShortText();
                    break;
                }
                case 'D': {
                    dateTimeFormatterBuilder.appendDayOfYear(n4);
                    break;
                }
                case 'w': {
                    dateTimeFormatterBuilder.appendWeekOfWeekyear(n4);
                    break;
                }
                case 'z': {
                    if (n4 >= 4) {
                        dateTimeFormatterBuilder.appendTimeZoneName();
                        break;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneShortName(null);
                    break;
                }
                case 'Z': {
                    if (n4 == 1) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", false, 2, 2);
                        break;
                    }
                    if (n4 == 2) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", true, 2, 2);
                        break;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneId();
                    break;
                }
                case '\'': {
                    String string4 = string3.substring(1);
                    if (string4.length() == 1) {
                        dateTimeFormatterBuilder.appendLiteral(string4.charAt(0));
                        break;
                    }
                    dateTimeFormatterBuilder.appendLiteral(new String(string4));
                }
            }
            n3 = n5 + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parseToken(String string2, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string2.length();
        char c2 = string2.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && string2.charAt(n2 + 1) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl2 = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                char c3 = string2.charAt(n2);
                if (c3 == '\'') {
                    if (n2 + 1 < n3 && string2.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c3);
                        continue;
                    }
                    if (!bl2) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (bl2 || (c3 < 'A' || c3 > 'Z') && (c3 < 'a' || c3 > 'z')) {
                    stringBuilder.append(c3);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    public static String patternForStyle(String string2, Locale locale) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.createFormatterForStyle(string2);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ((StyleFormatter)dateTimeFormatter.getPrinter()).getPattern(locale);
    }

    private static int selectStyle(char c2) {
        switch (c2) {
            default: {
                throw new IllegalArgumentException("Invalid style character: " + c2);
            }
            case 'S': {
                return 3;
            }
            case 'M': {
                return 2;
            }
            case 'L': {
                return 1;
            }
            case 'F': {
                return 0;
            }
            case '-': 
        }
        return 4;
    }

    public static DateTimeFormatter shortDate() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 4);
    }

    public static DateTimeFormatter shortDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 3);
    }

    public static DateTimeFormatter shortTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 3);
    }

    static class StyleFormatter
    implements DateTimePrinter,
    DateTimeParser {
        private static final Map<String, DateTimeFormatter> cCache = new HashMap<String, DateTimeFormatter>();
        private final int iDateStyle;
        private final int iTimeStyle;
        private final int iType;

        StyleFormatter(int n2, int n3, int n4) {
            this.iDateStyle = n2;
            this.iTimeStyle = n3;
            this.iType = n4;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private DateTimeFormatter getFormatter(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            String string2 = Integer.toString(this.iType + (this.iDateStyle << 4) + (this.iTimeStyle << 8)) + locale.toString();
            Map<String, DateTimeFormatter> map = cCache;
            synchronized (map) {
                DateTimeFormatter dateTimeFormatter = cCache.get(string2);
                if (dateTimeFormatter == null) {
                    dateTimeFormatter = DateTimeFormat.forPattern(this.getPattern(locale));
                    cCache.put(string2, dateTimeFormatter);
                }
                return dateTimeFormatter;
            }
        }

        @Override
        public int estimateParsedLength() {
            return 40;
        }

        @Override
        public int estimatePrintedLength() {
            return 40;
        }

        /*
         * Enabled aggressive block sorting
         */
        String getPattern(Locale locale) {
            int n2 = this.iType;
            DateFormat dateFormat = null;
            switch (n2) {
                case 0: {
                    dateFormat = DateFormat.getDateInstance(this.iDateStyle, locale);
                    break;
                }
                case 1: {
                    dateFormat = DateFormat.getTimeInstance(this.iTimeStyle, locale);
                    break;
                }
                case 2: {
                    dateFormat = DateFormat.getDateTimeInstance(this.iDateStyle, this.iTimeStyle, locale);
                }
            }
            if (!(dateFormat instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("No datetime pattern for locale: " + locale);
            }
            return ((SimpleDateFormat)dateFormat).toPattern();
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n2) {
            return this.getFormatter(dateTimeParserBucket.getLocale()).getParser().parseInto(dateTimeParserBucket, string2, n2);
        }

        @Override
        public void printTo(Writer writer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            this.getFormatter(locale).getPrinter().printTo(writer, l2, chronology, n2, dateTimeZone, locale);
        }

        @Override
        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            this.getFormatter(locale).getPrinter().printTo(writer, readablePartial, locale);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) {
            this.getFormatter(locale).getPrinter().printTo(stringBuffer, l2, chronology, n2, dateTimeZone, locale);
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            this.getFormatter(locale).getPrinter().printTo(stringBuffer, readablePartial, locale);
        }
    }
}

