/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.HashMap;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;

public final class UnsupportedDurationField
extends DurationField
implements Serializable {
    private static HashMap<DurationFieldType, UnsupportedDurationField> cCache;
    private static final long serialVersionUID = -6390301302770925357L;
    private final DurationFieldType iType;

    private UnsupportedDurationField(DurationFieldType durationFieldType) {
        this.iType = durationFieldType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UnsupportedDurationField getInstance(DurationFieldType durationFieldType) {
        synchronized (UnsupportedDurationField.class) {
            UnsupportedDurationField unsupportedDurationField;
            if (cCache == null) {
                cCache = new HashMap(7);
                unsupportedDurationField = null;
            } else {
                unsupportedDurationField = cCache.get(durationFieldType);
            }
            if (unsupportedDurationField == null) {
                unsupportedDurationField = new UnsupportedDurationField(durationFieldType);
                cCache.put(durationFieldType, unsupportedDurationField);
            }
            return unsupportedDurationField;
        }
    }

    private Object readResolve() {
        return UnsupportedDurationField.getInstance(this.iType);
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.iType + " field is unsupported");
    }

    @Override
    public long add(long l2, int n2) {
        throw this.unsupported();
    }

    @Override
    public long add(long l2, long l3) {
        throw this.unsupported();
    }

    @Override
    public int compareTo(DurationField durationField) {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (this == object) break block5;
                if (!(object instanceof UnsupportedDurationField)) {
                    return false;
                }
                UnsupportedDurationField unsupportedDurationField = (UnsupportedDurationField)object;
                if (unsupportedDurationField.getName() != null) {
                    return unsupportedDurationField.getName().equals(this.getName());
                }
                if (this.getName() != null) break block6;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getDifference(long l2, long l3) {
        throw this.unsupported();
    }

    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(int n2) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(int n2, long l2) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(long l2) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(long l2, long l3) {
        throw this.unsupported();
    }

    @Override
    public String getName() {
        return this.iType.getName();
    }

    @Override
    public final DurationFieldType getType() {
        return this.iType;
    }

    @Override
    public long getUnitMillis() {
        return 0L;
    }

    @Override
    public int getValue(long l2) {
        throw this.unsupported();
    }

    @Override
    public int getValue(long l2, long l3) {
        throw this.unsupported();
    }

    @Override
    public long getValueAsLong(long l2) {
        throw this.unsupported();
    }

    @Override
    public long getValueAsLong(long l2, long l3) {
        throw this.unsupported();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean isPrecise() {
        return true;
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public String toString() {
        return "UnsupportedDurationField[" + this.getName() + ']';
    }
}

