/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;

public final class UnsupportedDateTimeField
extends DateTimeField
implements Serializable {
    private static HashMap<DateTimeFieldType, UnsupportedDateTimeField> cCache;
    private static final long serialVersionUID = -1934618396111902255L;
    private final DurationField iDurationField;
    private final DateTimeFieldType iType;

    private UnsupportedDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        if (dateTimeFieldType == null || durationField == null) {
            throw new IllegalArgumentException();
        }
        this.iType = dateTimeFieldType;
        this.iDurationField = durationField;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UnsupportedDateTimeField getInstance(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        synchronized (UnsupportedDateTimeField.class) {
            UnsupportedDateTimeField unsupportedDateTimeField;
            if (cCache == null) {
                cCache = new HashMap(7);
                unsupportedDateTimeField = null;
            } else {
                DurationField durationField2;
                unsupportedDateTimeField = cCache.get(dateTimeFieldType);
                if (unsupportedDateTimeField != null && (durationField2 = unsupportedDateTimeField.getDurationField()) != durationField) {
                    unsupportedDateTimeField = null;
                }
            }
            if (unsupportedDateTimeField == null) {
                unsupportedDateTimeField = new UnsupportedDateTimeField(dateTimeFieldType, durationField);
                cCache.put(dateTimeFieldType, unsupportedDateTimeField);
            }
            return unsupportedDateTimeField;
        }
    }

    private Object readResolve() {
        return UnsupportedDateTimeField.getInstance(this.iType, this.iDurationField);
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.iType + " field is unsupported");
    }

    @Override
    public long add(long l2, int n2) {
        return this.getDurationField().add(l2, n2);
    }

    @Override
    public long add(long l2, long l3) {
        return this.getDurationField().add(l2, l3);
    }

    @Override
    public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    @Override
    public long addWrapField(long l2, int n2) {
        throw this.unsupported();
    }

    @Override
    public int[] addWrapField(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    @Override
    public int[] addWrapPartial(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    @Override
    public int get(long l2) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(int n2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(long l2) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(long l2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(ReadablePartial readablePartial, int n2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(ReadablePartial readablePartial, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(int n2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(long l2) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(long l2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(ReadablePartial readablePartial, int n2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(ReadablePartial readablePartial, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public int getDifference(long l2, long l3) {
        return this.getDurationField().getDifference(l2, l3);
    }

    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        return this.getDurationField().getDifferenceAsLong(l2, l3);
    }

    @Override
    public DurationField getDurationField() {
        return this.iDurationField;
    }

    @Override
    public int getLeapAmount(long l2) {
        throw this.unsupported();
    }

    @Override
    public DurationField getLeapDurationField() {
        return null;
    }

    @Override
    public int getMaximumShortTextLength(Locale locale) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue() {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(long l2) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue() {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(long l2) {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(ReadablePartial readablePartial) {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
        throw this.unsupported();
    }

    @Override
    public String getName() {
        return this.iType.getName();
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public DateTimeFieldType getType() {
        return this.iType;
    }

    @Override
    public boolean isLeap(long l2) {
        throw this.unsupported();
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public long remainder(long l2) {
        throw this.unsupported();
    }

    @Override
    public long roundCeiling(long l2) {
        throw this.unsupported();
    }

    @Override
    public long roundFloor(long l2) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfCeiling(long l2) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfEven(long l2) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfFloor(long l2) {
        throw this.unsupported();
    }

    @Override
    public long set(long l2, int n2) {
        throw this.unsupported();
    }

    @Override
    public long set(long l2, String string2) {
        throw this.unsupported();
    }

    @Override
    public long set(long l2, String string2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        throw this.unsupported();
    }

    @Override
    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, String string2, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String toString() {
        return "UnsupportedDateTimeField";
    }
}

