/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.FieldUtils;

public final class SkipDateTimeField
extends DelegatedDateTimeField {
    private static final long serialVersionUID = -8869148464118507846L;
    private final Chronology iChronology;
    private transient int iMinValue;
    private final int iSkip;

    public SkipDateTimeField(Chronology chronology, DateTimeField dateTimeField) {
        this(chronology, dateTimeField, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SkipDateTimeField(Chronology chronology, DateTimeField dateTimeField, int n2) {
        super(dateTimeField);
        this.iChronology = chronology;
        int n3 = super.getMinimumValue();
        this.iMinValue = n3 < n2 ? n3 - 1 : (n3 == n2 ? n2 + 1 : n3);
        this.iSkip = n2;
    }

    private Object readResolve() {
        return this.getType().getField(this.iChronology);
    }

    @Override
    public int get(long l2) {
        int n2 = super.get(l2);
        if (n2 <= this.iSkip) {
            --n2;
        }
        return n2;
    }

    @Override
    public int getMinimumValue() {
        return this.iMinValue;
    }

    @Override
    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iMinValue, this.getMaximumValue());
        if (n2 <= this.iSkip) {
            if (n2 == this.iSkip) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)n2, null, null);
            }
            ++n2;
        }
        return super.set(l2, n2);
    }
}

