/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ScaledDurationField;

public class RemainderDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 5708241235177666790L;
    final int iDivisor;
    final DurationField iRangeField;

    /*
     * Enabled aggressive block sorting
     */
    public RemainderDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n2) {
        super(dateTimeField, dateTimeFieldType);
        if (n2 < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField durationField = dateTimeField.getDurationField();
        this.iRangeField = durationField == null ? null : new ScaledDurationField(durationField, dateTimeFieldType.getRangeDurationType(), n2);
        this.iDivisor = n2;
    }

    public RemainderDateTimeField(DividedDateTimeField dividedDateTimeField) {
        this(dividedDateTimeField, dividedDateTimeField.getType());
    }

    public RemainderDateTimeField(DividedDateTimeField dividedDateTimeField, DateTimeFieldType dateTimeFieldType) {
        super(dividedDateTimeField.getWrappedField(), dateTimeFieldType);
        this.iDivisor = dividedDateTimeField.iDivisor;
        this.iRangeField = dividedDateTimeField.iDurationField;
    }

    private int getDivided(int n2) {
        if (n2 >= 0) {
            return n2 / this.iDivisor;
        }
        return -1 + (n2 + 1) / this.iDivisor;
    }

    @Override
    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, 0, -1 + this.iDivisor));
    }

    @Override
    public int get(long l2) {
        int n2 = this.getWrappedField().get(l2);
        if (n2 >= 0) {
            return n2 % this.iDivisor;
        }
        return -1 + this.iDivisor + (n2 + 1) % this.iDivisor;
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    @Override
    public int getMaximumValue() {
        return -1 + this.iDivisor;
    }

    @Override
    public int getMinimumValue() {
        return 0;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    @Override
    public long remainder(long l2) {
        return this.getWrappedField().remainder(l2);
    }

    @Override
    public long roundCeiling(long l2) {
        return this.getWrappedField().roundCeiling(l2);
    }

    @Override
    public long roundFloor(long l2) {
        return this.getWrappedField().roundFloor(l2);
    }

    @Override
    public long roundHalfCeiling(long l2) {
        return this.getWrappedField().roundHalfCeiling(l2);
    }

    @Override
    public long roundHalfEven(long l2) {
        return this.getWrappedField().roundHalfEven(l2);
    }

    @Override
    public long roundHalfFloor(long l2) {
        return this.getWrappedField().roundHalfFloor(l2);
    }

    @Override
    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, 0, -1 + this.iDivisor);
        int n3 = this.getDivided(this.getWrappedField().get(l2));
        return this.getWrappedField().set(l2, n2 + n3 * this.iDivisor);
    }
}

