/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public class PreciseDurationField
extends BaseDurationField {
    private static final long serialVersionUID = -8346152187724495365L;
    private final long iUnitMillis;

    public PreciseDurationField(DurationFieldType durationFieldType, long l2) {
        super(durationFieldType);
        this.iUnitMillis = l2;
    }

    @Override
    public long add(long l2, int n2) {
        return FieldUtils.safeAdd(l2, (long)n2 * this.iUnitMillis);
    }

    @Override
    public long add(long l2, long l3) {
        return FieldUtils.safeAdd(l2, FieldUtils.safeMultiply(l3, this.iUnitMillis));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof PreciseDurationField)) {
                    return false;
                }
                PreciseDurationField preciseDurationField = (PreciseDurationField)object;
                if (this.getType() != preciseDurationField.getType() || this.iUnitMillis != preciseDurationField.iUnitMillis) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        return FieldUtils.safeSubtract(l2, l3) / this.iUnitMillis;
    }

    @Override
    public long getMillis(int n2, long l2) {
        return (long)n2 * this.iUnitMillis;
    }

    @Override
    public long getMillis(long l2, long l3) {
        return FieldUtils.safeMultiply(l2, this.iUnitMillis);
    }

    @Override
    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    @Override
    public long getValueAsLong(long l2, long l3) {
        return l2 / this.iUnitMillis;
    }

    public int hashCode() {
        long l2 = this.iUnitMillis;
        return (int)(l2 ^ l2 >>> 32) + this.getType().hashCode();
    }

    @Override
    public final boolean isPrecise() {
        return true;
    }
}

