/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.PreciseDurationDateTimeField;

public class PreciseDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -5586801265774496376L;
    private final int iRange;
    private final DurationField iRangeField;

    public PreciseDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField, DurationField durationField2) {
        super(dateTimeFieldType, durationField);
        if (!durationField2.isPrecise()) {
            throw new IllegalArgumentException("Range duration field must be precise");
        }
        this.iRange = (int)(durationField2.getUnitMillis() / this.getUnitMillis());
        if (this.iRange < 2) {
            throw new IllegalArgumentException("The effective range must be at least 2");
        }
        this.iRangeField = durationField2;
    }

    @Override
    public long addWrapField(long l2, int n2) {
        int n3 = this.get(l2);
        return l2 + (long)(FieldUtils.getWrappedValue(n3, n2, this.getMinimumValue(), this.getMaximumValue()) - n3) * this.getUnitMillis();
    }

    @Override
    public int get(long l2) {
        if (l2 >= 0L) {
            return (int)(l2 / this.getUnitMillis() % (long)this.iRange);
        }
        return -1 + this.iRange + (int)((1L + l2) / this.getUnitMillis() % (long)this.iRange);
    }

    @Override
    public int getMaximumValue() {
        return -1 + this.iRange;
    }

    public int getRange() {
        return this.iRange;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    @Override
    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.getMinimumValue(), this.getMaximumValue());
        return l2 + (long)(n2 - this.get(l2)) * this.iUnitMillis;
    }
}

