/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

public class OffsetDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 3145790132623583142L;
    private final int iMax;
    private final int iMin;
    private final int iOffset;

    /*
     * Enabled aggressive block sorting
     */
    public OffsetDateTimeField(DateTimeField dateTimeField, int n2) {
        DateTimeFieldType dateTimeFieldType = dateTimeField == null ? null : dateTimeField.getType();
        this(dateTimeField, dateTimeFieldType, n2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n2) {
        this(dateTimeField, dateTimeFieldType, n2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public OffsetDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n2, int n3, int n4) {
        super(dateTimeField, dateTimeFieldType);
        if (n2 == 0) {
            throw new IllegalArgumentException("The offset cannot be zero");
        }
        this.iOffset = n2;
        this.iMin = n3 < n2 + dateTimeField.getMinimumValue() ? n2 + dateTimeField.getMinimumValue() : n3;
        if (n4 > n2 + dateTimeField.getMaximumValue()) {
            this.iMax = n2 + dateTimeField.getMaximumValue();
            return;
        }
        this.iMax = n4;
    }

    @Override
    public long add(long l2, int n2) {
        long l3 = super.add(l2, n2);
        FieldUtils.verifyValueBounds(this, this.get(l3), this.iMin, this.iMax);
        return l3;
    }

    @Override
    public long add(long l2, long l3) {
        long l4 = super.add(l2, l3);
        FieldUtils.verifyValueBounds(this, this.get(l4), this.iMin, this.iMax);
        return l4;
    }

    @Override
    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, this.iMin, this.iMax));
    }

    @Override
    public int get(long l2) {
        return super.get(l2) + this.iOffset;
    }

    @Override
    public int getLeapAmount(long l2) {
        return this.getWrappedField().getLeapAmount(l2);
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    @Override
    public int getMaximumValue() {
        return this.iMax;
    }

    @Override
    public int getMinimumValue() {
        return this.iMin;
    }

    public int getOffset() {
        return this.iOffset;
    }

    @Override
    public boolean isLeap(long l2) {
        return this.getWrappedField().isLeap(l2);
    }

    @Override
    public long remainder(long l2) {
        return this.getWrappedField().remainder(l2);
    }

    @Override
    public long roundCeiling(long l2) {
        return this.getWrappedField().roundCeiling(l2);
    }

    @Override
    public long roundFloor(long l2) {
        return this.getWrappedField().roundFloor(l2);
    }

    @Override
    public long roundHalfCeiling(long l2) {
        return this.getWrappedField().roundHalfCeiling(l2);
    }

    @Override
    public long roundHalfEven(long l2) {
        return this.getWrappedField().roundHalfEven(l2);
    }

    @Override
    public long roundHalfFloor(long l2) {
        return this.getWrappedField().roundHalfFloor(l2);
    }

    @Override
    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iMin, this.iMax);
        return super.set(l2, n2 - this.iOffset);
    }
}

