/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.FieldUtils;

public final class MillisDurationField
extends DurationField
implements Serializable {
    public static final DurationField INSTANCE = new MillisDurationField();
    private static final long serialVersionUID = 2656707858124633367L;

    private MillisDurationField() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public long add(long l2, int n2) {
        return FieldUtils.safeAdd(l2, (long)n2);
    }

    @Override
    public long add(long l2, long l3) {
        return FieldUtils.safeAdd(l2, l3);
    }

    @Override
    public int compareTo(DurationField durationField) {
        long l2 = durationField.getUnitMillis();
        long l3 = this.getUnitMillis();
        if (l3 == l2) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        boolean bl2 = object instanceof MillisDurationField;
        boolean bl3 = false;
        if (bl2) {
            long l2 = this.getUnitMillis() - ((MillisDurationField)object).getUnitMillis();
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            bl3 = false;
            if (l3 == false) {
                bl3 = true;
            }
        }
        return bl3;
    }

    @Override
    public int getDifference(long l2, long l3) {
        return FieldUtils.safeToInt(FieldUtils.safeSubtract(l2, l3));
    }

    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        return FieldUtils.safeSubtract(l2, l3);
    }

    @Override
    public long getMillis(int n2) {
        return n2;
    }

    @Override
    public long getMillis(int n2, long l2) {
        return n2;
    }

    @Override
    public long getMillis(long l2) {
        return l2;
    }

    @Override
    public long getMillis(long l2, long l3) {
        return l2;
    }

    @Override
    public String getName() {
        return "millis";
    }

    @Override
    public DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    @Override
    public final long getUnitMillis() {
        return 1L;
    }

    @Override
    public int getValue(long l2) {
        return FieldUtils.safeToInt(l2);
    }

    @Override
    public int getValue(long l2, long l3) {
        return FieldUtils.safeToInt(l2);
    }

    @Override
    public long getValueAsLong(long l2) {
        return l2;
    }

    @Override
    public long getValueAsLong(long l2, long l3) {
        return l2;
    }

    public int hashCode() {
        return (int)this.getUnitMillis();
    }

    @Override
    public final boolean isPrecise() {
        return true;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String toString() {
        return "DurationField[millis]";
    }
}

