/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public abstract class ImpreciseDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 7190739608550251860L;
    private final DurationField iDurationField;
    final long iUnitMillis;

    public ImpreciseDateTimeField(DateTimeFieldType dateTimeFieldType, long l2) {
        super(dateTimeFieldType);
        this.iUnitMillis = l2;
        this.iDurationField = new LinkedDurationField(dateTimeFieldType.getDurationType());
    }

    @Override
    public abstract long add(long var1, int var3);

    @Override
    public abstract long add(long var1, long var3);

    @Override
    public abstract int get(long var1);

    @Override
    public int getDifference(long l2, long l3) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(l2, l3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        if (l2 < l3) {
            return -this.getDifferenceAsLong(l3, l2);
        }
        long l4 = (l2 - l3) / this.iUnitMillis;
        if (this.add(l3, l4) < l2) {
            while (this.add(l3, ++l4) <= l2) {
            }
            return l4 - 1L;
        }
        if (this.add(l3, l4) <= l2) return l4;
        while (this.add(l3, --l4) > l2) {
        }
        return l4;
    }

    @Override
    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    protected final long getDurationUnitMillis() {
        return this.iUnitMillis;
    }

    @Override
    public abstract DurationField getRangeDurationField();

    @Override
    public abstract long roundFloor(long var1);

    @Override
    public abstract long set(long var1, int var3);

    private final class LinkedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -203813474600094134L;

        LinkedDurationField(DurationFieldType durationFieldType) {
            super(durationFieldType);
        }

        @Override
        public long add(long l2, int n2) {
            return ImpreciseDateTimeField.this.add(l2, n2);
        }

        @Override
        public long add(long l2, long l3) {
            return ImpreciseDateTimeField.this.add(l2, l3);
        }

        @Override
        public int getDifference(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifference(l2, l3);
        }

        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(l2, l3);
        }

        @Override
        public long getMillis(int n2, long l2) {
            return ImpreciseDateTimeField.this.add(l2, n2) - l2;
        }

        @Override
        public long getMillis(long l2, long l3) {
            return ImpreciseDateTimeField.this.add(l3, l2) - l3;
        }

        @Override
        public long getUnitMillis() {
            return ImpreciseDateTimeField.this.iUnitMillis;
        }

        @Override
        public int getValue(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifference(l3 + l2, l3);
        }

        @Override
        public long getValueAsLong(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(l3 + l2, l3);
        }

        @Override
        public boolean isPrecise() {
            return false;
        }
    }
}

